/*
 * Decompiled with CFR 0.152.
 */
package com.github.afarion1.command_handler.command;

import com.github.afarion1.command_handler.command.CommandHandler;
import com.github.afarion1.command_handler.utils.NamedThreadFactory;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.dv8tion.jda.api.JDA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandHandlerBuilder {
    private static final String KEY_PREFIX = "commands_prefix";
    private static final String KEY_COMMAND_LIST = "enable_command_list";
    private static final String KEY_INSPECT_COMMAND = "enable_inspect_command";
    private static final String KEY_CLEAN_DB = "clean_outdated_cooldown_on_startup";
    private static final Logger log = LoggerFactory.getLogger(CommandHandlerBuilder.class);
    private final String fileName = "command_handler.properties";
    JDA jda = null;
    String commandsPrefix = "~";
    boolean enableCommandList = true;
    boolean enableInspectCommand = true;
    boolean cleanDbOnStartup = true;
    Color commandListColor = Color.yellow;
    Color inspectCommandColor = Color.yellow;
    Color errorColor = Color.red;
    ExecutorService executor = null;

    public CommandHandlerBuilder() {
        this(true);
    }

    public CommandHandlerBuilder(boolean createConfigIfAbsent) {
        Properties prop;
        try {
            FileInputStream in = new FileInputStream("command_handler.properties");
            prop = new Properties();
            prop.load(in);
        }
        catch (IOException e) {
            log.warn("Unable to  find configuration file");
            log.debug(e.toString());
            prop = null;
        }
        if (prop == null) {
            if (!createConfigIfAbsent) {
                return;
            }
            prop = new Properties();
        }
        if (prop.containsKey(KEY_PREFIX)) {
            String commandsPrefixProb = prop.getProperty(KEY_PREFIX);
            log.trace("{} - Found property {} = {}", new Object[]{"command_handler.properties", KEY_PREFIX, commandsPrefixProb});
            if (commandsPrefixProb != null && commandsPrefixProb.length() > 0) {
                this.commandsPrefix = commandsPrefixProb;
            }
        } else {
            prop.setProperty(KEY_PREFIX, this.commandsPrefix);
            log.trace("{} - Adding property {} with value {}", new Object[]{"command_handler.properties", KEY_PREFIX, this.commandsPrefix});
        }
        this.enableCommandList = this.loadOrAddBoolProperty(prop, KEY_COMMAND_LIST, this.enableCommandList);
        this.enableInspectCommand = this.loadOrAddBoolProperty(prop, KEY_INSPECT_COMMAND, this.enableCommandList);
        this.cleanDbOnStartup = this.loadOrAddBoolProperty(prop, KEY_CLEAN_DB, this.cleanDbOnStartup);
        try (FileOutputStream out = new FileOutputStream("command_handler.properties");){
            prop.store(out, "Configuration file for Command Handler.");
        }
        catch (IOException e) {
            log.error("Unable to create configuration file", (Throwable)e);
        }
    }

    private boolean loadOrAddBoolProperty(Properties prop, String key, boolean defaultBool) {
        if (prop.containsKey(key)) {
            boolean parsedVal;
            String found = prop.getProperty(key).trim();
            log.trace("{} - Found property {} = {}", new Object[]{"command_handler.properties", key, found});
            if (found.equalsIgnoreCase("true")) {
                parsedVal = true;
            } else if (found.equalsIgnoreCase("false")) {
                parsedVal = false;
            } else {
                parsedVal = defaultBool;
                log.trace("Couldn't parse the value to a bool, setting value to {} (default)", (Object)defaultBool);
            }
            return parsedVal;
        }
        prop.setProperty(key, Boolean.toString(defaultBool));
        log.trace("{} - Adding property {} with value {}", new Object[]{"command_handler.properties", key, defaultBool});
        return defaultBool;
    }

    public CommandHandlerBuilder setJda(JDA jda) {
        this.jda = jda;
        return this;
    }

    public CommandHandlerBuilder cleanDbOnStartup(boolean cleanDbOnStartup) {
        this.cleanDbOnStartup = cleanDbOnStartup;
        return this;
    }

    public CommandHandlerBuilder setExecutorService(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public CommandHandlerBuilder setCommandPrefix(String commandsPrefix) {
        this.commandsPrefix = commandsPrefix;
        return this;
    }

    public CommandHandlerBuilder setCommandListEmbedColor(Color helpColor) {
        this.commandListColor = helpColor;
        return this;
    }

    public CommandHandlerBuilder setErrorEmbedColor(Color errorColor) {
        this.errorColor = errorColor;
        return this;
    }

    public CommandHandlerBuilder setInspectCommandEmbedColor(Color inspectColor) {
        this.inspectCommandColor = inspectColor;
        return this;
    }

    public CommandHandlerBuilder disableCommandList() {
        this.enableCommandList = false;
        return this;
    }

    public CommandHandlerBuilder disableInspectCommand() {
        this.enableInspectCommand = false;
        return this;
    }

    public CommandHandler build() {
        if (this.jda == null) {
            throw new IllegalStateException("JDA is not specified");
        }
        if (this.executor == null) {
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            this.executor = Executors.newFixedThreadPool(availableProcessors, new NamedThreadFactory("Command handling thread"));
            log.info("Executor is not specified, using FixedThreadPool with size of {} (amount of available processors)", (Object)availableProcessors);
        }
        return new CommandHandler(this);
    }
}

