/*
 * Decompiled with CFR 0.152.
 */
package com.github.afarion1.command_handler.command;

import com.github.afarion1.command_handler.command.CommandHandler;
import java.util.concurrent.ExecutorService;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MessageListener
extends ListenerAdapter {
    private static final Logger log = LoggerFactory.getLogger(MessageListener.class);
    private final String prefix;
    private final ExecutorService executor;
    private final CommandHandler handler;

    MessageListener(CommandHandler handler) {
        this.handler = handler;
        this.prefix = handler.getCommandsPrefix();
        this.executor = handler.getExecutor();
    }

    public void onMessageReceived(MessageReceivedEvent event) {
        if (event.getAuthor().isBot()) {
            return;
        }
        Message msg = event.getMessage();
        String content = msg.getContentRaw();
        log.trace("Received message \"{}\" from user {}in channel {}", new Object[]{content, msg.getAuthor().getAsMention(), msg.getChannel().getId()});
        if (content.length() > this.prefix.length() && content.substring(0, this.prefix.length()).equals(this.prefix)) {
            log.debug("Found prefix, processing message  \"{}\" from user {} in channel id{}", new Object[]{content, msg.getAuthor().getAsMention(), msg.getChannel().getId()});
            Runnable processCommand = () -> this.handler.processCommand(event);
            this.executor.execute(processCommand);
        }
    }
}

