/*
 * Decompiled with CFR 0.152.
 */
package com.github.afarion1.command_handler.command.config;

import com.github.afarion1.command_handler.command.config.CommandArgumentConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.DoublePredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class CommandArgumentConfigBuilder {
    private final int id;
    private final String argumentName;
    private final List<String> argumentOptions;
    private final List<Predicate<String>> stringValidators;
    private final List<DoublePredicate> doubleValidators;
    private boolean optional;
    private String argumentDesc;
    private boolean parseToDouble;
    private String defaultStringValue;
    private double defaultDoubleValue;
    private boolean inQuotes = false;
    private final String errorMsg;
    private boolean multiWordChoosingEnabled;

    public CommandArgumentConfigBuilder(int id, String argumentName) {
        this.id = id;
        this.argumentName = argumentName;
        this.argumentDesc = "";
        this.defaultStringValue = null;
        this.defaultDoubleValue = Double.NaN;
        this.argumentOptions = new ArrayList<String>();
        this.stringValidators = new ArrayList<Predicate<String>>();
        this.doubleValidators = new ArrayList<DoublePredicate>();
        this.errorMsg = "";
        this.multiWordChoosingEnabled = false;
    }

    public CommandArgumentConfigBuilder setArgumentDescription(String desc) {
        if (desc != null) {
            this.argumentDesc = desc;
        }
        return this;
    }

    @SafeVarargs
    public final CommandArgumentConfigBuilder addStringValidators(Predicate<String> ... validators) {
        this.stringValidators.addAll(Arrays.asList(validators));
        return this;
    }

    public CommandArgumentConfigBuilder addDoubleValidators(DoublePredicate ... validators) {
        this.doubleValidators.addAll(Arrays.asList(validators));
        return this;
    }

    public CommandArgumentConfigBuilder setArgumentOptions(String ... options) {
        for (String option : options) {
            if (option == null || option.length() <= 0) continue;
            this.argumentOptions.add(option);
        }
        return this;
    }

    public CommandArgumentConfigBuilder setOptional(boolean bool) {
        this.optional = bool;
        return this;
    }

    public CommandArgumentConfigBuilder setInQuotes(boolean bool) {
        this.inQuotes = bool;
        return this;
    }

    @NotNull
    public CommandArgumentConfigBuilder setDefaultStringValue(String str) {
        this.defaultStringValue = str;
        return this;
    }

    public CommandArgumentConfigBuilder setDefaultDoubleValue(double num) {
        this.defaultDoubleValue = num;
        return this;
    }

    public CommandArgumentConfigBuilder setParseToDouble(boolean bool) {
        this.parseToDouble = bool;
        return this;
    }

    public CommandArgumentConfigBuilder enableCustomArgumentChoosing(boolean enable) {
        this.multiWordChoosingEnabled = enable;
        return this;
    }

    CommandArgumentConfig build() {
        return new CommandArgumentConfig(this.id, this.argumentName, this.argumentOptions, this.stringValidators, this.doubleValidators, this.optional, this.argumentDesc, this.parseToDouble, this.defaultStringValue, this.defaultDoubleValue, this.inQuotes, this.errorMsg, this.multiWordChoosingEnabled);
    }

    boolean isOptional() {
        return this.optional;
    }

    String getArgumentName() {
        return this.argumentName;
    }

    List<String> getArgumentOptions() {
        return this.argumentOptions;
    }
}

