/*
 * Decompiled with CFR 0.152.
 */
package com.github.afarion1.command_handler.command.config;

import com.github.afarion1.command_handler.command.config.CommandArgumentConfig;
import com.github.afarion1.command_handler.command.config.CommandListType;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import net.dv8tion.jda.api.Permission;

public final class CommandConfig {
    private final List<String> nameAndAliases;
    private final String desc;
    private final String verboseDesc;
    private final CommandListType listType;
    private final Duration commandCooldown;
    private final List<Permission> discordPerms;
    private final Duration commandGuildCooldown;
    private final List<CommandArgumentConfig> arguments;
    private final boolean executeInGuildOnly;
    private final boolean rawArgs;
    private final String rawArgsName;
    private final String rawArgsDesc;
    private final boolean executeIfCantCheckCooldown;
    private final String commandArgumentsSignature;
    private final boolean cleanCooldownRecords;
    private final Duration cooldownRecordsCleaningPeriod;

    CommandConfig(List<String> nameAndAliases, String desc, String verboseDesc, CommandListType listType, Duration commandCooldown, List<Permission> discordPerms, Duration commandGuildCooldown, List<CommandArgumentConfig> arguments, boolean executeInGuildOnly, boolean rawArgs, String rawArgsName, String rawArgsDesc, boolean executeIfCantCheckCooldown, String commandArgumentsSignature, boolean cleanCooldownRecords, Duration cooldownRecordsCleaningPeriod) {
        this.nameAndAliases = Collections.unmodifiableList(nameAndAliases);
        this.desc = desc;
        this.verboseDesc = verboseDesc;
        this.listType = listType;
        this.commandCooldown = commandCooldown;
        this.discordPerms = Collections.unmodifiableList(discordPerms);
        this.commandGuildCooldown = commandGuildCooldown;
        this.arguments = Collections.unmodifiableList(arguments);
        this.executeInGuildOnly = executeInGuildOnly;
        this.rawArgs = rawArgs;
        this.rawArgsName = rawArgsName;
        this.rawArgsDesc = rawArgsDesc;
        this.executeIfCantCheckCooldown = executeIfCantCheckCooldown;
        this.commandArgumentsSignature = commandArgumentsSignature;
        this.cleanCooldownRecords = cleanCooldownRecords;
        this.cooldownRecordsCleaningPeriod = cooldownRecordsCleaningPeriod;
    }

    public List<String> getNameAndAliases() {
        return this.nameAndAliases;
    }

    public String getName() {
        return this.nameAndAliases.get(0);
    }

    public String getDescription() {
        return this.desc;
    }

    public String getVerboseDesc() {
        return this.verboseDesc;
    }

    public CommandListType getListType() {
        return this.listType;
    }

    public Duration getUserCooldown() {
        return this.commandCooldown;
    }

    public List<Permission> getDiscordPerms() {
        return this.discordPerms;
    }

    public Duration getGuildCooldown() {
        return this.commandGuildCooldown;
    }

    public List<CommandArgumentConfig> getArguments() {
        return this.arguments;
    }

    public boolean isExecuteInGuildOnly() {
        return this.executeInGuildOnly;
    }

    public boolean isRawArgs() {
        return this.rawArgs;
    }

    public String getRawArgsName() {
        return this.rawArgsName;
    }

    public String getRawArgsDesc() {
        return this.rawArgsDesc;
    }

    public boolean shouldExecuteIfCantCheckOrSaveCooldown() {
        return this.executeIfCantCheckCooldown;
    }

    public String getCommandArgumentsSignature() {
        return this.commandArgumentsSignature;
    }

    public boolean shouldCleanCooldownRecords() {
        return this.cleanCooldownRecords;
    }

    public Duration getCooldownRecordsCleaningPeriod() {
        return this.cooldownRecordsCleaningPeriod;
    }
}

