/*
 * Decompiled with CFR 0.152.
 */
package com.github.afarion1.command_handler.command.config;

import com.github.afarion1.command_handler.command.config.CommandArgumentConfig;
import com.github.afarion1.command_handler.command.config.CommandArgumentConfigBuilder;
import com.github.afarion1.command_handler.command.config.CommandConfig;
import com.github.afarion1.command_handler.command.config.CommandListType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.Permission;
import org.jetbrains.annotations.NotNull;

public final class CommandConfigBuilder {
    private List<String> nameAndAliases;
    private List<CommandArgumentConfigBuilder> arguments;
    private List<Permission> discordPerms;
    private String desc;
    private String verboseDesc;
    private String rawArgsDesc;
    private String rawArgsName;
    private CommandListType listType;
    private Duration commandCooldown;
    private Duration commandGuildCooldown;
    private boolean executeInGuildOnly;
    private boolean rawArgs;
    private boolean executeIfCantCheckCooldown;
    private boolean cleanCooldownRecords;
    private Duration cooldownRecordsCleaningPeriod;

    public CommandConfigBuilder(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name should be not null and with length 1 or morel");
        }
        this.nameAndAliases = new ArrayList<String>();
        this.nameAndAliases.add(name);
        this.desc = "";
        this.verboseDesc = "";
        this.listType = CommandListType.LISTED;
        this.commandCooldown = Duration.ZERO;
        this.commandGuildCooldown = Duration.ZERO;
        this.discordPerms = new ArrayList<Permission>();
        this.arguments = new ArrayList<CommandArgumentConfigBuilder>();
        this.executeInGuildOnly = false;
        this.rawArgs = false;
        this.rawArgsName = "";
        this.rawArgsDesc = "";
        this.executeIfCantCheckCooldown = false;
        this.cleanCooldownRecords = true;
        this.cooldownRecordsCleaningPeriod = Duration.ZERO;
    }

    public CommandConfigBuilder setCleanCooldownRecords(boolean bool) {
        this.cleanCooldownRecords = bool;
        return this;
    }

    public CommandConfigBuilder setExecuteIfCantCheckOrSaveCooldown(boolean bool) {
        this.executeIfCantCheckCooldown = bool;
        return this;
    }

    public CommandConfigBuilder addArguments(List<CommandArgumentConfigBuilder> args) {
        this.arguments.addAll(args);
        return this;
    }

    public CommandConfigBuilder addArguments(CommandArgumentConfigBuilder ... arg) {
        this.arguments.addAll(Arrays.asList(arg));
        return this;
    }

    public CommandConfigBuilder setUseRawArgs(boolean bool) {
        this.rawArgs = bool;
        return this;
    }

    public CommandConfigBuilder setPerGuildCooldown(Duration cooldown) {
        if (cooldown != null && !cooldown.equals(Duration.ZERO)) {
            this.commandGuildCooldown = cooldown;
            this.executeInGuildOnly = true;
        }
        return this;
    }

    public CommandConfigBuilder addDiscordPermission(Permission perm) {
        this.discordPerms.add(perm);
        return this;
    }

    public CommandConfigBuilder addDiscordPermission(List<Permission> perms) {
        this.discordPerms.addAll(perms);
        return this;
    }

    public CommandConfigBuilder setCooldown(Duration cooldown) {
        if (cooldown != null) {
            this.commandCooldown = cooldown;
        }
        return this;
    }

    public CommandConfigBuilder addAliases(List<String> aliases) {
        this.nameAndAliases.addAll(aliases);
        return this;
    }

    public CommandConfigBuilder addAliases(String ... aliases) {
        this.nameAndAliases.addAll(Arrays.asList(aliases));
        return this;
    }

    public CommandConfigBuilder setDescription(String desc) {
        this.desc = desc;
        return this;
    }

    public CommandConfigBuilder setVerboseDescription(String verbDesc) {
        if (verbDesc == null) {
            verbDesc = "";
        }
        this.verboseDesc = verbDesc;
        return this;
    }

    public CommandConfigBuilder setCommandListType(CommandListType type) {
        this.listType = type;
        return this;
    }

    public CommandConfigBuilder setExecuteInGuildOnly(boolean bool) {
        this.executeInGuildOnly = bool;
        return this;
    }

    public CommandConfigBuilder setRawArgsDesc(String desc) {
        this.rawArgsDesc = desc;
        return this;
    }

    public CommandConfigBuilder setRawArgsName(String name) {
        this.rawArgsName = name;
        return this;
    }

    public CommandConfig build() {
        List<CommandArgumentConfig> finalArgs = this.arguments.stream().map(CommandArgumentConfigBuilder::build).collect(Collectors.toList());
        this.validate(finalArgs);
        String commandArgumentsSignature = this.generateCmdArgsSignature();
        ArrayList<String> aliasesCopy = new ArrayList<String>(this.nameAndAliases);
        ArrayList<Permission> permissionsCopy = new ArrayList<Permission>(this.discordPerms);
        return new CommandConfig(aliasesCopy, this.desc, this.verboseDesc, this.listType, this.commandCooldown, permissionsCopy, this.commandGuildCooldown, finalArgs, this.executeInGuildOnly, this.rawArgs, this.rawArgsName, this.rawArgsDesc, this.executeIfCantCheckCooldown, commandArgumentsSignature, this.cleanCooldownRecords, this.cooldownRecordsCleaningPeriod);
    }

    private void validate(List<CommandArgumentConfig> args) {
        if (!this.commandGuildCooldown.equals(Duration.ZERO) && !this.executeInGuildOnly) {
            throw new IllegalArgumentException("If a command uses Guild Cooldown, in should be executeInGuildOnly");
        }
        boolean prevOptional = false;
        for (CommandArgumentConfig argCfg : args) {
            if (argCfg.isParseToDouble() && !argCfg.getArgumentOptions().isEmpty()) {
                throw new IllegalArgumentException("An argument must be either parse to double or have String options");
            }
            if (!argCfg.getDoubleValidators().isEmpty() && !argCfg.isParseToDouble()) {
                throw new IllegalArgumentException("If an argument has double validators, it must be set to parse to double as well.");
            }
            if (!argCfg.getStringValidators().isEmpty() && (argCfg.isMultiWordChoosingEnabled() || argCfg.isParseToDouble())) {
                throw new IllegalArgumentException("An argument must either have String validators or be set tomulti word choosing/paring to double");
            }
            if (argCfg.isMultiWordChoosingEnabled() && argCfg.isInQuotes()) {
                throw new IllegalArgumentException("An argument must be either in quotes or have multi word choosing enabled");
            }
            if ((argCfg.isMultiWordChoosingEnabled() || argCfg.isInQuotes()) && argCfg.isParseToDouble()) {
                throw new IllegalArgumentException("An argument must be either multi word/in quotes or parseToDouble");
            }
            if (prevOptional && !argCfg.isOptional()) {
                throw new IllegalArgumentException("If an argument is optional, then all the following arguments should be optional as well");
            }
            prevOptional = argCfg.isOptional();
        }
    }

    @NotNull
    private String generateCmdArgsSignature() {
        StringBuilder sbFieldName = new StringBuilder(this.nameAndAliases.get(0));
        if (this.rawArgs) {
            sbFieldName.append(" ");
            sbFieldName.append(this.rawArgsName);
        } else if (this.arguments.size() > 0) {
            for (CommandArgumentConfigBuilder arg : this.arguments) {
                sbFieldName.append(" ");
                if (arg.isOptional()) {
                    sbFieldName.append("{");
                    sbFieldName.append(arg.getArgumentName().toLowerCase());
                    CommandConfigBuilder.appendOptions(sbFieldName, arg);
                    sbFieldName.append("}");
                    continue;
                }
                sbFieldName.append("[");
                sbFieldName.append(arg.getArgumentName().toLowerCase());
                CommandConfigBuilder.appendOptions(sbFieldName, arg);
                sbFieldName.append("]");
            }
        }
        return sbFieldName.toString();
    }

    private static void appendOptions(StringBuilder fieldName, CommandArgumentConfigBuilder arg) {
        if (!arg.getArgumentOptions().isEmpty()) {
            fieldName.append("(");
            for (int j = 0; j < arg.getArgumentOptions().size(); ++j) {
                if (j > 0) {
                    fieldName.append("/");
                }
                fieldName.append(arg.getArgumentOptions().get(j));
            }
            fieldName.append(")");
        }
    }
}

