/*
 * Decompiled with CFR 0.152.
 */
package com.github.afarion1.command_handler.internal_commands;

import com.github.afarion1.command_handler.annotations.Config;
import com.github.afarion1.command_handler.command.AbstractCommand;
import com.github.afarion1.command_handler.command.CommandArguments;
import com.github.afarion1.command_handler.command.CommandHandler;
import com.github.afarion1.command_handler.command.config.CommandArgumentConfig;
import com.github.afarion1.command_handler.command.config.CommandArgumentConfigBuilder;
import com.github.afarion1.command_handler.command.config.CommandConfig;
import com.github.afarion1.command_handler.command.config.CommandConfigBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.Color;
import java.util.Set;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdInspectCommand
extends AbstractCommand {
    private static final Logger log = LoggerFactory.getLogger(CmdInspectCommand.class);
    private static final int ARG_CMD_NAME_ID = 0;
    private final Color embedColor;
    private final CommandHandler handler;
    private final Set<String> commandNames;

    public CmdInspectCommand(CommandHandler handler) {
        super(handler);
        this.embedColor = handler.getInspectCommandColor();
        this.handler = handler;
        this.commandNames = handler.getAllCommandNamesAndAliases();
    }

    @Config
    private static CommandConfig config() {
        return new CommandConfigBuilder("inspect command").addAliases("inspect").setDescription("Shows information about a command").addArguments(new CommandArgumentConfigBuilder(0, "Command name").setArgumentDescription("Name of the command you want to inspect").enableCustomArgumentChoosing(true).setOptional(true).setDefaultStringValue("inspect command")).build();
    }

    @Override
    public void execute(MessageReceivedEvent event, CommandArguments args) {
        String argCmdName = args.getStringArgumentValue(0);
        log.trace("Executing command inspection on {}", (Object)argCmdName);
        CommandConfig cfg = this.handler.findCommandAndGetConfig(argCmdName);
        if (cfg == null) {
            log.debug("Couldn't find command with name or alias {}", (Object)argCmdName);
            event.getChannel().sendMessage((CharSequence)(argCmdName + " wasn't found.")).queue();
            return;
        }
        MessageEmbed embed = this.setupEmbed(cfg);
        event.getChannel().sendMessage(embed).queue();
    }

    @Override
    public int chooseArgumentSymbols(MessageReceivedEvent event, String arguments, int argumentId) {
        if (argumentId != 0) {
            return 0;
        }
        IntArrayList matches = new IntArrayList();
        for (String name : this.commandNames) {
            int index = arguments.indexOf(name);
            if (index != 0 || arguments.length() != name.length()) continue;
            matches.add(index + name.length());
        }
        return matches.stream().min(Integer::compareTo).orElse(0);
    }

    @NotNull
    private MessageEmbed setupEmbed(CommandConfig cfg) {
        EmbedBuilder eb = new EmbedBuilder();
        eb.setTitle(cfg.getName());
        StringBuilder sb = new StringBuilder();
        if (cfg.getVerboseDesc().length() > 0) {
            sb.append(cfg.getVerboseDesc());
        } else {
            sb.append(cfg.getDescription());
        }
        sb.append("\n");
        if (cfg.getNameAndAliases().size() > 1) {
            sb.append("\nAliases: **");
            sb.append(cfg.getNameAndAliases().get(1));
            sb.append("**");
            for (int i = 2; i < cfg.getNameAndAliases().size(); ++i) {
                sb.append(", **");
                sb.append(cfg.getNameAndAliases().get(i));
                sb.append("**");
            }
        }
        if (cfg.getArguments().size() > 0) {
            sb.append("\n\nArguments:\n");
            for (CommandArgumentConfig arg : cfg.getArguments()) {
                String argumentInfo = arg.getArgumentDesc();
                argumentInfo = argumentInfo + "\n";
                if (arg.isOptional()) {
                    argumentInfo = argumentInfo + "Optional";
                }
                if (arg.isOptional() && arg.isInQuotes()) {
                    argumentInfo = argumentInfo + ", ";
                }
                if (arg.isInQuotes()) {
                    argumentInfo = argumentInfo + "Should be in quotes";
                }
                eb.addField(arg.getArgumentName(), argumentInfo, false);
            }
        } else if (cfg.isRawArgs()) {
            eb.addField(cfg.getRawArgsName(), cfg.getRawArgsDesc(), false);
        }
        eb.setDescription((CharSequence)sb.toString());
        eb.setFooter("", "https://images.vexels.com/media/users/3/147198/isolated/preview/76aff801de0d17c4d313489fccc55fa6-sunlight-burst-icon-by-vexels.png");
        eb.setColor(this.embedColor);
        return eb.build();
    }
}

