/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.base;

import com.mgz.afp.base.IHasTriplets;
import com.mgz.afp.base.RepeatingGroupBase;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.AFPValidationException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.parser.TripletParser;
import com.mgz.afp.triplets.Triplet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class RepeatingGroupWithTriplets
extends RepeatingGroupBase
implements IHasTriplets {
    protected List<Triplet> triplets;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        super.decodeAFP(sfData, offset, length, config);
        if (this.repeatingGroupLength > 2) {
            this.triplets = TripletParser.parseTriplets(sfData, offset + 2, this.repeatingGroupLength - 2, config);
        }
    }

    @Override
    public void validate() throws AFPValidationException {
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        super.writeAFP(os, config);
        if (this.triplets != null) {
            for (Triplet t : this.triplets) {
                t.writeAFP(os, config);
            }
        }
    }

    @Override
    public List<Triplet> getTriplets() {
        return this.triplets;
    }

    @Override
    public void setTriplets(List<Triplet> triplets) {
        this.triplets = triplets;
    }

    @Override
    public void addTriplet(Triplet triplet) {
        if (triplet == null) {
            return;
        }
        if (this.triplets == null) {
            this.triplets = new ArrayList<Triplet>();
        }
        this.triplets.add(triplet);
    }

    @Override
    public void removeTriplet(Triplet triplet) {
        if (this.triplets == null) {
            return;
        }
        this.triplets.add(triplet);
    }
}

