/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.base;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import java.io.IOException;
import java.io.OutputStream;

public class StructuredFieldBaseData
extends StructuredField {
    @AFPField(maxSize=32759)
    protected byte[] data;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        int actualLength = StructuredFieldBaseData.getActualLength(sfData, offset, length);
        if (actualLength > 0) {
            this.data = new byte[actualLength];
            System.arraycopy(sfData, offset, this.data, 0, actualLength);
        } else {
            this.data = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        this.writeFullStructuredField(os, this.data);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

