/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.base;

import com.mgz.afp.base.IHasName;
import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilCharacterEncoding;
import java.io.IOException;
import java.io.OutputStream;

public abstract class StructuredFieldBaseName
extends StructuredField
implements IHasName {
    @AFPField(maxSize=8)
    protected String name;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        int actualLength = StructuredFieldBaseName.getActualLength(sfData, offset, length);
        this.name = actualLength >= 8 ? new String(sfData, 0, 8, config.getAfpCharSet()) : null;
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        if (this.name != null) {
            this.writeFullStructuredField(os, UtilCharacterEncoding.stringToByteArray(this.name, config.getAfpCharSet(), 8, (byte)64));
        } else {
            this.writeFullStructuredField(os, null);
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String name) {
        this.name = name;
    }
}

