/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.base;

import com.mgz.afp.base.IHasTriplets;
import com.mgz.afp.base.StructuredFieldBaseName;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.parser.TripletParser;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class StructuredFieldBaseNameAndTriplets
extends StructuredFieldBaseName
implements IHasTriplets {
    @AFPField
    protected List<Triplet> triplets;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        super.decodeAFP(sfData, offset, length, config);
        int actualLength = StructuredFieldBaseNameAndTriplets.getActualLength(sfData, offset, length);
        this.triplets = actualLength > 8 ? TripletParser.parseTriplets(sfData, 8, sfData.length - 8, config) : null;
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.name != null) {
            baos.write(UtilCharacterEncoding.stringToByteArray(this.name, config.getAfpCharSet(), 8, (byte)64));
        }
        if (this.triplets != null) {
            for (Triplet triplet : this.triplets) {
                triplet.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    @Override
    public final List<Triplet> getTriplets() {
        return this.triplets;
    }

    @Override
    public final void setTriplets(List<Triplet> triplets) {
        this.triplets = triplets;
    }

    @Override
    public final void addTriplet(Triplet triplet) {
        if (triplet != null) {
            if (this.triplets == null) {
                this.triplets = new ArrayList<Triplet>();
            }
            this.triplets.add(triplet);
        }
    }

    @Override
    public final void removeTriplet(Triplet triplet) {
        if (triplet != null && this.triplets != null) {
            this.triplets.remove(triplet);
        }
    }
}

