/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.base;

import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.enums.SFFlag;
import com.mgz.afp.enums.SFTypeID;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;

public class StructuredFieldIntroducer {
    @AFPField(isEditable=false)
    int sfLength;
    @AFPField(isEditable=false)
    SFTypeID sfTypeID;
    @AFPField
    EnumSet<SFFlag> flagByte;
    @AFPField
    int reserved = 0;
    @AFPField
    short extenstionLength;
    @AFPField(maxSize=254)
    byte[] extenstion;
    AFPParserConfiguration actualConfig;
    @AFPField(isHidden=true)
    private long fileOffset;

    public static StructuredFieldIntroducer parse(InputStream is) throws AFPParserException {
        StructuredFieldIntroducer sfi = new StructuredFieldIntroducer();
        try {
            sfi.sfLength = UtilBinaryDecoding.parseInt(is, 2);
            sfi.sfTypeID = SFTypeID.parse(is);
            sfi.flagByte = SFFlag.valueOf(is.read());
            sfi.reserved = UtilBinaryDecoding.parseInt(is, 2);
        }
        catch (IOException ioex) {
            throw new AFPParserException("Failed to decode SFI header.", ioex);
        }
        try {
            if (sfi.isFlagSet(SFFlag.hasExtension)) {
                sfi.extenstionLength = (short)is.read();
                sfi.extenstion = new byte[sfi.extenstionLength - 1];
                if (sfi.extenstionLength - 1 < is.read(sfi.extenstion, 0, sfi.extenstionLength - 1)) {
                    throw new AFPParserException("Failed to read SFI extension data.");
                }
            }
        }
        catch (IOException ioex) {
            throw new AFPParserException("Failed to decode decode SFI extension data.", ioex);
        }
        return sfi;
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream b = this.flagByte == null || !this.flagByte.contains((Object)SFFlag.hasExtension) ? new ByteArrayOutputStream(8) : new ByteArrayOutputStream(8 + this.extenstionLength);
        b.write(UtilBinaryDecoding.intToByteArray(this.sfLength, 2));
        if (this.sfTypeID != null) {
            b.write(this.sfTypeID.toBytes());
        } else {
            b.write(new byte[]{0, 0, 0});
        }
        if (this.flagByte != null) {
            b.write(SFFlag.toByte(this.flagByte));
        } else {
            b.write(0);
        }
        b.write(UtilBinaryDecoding.intToByteArray(this.reserved, 2));
        if (this.flagByte != null && this.flagByte.contains((Object)SFFlag.hasExtension)) {
            b.write(UtilBinaryDecoding.shortToByteArray(this.extenstionLength, 1));
            b.write(this.extenstion);
        }
        return b.toByteArray();
    }

    public int getLengthOfStructuredFieldIntroducerIncludingExtension() {
        if (this.isFlagSet(SFFlag.hasExtension)) {
            return 8;
        }
        return 8 + this.extenstionLength;
    }

    public int getSFLength() {
        return this.sfLength;
    }

    public void setSFLength(int length) {
        this.sfLength = length;
    }

    public short getExtensionLength() {
        return this.extenstionLength;
    }

    public byte[] getExtensionData() {
        return this.extenstion;
    }

    public void setExtensionData(byte[] sfiExtensionData) {
        if (sfiExtensionData != null && sfiExtensionData.length > 254) {
            byte[] tmp = new byte[254];
            System.arraycopy(sfiExtensionData, 0, tmp, 0, 254);
            sfiExtensionData = tmp;
        }
        this.extenstion = sfiExtensionData;
        if (sfiExtensionData != null) {
            if (this.flagByte == null) {
                this.flagByte = EnumSet.noneOf(SFFlag.class);
            }
            this.flagByte.add(SFFlag.hasExtension);
            this.extenstionLength = (short)(sfiExtensionData.length + 1);
        } else {
            if (this.flagByte != null) {
                this.flagByte.remove((Object)SFFlag.hasExtension);
            }
            this.extenstionLength = 0;
        }
    }

    public int getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    public boolean isFlagSet(SFFlag flag) {
        if (this.flagByte == null) {
            return false;
        }
        return this.flagByte.contains((Object)flag);
    }

    public void setFlag(SFFlag flag) {
        if (this.flagByte == null) {
            this.flagByte = EnumSet.noneOf(SFFlag.class);
        }
        this.flagByte.add(flag);
    }

    public void removeFlag(SFFlag flag) {
        if (this.flagByte == null) {
            return;
        }
        this.flagByte.remove((Object)flag);
    }

    public SFTypeID getSFTypeID() {
        return this.sfTypeID;
    }

    public void setSFTypeID(SFTypeID sfTypeID) {
        this.sfTypeID = sfTypeID;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(long fileOffset) {
        this.fileOffset = fileOffset;
    }

    public EnumSet<SFFlag> getFlagByte() {
        return this.flagByte;
    }

    public void setFlagByte(EnumSet<SFFlag> flagByte) {
        this.flagByte = flagByte;
    }

    public AFPParserConfiguration getActualConfig() {
        return this.actualConfig;
    }

    public void setActualConfig(AFPParserConfiguration actualConfig) {
        this.actualConfig = actualConfig;
    }

    public String toString() {
        return "StructuredFieldIntroducer{sfTypeID=" + (Object)((Object)this.sfTypeID) + '}';
    }
}

