/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.bcoca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.enums.AFPUnitBase;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BDD_BarCodeDataDescriptor
extends StructuredField {
    @AFPField
    static byte Reserved1 = 0;
    @AFPField
    AFPUnitBase unitBase;
    @AFPField
    short unitsPerUnitBaseX;
    @AFPField
    short unitsPerUnitBaseY;
    @AFPField
    int presentationSpaceWidth;
    @AFPField
    int presentationSpaceLength;
    @AFPField
    short desiredSymbolWidth;
    @AFPField
    BarCodeType barcodeType;
    @AFPField
    byte barcodeModifier;
    @AFPField
    short fontLocalIDForHRI;
    @AFPField
    int color;
    @AFPField
    short moduleWidthInMils;
    @AFPField
    int elementHeight;
    @AFPField
    short heightMultiplier;
    @AFPField
    int wideToNarrowRatio;

    public static byte getReserved1() {
        return Reserved1;
    }

    public static void setReserved1(byte reserved1) {
        Reserved1 = reserved1;
    }

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        BDD_BarCodeDataDescriptor.checkDataLength(sfData, offset, length, 23);
        this.unitBase = AFPUnitBase.valueOf(sfData[offset]);
        this.unitsPerUnitBaseX = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
        this.unitsPerUnitBaseY = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
        this.presentationSpaceWidth = UtilBinaryDecoding.parseInt(sfData, offset + 6, 2);
        this.presentationSpaceLength = UtilBinaryDecoding.parseInt(sfData, offset + 8, 2);
        this.desiredSymbolWidth = UtilBinaryDecoding.parseShort(sfData, offset + 10, 2);
        this.barcodeType = BarCodeType.valueOf(sfData[offset + 12]);
        this.barcodeModifier = sfData[offset + 13];
        this.fontLocalIDForHRI = UtilBinaryDecoding.parseShort(sfData, offset + 14, 1);
        this.color = UtilBinaryDecoding.parseInt(sfData, offset + 15, 2);
        this.moduleWidthInMils = UtilBinaryDecoding.parseShort(sfData, offset + 17, 1);
        this.elementHeight = UtilBinaryDecoding.parseInt(sfData, offset + 18, 2);
        this.heightMultiplier = UtilBinaryDecoding.parseShort(sfData, offset + 20, 1);
        this.wideToNarrowRatio = UtilBinaryDecoding.parseInt(sfData, offset + 21, 2);
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.unitBase.toByte());
        baos.write(Reserved1);
        baos.write(UtilBinaryDecoding.shortToByteArray(this.unitsPerUnitBaseX, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.unitsPerUnitBaseY, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.presentationSpaceWidth, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.presentationSpaceLength, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.desiredSymbolWidth, 2));
        baos.write(this.barcodeType.toByte());
        baos.write(this.barcodeModifier);
        baos.write(UtilBinaryDecoding.shortToByteArray(this.fontLocalIDForHRI, 1));
        baos.write(UtilBinaryDecoding.intToByteArray(this.color, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.moduleWidthInMils, 1));
        baos.write(UtilBinaryDecoding.intToByteArray(this.elementHeight, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.heightMultiplier, 1));
        baos.write(UtilBinaryDecoding.intToByteArray(this.wideToNarrowRatio, 2));
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public AFPUnitBase getUnitBase() {
        return this.unitBase;
    }

    public void setUnitBase(AFPUnitBase unitBase) {
        this.unitBase = unitBase;
    }

    public short getUnitsPerUnitBaseX() {
        return this.unitsPerUnitBaseX;
    }

    public void setUnitsPerUnitBaseX(short unitsPerUnitBaseX) {
        this.unitsPerUnitBaseX = unitsPerUnitBaseX;
    }

    public short getUnitsPerUnitBaseY() {
        return this.unitsPerUnitBaseY;
    }

    public void setUnitsPerUnitBaseY(short unitsPerUnitBaseY) {
        this.unitsPerUnitBaseY = unitsPerUnitBaseY;
    }

    public int getPresentationSpaceWidth() {
        return this.presentationSpaceWidth;
    }

    public void setPresentationSpaceWidth(int presentationSpaceWidth) {
        this.presentationSpaceWidth = presentationSpaceWidth;
    }

    public int getPresentationSpaceLength() {
        return this.presentationSpaceLength;
    }

    public void setPresentationSpaceLength(int presentationSpaceLength) {
        this.presentationSpaceLength = presentationSpaceLength;
    }

    public short getDesiredSymbolWidth() {
        return this.desiredSymbolWidth;
    }

    public void setDesiredSymbolWidth(short desiredSymbolWidth) {
        this.desiredSymbolWidth = desiredSymbolWidth;
    }

    public BarCodeType getBarcodeType() {
        return this.barcodeType;
    }

    public void setBarcodeType(BarCodeType barcodeType) {
        this.barcodeType = barcodeType;
    }

    public byte getBarcodeModifier() {
        return this.barcodeModifier;
    }

    public void setBarcodeModifier(byte barcodeModifier) {
        this.barcodeModifier = barcodeModifier;
    }

    public short getFontLocalIDForHRI() {
        return this.fontLocalIDForHRI;
    }

    public void setFontLocalIDForHRI(short fontLocalIDForHRI) {
        this.fontLocalIDForHRI = fontLocalIDForHRI;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public short getModuleWidthInMils() {
        return this.moduleWidthInMils;
    }

    public void setModuleWidthInMils(short moduleWidthInMils) {
        this.moduleWidthInMils = moduleWidthInMils;
    }

    public int getElementHeight() {
        return this.elementHeight;
    }

    public void setElementHeight(int elementHeight) {
        this.elementHeight = elementHeight;
    }

    public short getHeightMultiplier() {
        return this.heightMultiplier;
    }

    public void setHeightMultiplier(short heightMultiplier) {
        this.heightMultiplier = heightMultiplier;
    }

    public int getWideToNarrowRatio() {
        return this.wideToNarrowRatio;
    }

    public void setWideToNarrowRatio(int wideToNarrowRatio) {
        this.wideToNarrowRatio = wideToNarrowRatio;
    }

    public static enum BarCodeType {
        Code39_3of9Code_AIM_USS_39(1, true, true, new byte[]{1, 2}),
        MSI_MmodifiedPlesseyCode(2, true, true, new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}),
        UPC_CGPC_VersionA(3, true, true, new byte[]{0}),
        UPC_CGPC_VersionE(5, true, true, new byte[]{0}),
        UPC_TwoDigit_Supplemental_Periodicals(6, true, true, new byte[]{0, 1, 2}),
        UPC_FiveDigit_Supplemental_Paperbacks(7, true, true, new byte[]{0, 1, 2}),
        EAN_8_includingJANShort(8, true, true, new byte[]{0}),
        EAN_13_includingJANStandard(9, true, true, new byte[]{0}),
        Industrial_2of5(10, false, false, new byte[]{1, 2}),
        Matrix_2ofFive(11, false, false, new byte[]{1, 2}),
        Interleaved_2of5__ITF14__AIM_USS_I_2of5(12, true, true, new byte[]{1, 2, 3, 4}),
        Codabar_2of7_AIM_USS_Codabar(13, false, true, new byte[]{1, 2}),
        Code_128__GS1_128__UCC_EAN_128__AIM_USS_128__IntelligentMail__ContainerBarcode(17, false, true, new byte[]{2, 3, 4, 5}),
        EAN_TwoDigit_Supplemental(22, true, true, new byte[]{0, 1}),
        EAN_FiveDigit_Supplemental(23, true, true, new byte[]{0, 1}),
        POSTNET_PLANET(24, false, false, new byte[]{0, 1, 2, 3, 4}),
        RM4SCC_DutchKIX(26, false, true, new byte[]{0, 1}),
        JapanPostalBarCode(27, false, true, new byte[]{0, 1}),
        DataMatrix_GS1DataMatrix_2D(28, false, true, new byte[]{0}),
        MaxiCode_2D(29, false, true, new byte[]{0}),
        PDF417_2D(30, false, true, new byte[]{0, 1}),
        AustraliaPostBarCode(31, false, true, new byte[]{1, 2, 3, 4, 5, 6, 7, 8}),
        QRCode_2D(32, false, true, new byte[]{2}),
        Code93(33, false, true, new byte[]{0}),
        IntelligentMailBarcode(34, false, true, new byte[]{0, 1, 2, 3}),
        RoyalMail_RED_TAG(35, false, false, new byte[]{0}),
        GS1_DataBar(36, false, false, new byte[]{0, 1, 2, 4, 17, 18, 19, 20, 21, 22, 23, 23, 24, 25, 26, 27}),
        Retired_Item7(4, false, false, new byte[]{0, 1, 2, 3, 4}),
        Retired_Item10(14, false, false, new byte[]{0}),
        Retired_Item11(15, false, false, new byte[]{0}),
        Retired_Item12(16, false, false, new byte[]{1, 2}),
        Retired_Item13(18, false, false, new byte[]{1, 2}),
        Retired_Item14(19, false, false, new byte[]{1, 2, 3}),
        Retired_Item15(20, false, false, new byte[]{0}),
        Retired_Item16(21, false, false, new byte[]{1, 2}),
        Retired_Item19(25, false, false, new byte[]{0, 1, 2, 3}),
        Retired_Item22(236, false, false, new byte[]{2}),
        Retired_Item23(237, false, false, new byte[]{0}),
        Retired_Item24(238, false, false, new byte[]{0}),
        Retired_Item25(239, false, false, new byte[]{0, 1});

        int code;
        boolean isBCD1;
        boolean isBCD2;

        private BarCodeType(int code, boolean isBCD1, boolean isBCD2, byte[] possibleBarCodeModfier) {
            this.code = code;
            this.isBCD1 = isBCD1;
            this.isBCD2 = isBCD2;
        }

        public static BarCodeType valueOf(int barcodeTypeCode) {
            for (BarCodeType bct : BarCodeType.values()) {
                if (bct.code != barcodeTypeCode) continue;
                return bct;
            }
            return null;
        }

        public byte toByte() {
            return (byte)this.code;
        }

        public boolean isBCD1() {
            return this.isBCD1;
        }

        public boolean isBCD2() {
            return this.isBCD2;
        }
    }
}

