/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.enums;

import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.util.UtilBinaryDecoding;

public enum AFPColorValue {
    DeviceDefault_0x00(0, 0, 0, 0),
    DeviceDefault_0xFF00(65280, 0, 0, 0),
    Blue_0x01(1, 0, 0, 255),
    Blue_0xFF01(65281, 0, 0, 255),
    Red_0x02(2, 255, 0, 0),
    Red_0xFF02(65282, 255, 0, 0),
    Magenta_0x03(3, 255, 0, 255),
    Magenta_0xFF03(65283, 255, 0, 255),
    Green_0x04(4, 0, 255, 0),
    Green_0xFF04(65284, 0, 255, 0),
    Cyan_0x05(5, 0, 255, 255),
    Cyan_0xFF05(65285, 0, 255, 255),
    Yellow_0x06(6, 255, 255, 0),
    Yellow_0xFF06(65286, 255, 255, 0),
    White_DeviceDefault_0x07(7, 255, 255, 255),
    White_DeviceDefault_0xFF07(65287, 255, 255, 255),
    Black_ColorOfMedium_0x08(8, 0, 0, 0),
    Black_ColorOfMedium_0xFF08(65288, 0, 0, 0),
    DarkBlue_0x09(9, 0, 0, 170),
    DarkBlue_0xFF09(65289, 0, 0, 170),
    Orange_0x0A(10, 255, 128, 0),
    Orange_0xFF0A(65290, 255, 128, 0),
    Purple_0x0B(11, 170, 0, 170),
    Purple_0xFF0B(65291, 170, 0, 170),
    DarkGreen_0x0C(12, 0, 146, 0),
    DarkGreen_0xFF0C(65292, 0, 146, 0),
    DarkTurquoise_0x0D(13, 0, 146, 170),
    DarkTurquoise_0xFF0D(65293, 0, 146, 170),
    Mustard_0x0E(14, 196, 160, 32),
    Mustard_0xFF0E(65294, 196, 160, 32),
    Gray_0x0F(15, 131, 131, 131),
    Gray_0xFF0F(65295, 131, 131, 131),
    Brown_0x10(16, 144, 48, 0),
    Brown_0xFF10(65296, 144, 48, 0),
    Default_0xFF(255, 0, 0, 0),
    Default_0xFFFF(65535, 0, 0, 0);

    int code;
    int red;
    int green;
    int blue;

    private AFPColorValue(int code, int red, int green, int blue) {
        this.code = code;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public static AFPColorValue valueOf(int code) throws AFPParserException {
        for (AFPColorValue cv : AFPColorValue.values()) {
            if (cv.code != code) continue;
            return cv;
        }
        throw new AFPParserException(AFPColorValue.class.getSimpleName() + ": color code 0x" + Integer.toHexString(code) + " is undefined.");
    }

    public int toByte() {
        return this.code & 0xFF;
    }

    public byte[] toByte2() {
        return UtilBinaryDecoding.intToByteArray(this.code, 2);
    }
}

