/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.foca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CFI_CodedFontIndex
extends StructuredField {
    public static final int CFIRepeatingGroupLength = 25;
    @AFPField
    List<CFIRepeatingGroup> cfiRepeatingGroups;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        CFI_CodedFontIndex.checkDataLength(sfData, offset, length, -1);
        this.cfiRepeatingGroups = new ArrayList<CFIRepeatingGroup>();
        for (int pos = 0; pos < sfData.length; pos += 25) {
            CFIRepeatingGroup cfiRepeatingGroup = new CFIRepeatingGroup();
            cfiRepeatingGroup.decodeAFP(sfData, pos, 25, config);
            this.cfiRepeatingGroups.add(cfiRepeatingGroup);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (CFIRepeatingGroup cfiRG : this.cfiRepeatingGroups) {
            cfiRG.writeAFP(baos, config);
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public List<CFIRepeatingGroup> getCfiRepeatingGroups() {
        return this.cfiRepeatingGroups;
    }

    public void setCfiRepeatingGroups(List<CFIRepeatingGroup> cfiRepeatingGroups) {
        this.cfiRepeatingGroups = cfiRepeatingGroups;
    }

    public void addCFIRepeatingGroup(CFIRepeatingGroup CFIrg) {
        if (CFIrg == null) {
            return;
        }
        if (this.cfiRepeatingGroups == null) {
            this.cfiRepeatingGroups = new ArrayList<CFIRepeatingGroup>();
        }
        this.cfiRepeatingGroups.add(CFIrg);
    }

    public void removeCFIRepeatingGroup(CFIRepeatingGroup CFIrg) {
        if (this.cfiRepeatingGroups == null) {
            return;
        }
        this.cfiRepeatingGroups.remove(CFIrg);
    }

    public static class CFIRepeatingGroup
    implements IAFPDecodeableWriteable {
        @AFPField
        String fcsName;
        @AFPField
        String cpName;
        @AFPField
        int svSize;
        @AFPField
        int shScale;
        @AFPField
        short section;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 25);
            this.fcsName = new String(sfData, offset, 8, config.getAfpCharSet());
            this.cpName = new String(sfData, offset + 8, 8, config.getAfpCharSet());
            this.svSize = UtilBinaryDecoding.parseInt(sfData, offset + 16, 2);
            this.shScale = UtilBinaryDecoding.parseInt(sfData, offset + 18, 2);
            this.section = UtilBinaryDecoding.parseShort(sfData, offset + 24, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilCharacterEncoding.stringToByteArray(this.fcsName, config.getAfpCharSet(), 8, (byte)64));
            os.write(UtilCharacterEncoding.stringToByteArray(this.cpName, config.getAfpCharSet(), 8, (byte)64));
            os.write(UtilBinaryDecoding.intToByteArray(this.svSize, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.shScale, 2));
            os.write(new byte[4]);
            os.write(UtilBinaryDecoding.shortToByteArray(this.section, 1));
        }
    }
}

