/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.foca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.Constants;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class CPD_CodePageDescriptor
extends StructuredField {
    private static final Charset cpIBM500 = Constants.cpIBM500;
    @AFPField
    public short graphicCharacterGIDLength;
    @AFPField
    String codePageDescription;
    @AFPField
    long numberOfCodedGraphicCharactersAssigned;
    @AFPField
    int graphicCharacterSetGID;
    @AFPField
    int codePageGID;
    @AFPField(isOptional=true, indexNr=0)
    EncodingScheme encodingScheme;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        CPD_CodePageDescriptor.checkDataLength(sfData, 0, -1, 42);
        this.codePageDescription = new String(sfData, offset, 32, cpIBM500);
        this.graphicCharacterGIDLength = UtilBinaryDecoding.parseShort(sfData, offset + 32, 2);
        this.numberOfCodedGraphicCharactersAssigned = UtilBinaryDecoding.parseLong(sfData, offset + 34, 4);
        this.graphicCharacterSetGID = UtilBinaryDecoding.parseInt(sfData, offset + 38, 2);
        this.codePageGID = UtilBinaryDecoding.parseInt(sfData, offset + 40, 2);
        this.encodingScheme = length > 42 && sfData.length > offset + 42 ? EncodingScheme.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 42, 2)) : null;
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(UtilCharacterEncoding.stringToByteArray(this.codePageDescription, cpIBM500, 32, (byte)64));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.graphicCharacterGIDLength, 2));
        baos.write(UtilBinaryDecoding.longToByteArray(this.numberOfCodedGraphicCharactersAssigned, 4));
        baos.write(UtilBinaryDecoding.intToByteArray(this.graphicCharacterSetGID, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.codePageGID, 2));
        if (this.encodingScheme != null) {
            baos.write(this.encodingScheme.toBytes());
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public String getCodePageDescription() {
        return this.codePageDescription;
    }

    public void setCodePageDescription(String codePageDescription) {
        this.codePageDescription = codePageDescription;
    }

    public short getGraphicCharacterGIDLength() {
        return this.graphicCharacterGIDLength;
    }

    public void setGraphicCharacterGIDLength(short graphicCharacterGIDLength) {
        this.graphicCharacterGIDLength = graphicCharacterGIDLength;
    }

    public long getNumberOfCodedGraphicCharactersAssigned() {
        return this.numberOfCodedGraphicCharactersAssigned;
    }

    public void setNumberOfCodedGraphicCharactersAssigned(long numberOfCodedGraphicCharactersAssigned) {
        this.numberOfCodedGraphicCharactersAssigned = numberOfCodedGraphicCharactersAssigned;
    }

    public int getGraphicCharacterSetGID() {
        return this.graphicCharacterSetGID;
    }

    public void setGraphicCharacterSetGID(int graphicCharacterSetGID) {
        this.graphicCharacterSetGID = graphicCharacterSetGID;
    }

    public int getCodePageGID() {
        return this.codePageGID;
    }

    public void setCodePageGID(int codePageGID) {
        this.codePageGID = codePageGID;
    }

    public EncodingScheme getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingScheme(EncodingScheme encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    public static enum EncodingScheme {
        NoEncodingSchemeSpecified(0),
        SingleByte_EncodingNotSpecified(256),
        DoubleByte_EncodingNotSpecified(512),
        SingleByte_IBMPCData(8448),
        SingleByte_EBCDICPresentation(24832),
        DoubleByte_EBCDICPresentation(25088),
        DoubleByte_UCSPresentation(33280);

        int encodingSchemeCode;

        private EncodingScheme(int encodingSchemeCode) {
            this.encodingSchemeCode = encodingSchemeCode;
        }

        public static EncodingScheme valueOf(int encodingSchemeCode) {
            for (EncodingScheme es : EncodingScheme.values()) {
                if (es.encodingSchemeCode != encodingSchemeCode) continue;
                return es;
            }
            return null;
        }

        public byte[] toBytes() {
            return UtilBinaryDecoding.intToByteArray(this.encodingSchemeCode, 2);
        }

        public boolean isDoubleByte() {
            return this == DoubleByte_EncodingNotSpecified || this == DoubleByte_EBCDICPresentation || this == DoubleByte_UCSPresentation;
        }
    }
}

