/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.foca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.foca.CPC_CodePageControl;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.Constants;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class CPI_CodePageIndex
extends StructuredField {
    private static final Charset cpIBM500 = Constants.cpIBM500;
    @AFPField
    List<CPI_RepeatingGroup> repeatingGroups;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        CPC_CodePageControl cpc = config.getCurrentCodePageControl();
        CPC_CodePageControl.CPIRepeatingGroupLength cpiRGLen = cpc.getCpiRepeatingGroupLength();
        short nrOfBytes = cpiRGLen.nrOfBytes();
        int minLength = 9 + nrOfBytes;
        CPI_CodePageIndex.checkDataLength(sfData, offset, length, minLength);
        int actualLength = CPI_CodePageIndex.getActualLength(sfData, offset, length);
        if (actualLength > minLength) {
            this.repeatingGroups = new ArrayList<CPI_RepeatingGroup>();
            int pos = 0;
            while (pos < actualLength) {
                CPI_RepeatingGroup cpirg = new CPI_RepeatingGroup();
                cpirg.graphicCharacterGID = new String(sfData, offset + pos, 8, cpIBM500);
                cpirg.graphicCharacterUseFlags = GraphicCharacterUseFlag.valueOf(sfData[offset + pos + 8] & 0xFF);
                cpirg.codePoint = UtilBinaryDecoding.parseInt(sfData, offset + pos + 9, nrOfBytes);
                if (cpiRGLen.isUnicodeScalarValues() && (pos += minLength) < actualLength) {
                    int numberOfUnicodeScalarValues = UtilBinaryDecoding.parseShort(sfData, offset + pos, 1);
                    if (numberOfUnicodeScalarValues > 0) {
                        cpirg.unicodeScalarValues = new ArrayList<Long>(numberOfUnicodeScalarValues);
                        CPI_CodePageIndex.checkDataLength(sfData, offset, length, minLength + 1 + numberOfUnicodeScalarValues * 4);
                        for (int i = 0; i < numberOfUnicodeScalarValues; ++i) {
                            cpirg.unicodeScalarValues.add(UtilBinaryDecoding.parseLong(sfData, offset + pos, 4));
                            pos += 4;
                        }
                    } else {
                        cpirg.unicodeScalarValues = null;
                    }
                } else {
                    cpirg.unicodeScalarValues = null;
                }
                this.repeatingGroups.add(cpirg);
            }
        } else {
            this.repeatingGroups = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        CPC_CodePageControl cpc = config.getCurrentCodePageControl();
        CPC_CodePageControl.CPIRepeatingGroupLength cpiRGLen = cpc.getCpiRepeatingGroupLength();
        short nrOfBytes = cpiRGLen.nrOfBytes();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (CPI_RepeatingGroup rg : this.repeatingGroups) {
            baos.write(UtilCharacterEncoding.stringToByteArray(rg.graphicCharacterGID, cpIBM500, 8, (byte)64));
            baos.write(GraphicCharacterUseFlag.toByte(rg.graphicCharacterUseFlags));
            baos.write(UtilBinaryDecoding.intToByteArray(rg.codePoint, nrOfBytes));
            if (!cpiRGLen.isUnicodeScalarValues()) continue;
            if (rg.unicodeScalarValues == null) {
                baos.write(0);
                continue;
            }
            baos.write(rg.unicodeScalarValues.size());
            for (Long usv : rg.unicodeScalarValues) {
                baos.write(UtilBinaryDecoding.longToByteArray(usv, 4));
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public static class CPI_RepeatingGroup {
        @AFPField
        String graphicCharacterGID;
        @AFPField
        EnumSet<GraphicCharacterUseFlag> graphicCharacterUseFlags;
        @AFPField
        int codePoint;
        @AFPField
        List<Long> unicodeScalarValues;

        public String getGraphicCharacterGID() {
            return this.graphicCharacterGID;
        }

        public void setGraphicCharacterGID(String graphicCharacterGID) {
            this.graphicCharacterGID = graphicCharacterGID;
        }

        public EnumSet<GraphicCharacterUseFlag> getGraphicCharacterUseFlags() {
            return this.graphicCharacterUseFlags;
        }

        public void setGraphicCharacterUseFlags(EnumSet<GraphicCharacterUseFlag> graphicCharacterUseFlags) {
            this.graphicCharacterUseFlags = graphicCharacterUseFlags;
        }

        public int getCodePoint() {
            return this.codePoint;
        }

        public void setCodePoint(int codePoint) {
            this.codePoint = codePoint;
        }

        public List<Long> getUnicodeScalarValues() {
            return this.unicodeScalarValues;
        }

        public void setUnicodeScalarValues(List<Long> unicodeScalarValues) {
            this.unicodeScalarValues = unicodeScalarValues;
        }
    }

    public static enum GraphicCharacterUseFlag {
        InvalidCodedCharacter,
        NoPresentation,
        NoIncrement;


        public static EnumSet<GraphicCharacterUseFlag> valueOf(int flagByte) {
            EnumSet<GraphicCharacterUseFlag> result = EnumSet.noneOf(GraphicCharacterUseFlag.class);
            if ((flagByte & 0x80) != 0) {
                result.add(InvalidCodedCharacter);
            }
            if ((flagByte & 0x40) != 0) {
                result.add(NoPresentation);
            }
            if ((flagByte & 0x20) != 0) {
                result.add(NoIncrement);
            }
            return result;
        }

        public static int toByte(EnumSet<GraphicCharacterUseFlag> flags) {
            int result = 0;
            if (flags.contains((Object)InvalidCodedCharacter)) {
                result += 128;
            }
            if (flags.contains((Object)NoPresentation)) {
                result += 64;
            }
            if (flags.contains((Object)NoIncrement)) {
                result += 32;
            }
            return result;
        }
    }
}

