/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.foca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.parser.TripletParser;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.List;

public class FNC_FontControl
extends StructuredField {
    public static final byte FNPRepeatingGroupLength = 22;
    public static final byte FNNRepeatingGroupLength = 12;
    public static final byte FNORepeatingGroupLength = 26;
    @AFPField
    byte retired0 = 1;
    @AFPField
    PatternTechnologyIdentifier patternTechnologyIdentifier;
    @AFPField
    byte reserved2 = 0;
    @AFPField
    EnumSet<FNC_FontUseFlag> fontUseFlags;
    @AFPField
    FontUnitBase xUnitBase;
    @AFPField
    FontUnitBase yUnitBase;
    @AFPField
    short xUnitsPerUnitBase;
    @AFPField
    short yUnitsPerUnitBase;
    @AFPField
    short maxCharacterBoxWidth;
    @AFPField
    short maxCharacterBoxHeight;
    @AFPField
    byte fnoRepeatingGroupLength = (byte)26;
    @AFPField
    short fniRepeatingGroupLength;
    @AFPField
    RasterPatternDataAlignment rasterPatternDataAlignment;
    @AFPField
    int rasterPatternDataCount;
    @AFPField
    byte fnpRepeatingGroupLength = (byte)22;
    @AFPField
    byte fnmRepeatinGroupLength;
    @AFPField
    byte ShapeResolutionXUnitBase10Inches = 0;
    @AFPField
    byte ShapeResolutionYUnitBase10Inches = 0;
    @AFPField
    short shapeResolutionXUnitsPerUnitBase;
    @AFPField
    short shapeResolutionYUnitsPerUnitBase;
    @AFPField
    long outlinePatternDataCount;
    @AFPField(size=3)
    byte[] reserved32_34 = new byte[]{0, 0, 0};
    @AFPField
    byte fnnRepeatingGroupLength = (byte)12;
    @AFPField
    long fnnDataCount;
    @AFPField
    int fnnIBMNameGCGIDCount;
    @AFPField
    List<Triplet> triplets;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        FNC_FontControl.checkDataLength(sfData, offset, length, 22);
        int actualLength = FNC_FontControl.getActualLength(sfData, offset, length);
        this.patternTechnologyIdentifier = PatternTechnologyIdentifier.valueOf(sfData[offset + 1]);
        this.fontUseFlags = FNC_FontUseFlag.valueOf(sfData[offset + 3]);
        this.xUnitBase = FontUnitBase.valueOf(sfData[offset + 4]);
        this.yUnitBase = FontUnitBase.valueOf(sfData[offset + 5]);
        this.xUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 6, 2);
        this.yUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 8, 2);
        this.maxCharacterBoxWidth = UtilBinaryDecoding.parseShort(sfData, offset + 10, 2);
        this.maxCharacterBoxHeight = UtilBinaryDecoding.parseShort(sfData, offset + 12, 2);
        this.fniRepeatingGroupLength = UtilBinaryDecoding.parseShort(sfData, offset + 15, 1);
        this.rasterPatternDataAlignment = RasterPatternDataAlignment.valueOf(sfData[offset + 16]);
        this.rasterPatternDataCount = UtilBinaryDecoding.parseInt(sfData, offset + 17, 3);
        this.fnmRepeatinGroupLength = sfData[offset + 21];
        this.shapeResolutionXUnitsPerUnitBase = actualLength >= 26 ? UtilBinaryDecoding.parseShort(sfData, offset + 24, 2) : (short)0;
        this.shapeResolutionYUnitsPerUnitBase = actualLength >= 28 ? UtilBinaryDecoding.parseShort(sfData, offset + 26, 2) : (short)0;
        this.outlinePatternDataCount = actualLength >= 32 ? UtilBinaryDecoding.parseLong(sfData, offset + 28, 4) : 0L;
        this.fnnIBMNameGCGIDCount = actualLength >= 42 ? UtilBinaryDecoding.parseInt(sfData, offset + 40, 2) : 0;
        this.triplets = actualLength >= 43 ? TripletParser.parseTriplets(sfData, 42, -1, config) : null;
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.retired0);
        baos.write(this.patternTechnologyIdentifier.toByte());
        baos.write(this.reserved2);
        baos.write(FNC_FontUseFlag.toByte(this.fontUseFlags));
        baos.write(this.xUnitBase.toByte());
        baos.write(this.yUnitBase.toByte());
        baos.write(UtilBinaryDecoding.shortToByteArray(this.xUnitsPerUnitBase, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.yUnitsPerUnitBase, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.maxCharacterBoxWidth, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.maxCharacterBoxHeight, 2));
        baos.write(this.fnoRepeatingGroupLength);
        baos.write(UtilBinaryDecoding.shortToByteArray(this.fniRepeatingGroupLength, 1));
        baos.write(this.rasterPatternDataAlignment.toByte());
        baos.write(UtilBinaryDecoding.intToByteArray(this.rasterPatternDataCount, 3));
        baos.write(this.fnpRepeatingGroupLength);
        baos.write(this.fnmRepeatinGroupLength);
        if (!(this.xUnitBase == FontUnitBase.BaseIsFixedAt10Inches && this.yUnitBase == FontUnitBase.BaseIsFixedAt10Inches && this.xUnitsPerUnitBase == 0 && this.yUnitsPerUnitBase == 0 || this.xUnitBase == FontUnitBase.BaseIsRelativ && this.yUnitBase == FontUnitBase.BaseIsRelativ && this.xUnitsPerUnitBase == 0 && this.yUnitsPerUnitBase == 0)) {
            baos.write(this.ShapeResolutionXUnitBase10Inches);
            baos.write(this.ShapeResolutionYUnitBase10Inches);
            baos.write(UtilBinaryDecoding.shortToByteArray(this.shapeResolutionXUnitsPerUnitBase, 2));
            baos.write(UtilBinaryDecoding.shortToByteArray(this.shapeResolutionYUnitsPerUnitBase, 2));
            if (this.patternTechnologyIdentifier != PatternTechnologyIdentifier.LaserMatrixNBitWide) {
                baos.write(UtilBinaryDecoding.longToByteArray(this.outlinePatternDataCount, 4));
                baos.write(this.reserved32_34);
                baos.write(this.fnnRepeatingGroupLength);
                baos.write(UtilBinaryDecoding.longToByteArray(this.fnnDataCount, 4));
                baos.write(UtilBinaryDecoding.intToByteArray(this.fnnIBMNameGCGIDCount, 2));
            }
            if (this.triplets != null) {
                for (Triplet t : this.triplets) {
                    t.writeAFP(baos, config);
                }
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public PatternTechnologyIdentifier getPatternTechnologyIdentifier() {
        return this.patternTechnologyIdentifier;
    }

    public void setPatternTechnologyIdentifier(PatternTechnologyIdentifier patternTechnologyIdentifier) {
        this.patternTechnologyIdentifier = patternTechnologyIdentifier;
    }

    public EnumSet<FNC_FontUseFlag> getFontUseFlags() {
        return this.fontUseFlags;
    }

    public void setFontUseFlags(EnumSet<FNC_FontUseFlag> fontUseFlags) {
        this.fontUseFlags = fontUseFlags;
    }

    public FontUnitBase getxUnitBase() {
        return this.xUnitBase;
    }

    public void setxUnitBase(FontUnitBase xUnitBase) {
        this.xUnitBase = xUnitBase;
    }

    public FontUnitBase getyUnitBase() {
        return this.yUnitBase;
    }

    public void setyUnitBase(FontUnitBase yUnitBase) {
        this.yUnitBase = yUnitBase;
    }

    public short getxUnitsPerUnitBase() {
        return this.xUnitsPerUnitBase;
    }

    public void setxUnitsPerUnitBase(short xUnitsPerUnitBase) {
        this.xUnitsPerUnitBase = xUnitsPerUnitBase;
    }

    public short getyUnitsPerUnitBase() {
        return this.yUnitsPerUnitBase;
    }

    public void setyUnitsPerUnitBase(short yUnitsPerUnitBase) {
        this.yUnitsPerUnitBase = yUnitsPerUnitBase;
    }

    public short getMaxCharacterBoxWidth() {
        return this.maxCharacterBoxWidth;
    }

    public void setMaxCharacterBoxWidth(short maxCharacterBoxWidth) {
        this.maxCharacterBoxWidth = maxCharacterBoxWidth;
    }

    public short getMaxCharacterBoxHeight() {
        return this.maxCharacterBoxHeight;
    }

    public void setMaxCharacterBoxHeight(short maxCharacterBoxHeight) {
        this.maxCharacterBoxHeight = maxCharacterBoxHeight;
    }

    public byte getFNORepeatingGroupLength() {
        return this.fnoRepeatingGroupLength;
    }

    public void setFNORepeatingGroupLength(byte fnoRepeatingGroupLength) {
        this.fnoRepeatingGroupLength = fnoRepeatingGroupLength;
    }

    public short getFniRepeatingGroupLength() {
        return this.fniRepeatingGroupLength;
    }

    public void setFniRepeatingGroupLength(short fniRepeatingGroupLength) {
        this.fniRepeatingGroupLength = fniRepeatingGroupLength;
    }

    public RasterPatternDataAlignment getRasterPatternDataAlignment() {
        return this.rasterPatternDataAlignment;
    }

    public void setRasterPatternDataAlignment(RasterPatternDataAlignment rasterPatternDataAlignment) {
        this.rasterPatternDataAlignment = rasterPatternDataAlignment;
    }

    public int getRasterPatternDataCount() {
        return this.rasterPatternDataCount;
    }

    public void setRasterPatternDataCount(int rasterPatternDataCount) {
        this.rasterPatternDataCount = rasterPatternDataCount;
    }

    public byte getFNPRepeatingGroupLength() {
        return this.fnpRepeatingGroupLength;
    }

    public void setFNPRepeatingGroupLength(byte fNPRepeatingGroupLength) {
        this.fnpRepeatingGroupLength = fNPRepeatingGroupLength;
    }

    public byte getFnmRepeatinGroupLength() {
        return this.fnmRepeatinGroupLength;
    }

    public void setFnmRepeatinGroupLength(byte fnmRepeatinGroupLength) {
        this.fnmRepeatinGroupLength = fnmRepeatinGroupLength;
    }

    public byte getShapeResolutionXUnitBase10Inches() {
        return this.ShapeResolutionXUnitBase10Inches;
    }

    public void setShapeResolutionXUnitBase10Inches(byte shapeResolutionXUnitBase10Inches) {
        this.ShapeResolutionXUnitBase10Inches = shapeResolutionXUnitBase10Inches;
    }

    public byte getShapeResolutionYUnitBase10Inches() {
        return this.ShapeResolutionYUnitBase10Inches;
    }

    public void setShapeResolutionYUnitBase10Inches(byte shapeResolutionYUnitBase10Inches) {
        this.ShapeResolutionYUnitBase10Inches = shapeResolutionYUnitBase10Inches;
    }

    public short getShapeResolutionXUnitsPerUnitBase() {
        return this.shapeResolutionXUnitsPerUnitBase;
    }

    public void setShapeResolutionXUnitsPerUnitBase(short shapeResolutionXUnitsPerUnitBase) {
        this.shapeResolutionXUnitsPerUnitBase = shapeResolutionXUnitsPerUnitBase;
    }

    public short getShapeResolutionYUnitsPerUnitBase() {
        return this.shapeResolutionYUnitsPerUnitBase;
    }

    public void setShapeResolutionYUnitsPerUnitBase(short shapeResolutionYUnitsPerUnitBase) {
        this.shapeResolutionYUnitsPerUnitBase = shapeResolutionYUnitsPerUnitBase;
    }

    public long getOutlinePatternDataCount() {
        return this.outlinePatternDataCount;
    }

    public void setOutlinePatternDataCount(long outlinePatternDataCount) {
        this.outlinePatternDataCount = outlinePatternDataCount;
    }

    public byte[] getReserved32_34() {
        return this.reserved32_34;
    }

    public void setReserved32_34(byte[] reservedByte32_34) {
        this.reserved32_34 = reservedByte32_34;
    }

    public long getFnnDataCount() {
        return this.fnnDataCount;
    }

    public void setFnnDataCount(long fnnDataCount) {
        this.fnnDataCount = fnnDataCount;
    }

    public int getFnnIBMNameGCGIDCount() {
        return this.fnnIBMNameGCGIDCount;
    }

    public void setFnnIBMNameGCGIDCount(int fnnIBMNameGCGIDCount) {
        this.fnnIBMNameGCGIDCount = fnnIBMNameGCGIDCount;
    }

    public List<Triplet> getTriplets() {
        return this.triplets;
    }

    public void setTriplets(List<Triplet> triplets) {
        this.triplets = triplets;
    }

    public byte getRetiredbyte0() {
        return this.retired0;
    }

    public byte getReservedbyte2() {
        return this.reserved2;
    }

    public byte getRetired0() {
        return this.retired0;
    }

    public void setRetired0(byte retired0) {
        this.retired0 = retired0;
    }

    public byte getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(byte reserved2) {
        this.reserved2 = reserved2;
    }

    public byte getFnoRepeatingGroupLength() {
        return this.fnoRepeatingGroupLength;
    }

    public void setFnoRepeatingGroupLength(byte fnoRepeatingGroupLength) {
        this.fnoRepeatingGroupLength = fnoRepeatingGroupLength;
    }

    public byte getFnpRepeatingGroupLength() {
        return this.fnpRepeatingGroupLength;
    }

    public void setFnpRepeatingGroupLength(byte fnpRepeatingGroupLength) {
        this.fnpRepeatingGroupLength = fnpRepeatingGroupLength;
    }

    public byte getFnnRepeatingGroupLength() {
        return this.fnnRepeatingGroupLength;
    }

    public void setFnnRepeatingGroupLength(byte fnnRepeatingGroupLength) {
        this.fnnRepeatingGroupLength = fnnRepeatingGroupLength;
    }

    public static enum RasterPatternDataAlignment {
        Alignment_1Byte(0),
        Alignment_4Byte(2),
        Alignment_8Byte(3);

        byte rasterPatternAlignmentByte;

        private RasterPatternDataAlignment(byte rasterPatternAlignmentByte) {
            this.rasterPatternAlignmentByte = rasterPatternAlignmentByte;
        }

        public static RasterPatternDataAlignment valueOf(byte rasterPatternAlignmentCode) {
            for (RasterPatternDataAlignment rpda : RasterPatternDataAlignment.values()) {
                if (rasterPatternAlignmentCode != rpda.rasterPatternAlignmentByte) continue;
                return rpda;
            }
            return null;
        }

        public byte toByte() {
            return this.rasterPatternAlignmentByte;
        }
    }

    public static enum FontUnitBase {
        BaseIsFixedAt10Inches,
        BaseIsRelativ;


        public static FontUnitBase valueOf(byte fontUnitBaseByte) {
            if (fontUnitBaseByte == 0) {
                return BaseIsFixedAt10Inches;
            }
            if (fontUnitBaseByte == 2) {
                return BaseIsRelativ;
            }
            return null;
        }

        public byte toByte() {
            if (this == BaseIsFixedAt10Inches) {
                return 0;
            }
            if (this == BaseIsRelativ) {
                return 2;
            }
            return 0;
        }
    }

    public static enum FNC_FontUseFlag {
        MICRPrinting,
        ExtensionFont,
        RetiredDoNotShiftBaseLineOffset,
        UniformRasterPatternSize;


        public static EnumSet<FNC_FontUseFlag> valueOf(byte fontUseFlagByte) {
            EnumSet<FNC_FontUseFlag> result = EnumSet.noneOf(FNC_FontUseFlag.class);
            if ((fontUseFlagByte & 0xFF & 0x80) > 0) {
                result.add(MICRPrinting);
            }
            if ((fontUseFlagByte & 0xFF & 0x40) > 0) {
                result.add(ExtensionFont);
            }
            if ((fontUseFlagByte & 0xFF & 8) > 0) {
                result.add(RetiredDoNotShiftBaseLineOffset);
            }
            if ((fontUseFlagByte & 0xFF & 2) > 0) {
                result.add(UniformRasterPatternSize);
            }
            return result;
        }

        public static byte toByte(EnumSet<FNC_FontUseFlag> fontUseFlags) {
            byte result = 0;
            if (fontUseFlags.contains((Object)MICRPrinting)) {
                result = (byte)(result | 0x80);
            }
            if (fontUseFlags.contains((Object)ExtensionFont)) {
                result = (byte)(result | 0x40);
            }
            if (fontUseFlags.contains((Object)RetiredDoNotShiftBaseLineOffset)) {
                result = (byte)(result | 8);
            }
            if (fontUseFlags.contains((Object)UniformRasterPatternSize)) {
                result = (byte)(result | 2);
            }
            return result;
        }
    }

    public static enum PatternTechnologyIdentifier {
        LaserMatrixNBitWide(5),
        CompositeAdobeType0(30),
        Type1FontPrinterFileBinary(31);

        byte patternTechnologyIdentifierByte;

        private PatternTechnologyIdentifier(byte code) {
            this.patternTechnologyIdentifierByte = code;
        }

        public static PatternTechnologyIdentifier valueOf(byte patternTechnologyIdentifierByte) {
            for (PatternTechnologyIdentifier pti : PatternTechnologyIdentifier.values()) {
                if (pti.patternTechnologyIdentifierByte != patternTechnologyIdentifierByte) continue;
                return pti;
            }
            return null;
        }

        public byte toByte() {
            return this.patternTechnologyIdentifierByte;
        }
    }
}

