/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.foca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.parser.TripletParser;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.Constants;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.List;

public class FND_FontDescriptor
extends StructuredField {
    private static final Charset cpIBM500 = Constants.cpIBM500;
    @AFPField
    String typefaceDescription;
    @AFPField
    FontWeightClass fontWeightClass;
    @AFPField
    FontWidthClass fontWidthClass;
    @AFPField
    short maxVerticalSize;
    @AFPField
    short nominalVerticalSize;
    @AFPField
    short minVerticalSize;
    @AFPField
    short maxHorizontalSize;
    @AFPField
    short nominalHorizontalSize;
    @AFPField
    short minHorizontalSize;
    @AFPField
    short designGeneralClass;
    @AFPField
    short designSubClass;
    @AFPField
    short designSpecificGroup;
    @AFPField(size=15)
    byte[] reserved49_63 = new byte[15];
    @AFPField
    EnumSet<FontDesignFlag> fontDesignFlags;
    @AFPField(size=10)
    byte[] reserved66_75 = new byte[10];
    @AFPField
    int GCSGID_FontGraphicCharacterSetGlobalID;
    @AFPField
    int FGID_FontTypefaceGlobalID;
    @AFPField
    List<Triplet> triplets;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        FND_FontDescriptor.checkDataLength(sfData, offset, length, 80);
        this.typefaceDescription = new String(sfData, offset, 32, cpIBM500);
        this.fontWeightClass = FontWeightClass.valueOf(sfData[offset + 32]);
        this.fontWidthClass = FontWidthClass.valueOf(sfData[offset + 33]);
        this.maxVerticalSize = UtilBinaryDecoding.parseShort(sfData, offset + 34, 2);
        this.nominalVerticalSize = UtilBinaryDecoding.parseShort(sfData, offset + 36, 2);
        this.minVerticalSize = UtilBinaryDecoding.parseShort(sfData, offset + 38, 2);
        this.maxHorizontalSize = UtilBinaryDecoding.parseShort(sfData, offset + 40, 2);
        this.nominalHorizontalSize = UtilBinaryDecoding.parseShort(sfData, offset + 42, 2);
        this.minHorizontalSize = UtilBinaryDecoding.parseShort(sfData, offset + 44, 2);
        this.designGeneralClass = UtilBinaryDecoding.parseShort(sfData, offset + 46, 1);
        this.designSubClass = UtilBinaryDecoding.parseShort(sfData, offset + 47, 1);
        this.designSpecificGroup = UtilBinaryDecoding.parseShort(sfData, offset + 48, 1);
        this.reserved49_63 = new byte[15];
        System.arraycopy(sfData, offset + 49, this.reserved49_63, 0, this.reserved49_63.length);
        this.fontDesignFlags = FontDesignFlag.valueOf(sfData[offset + 64]);
        this.reserved66_75 = new byte[10];
        System.arraycopy(sfData, offset + 66, this.reserved66_75, 0, 10);
        this.GCSGID_FontGraphicCharacterSetGlobalID = UtilBinaryDecoding.parseInt(sfData, offset + 76, 2);
        this.FGID_FontTypefaceGlobalID = UtilBinaryDecoding.parseInt(sfData, offset + 78, 2);
        int actualLength = FND_FontDescriptor.getActualLength(sfData, offset, length);
        this.triplets = actualLength > 80 ? TripletParser.parseTriplets(sfData, offset + 80, -1, config) : null;
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(UtilCharacterEncoding.stringToByteArray(this.typefaceDescription, cpIBM500, 32, (byte)64));
        baos.write(this.fontWeightClass.toByte());
        baos.write(this.fontWidthClass.toByte());
        baos.write(UtilBinaryDecoding.shortToByteArray(this.maxVerticalSize, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.nominalVerticalSize, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.minVerticalSize, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.maxHorizontalSize, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.nominalHorizontalSize, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.minHorizontalSize, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.designGeneralClass, 1));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.designSubClass, 1));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.designSpecificGroup, 1));
        baos.write(this.reserved49_63 != null ? this.reserved49_63 : new byte[15]);
        baos.write(FontDesignFlag.toByte(this.fontDesignFlags));
        baos.write(0);
        baos.write(this.reserved66_75 != null ? this.reserved66_75 : new byte[10]);
        baos.write(UtilBinaryDecoding.intToByteArray(this.GCSGID_FontGraphicCharacterSetGlobalID, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.FGID_FontTypefaceGlobalID, 2));
        if (this.triplets != null) {
            for (Triplet t : this.triplets) {
                t.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public String getTypefaceDescription() {
        return this.typefaceDescription;
    }

    public void setTypefaceDescription(String typefaceDescription) {
        this.typefaceDescription = typefaceDescription;
    }

    public FontWeightClass getFontWeightClass() {
        return this.fontWeightClass;
    }

    public void setFontWeightClass(FontWeightClass fontWeightClass) {
        this.fontWeightClass = fontWeightClass;
    }

    public FontWidthClass getFontWidthClass() {
        return this.fontWidthClass;
    }

    public void setFontWidthClass(FontWidthClass fontWidthClass) {
        this.fontWidthClass = fontWidthClass;
    }

    public short getMaxVerticalSize() {
        return this.maxVerticalSize;
    }

    public void setMaxVerticalSize(short maxVerticalSize) {
        this.maxVerticalSize = maxVerticalSize;
    }

    public short getNominalVerticalSize() {
        return this.nominalVerticalSize;
    }

    public void setNominalVerticalSize(short nominalVerticalSize) {
        this.nominalVerticalSize = nominalVerticalSize;
    }

    public short getMinVerticalSize() {
        return this.minVerticalSize;
    }

    public void setMinVerticalSize(short minVerticalSize) {
        this.minVerticalSize = minVerticalSize;
    }

    public short getMaxHorizontalSize() {
        return this.maxHorizontalSize;
    }

    public void setMaxHorizontalSize(short maxHorizontalSize) {
        this.maxHorizontalSize = maxHorizontalSize;
    }

    public short getNominalHorizontalSize() {
        return this.nominalHorizontalSize;
    }

    public void setNominalHorizontalSize(short nominalHorizontalSize) {
        this.nominalHorizontalSize = nominalHorizontalSize;
    }

    public short getMinHorizontalSize() {
        return this.minHorizontalSize;
    }

    public void setMinHorizontalSize(short minHorizontalSize) {
        this.minHorizontalSize = minHorizontalSize;
    }

    public short getDesignGeneralClass() {
        return this.designGeneralClass;
    }

    public void setDesignGeneralClass(short designGeneralClass) {
        this.designGeneralClass = designGeneralClass;
    }

    public short getDesignSubClass() {
        return this.designSubClass;
    }

    public void setDesignSubClass(short designSubClass) {
        this.designSubClass = designSubClass;
    }

    public short getDesignSpecificGroup() {
        return this.designSpecificGroup;
    }

    public void setDesignSpecificGroup(short designSpecificGroup) {
        this.designSpecificGroup = designSpecificGroup;
    }

    public byte[] getReserved49_63() {
        return this.reserved49_63;
    }

    public void setReserved49_63(byte[] reserved49to63) {
        this.reserved49_63 = reserved49to63;
    }

    public EnumSet<FontDesignFlag> getFontDesignFlags() {
        return this.fontDesignFlags;
    }

    public void setFontDesignFlags(EnumSet<FontDesignFlag> fontDesignFlags) {
        this.fontDesignFlags = fontDesignFlags;
    }

    public byte[] getReserved66_75() {
        return this.reserved66_75;
    }

    public void setReserved66_75(byte[] reserved66to75) {
        this.reserved66_75 = reserved66to75;
    }

    public int getGCSGID_FontGraphicCharacterSetGlobalID() {
        return this.GCSGID_FontGraphicCharacterSetGlobalID;
    }

    public void setGCSGID_FontGraphicCharacterSetGlobalID(int gCSGID_FontGraphicCharacterSetGlobalID) {
        this.GCSGID_FontGraphicCharacterSetGlobalID = gCSGID_FontGraphicCharacterSetGlobalID;
    }

    public int getFGID_FontTypefaceGlobalID() {
        return this.FGID_FontTypefaceGlobalID;
    }

    public void setFGID_FontTypefaceGlobalID(int fGID_FontTypefaceGlobalID) {
        this.FGID_FontTypefaceGlobalID = fGID_FontTypefaceGlobalID;
    }

    public List<Triplet> getTriplets() {
        return this.triplets;
    }

    public void setTriplets(List<Triplet> triplets) {
        this.triplets = triplets;
    }

    public static enum FontDesignFlag {
        Italic,
        Underscored,
        Hollow,
        Overstruck;


        public static EnumSet<FontDesignFlag> valueOf(byte code) {
            EnumSet<FontDesignFlag> result = EnumSet.noneOf(FontDesignFlag.class);
            if ((code & 0x80) != 0) {
                result.add(Italic);
            }
            if ((code & 0x40) != 0) {
                result.add(Underscored);
            }
            if ((code & 0x10) != 0) {
                result.add(Hollow);
            }
            if ((code & 8) != 0) {
                result.add(Overstruck);
            }
            return result;
        }

        public static int toByte(EnumSet<FontDesignFlag> fontDesignFlags) {
            int result = 0;
            if (fontDesignFlags.contains((Object)Italic)) {
                result |= 0x80;
            }
            if (fontDesignFlags.contains((Object)Underscored)) {
                result |= 0x40;
            }
            if (fontDesignFlags.contains((Object)Hollow)) {
                result |= 0x10;
            }
            if (fontDesignFlags.contains((Object)Overstruck)) {
                result |= 8;
            }
            return result;
        }
    }

    public static enum FontWidthClass {
        Ultracondensed,
        Extracondensed,
        Condensed,
        Semicondensed,
        Medium_Normal,
        Semiexpanded,
        Expanded,
        Extraexpanded,
        Ultraexpanded;


        public static FontWidthClass valueOf(byte code) {
            for (FontWidthClass fwc : FontWidthClass.values()) {
                if (fwc.ordinal() != code) continue;
                return fwc;
            }
            return null;
        }

        public int toByte() {
            return this.ordinal();
        }
    }

    public static enum FontWeightClass {
        Ultralight,
        Extralight,
        Light,
        Semilight,
        Medium_Normal,
        Semibold,
        Bold,
        Extrabold,
        Ultrabold;


        public static FontWeightClass valueOf(byte code) {
            for (FontWeightClass fwc : FontWeightClass.values()) {
                if (fwc.ordinal() != code) continue;
                return fwc;
            }
            return null;
        }

        public int toByte() {
            return this.ordinal();
        }
    }
}

