/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.foca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FNM_FontPatternsMap
extends StructuredField {
    @AFPField
    List<FNM_RepeatingGroup> repeatingGroups;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        int actualLength = FNM_FontPatternsMap.getActualLength(sfData, offset, length);
        this.repeatingGroups = new ArrayList<FNM_RepeatingGroup>();
        for (int pos = 0; pos < actualLength; pos += 8) {
            FNM_RepeatingGroup rg = new FNM_RepeatingGroup();
            rg.decodeAFP(sfData, offset + pos, actualLength - pos, config);
            this.repeatingGroups.add(rg);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.repeatingGroups != null) {
            for (FNM_RepeatingGroup rg : this.repeatingGroups) {
                rg.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public static class FNM_RepeatingGroup
    implements IAFPDecodeableWriteable {
        @AFPField
        short characterBoxWidth;
        @AFPField
        short characterBoxHeight;
        @AFPField
        long patternDataOffset;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 8);
            this.characterBoxWidth = UtilBinaryDecoding.parseShort(sfData, offset, 2);
            this.characterBoxHeight = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.patternDataOffset = UtilBinaryDecoding.parseLong(sfData, offset + 4, 4);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.characterBoxWidth, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.characterBoxHeight, 2));
            os.write(UtilBinaryDecoding.longToByteArray(this.patternDataOffset, 4));
        }

        public short getCharacterBoxWidth() {
            return this.characterBoxWidth;
        }

        public void setCharacterBoxWidth(short characterBoxWidth) {
            this.characterBoxWidth = characterBoxWidth;
        }

        public short getCharacterBoxHeight() {
            return this.characterBoxHeight;
        }

        public void setCharacterBoxHeight(short characterBoxHeight) {
            this.characterBoxHeight = characterBoxHeight;
        }

        public long getPatternDataOffset() {
            return this.patternDataOffset;
        }

        public void setPatternDataOffset(long patternDataOffset) {
            this.patternDataOffset = patternDataOffset;
        }
    }
}

