/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.foca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.enums.AFPOrientation;
import com.mgz.afp.enums.IMutualExclusiveGroupedFlag;
import com.mgz.afp.enums.MutualExclusiveGroupedFlagHandler;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class FNO_FontOrientation
extends StructuredField {
    List<FNO_RepeatingGroup> repeatingGroups;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        FNO_FontOrientation.checkDataLength(sfData, offset, length, 26);
        int actualLength = length != -1 ? length : sfData.length - offset;
        this.repeatingGroups = new ArrayList<FNO_RepeatingGroup>(4);
        for (int pos = 0; pos < actualLength; pos += 26) {
            FNO_RepeatingGroup rg = new FNO_RepeatingGroup();
            rg.decodeAFP(sfData, offset + pos, 26, config);
            this.repeatingGroups.add(rg);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(26 * this.repeatingGroups.size());
        for (FNO_RepeatingGroup rg : this.repeatingGroups) {
            rg.writeAFP(baos, config);
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public List<FNO_RepeatingGroup> getRepeatingGroups() {
        return this.repeatingGroups;
    }

    public void setRepeatingGroups(List<FNO_RepeatingGroup> repeatingGroups) {
        this.repeatingGroups = repeatingGroups;
    }

    public static class FNO_RepeatingGroup
    implements IAFPDecodeableWriteable {
        public static final int RGLENGTH = 26;
        @AFPField(size=2)
        public byte[] reserved0_1 = new byte[]{0, 0};
        @AFPField
        public byte reserved13 = 0;
        @AFPField(size=2)
        public byte[] reserved16_17 = new byte[]{0, 0};
        @AFPField
        AFPOrientation characterRotation;
        @AFPField
        short maxBaselineOffset;
        @AFPField
        short maxCharacterIncrement;
        @AFPField
        short spaceCharacterIncrement;
        @AFPField
        short maxBaselineExtent;
        @AFPField
        EnumSet<FNO_ControlFlag> controlFlags;
        @AFPField
        short emSpaceIncrement;
        @AFPField
        short figureSpaceIncrement;
        @AFPField
        short nominalCharacterIncrement;
        @AFPField
        int defaultBaselineIncrement;
        @AFPField
        short minASpace;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 26);
            this.reserved0_1 = new byte[]{sfData[offset], sfData[offset + 1]};
            this.characterRotation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 2, 2));
            this.maxBaselineOffset = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            this.maxCharacterIncrement = UtilBinaryDecoding.parseShort(sfData, offset + 6, 2);
            this.spaceCharacterIncrement = UtilBinaryDecoding.parseShort(sfData, offset + 8, 2);
            this.maxBaselineExtent = UtilBinaryDecoding.parseShort(sfData, offset + 10, 2);
            this.controlFlags = FNO_ControlFlag.valueOf(sfData[offset + 12]);
            this.reserved13 = sfData[offset + 13];
            this.emSpaceIncrement = UtilBinaryDecoding.parseShort(sfData, offset + 14, 2);
            this.reserved16_17 = new byte[]{sfData[offset + 16], sfData[offset + 17]};
            this.figureSpaceIncrement = UtilBinaryDecoding.parseShort(sfData, offset + 18, 2);
            this.nominalCharacterIncrement = UtilBinaryDecoding.parseShort(sfData, offset + 20, 2);
            this.defaultBaselineIncrement = UtilBinaryDecoding.parseInt(sfData, offset + 22, 2);
            this.minASpace = UtilBinaryDecoding.parseShort(sfData, offset + 24, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.reserved0_1);
            os.write(this.characterRotation.toBytes());
            os.write(UtilBinaryDecoding.shortToByteArray(this.maxBaselineOffset, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.maxCharacterIncrement, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.spaceCharacterIncrement, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.maxBaselineExtent, 2));
            os.write(FNO_ControlFlag.toByte(this.controlFlags));
            os.write(this.reserved13);
            os.write(UtilBinaryDecoding.shortToByteArray(this.emSpaceIncrement, 2));
            os.write(this.reserved16_17);
            os.write(UtilBinaryDecoding.shortToByteArray(this.figureSpaceIncrement, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.nominalCharacterIncrement, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.defaultBaselineIncrement, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.minASpace, 2));
        }

        public AFPOrientation getCharacterRotation() {
            return this.characterRotation;
        }

        public void setCharacterRotation(AFPOrientation characterRotation) {
            this.characterRotation = characterRotation;
        }

        public short getMaxBaselineOffset() {
            return this.maxBaselineOffset;
        }

        public void setMaxBaselineOffset(short maxBaselineOffset) {
            this.maxBaselineOffset = maxBaselineOffset;
        }

        public short getMaxCharacterIncrement() {
            return this.maxCharacterIncrement;
        }

        public void setMaxCharacterIncrement(short maxCharacterIncrement) {
            this.maxCharacterIncrement = maxCharacterIncrement;
        }

        public short getSpaceCharacterIncrement() {
            return this.spaceCharacterIncrement;
        }

        public void setSpaceCharacterIncrement(short spaceCharacterIncrement) {
            this.spaceCharacterIncrement = spaceCharacterIncrement;
        }

        public short getMaxBaselineExtent() {
            return this.maxBaselineExtent;
        }

        public void setMaxBaselineExtent(short maxBaselineExtent) {
            this.maxBaselineExtent = maxBaselineExtent;
        }

        public EnumSet<FNO_ControlFlag> getControlFlags() {
            return this.controlFlags;
        }

        public void setControlFlag(FNO_ControlFlag controlFlag) {
            if (this.controlFlags == null) {
                this.controlFlags = EnumSet.noneOf(FNO_ControlFlag.class);
            }
            FNO_ControlFlag.setFlag(this.controlFlags, controlFlag);
        }

        public short getEmSpaceIncrement() {
            return this.emSpaceIncrement;
        }

        public void setEmSpaceIncrement(short emSpaceIncrement) {
            this.emSpaceIncrement = emSpaceIncrement;
        }

        public short getFigureSpaceIncrement() {
            return this.figureSpaceIncrement;
        }

        public void setFigureSpaceIncrement(short figureSpaceIncrement) {
            this.figureSpaceIncrement = figureSpaceIncrement;
        }

        public short getNominalCharacterIncrement() {
            return this.nominalCharacterIncrement;
        }

        public void setNominalCharacterIncrement(short nominalCharacterIncrement) {
            this.nominalCharacterIncrement = nominalCharacterIncrement;
        }

        public int getDefaultBaselineIncrement() {
            return this.defaultBaselineIncrement;
        }

        public void setDefaultBaselineIncrement(int defaultBaselineIncrement) {
            this.defaultBaselineIncrement = defaultBaselineIncrement;
        }

        public short getMinASpace() {
            return this.minASpace;
        }

        public void setMinASpace(short minASpace) {
            this.minASpace = minASpace;
        }
    }

    public static enum FNO_ControlFlag implements IMutualExclusiveGroupedFlag
    {
        FontIndex_Number0(0),
        FontIndex_Number1(0),
        FontIndex_Number2(0),
        FontIndex_Number3(0),
        FontIndex_Number4(0),
        FontIndex_Number5(0),
        FontIndex_Number6(0),
        FontIndex_Number7(0),
        KerningData_NoKerningData(1),
        KerningData_WithKerningData(1),
        ASpace_Minimum(2),
        ASpace_Uniform(2),
        BaselineOffset_Maximum(3),
        BaselineOffset_Uniform(3),
        CharacterIncrement_Maximum(4),
        CharacterIncrement_Uniform(4);

        int group;

        private FNO_ControlFlag(int group) {
            this.group = group;
        }

        public static EnumSet<FNO_ControlFlag> valueOf(byte controlFlagByte) {
            EnumSet<FNO_ControlFlag> result = EnumSet.noneOf(FNO_ControlFlag.class);
            int fontIndexNumber = controlFlagByte >>> 5;
            if (fontIndexNumber == 0) {
                result.add(FontIndex_Number0);
            } else if (fontIndexNumber == 1) {
                result.add(FontIndex_Number1);
            } else if (fontIndexNumber == 2) {
                result.add(FontIndex_Number2);
            } else if (fontIndexNumber == 3) {
                result.add(FontIndex_Number3);
            } else if (fontIndexNumber == 4) {
                result.add(FontIndex_Number4);
            } else if (fontIndexNumber == 5) {
                result.add(FontIndex_Number5);
            } else if (fontIndexNumber == 6) {
                result.add(FontIndex_Number6);
            } else if (fontIndexNumber == 7) {
                result.add(FontIndex_Number7);
            }
            if ((controlFlagByte & 8) == 0) {
                result.add(KerningData_NoKerningData);
            } else {
                result.add(KerningData_WithKerningData);
            }
            if ((controlFlagByte & 4) == 0) {
                result.add(ASpace_Minimum);
            } else {
                result.add(ASpace_Uniform);
            }
            if ((controlFlagByte & 2) == 0) {
                result.add(BaselineOffset_Maximum);
            } else {
                result.add(BaselineOffset_Uniform);
            }
            if ((controlFlagByte & 1) == 0) {
                result.add(CharacterIncrement_Maximum);
            } else {
                result.add(CharacterIncrement_Uniform);
            }
            return result;
        }

        public static int toByte(EnumSet<FNO_ControlFlag> controlFlags) {
            int result = 0;
            if (controlFlags.contains(FontIndex_Number1)) {
                result = 1;
            } else if (controlFlags.contains(FontIndex_Number2)) {
                result = 2;
            } else if (controlFlags.contains(FontIndex_Number3)) {
                result = 3;
            } else if (controlFlags.contains(FontIndex_Number4)) {
                result = 4;
            } else if (controlFlags.contains(FontIndex_Number5)) {
                result = 5;
            } else if (controlFlags.contains(FontIndex_Number6)) {
                result = 6;
            } else if (controlFlags.contains(FontIndex_Number7)) {
                result = 7;
            }
            result <<= 5;
            if (controlFlags.contains(KerningData_WithKerningData)) {
                result |= 8;
            }
            if (controlFlags.contains(ASpace_Uniform)) {
                result |= 4;
            }
            if (controlFlags.contains(BaselineOffset_Uniform)) {
                result |= 2;
            }
            if (controlFlags.contains(CharacterIncrement_Uniform)) {
                result |= 1;
            }
            return result;
        }

        public static void setFlag(EnumSet<FNO_ControlFlag> set, FNO_ControlFlag flag) {
            new MutualExclusiveGroupedFlagHandler<FNO_ControlFlag>().setFlag(set, flag);
        }

        @Override
        public int getGroup() {
            return this.group;
        }
    }
}

