/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.goca;

import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.enums.AFPColorSpace;
import com.mgz.afp.enums.AFPColorValue;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class GAD_DrawingOrder
implements IAFPDecodeableWriteable {
    @AFPField
    short drawingOrderType;

    public static class GOCA_Point {
        @AFPField
        short xCoordinate;
        @AFPField
        short yCoordinate;

        public byte[] toBytes() {
            return new byte[]{(byte)(this.xCoordinate >>> 8), (byte)(this.xCoordinate & 0xFF), (byte)(this.yCoordinate >>> 8), (byte)(this.yCoordinate & 0xFF)};
        }

        public short getxCoordinate() {
            return this.xCoordinate;
        }

        public void setxCoordinate(short xCoordinate) {
            this.xCoordinate = xCoordinate;
        }

        public short getyCoordinate() {
            return this.yCoordinate;
        }

        public void setyCoordinate(short yCoordinate) {
            this.yCoordinate = yCoordinate;
        }
    }

    public static class GEXO_ExtendedOrder
    extends GAD_DrawingOrder {
        @AFPField
        short qualifier;
        @AFPField
        int lengthOfFollowingData;
        @AFPField(maxSize=65535, isOptional=true)
        byte[] extendedData;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.qualifier = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.extendedData = new byte[this.lengthOfFollowingData];
            System.arraycopy(sfData, offset + 4, this.extendedData, 0, this.extendedData.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = this.extendedData != null ? this.extendedData.length : 0;
            os.write(this.drawingOrderType);
            os.write(this.qualifier);
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 2));
            os.write(this.extendedData);
        }

        public short getQualifier() {
            return this.qualifier;
        }

        public void setQualifier(short qualifier) {
            this.qualifier = qualifier;
        }

        public int getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(int lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public byte[] getExtendedData() {
            return this.extendedData;
        }

        public void setExtendedData(byte[] extendedData) {
            this.extendedData = extendedData;
            this.lengthOfFollowingData = extendedData != null ? extendedData.length : 0;
        }
    }

    public static class GCBEZ_CubicBezierCurveAtGivenPosition
    extends DrawingOrder_HasPoints {
        public GCBEZ_CubicBezierCurveAtGivenPosition() {
            this.isAtCurrentPosition = false;
        }
    }

    public static class GPARC_PartialArcAtGivenPosition
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        GOCA_Point lineStartPoint;
        @AFPField
        GOCA_Point arcCenter;
        @AFPField
        short multiplierIntegerPortion;
        @AFPField
        short multiplierFractionalPortion;
        @AFPField
        int startAngle;
        @AFPField
        int sweepAngle;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.lineStartPoint = new GOCA_Point();
            this.lineStartPoint.xCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.lineStartPoint.yCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            this.arcCenter = new GOCA_Point();
            this.arcCenter.xCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 6, 2);
            this.arcCenter.yCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 8, 2);
            this.multiplierIntegerPortion = UtilBinaryDecoding.parseShort(sfData, offset + 10, 1);
            this.multiplierFractionalPortion = UtilBinaryDecoding.parseShort(sfData, offset + 11, 1);
            this.startAngle = UtilBinaryDecoding.parseInt(sfData, offset + 12, 4);
            this.sweepAngle = UtilBinaryDecoding.parseInt(sfData, offset + 16, 4);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(this.lineStartPoint.toBytes());
            os.write(this.arcCenter.toBytes());
            os.write(this.multiplierIntegerPortion);
            os.write(this.multiplierFractionalPortion);
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public GOCA_Point getLineStartPoint() {
            return this.lineStartPoint;
        }

        public void setLineStartPoint(GOCA_Point lineStartPoint) {
            this.lineStartPoint = lineStartPoint;
        }

        public GOCA_Point getArcCenter() {
            return this.arcCenter;
        }

        public void setArcCenter(GOCA_Point arcCenter) {
            this.arcCenter = arcCenter;
        }

        public short getMultiplierIntegerPortion() {
            return this.multiplierIntegerPortion;
        }

        public void setMultiplierIntegerPortion(short multiplierIntegerPortion) {
            this.multiplierIntegerPortion = multiplierIntegerPortion;
        }

        public short getMultiplierFractionalPortion() {
            return this.multiplierFractionalPortion;
        }

        public void setMultiplierFractionalPortion(short multiplierFractionalPortion) {
            this.multiplierFractionalPortion = multiplierFractionalPortion;
        }

        public int getStartAngle() {
            return this.startAngle;
        }

        public void setStartAngle(int startAngle) {
            this.startAngle = startAngle;
        }

        public int getSweepAngle() {
            return this.sweepAngle;
        }

        public void setSweepAngle(int sweepAngle) {
            this.sweepAngle = sweepAngle;
        }
    }

    public static class GRLINE_RelativeLineAtGivenPosition
    extends DrawingOrder_HasPoints {
        public GRLINE_RelativeLineAtGivenPosition() {
            this.isAtCurrentPosition = false;
        }
    }

    public static class GBIMG_BeginImageAtGivenPosition
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        GOCA_Point origin;
        @AFPField
        short formatOfImageData;
        @AFPField
        short reserved3 = 0;
        @AFPField
        int widthOfImageInImagePoints;
        @AFPField
        int heightOfImageInImagePoints;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.origin = new GOCA_Point();
            this.origin.xCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.origin.yCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            this.formatOfImageData = UtilBinaryDecoding.parseShort(sfData, offset + 6, 1);
            this.reserved3 = UtilBinaryDecoding.parseShort(sfData, offset + 7, 1);
            this.widthOfImageInImagePoints = UtilBinaryDecoding.parseInt(sfData, offset + 8, 2);
            this.heightOfImageInImagePoints = UtilBinaryDecoding.parseInt(sfData, offset + 10, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(this.origin.toBytes());
            os.write(this.formatOfImageData);
            os.write(this.reserved3);
            os.write(UtilBinaryDecoding.intToByteArray(this.widthOfImageInImagePoints, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.heightOfImageInImagePoints, 2));
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public GOCA_Point getOrigin() {
            return this.origin;
        }

        public void setOrigin(GOCA_Point origin) {
            this.origin = origin;
        }

        public short getFormatOfImageData() {
            return this.formatOfImageData;
        }

        public void setFormatOfImageData(short formatOfImageData) {
            this.formatOfImageData = formatOfImageData;
        }

        public short getReserved3() {
            return this.reserved3;
        }

        public void setReserved3(short reserved3) {
            this.reserved3 = reserved3;
        }

        public int getWidthOfImageInImagePoints() {
            return this.widthOfImageInImagePoints;
        }

        public void setWidthOfImageInImagePoints(int widthOfImageInImagePoints) {
            this.widthOfImageInImagePoints = widthOfImageInImagePoints;
        }

        public int getHeightOfImageInImagePoints() {
            return this.heightOfImageInImagePoints;
        }

        public void setHeightOfImageInImagePoints(int heightOfImageInImagePoints) {
            this.heightOfImageInImagePoints = heightOfImageInImagePoints;
        }
    }

    public static class GCFARC_FullArcAtCurrentPosition
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        short multiplierIntegerPortion;
        @AFPField
        short multiplierFractionalPortion;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.multiplierIntegerPortion = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.multiplierFractionalPortion = UtilBinaryDecoding.parseShort(sfData, offset + 3, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(this.multiplierIntegerPortion);
            os.write(this.multiplierFractionalPortion);
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public short getMultiplierIntegerPortion() {
            return this.multiplierIntegerPortion;
        }

        public void setMultiplierIntegerPortion(short multiplierIntegerPortion) {
            this.multiplierIntegerPortion = multiplierIntegerPortion;
        }

        public short getMultiplierFractionalPortion() {
            return this.multiplierFractionalPortion;
        }

        public void setMultiplierFractionalPortion(short multiplierFractionalPortion) {
            this.multiplierFractionalPortion = multiplierFractionalPortion;
        }
    }

    public static class GFLT_FilletAtGivenPosition
    extends DrawingOrder_HasPoints {
        public GFLT_FilletAtGivenPosition() {
            this.isAtCurrentPosition = false;
        }
    }

    public static class GCHST_CharacterStringAtGivenPosition
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        GOCA_Point originPoint;
        @AFPField(isOptional=true, maxSize=251)
        byte[] codePoints;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.originPoint = new GOCA_Point();
            this.originPoint.xCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.originPoint.yCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            if (this.lengthOfFollowingData > 4) {
                this.codePoints = new byte[this.lengthOfFollowingData - 4];
                System.arraycopy(sfData, offset + 6, this.codePoints, 0, this.codePoints.length);
            } else {
                this.codePoints = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            int actualLengthOfFollowingData = 4;
            if (this.codePoints != null) {
                actualLengthOfFollowingData = (short)(4 + this.codePoints.length);
            }
            this.lengthOfFollowingData = (short)actualLengthOfFollowingData;
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(this.originPoint.toBytes());
            if (this.codePoints != null) {
                os.write(this.codePoints);
            }
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public GOCA_Point getOriginPoint() {
            return this.originPoint;
        }

        public void setOriginPoint(GOCA_Point originPoint) {
            this.originPoint = originPoint;
        }

        public byte[] getCodePoints() {
            return this.codePoints;
        }

        public void setCodePoints(byte[] codePoints) {
            this.codePoints = codePoints;
            this.lengthOfFollowingData = (short)(codePoints != null ? (int)(4 + codePoints.length) : 4);
        }
    }

    public static class GMRK_MarkerAtGivenPosition
    extends DrawingOrder_HasPoints {
        public GMRK_MarkerAtGivenPosition() {
            this.isAtCurrentPosition = false;
        }
    }

    public static class GLINE_LineAtGivenPosition
    extends DrawingOrder_HasPoints {
        public GLINE_LineAtGivenPosition() {
            this.isAtCurrentPosition = false;
        }
    }

    public static class GBOX_BoxAtGivenPosition
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        short reserved2_3 = 0;
        @AFPField
        GOCA_Point firstCorner;
        @AFPField
        GOCA_Point diagonalCorner;
        @AFPField(isOptional=true, indexNr=0)
        Short xAxisLengthForRoundCorner;
        @AFPField(isOptional=true, indexNr=1)
        Short yAxisLengthForRoundCorner;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.firstCorner = new GOCA_Point();
            this.firstCorner.xCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            this.firstCorner.yCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 6, 2);
            this.diagonalCorner = new GOCA_Point();
            this.diagonalCorner.xCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 8, 2);
            this.diagonalCorner.yCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 10, 2);
            if (this.lengthOfFollowingData >= 12) {
                this.xAxisLengthForRoundCorner = UtilBinaryDecoding.parseShort(sfData, offset + 12, 2);
            }
            if (this.lengthOfFollowingData == 14) {
                this.yAxisLengthForRoundCorner = UtilBinaryDecoding.parseShort(sfData, offset + 14, 2);
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            int actualLengthOfFollowingData = 10;
            if (this.xAxisLengthForRoundCorner != null) {
                actualLengthOfFollowingData = 12;
                if (this.yAxisLengthForRoundCorner != null) {
                    actualLengthOfFollowingData = 14;
                }
            }
            this.lengthOfFollowingData = (short)actualLengthOfFollowingData;
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(UtilBinaryDecoding.shortToByteArray(this.reserved2_3, 2));
            os.write(this.firstCorner.toBytes());
            os.write(this.diagonalCorner.toBytes());
            if (this.xAxisLengthForRoundCorner != null) {
                os.write(UtilBinaryDecoding.shortToByteArray(this.xAxisLengthForRoundCorner, 2));
                if (this.yAxisLengthForRoundCorner != null) {
                    os.write(UtilBinaryDecoding.shortToByteArray(this.yAxisLengthForRoundCorner, 2));
                }
            }
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public short getReserved2_3() {
            return this.reserved2_3;
        }

        public void setReserved2_3(short reserved2_3) {
            this.reserved2_3 = reserved2_3;
        }

        public GOCA_Point getFirstCorner() {
            return this.firstCorner;
        }

        public void setFirstCorner(GOCA_Point firstCorner) {
            this.firstCorner = firstCorner;
        }

        public GOCA_Point getDiagonalCorner() {
            return this.diagonalCorner;
        }

        public void setDiagonalCorner(GOCA_Point diagonalCorner) {
            this.diagonalCorner = diagonalCorner;
        }

        public Short getxAxisLengthForRoundCorner() {
            return this.xAxisLengthForRoundCorner;
        }

        public void setxAxisLengthForRoundCorner(Short xAxisLengthForRoundCorner) {
            this.xAxisLengthForRoundCorner = xAxisLengthForRoundCorner;
        }

        public Short getyAxisLengthForRoundCorner() {
            return this.yAxisLengthForRoundCorner;
        }

        public void setyAxisLengthForRoundCorner(Short yAxisLengthForRoundCorner) {
            this.yAxisLengthForRoundCorner = yAxisLengthForRoundCorner;
        }
    }

    public static class GSPCOL_SetProcessColor
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        short reserved2 = 0;
        @AFPField
        AFPColorSpace colorSpace;
        @AFPField
        int reserved4_7 = 0;
        @AFPField
        byte nrOfBitsComponent1;
        @AFPField
        byte nrOfBitsComponent2;
        @AFPField
        byte nrOfBitsComponent3;
        @AFPField
        byte nrOfBitsComponent4;
        @AFPField(maxSize=245)
        byte[] colorValue;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.reserved2 = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.colorSpace = AFPColorSpace.valueOf(sfData[offset + 3]);
            this.reserved4_7 = UtilBinaryDecoding.parseInt(sfData, offset + 4, 4);
            this.nrOfBitsComponent1 = sfData[offset + 8];
            this.nrOfBitsComponent2 = sfData[offset + 9];
            this.nrOfBitsComponent3 = sfData[offset + 10];
            this.nrOfBitsComponent4 = sfData[offset + 11];
            this.colorValue = new byte[this.lengthOfFollowingData - 10];
            System.arraycopy(sfData, offset + 12, this.colorValue, 0, this.colorValue.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = (short)(this.colorValue != null ? (int)(10 + this.colorValue.length) : 10);
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(this.reserved2);
            os.write(this.colorSpace.toByte());
            os.write(UtilBinaryDecoding.intToByteArray(this.reserved4_7, 4));
            os.write(this.nrOfBitsComponent1);
            os.write(this.nrOfBitsComponent2);
            os.write(this.nrOfBitsComponent3);
            os.write(this.nrOfBitsComponent4);
            os.write(this.colorValue);
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public short getReserved2() {
            return this.reserved2;
        }

        public void setReserved2(short reserved2) {
            this.reserved2 = reserved2;
        }

        public AFPColorSpace getColorSpace() {
            return this.colorSpace;
        }

        public void setColorSpace(AFPColorSpace colorSpace) {
            this.colorSpace = colorSpace;
        }

        public int getReserved4_7() {
            return this.reserved4_7;
        }

        public void setReserved4_7(int reserved4_7) {
            this.reserved4_7 = reserved4_7;
        }

        public byte getNrOfBitsComponent1() {
            return this.nrOfBitsComponent1;
        }

        public void setNrOfBitsComponent1(byte nrOfBitsComponent1) {
            this.nrOfBitsComponent1 = nrOfBitsComponent1;
        }

        public byte getNrOfBitsComponent2() {
            return this.nrOfBitsComponent2;
        }

        public void setNrOfBitsComponent2(byte nrOfBitsComponent2) {
            this.nrOfBitsComponent2 = nrOfBitsComponent2;
        }

        public byte getNrOfBitsComponent3() {
            return this.nrOfBitsComponent3;
        }

        public void setNrOfBitsComponent3(byte nrOfBitsComponent3) {
            this.nrOfBitsComponent3 = nrOfBitsComponent3;
        }

        public byte getNrOfBitsComponent4() {
            return this.nrOfBitsComponent4;
        }

        public void setNrOfBitsComponent4(byte nrOfBitsComponent4) {
            this.nrOfBitsComponent4 = nrOfBitsComponent4;
        }

        public byte[] getColorValue() {
            return this.colorValue;
        }

        public void setColorValue(byte[] colorValue) {
            this.colorValue = colorValue;
            this.lengthOfFollowingData = (short)(colorValue != null ? (int)colorValue.length : 10);
        }
    }

    public static class GCCBEZ_CubicBezierCurveAtCurrentPosition
    extends DrawingOrder_HasPoints {
        public GCCBEZ_CubicBezierCurveAtCurrentPosition() {
            this.isAtCurrentPosition = true;
        }
    }

    public static class GCPARC_PartialArcAtCurrentPosition
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        GOCA_Point arcCenter;
        @AFPField
        short multiplierIntegerPortion;
        @AFPField
        short multiplierFractionalPortion;
        @AFPField
        int startAngle;
        @AFPField
        int sweepAngle;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.arcCenter = new GOCA_Point();
            this.arcCenter.xCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.arcCenter.yCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            this.multiplierIntegerPortion = UtilBinaryDecoding.parseShort(sfData, offset + 6, 1);
            this.multiplierFractionalPortion = UtilBinaryDecoding.parseShort(sfData, offset + 7, 1);
            this.startAngle = UtilBinaryDecoding.parseInt(sfData, offset + 8, 4);
            this.sweepAngle = UtilBinaryDecoding.parseInt(sfData, offset + 12, 4);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(this.arcCenter.toBytes());
            os.write(this.multiplierIntegerPortion);
            os.write(this.multiplierFractionalPortion);
            os.write(UtilBinaryDecoding.longToByteArray(this.startAngle, 4));
            os.write(UtilBinaryDecoding.longToByteArray(this.sweepAngle, 4));
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public GOCA_Point getArcCenter() {
            return this.arcCenter;
        }

        public void setArcCenter(GOCA_Point arcCenter) {
            this.arcCenter = arcCenter;
        }

        public short getMultiplierIntegerPortion() {
            return this.multiplierIntegerPortion;
        }

        public void setMultiplierIntegerPortion(short multiplierIntegerPortion) {
            this.multiplierIntegerPortion = multiplierIntegerPortion;
        }

        public short getMultiplierFractionalPortion() {
            return this.multiplierFractionalPortion;
        }

        public void setMultiplierFractionalPortion(short multiplierFractionalPortion) {
            this.multiplierFractionalPortion = multiplierFractionalPortion;
        }

        public int getStartAngle() {
            return this.startAngle;
        }

        public void setStartAngle(int startAngle) {
            this.startAngle = startAngle;
        }

        public int getSweepAngle() {
            return this.sweepAngle;
        }

        public void setSweepAngle(int sweepAngle) {
            this.sweepAngle = sweepAngle;
        }
    }

    public static class GCRLINE_RelativeLineAtCurrentPosition
    extends DrawingOrder_HasPoints {
        public GCRLINE_RelativeLineAtCurrentPosition() {
            this.isAtCurrentPosition = true;
        }
    }

    public static class GEIMD_EndImage
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData = 0;
        @AFPField(maxSize=255)
        byte[] reservedData = new byte[0];

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.reservedData = new byte[this.lengthOfFollowingData];
            System.arraycopy(sfData, offset + 2, this.reservedData, 0, this.reservedData.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = this.reservedData == null ? (short)0 : (short)this.reservedData.length;
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            if (this.reservedData != null) {
                os.write(this.reservedData);
            }
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public byte[] getReservedData() {
            return this.reservedData;
        }

        public void setReservedData(byte[] reservedData) {
            this.reservedData = reservedData;
            this.lengthOfFollowingData = reservedData == null ? (short)0 : (short)reservedData.length;
        }
    }

    public static class GIMD_ImageData
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField(maxSize=255)
        byte[] imageData;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.imageData = new byte[this.lengthOfFollowingData];
            System.arraycopy(sfData, offset + 2, this.imageData, 0, this.imageData.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = this.imageData == null ? (short)0 : (short)this.imageData.length;
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            if (this.imageData != null) {
                os.write(this.imageData);
            }
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public byte[] getImageData() {
            return this.imageData;
        }

        public void setImageData(byte[] imageData) {
            this.imageData = imageData;
            this.lengthOfFollowingData = imageData == null ? (short)0 : (short)imageData.length;
        }
    }

    public static class GCBIMG_BeginImageAtCurrentPosition
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        short formatOfImageData;
        @AFPField
        short reserved3 = 0;
        @AFPField
        int widthOfImageInImagePoints;
        @AFPField
        int heightOfImageInImagePoints;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.formatOfImageData = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.reserved3 = UtilBinaryDecoding.parseShort(sfData, offset + 3, 1);
            this.widthOfImageInImagePoints = UtilBinaryDecoding.parseInt(sfData, offset + 4, 2);
            this.heightOfImageInImagePoints = UtilBinaryDecoding.parseInt(sfData, offset + 4, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(this.formatOfImageData);
            os.write(this.reserved3);
            os.write(UtilBinaryDecoding.intToByteArray(this.widthOfImageInImagePoints, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.heightOfImageInImagePoints, 2));
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public short getFormatOfImageData() {
            return this.formatOfImageData;
        }

        public void setFormatOfImageData(short formatOfImageData) {
            this.formatOfImageData = formatOfImageData;
        }

        public short getReserved3() {
            return this.reserved3;
        }

        public void setReserved3(short reserved3) {
            this.reserved3 = reserved3;
        }

        public int getWidthOfImageInImagePoints() {
            return this.widthOfImageInImagePoints;
        }

        public void setWidthOfImageInImagePoints(int widthOfImageInImagePoints) {
            this.widthOfImageInImagePoints = widthOfImageInImagePoints;
        }

        public int getHeightOfImageInImagePoints() {
            return this.heightOfImageInImagePoints;
        }

        public void setHeightOfImageInImagePoints(int heightOfImageInImagePoints) {
            this.heightOfImageInImagePoints = heightOfImageInImagePoints;
        }
    }

    public static class GFARC_FullArcAtGivenPosition
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        GOCA_Point arcCenter;
        @AFPField
        short multiplierIntegerPortion;
        @AFPField
        short multiplierFractionalPortion;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.arcCenter = new GOCA_Point();
            this.arcCenter.xCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.arcCenter.yCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            this.multiplierIntegerPortion = UtilBinaryDecoding.parseShort(sfData, offset + 6, 1);
            this.multiplierFractionalPortion = UtilBinaryDecoding.parseShort(sfData, offset + 7, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(this.arcCenter.toBytes());
            os.write(UtilBinaryDecoding.shortToByteArray(this.multiplierIntegerPortion, 1));
            os.write(UtilBinaryDecoding.shortToByteArray(this.multiplierFractionalPortion, 1));
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public short getMultiplierIntegerPortion() {
            return this.multiplierIntegerPortion;
        }

        public void setMultiplierIntegerPortion(short multiplierIntegerPortion) {
            this.multiplierIntegerPortion = multiplierIntegerPortion;
        }

        public short getMultiplierFractionalPortion() {
            return this.multiplierFractionalPortion;
        }

        public void setMultiplierFractionalPortion(short multiplierFractionalPortion) {
            this.multiplierFractionalPortion = multiplierFractionalPortion;
        }

        public GOCA_Point getArcCenter() {
            return this.arcCenter;
        }

        public void setArcCenter(GOCA_Point arcCenter) {
            this.arcCenter = arcCenter;
        }
    }

    public static class GCFLT_FilletAtCurrentPosition
    extends DrawingOrder_HasPoints {
        public GCFLT_FilletAtCurrentPosition() {
            this.isAtCurrentPosition = true;
        }
    }

    public static class GCCHST_CharacterStringAtCurrentPosition
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField(maxSize=255)
        byte[] codePoints;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            if (this.lengthOfFollowingData > 0) {
                this.codePoints = new byte[this.lengthOfFollowingData];
                System.arraycopy(sfData, offset + 2, this.codePoints, 0, this.codePoints.length);
            } else {
                this.codePoints = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = this.codePoints != null ? (short)this.codePoints.length : (short)0;
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            if (this.codePoints != null) {
                os.write(this.codePoints);
            }
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public byte[] getCodePoints() {
            return this.codePoints;
        }

        public void setCodePoints(byte[] codePoints) {
            this.codePoints = codePoints;
        }
    }

    public static class GCMRK_MarkerAtCurrentPosition
    extends DrawingOrder_HasPoints {
        public GCMRK_MarkerAtCurrentPosition() {
            this.isAtCurrentPosition = true;
        }
    }

    public static class GCLINE_LineAtCurrentPosition
    extends DrawingOrder_HasPoints {
        public GCLINE_LineAtCurrentPosition() {
            this.isAtCurrentPosition = true;
        }
    }

    public static class GCBOX_BoxAtCurrentPosition
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        short reserved2_3 = 0;
        @AFPField
        GOCA_Point diagonalCorner;
        @AFPField(isOptional=true, indexNr=0)
        Short xAxisLengthForRoundCorner;
        @AFPField(isOptional=true, indexNr=1)
        Short yAxisLengthForRoundCorner;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.reserved2_3 = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.diagonalCorner = new GOCA_Point();
            this.diagonalCorner.xCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            this.diagonalCorner.yCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 6, 2);
            if (this.lengthOfFollowingData >= 8) {
                this.xAxisLengthForRoundCorner = UtilBinaryDecoding.parseShort(sfData, offset + 8, 2);
            }
            if (this.lengthOfFollowingData == 10) {
                this.yAxisLengthForRoundCorner = UtilBinaryDecoding.parseShort(sfData, offset + 10, 2);
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            int actualLengthOfFollowingData = 6;
            if (this.xAxisLengthForRoundCorner != null) {
                actualLengthOfFollowingData = 8;
                if (this.yAxisLengthForRoundCorner != null) {
                    actualLengthOfFollowingData = 10;
                }
            }
            this.lengthOfFollowingData = (short)actualLengthOfFollowingData;
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(UtilBinaryDecoding.intToByteArray(this.reserved2_3, 2));
            os.write(this.diagonalCorner.toBytes());
            if (this.xAxisLengthForRoundCorner != null) {
                os.write(UtilBinaryDecoding.shortToByteArray(this.xAxisLengthForRoundCorner, 2));
                if (this.yAxisLengthForRoundCorner != null) {
                    os.write(UtilBinaryDecoding.shortToByteArray(this.yAxisLengthForRoundCorner, 2));
                }
            }
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public short getReserved2_3() {
            return this.reserved2_3;
        }

        public void setReserved2_3(short reserved2_3) {
            this.reserved2_3 = reserved2_3;
        }

        public Short getxAxisLengthForRoundCorner() {
            return this.xAxisLengthForRoundCorner;
        }

        public void setxAxisLengthForRoundCorner(Short xAxisLengthForRoundCorner) {
            this.xAxisLengthForRoundCorner = xAxisLengthForRoundCorner;
            if (this.xAxisLengthForRoundCorner != null) {
                this.lengthOfFollowingData = this.yAxisLengthForRoundCorner != null ? (short)10 : (short)8;
            }
        }

        public Short getyAxisLengthForRoundCorner() {
            return this.yAxisLengthForRoundCorner;
        }

        public void setyAxisLengthForRoundCorner(Short yAxisLengthForRoundCorner) {
            this.yAxisLengthForRoundCorner = yAxisLengthForRoundCorner;
            this.lengthOfFollowingData = this.yAxisLengthForRoundCorner != null ? (short)10 : (this.xAxisLengthForRoundCorner == null ? (short)6 : (short)8);
        }

        public GOCA_Point getDiagonalCorner() {
            return this.diagonalCorner;
        }

        public void setDiagonalCorner(GOCA_Point diagonalCorner) {
            this.diagonalCorner = diagonalCorner;
        }
    }

    public static class GBAR_BeginArea
    extends GAD_DrawingOrder {
        @AFPField
        short internalFlags;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.internalFlags = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.internalFlags);
        }

        public short getInternalFlags() {
            return this.internalFlags;
        }

        public void setInternalFlags(short internalFlags) {
            this.internalFlags = internalFlags;
        }
    }

    public static class GEAR_EndArea
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField(maxSize=255)
        byte[] data;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.data = new byte[this.lengthOfFollowingData];
            System.arraycopy(sfData, offset + 2, this.data, 0, this.data.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = this.data != null ? (short)this.data.length : (short)0;
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            if (this.data != null) {
                os.write(this.data);
            }
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
            this.lengthOfFollowingData = data == null ? (short)0 : (short)data.length;
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }
    }

    public static class GEPROL_EndProlog
    extends GAD_DrawingOrder {
        @AFPField
        short reserved0 = 0;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.reserved0 = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.reserved0);
        }

        public short getReserved0() {
            return this.reserved0;
        }

        public void setReserved0(short reserved_0x00) {
            this.reserved0 = reserved_0x00;
        }
    }

    public static class GSMS_SetMarkerSet
    extends GAD_DrawingOrder {
        @AFPField
        short markerSetLocalID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.markerSetLocalID = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.markerSetLocalID);
        }

        public short getMarkerSetLocalID() {
            return this.markerSetLocalID;
        }

        public void setMarkerSetLocalID(short markerSetLocalID) {
            this.markerSetLocalID = markerSetLocalID;
        }
    }

    public static class GSMP_SetMarkerPrecision
    extends GAD_DrawingOrder {
        @AFPField
        short markerPrecision;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.markerPrecision = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.markerPrecision);
        }

        public short getMarkerPrecision() {
            return this.markerPrecision;
        }

        public void setMarkerPrecision(short markerPrecision) {
            this.markerPrecision = markerPrecision;
        }
    }

    public static class GSCD_SetCharacterDirection
    extends GAD_DrawingOrder {
        @AFPField
        short characterDirection;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.characterDirection = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.characterDirection);
        }

        public short getCharacterDirection() {
            return this.characterDirection;
        }

        public void setCharacterDirection(short characterDirection) {
            this.characterDirection = characterDirection;
        }
    }

    public static class GSCR_SetCharacterPrecision
    extends GAD_DrawingOrder {
        @AFPField
        short characterPrecision;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.characterPrecision = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.characterPrecision);
        }

        public short getCharacterPrecision() {
            return this.characterPrecision;
        }

        public void setCharacterPrecision(short characterPrecision) {
            this.characterPrecision = characterPrecision;
        }
    }

    public static class GSCS_SetCharacterSet
    extends GAD_DrawingOrder {
        @AFPField
        short characterSetLocalID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.characterSetLocalID = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.characterSetLocalID);
        }

        public short getCharacterSetLocalID() {
            return this.characterSetLocalID;
        }

        public void setCharacterSetLocalID(short characterSetLocalID) {
            this.characterSetLocalID = characterSetLocalID;
        }
    }

    public static class GSMC_SetMarkerCell
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        short widthOfMarkerCell;
        @AFPField
        short heightOfMarkerCell;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.widthOfMarkerCell = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.heightOfMarkerCell = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(UtilBinaryDecoding.shortToByteArray(this.widthOfMarkerCell, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.heightOfMarkerCell, 2));
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public short getWidthOfMarkerCell() {
            return this.widthOfMarkerCell;
        }

        public void setWidthOfMarkerCell(short widthOfMarkerCell) {
            this.widthOfMarkerCell = widthOfMarkerCell;
        }

        public short getHeightOfMarkerCell() {
            return this.heightOfMarkerCell;
        }

        public void setHeightOfMarkerCell(short heightOfMarkerCell) {
            this.heightOfMarkerCell = heightOfMarkerCell;
        }
    }

    public static class GSCH_SetCharacterShear
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        short dividendOfShearRatio;
        @AFPField
        short divisorOfShearRatio;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.dividendOfShearRatio = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.divisorOfShearRatio = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(UtilBinaryDecoding.shortToByteArray(this.dividendOfShearRatio, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.divisorOfShearRatio, 2));
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public short getDividendOfShearRatio() {
            return this.dividendOfShearRatio;
        }

        public void setDividendOfShearRatio(short dividendOfShearRatio) {
            this.dividendOfShearRatio = dividendOfShearRatio;
        }

        public short getDivisorOfShearRatio() {
            return this.divisorOfShearRatio;
        }

        public void setDivisorOfShearRatio(short divisorOfShearRatio) {
            this.divisorOfShearRatio = divisorOfShearRatio;
        }
    }

    public static class GSCA_SetCharacterAngle
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        GOCA_Point anglePoint;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.anglePoint = new GOCA_Point();
            this.anglePoint.xCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.anglePoint.yCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(this.anglePoint.toBytes());
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public GOCA_Point getAnglePoint() {
            return this.anglePoint;
        }

        public void setAnglePoint(GOCA_Point anglePoint) {
            this.anglePoint = anglePoint;
        }
    }

    public static class GSCC_SetCharacterCell
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        short widthOfCharacterCellIntegerPart;
        @AFPField
        short heightOfCharacterCellIntegerPart;
        @AFPField(isOptional=true)
        Short widthOfCharacterCellFractionalPart;
        @AFPField(isOptional=true)
        Short heightOfCharacterCellFractionalPart;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.widthOfCharacterCellIntegerPart = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.heightOfCharacterCellIntegerPart = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            if (this.lengthOfFollowingData == 8) {
                this.widthOfCharacterCellFractionalPart = UtilBinaryDecoding.parseShort(sfData, offset + 6, 2);
                this.heightOfCharacterCellFractionalPart = UtilBinaryDecoding.parseShort(sfData, offset + 8, 2);
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(UtilBinaryDecoding.shortToByteArray(this.widthOfCharacterCellIntegerPart, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.heightOfCharacterCellIntegerPart, 2));
            if (this.lengthOfFollowingData == 8) {
                os.write(UtilBinaryDecoding.shortToByteArray(this.widthOfCharacterCellFractionalPart != null ? this.widthOfCharacterCellFractionalPart : (short)0, 2));
                os.write(UtilBinaryDecoding.shortToByteArray(this.heightOfCharacterCellFractionalPart != null ? this.heightOfCharacterCellFractionalPart : (short)0, 2));
            }
        }

        public short getWidthOfCharacterCellIntegerPart() {
            return this.widthOfCharacterCellIntegerPart;
        }

        public void setWidthOfCharacterCellIntegerPart(short widthOfCharacterCellIntegerPart) {
            this.widthOfCharacterCellIntegerPart = widthOfCharacterCellIntegerPart;
        }

        public short getHeightOfCharacterCellIntegerPart() {
            return this.heightOfCharacterCellIntegerPart;
        }

        public void setHeightOfCharacterCellIntegerPart(short heightOfCharacterCellIntegerPart) {
            this.heightOfCharacterCellIntegerPart = heightOfCharacterCellIntegerPart;
        }

        public Short getWidthOfCharacterCellFractionalPart() {
            return this.widthOfCharacterCellFractionalPart;
        }

        public void setWidthOfCharacterCellFractionalPart(Short widthOfCharacterCellFractionalPart) {
            this.widthOfCharacterCellFractionalPart = widthOfCharacterCellFractionalPart;
            if (widthOfCharacterCellFractionalPart != null) {
                this.lengthOfFollowingData = (short)8;
            } else if (this.heightOfCharacterCellFractionalPart == null) {
                this.lengthOfFollowingData = (short)4;
            }
        }

        public Short getHeightOfCharacterCellFractionalPart() {
            return this.heightOfCharacterCellFractionalPart;
        }

        public void setHeightOfCharacterCellFractionalPart(Short heightOfCharacterCellFractionalPart) {
            this.heightOfCharacterCellFractionalPart = heightOfCharacterCellFractionalPart;
            if (heightOfCharacterCellFractionalPart != null) {
                this.lengthOfFollowingData = (short)8;
            } else if (this.widthOfCharacterCellFractionalPart == null) {
                this.lengthOfFollowingData = (short)4;
            }
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }
    }

    public static class GSMT_SetMarkerSymbol
    extends GAD_DrawingOrder {
        @AFPField
        short markerSymbolCodePoint;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.markerSymbolCodePoint = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.markerSymbolCodePoint);
        }

        public short getMarkerSymbolCodePoint() {
            return this.markerSymbolCodePoint;
        }

        public void setMarkerSymbolCodePoint(short markerSymbolCodePoint) {
            this.markerSymbolCodePoint = markerSymbolCodePoint;
        }
    }

    public static class GSPT_SetPatternSymbol
    extends GAD_DrawingOrder {
        @AFPField
        short patternSymbolCodePoint;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.patternSymbolCodePoint = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.patternSymbolCodePoint);
        }

        public short getPatternSymbolCodePoint() {
            return this.patternSymbolCodePoint;
        }

        public void setPatternSymbolCodePoint(short patternSymbolCodePoint) {
            this.patternSymbolCodePoint = patternSymbolCodePoint;
        }
    }

    public static class GSECOL_SetExtendedColor
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        AFPColorValue color;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.color = AFPColorValue.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 2, 2));
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(this.color != null ? this.color.toByte2() : AFPColorValue.DeviceDefault_0xFF00.toByte2());
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public AFPColorValue getColor() {
            return this.color;
        }

        public void setColor(AFPColorValue color) {
            this.color = color;
        }
    }

    public static class GSAP_SetArcParameters
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        short arcTransformP;
        @AFPField
        short arcTransformQ;
        @AFPField
        short arcTransformR;
        @AFPField
        short arcTransformS;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.arcTransformP = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.arcTransformQ = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            this.arcTransformR = UtilBinaryDecoding.parseShort(sfData, offset + 6, 2);
            this.arcTransformS = UtilBinaryDecoding.parseShort(sfData, offset + 8, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(UtilBinaryDecoding.shortToByteArray(this.arcTransformP, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.arcTransformQ, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.arcTransformR, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.arcTransformS, 2));
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public short getArcTransformP() {
            return this.arcTransformP;
        }

        public void setArcTransformP(short arcTransformP) {
            this.arcTransformP = arcTransformP;
        }

        public short getArcTransformQ() {
            return this.arcTransformQ;
        }

        public void setArcTransformQ(short arcTransformQ) {
            this.arcTransformQ = arcTransformQ;
        }

        public short getArcTransformR() {
            return this.arcTransformR;
        }

        public void setArcTransformR(short arcTransformR) {
            this.arcTransformR = arcTransformR;
        }

        public short getArcTransformS() {
            return this.arcTransformS;
        }

        public void setArcTransformS(short arcTransformS) {
            this.arcTransformS = arcTransformS;
        }
    }

    public static class GSCP_SetCurrentPosition
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        short coordinateX;
        @AFPField
        short coordinateY;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.coordinateX = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.coordinateY = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(this.coordinateX);
            os.write(this.coordinateY);
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public short getCoordinateX() {
            return this.coordinateX;
        }

        public void setCoordinateX(short coordinateX) {
            this.coordinateX = coordinateX;
        }

        public short getCoordinateY() {
            return this.coordinateY;
        }

        public void setCoordinateY(short coordinateY) {
            this.coordinateY = coordinateY;
        }
    }

    public static class GSLJ_SetLineJoin
    extends GAD_DrawingOrder {
        @AFPField
        LineJoin lineJoin;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lineJoin = LineJoin.valueOf(sfData[offset + 1]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lineJoin.toByte());
        }

        public LineJoin getLineJoin() {
            return this.lineJoin;
        }

        public void setLineJoin(LineJoin lineJoin) {
            this.lineJoin = lineJoin;
        }

        public static enum LineJoin {
            Default,
            Bevel,
            Round,
            Miter;


            public static LineJoin valueOf(byte codeByte) throws AFPParserException {
                for (LineJoin le : LineJoin.values()) {
                    if (le.ordinal() != codeByte) continue;
                    return le;
                }
                throw new AFPParserException("The " + LineJoin.class.getSimpleName() + " code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal();
            }
        }
    }

    public static class GSLE_SetLineEnd
    extends GAD_DrawingOrder {
        @AFPField
        LineEnd lineEnd;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lineEnd = LineEnd.valueOf(sfData[offset + 1]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lineEnd.toByte());
        }

        public LineEnd getLineEnd() {
            return this.lineEnd;
        }

        public void setLineEnd(LineEnd lineEnd) {
            this.lineEnd = lineEnd;
        }

        public static enum LineEnd {
            Default,
            Flat,
            Square,
            Round;


            public static LineEnd valueOf(byte codeByte) throws AFPParserException {
                for (LineEnd le : LineEnd.values()) {
                    if (le.ordinal() != codeByte) continue;
                    return le;
                }
                throw new AFPParserException("The " + LineEnd.class.getSimpleName() + " code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal();
            }
        }
    }

    public static class GSLW_SetLineWidth
    extends GAD_DrawingOrder {
        @AFPField
        short lineWidth;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lineWidth = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lineWidth);
        }

        public short getLineWidth() {
            return this.lineWidth;
        }

        public void setLineWidth(short lineWidth) {
            this.lineWidth = lineWidth;
        }
    }

    public static class GSLT_SetLineType
    extends GAD_DrawingOrder {
        @AFPField
        short lineType;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lineType = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lineType);
        }

        public short getLineType() {
            return this.lineType;
        }

        public void setLineType(short lineType) {
            this.lineType = lineType;
        }

        public static enum LineType {
            Default,
            Dotted,
            ShortDashed,
            DashDot,
            DoubleDotted,
            LongDashed,
            DashDoubleDot,
            Solid,
            Invisible;


            public static LineType valueOf(byte codeByte) throws AFPParserException {
                for (LineType le : LineType.values()) {
                    if (le.ordinal() != codeByte) continue;
                    return le;
                }
                throw new AFPParserException("The " + LineType.class.getSimpleName() + " code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal();
            }
        }
    }

    public static class GSFLW_SetFractionLineWidth
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        short integralMultiplier;
        @AFPField
        short fractionalMultiplier;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.integralMultiplier = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.fractionalMultiplier = UtilBinaryDecoding.parseShort(sfData, offset + 3, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(this.integralMultiplier);
            os.write(this.fractionalMultiplier);
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public short getIntegralMultiplier() {
            return this.integralMultiplier;
        }

        public void setIntegralMultiplier(short integralMultiplier) {
            this.integralMultiplier = integralMultiplier;
        }

        public short getFractionalMultiplier() {
            return this.fractionalMultiplier;
        }

        public void setFractionalMultiplier(short fractionalMultiplier) {
            this.fractionalMultiplier = fractionalMultiplier;
        }
    }

    public static class GSBMX_SetBackgroundMix
    extends GAD_DrawingOrder {
        @AFPField
        short mixMode;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.mixMode = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.mixMode);
        }

        public short getMixMode() {
            return this.mixMode;
        }

        public void setMixMode(short mixMode) {
            this.mixMode = mixMode;
        }
    }

    public static class GSMX_SetMix
    extends GAD_DrawingOrder {
        @AFPField
        short mixMode;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.mixMode = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.mixMode);
        }

        public short getMixMode() {
            return this.mixMode;
        }

        public void setMixMode(short mixMode) {
            this.mixMode = mixMode;
        }
    }

    public static class GSCOL_SetColor
    extends GAD_DrawingOrder {
        @AFPField
        AFPColorValue color;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.color = AFPColorValue.valueOf(sfData[offset + 1]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.color != null ? this.color.toByte() : AFPColorValue.DeviceDefault_0x00.toByte());
        }

        public AFPColorValue getColor() {
            return this.color;
        }

        public void setColor(AFPColorValue color) {
            this.color = color;
        }
    }

    public static class GSPS_SetPatternSet
    extends GAD_DrawingOrder {
        @AFPField
        short patternLocalID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.patternLocalID = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
            os.write(this.patternLocalID);
        }

        public short getPatternLocalID() {
            return this.patternLocalID;
        }

        public void setPatternLocalID(short patternLocalID) {
            this.patternLocalID = patternLocalID;
        }
    }

    public static class GDGCH_SegmentCharacteristics
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        short identificationCode;
        @AFPField(maxSize=255)
        byte[] parameters;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.identificationCode = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.parameters = new byte[this.lengthOfFollowingData - 1];
            System.arraycopy(sfData, offset + 3, this.parameters, 0, this.lengthOfFollowingData - 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = this.parameters != null ? (short)(1 + this.parameters.length) : (short)1;
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            os.write(this.identificationCode);
            if (this.parameters != null) {
                os.write(this.parameters);
            }
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public short getIdentificationCode() {
            return this.identificationCode;
        }

        public void setIdentificationCode(short identificationCode) {
            this.identificationCode = identificationCode;
        }

        public byte[] getParameters() {
            return this.parameters;
        }

        public void setParameters(byte[] parameters) {
            this.parameters = parameters;
        }
    }

    public static class GCOMT_Comment
    extends GAD_DrawingOrder {
        @AFPField
        short lengthOfFollowingData;
        @AFPField(maxSize=255)
        byte[] comment;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.comment = new byte[this.lengthOfFollowingData];
            System.arraycopy(sfData, offset + 2, this.comment, 0, this.comment.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = this.comment != null ? (short)this.comment.length : (short)0;
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            if (this.comment != null) {
                os.write(this.comment);
            }
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public byte[] getComment() {
            return this.comment;
        }

        public void setComment(byte[] comment) {
            this.comment = comment;
        }
    }

    public static class GNOP1_NopOperation
    extends GAD_DrawingOrder {
        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.drawingOrderType);
        }
    }

    protected static abstract class DrawingOrder_HasPoints
    extends GAD_DrawingOrder {
        @AFPField(isHidden=true)
        protected boolean isAtCurrentPosition;
        @AFPField
        short lengthOfFollowingData;
        @AFPField
        List<GOCA_Point> points;

        protected DrawingOrder_HasPoints() {
        }

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.drawingOrderType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            if (this.lengthOfFollowingData > 0) {
                this.points = new ArrayList<GOCA_Point>();
                for (int pos = 0; pos < this.lengthOfFollowingData; pos += 4) {
                    GOCA_Point lp = new GOCA_Point();
                    lp.xCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 2 + pos, 2);
                    lp.yCoordinate = UtilBinaryDecoding.parseShort(sfData, offset + 2 + pos + 2, 2);
                    this.points.add(lp);
                }
            } else {
                this.points = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            byte[] lineEndpointsData = null;
            if (this.points != null && this.points.size() > 0) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                for (GOCA_Point lp : this.points) {
                    if (lp == null) continue;
                    UtilBinaryDecoding.shortToByteArray(lp.xCoordinate, 2);
                    UtilBinaryDecoding.shortToByteArray(lp.yCoordinate, 2);
                }
                lineEndpointsData = baos.toByteArray();
                this.lengthOfFollowingData = (short)lineEndpointsData.length;
            } else {
                this.lengthOfFollowingData = 0;
            }
            os.write(this.drawingOrderType);
            os.write(this.lengthOfFollowingData);
            if (lineEndpointsData != null) {
                os.write(lineEndpointsData);
            }
        }

        public short getLengthOfFollowingData() {
            return this.lengthOfFollowingData;
        }

        public void setLengthOfFollowingData(short lengthOfFollowingData) {
            this.lengthOfFollowingData = lengthOfFollowingData;
        }

        public List<GOCA_Point> getPoints() {
            return this.points;
        }

        public void setPoints(List<GOCA_Point> points) {
            this.points = points;
            this.lengthOfFollowingData = points == null ? (short)0 : (short)(4 * points.size());
        }

        public void addPoint(GOCA_Point point) {
            if (point == null) {
                return;
            }
            if (this.points == null) {
                this.points = new ArrayList<GOCA_Point>();
            }
            this.points.add(point);
            this.lengthOfFollowingData = (short)(4 * this.points.size());
        }

        public void removePoint(GOCA_Point point) {
            if (point == null || this.points == null) {
                return;
            }
            this.points.remove(point);
            this.lengthOfFollowingData = (short)(4 * this.points.size());
        }
    }
}

