/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.goca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.enums.IMutualExclusiveGroupedFlag;
import com.mgz.afp.enums.MutualExclusiveGroupedFlagHandler;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.goca.GAD_DrawingOrder;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.Constants;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class GAD_GraphicsData
extends StructuredField {
    private static final List<GAD_DrawingOrder> buildDrawingOrders(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        int dotLength;
        int actualLength = length != -1 ? length : sfData.length - offset;
        ArrayList<GAD_DrawingOrder> drawingOrders = new ArrayList<GAD_DrawingOrder>();
        for (int pos = 0; pos < actualLength; pos += dotLength) {
            dotLength = 0;
            GAD_DrawingOrder drawingOrder = null;
            int drawingOrderCode = UtilBinaryDecoding.parseInt(sfData, offset + pos, 1);
            switch (drawingOrderCode) {
                case 0: {
                    drawingOrder = new GAD_DrawingOrder.GNOP1_NopOperation();
                    dotLength = 1;
                    break;
                }
                case 1: {
                    drawingOrder = new GAD_DrawingOrder.GCOMT_Comment();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 4: {
                    drawingOrder = new GAD_DrawingOrder.GDGCH_SegmentCharacteristics();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 8: {
                    drawingOrder = new GAD_DrawingOrder.GSPS_SetPatternSet();
                    dotLength = 2;
                    break;
                }
                case 10: {
                    drawingOrder = new GAD_DrawingOrder.GSCOL_SetColor();
                    dotLength = 2;
                    break;
                }
                case 12: {
                    drawingOrder = new GAD_DrawingOrder.GSMX_SetMix();
                    dotLength = 2;
                    break;
                }
                case 13: {
                    drawingOrder = new GAD_DrawingOrder.GSBMX_SetBackgroundMix();
                    dotLength = 2;
                    break;
                }
                case 17: {
                    drawingOrder = new GAD_DrawingOrder.GSFLW_SetFractionLineWidth();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 24: {
                    drawingOrder = new GAD_DrawingOrder.GSLT_SetLineType();
                    dotLength = 2;
                    break;
                }
                case 25: {
                    drawingOrder = new GAD_DrawingOrder.GSLW_SetLineWidth();
                    dotLength = 2;
                    break;
                }
                case 26: {
                    drawingOrder = new GAD_DrawingOrder.GSLE_SetLineEnd();
                    dotLength = 2;
                    break;
                }
                case 27: {
                    drawingOrder = new GAD_DrawingOrder.GSLJ_SetLineJoin();
                    dotLength = 2;
                    break;
                }
                case 33: {
                    drawingOrder = new GAD_DrawingOrder.GSCP_SetCurrentPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 34: {
                    drawingOrder = new GAD_DrawingOrder.GSAP_SetArcParameters();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 38: {
                    drawingOrder = new GAD_DrawingOrder.GSECOL_SetExtendedColor();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 40: {
                    drawingOrder = new GAD_DrawingOrder.GSPT_SetPatternSymbol();
                    dotLength = 2;
                    break;
                }
                case 41: {
                    drawingOrder = new GAD_DrawingOrder.GSMT_SetMarkerSymbol();
                    dotLength = 2;
                    break;
                }
                case 51: {
                    drawingOrder = new GAD_DrawingOrder.GSCC_SetCharacterCell();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 52: {
                    drawingOrder = new GAD_DrawingOrder.GSCA_SetCharacterAngle();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 53: {
                    drawingOrder = new GAD_DrawingOrder.GSCH_SetCharacterShear();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 55: {
                    drawingOrder = new GAD_DrawingOrder.GSMC_SetMarkerCell();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 56: {
                    drawingOrder = new GAD_DrawingOrder.GSCS_SetCharacterSet();
                    dotLength = 2;
                    break;
                }
                case 57: {
                    drawingOrder = new GAD_DrawingOrder.GSCR_SetCharacterPrecision();
                    dotLength = 2;
                    break;
                }
                case 58: {
                    drawingOrder = new GAD_DrawingOrder.GSCD_SetCharacterDirection();
                    dotLength = 2;
                    break;
                }
                case 59: {
                    drawingOrder = new GAD_DrawingOrder.GSMP_SetMarkerPrecision();
                    dotLength = 2;
                    break;
                }
                case 60: {
                    drawingOrder = new GAD_DrawingOrder.GSMS_SetMarkerSet();
                    dotLength = 2;
                    break;
                }
                case 62: {
                    drawingOrder = new GAD_DrawingOrder.GEPROL_EndProlog();
                    dotLength = 2;
                    break;
                }
                case 96: {
                    drawingOrder = new GAD_DrawingOrder.GEAR_EndArea();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 104: {
                    drawingOrder = new GAD_DrawingOrder.GBAR_BeginArea();
                    dotLength = 2;
                    break;
                }
                case 128: {
                    drawingOrder = new GAD_DrawingOrder.GCBOX_BoxAtCurrentPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 129: {
                    drawingOrder = new GAD_DrawingOrder.GCLINE_LineAtCurrentPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 130: {
                    drawingOrder = new GAD_DrawingOrder.GCMRK_MarkerAtCurrentPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 131: {
                    drawingOrder = new GAD_DrawingOrder.GCCHST_CharacterStringAtCurrentPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 133: {
                    drawingOrder = new GAD_DrawingOrder.GCFLT_FilletAtCurrentPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 135: {
                    drawingOrder = new GAD_DrawingOrder.GCFARC_FullArcAtCurrentPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 145: {
                    drawingOrder = new GAD_DrawingOrder.GCBIMG_BeginImageAtCurrentPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 146: {
                    drawingOrder = new GAD_DrawingOrder.GIMD_ImageData();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 147: {
                    drawingOrder = new GAD_DrawingOrder.GEIMD_EndImage();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 161: {
                    drawingOrder = new GAD_DrawingOrder.GCRLINE_RelativeLineAtCurrentPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 163: {
                    drawingOrder = new GAD_DrawingOrder.GCPARC_PartialArcAtCurrentPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 165: {
                    drawingOrder = new GAD_DrawingOrder.GCCBEZ_CubicBezierCurveAtCurrentPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 178: {
                    drawingOrder = new GAD_DrawingOrder.GSPCOL_SetProcessColor();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 192: {
                    drawingOrder = new GAD_DrawingOrder.GBOX_BoxAtGivenPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 193: {
                    drawingOrder = new GAD_DrawingOrder.GLINE_LineAtGivenPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 194: {
                    drawingOrder = new GAD_DrawingOrder.GMRK_MarkerAtGivenPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 195: {
                    drawingOrder = new GAD_DrawingOrder.GCHST_CharacterStringAtGivenPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 197: {
                    drawingOrder = new GAD_DrawingOrder.GFLT_FilletAtGivenPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 199: {
                    drawingOrder = new GAD_DrawingOrder.GFARC_FullArcAtGivenPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 209: {
                    drawingOrder = new GAD_DrawingOrder.GBIMG_BeginImageAtGivenPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 225: {
                    drawingOrder = new GAD_DrawingOrder.GRLINE_RelativeLineAtGivenPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 227: {
                    drawingOrder = new GAD_DrawingOrder.GPARC_PartialArcAtGivenPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 229: {
                    drawingOrder = new GAD_DrawingOrder.GCBEZ_CubicBezierCurveAtGivenPosition();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 1, 1) + 2;
                    break;
                }
                case 254: {
                    drawingOrder = new GAD_DrawingOrder.GEXO_ExtendedOrder();
                    dotLength = UtilBinaryDecoding.parseInt(sfData, offset + pos + 2, 2) + 4;
                    break;
                }
                default: {
                    drawingOrder = null;
                }
            }
            if (drawingOrder == null) {
                throw new AFPParserException("The drawing order code 0x" + Integer.toHexString(drawingOrderCode) + "is unknown.");
            }
            drawingOrder.decodeAFP(sfData, offset + pos, dotLength, config);
            drawingOrders.add(drawingOrder);
        }
        return drawingOrders;
    }

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
    }

    public static class BeginSegment
    implements IAFPDecodeableWriteable {
        public static short COMMANDCODE_BeginSegment = (short)112;
        @AFPField
        short commandCode = COMMANDCODE_BeginSegment;
        @AFPField
        short lengtOfFollowingParameters = (short)12;
        @AFPField
        String nameOfSegment;
        @AFPField
        byte flagAnyValue;
        @AFPField
        EnumSet<SegmentPropertiesFlag> segmentPropertiesFlags = EnumSet.noneOf(SegmentPropertiesFlag.class);
        @AFPField
        int segmentDataLength;
        @AFPField
        String nameOfPredecessorSuccessorSegment;
        @AFPField
        List<GAD_DrawingOrder> drawingOrders;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.commandCode = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengtOfFollowingParameters = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.nameOfSegment = new String(sfData, offset + 2, 4, Constants.cpIBM500);
            this.flagAnyValue = sfData[offset + 6];
            this.segmentPropertiesFlags = SegmentPropertiesFlag.valueOF(sfData[offset + 7]);
            this.segmentDataLength = UtilBinaryDecoding.parseInt(sfData, offset + 8, 2);
            this.nameOfPredecessorSuccessorSegment = new String(sfData, offset + 10, 4, Constants.cpIBM500);
            this.drawingOrders = this.segmentDataLength > 0 ? GAD_GraphicsData.buildDrawingOrders(sfData, offset + 13, this.segmentDataLength, config) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            byte[] drawingOrdersData = null;
            os.write(this.commandCode);
            os.write(this.lengtOfFollowingParameters);
            os.write(this.nameOfSegment.getBytes(Constants.cpIBM500));
            os.write(this.flagAnyValue);
            if (this.segmentPropertiesFlags != null) {
                os.write(SegmentPropertiesFlag.toByte(this.segmentPropertiesFlags));
            } else {
                os.write(0);
            }
            if (this.drawingOrders != null && this.drawingOrders.size() > 0) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                for (GAD_DrawingOrder order : this.drawingOrders) {
                    if (order == null) continue;
                    order.writeAFP(baos, config);
                }
                drawingOrdersData = baos.toByteArray();
                this.segmentDataLength = drawingOrdersData.length;
            } else {
                this.segmentDataLength = 0;
            }
            os.write(UtilBinaryDecoding.intToByteArray(this.segmentDataLength, 2));
            os.write(this.nameOfPredecessorSuccessorSegment.getBytes(Constants.cpIBM500));
            if (drawingOrdersData != null) {
                os.write(drawingOrdersData);
            }
        }

        public void setSegmentPropertiesFlag(SegmentPropertiesFlag flag) {
            if (this.segmentPropertiesFlags == null) {
                this.segmentPropertiesFlags = EnumSet.noneOf(SegmentPropertiesFlag.class);
            }
            SegmentPropertiesFlag.setFlag(this.segmentPropertiesFlags, flag);
        }

        public short getCommandCode() {
            return this.commandCode;
        }

        public void setCommandCode(short commandCode) {
            this.commandCode = commandCode;
        }

        public short getLengtOfFollowingParameters() {
            return this.lengtOfFollowingParameters;
        }

        public void setLengtOfFollowingParameters(short lengtOfFollowingParameters) {
            this.lengtOfFollowingParameters = lengtOfFollowingParameters;
        }

        public String getNameOfSegment() {
            return this.nameOfSegment;
        }

        public void setNameOfSegment(String nameOfSegment) {
            this.nameOfSegment = nameOfSegment;
        }

        public byte getFlagAnyValue() {
            return this.flagAnyValue;
        }

        public void setFlagAnyValue(byte flagAnyValue) {
            this.flagAnyValue = flagAnyValue;
        }

        public EnumSet<SegmentPropertiesFlag> getSegmentPropertiesFlags() {
            return this.segmentPropertiesFlags;
        }

        public void setSegmentPropertiesFlags(EnumSet<SegmentPropertiesFlag> segmentPropertiesFlags) {
            this.segmentPropertiesFlags = segmentPropertiesFlags;
        }

        public int getSegmentDataLength() {
            return this.segmentDataLength;
        }

        public void setSegmentDataLength(int segmentDataLength) {
            this.segmentDataLength = segmentDataLength;
        }

        public String getNameOfPredecessorSuccessorSegment() {
            return this.nameOfPredecessorSuccessorSegment;
        }

        public void setNameOfPredecessorSuccessorSegment(String nameOfPredecessorSuccessorSegment) {
            this.nameOfPredecessorSuccessorSegment = nameOfPredecessorSuccessorSegment;
        }

        public List<GAD_DrawingOrder> getDrawingOrders() {
            return this.drawingOrders;
        }

        public void setDrawingOrders(List<GAD_DrawingOrder> drawingOrders) {
            this.drawingOrders = drawingOrders;
        }

        public static enum SegmentPropertiesFlag implements IMutualExclusiveGroupedFlag
        {
            Chained(0),
            Unchained(0),
            NoProlog(1),
            Prolog(1),
            NewSegment(2),
            Reserved_01(2),
            Reserved_10(2),
            AppendToExisting(2);

            int group;

            private SegmentPropertiesFlag(int group) {
                this.group = group;
            }

            public static EnumSet<SegmentPropertiesFlag> valueOF(byte flagsByte) {
                EnumSet<SegmentPropertiesFlag> result = EnumSet.noneOf(SegmentPropertiesFlag.class);
                if ((flagsByte & 0x80) == 0) {
                    result.add(Chained);
                } else {
                    result.add(Unchained);
                }
                if ((flagsByte & 0x10) == 0) {
                    result.add(NoProlog);
                } else {
                    result.add(Prolog);
                }
                int crap = flagsByte >> 1 & 3;
                if (crap == 0) {
                    result.add(NewSegment);
                } else if (crap == 1) {
                    result.add(Reserved_01);
                } else if (crap == 2) {
                    result.add(Reserved_10);
                } else if (crap == 3) {
                    result.add(AppendToExisting);
                }
                return result;
            }

            public static int toByte(EnumSet<SegmentPropertiesFlag> flags) {
                int result = 0;
                if (flags.contains(Unchained)) {
                    result |= 0x80;
                }
                if (flags.contains(Prolog)) {
                    result |= 0x10;
                }
                if (flags.contains(Reserved_01)) {
                    result += 2;
                } else if (flags.contains(Reserved_10)) {
                    result += 4;
                } else if (flags.contains(AppendToExisting)) {
                    result += 6;
                }
                return result;
            }

            public static void setFlag(EnumSet<SegmentPropertiesFlag> set, SegmentPropertiesFlag flag) {
                new MutualExclusiveGroupedFlagHandler<SegmentPropertiesFlag>().setFlag(set, flag);
            }

            @Override
            public int getGroup() {
                return this.group;
            }
        }
    }
}

