/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.goca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.goca.GDD_Parameter;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class GDD_GraphicsDataDescriptor
extends StructuredField {
    List<GDD_Parameter> gddParameters;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        int paramLength;
        int actualLength = length != -1 ? length : sfData.length - offset;
        this.gddParameters = new ArrayList<GDD_Parameter>();
        for (int pos = 0; pos < actualLength; pos += paramLength) {
            paramLength = UtilBinaryDecoding.parseShort(sfData, offset + pos, 2) + 1;
            GDD_Parameter gddParameter = GDD_Parameter.buildGDDParameter(sfData, offset + pos, paramLength, config);
            this.gddParameters.add(gddParameter);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        byte[] netData = null;
        if (this.gddParameters != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (GDD_Parameter gddParameter : this.gddParameters) {
                gddParameter.writeAFP(baos, config);
            }
            netData = baos.toByteArray();
        }
        super.writeFullStructuredField(os, netData);
    }
}

