/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.goca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.enums.AFPBackgroundMix;
import com.mgz.afp.enums.AFPColorValue;
import com.mgz.afp.enums.AFPForegroundMix;
import com.mgz.afp.enums.AFPUnitBase;
import com.mgz.afp.enums.IMutualExclusiveGroupedFlag;
import com.mgz.afp.enums.MutualExclusiveGroupedFlagHandler;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.goca.GAD_DrawingOrder;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.Constants;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.EnumSet;

public abstract class GDD_Parameter
implements IAFPDecodeableWriteable {
    public static short PARAMETERTYPE_WindowSpecification = (short)246;
    public static short PARAMETERTYPE_DrawingOrderSubset_RETIRED = (short)247;
    public static short PARAMETERTYPE_SetCurrentDefaultInstruction = (short)33;
    @AFPField
    short parameterType;
    @AFPField
    short lengthOfFollowingData;

    public static GDD_Parameter buildGDDParameter(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        short parameterType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
        GDD_Parameter gddParameter = null;
        if (parameterType == PARAMETERTYPE_SetCurrentDefaultInstruction) {
            gddParameter = SetCurrentDefaultInstruction.buildSetCurrentDefaultInstruction(sfData, offset, length, config);
        } else if (parameterType == PARAMETERTYPE_WindowSpecification) {
            gddParameter = new WindowSpecification();
        } else if (parameterType == PARAMETERTYPE_DrawingOrderSubset_RETIRED) {
            gddParameter = new DrawingOrderSubsetParameterRetired();
        }
        if (gddParameter == null) {
            throw new AFPParserException("GDD parameter type 0x" + Integer.toHexString(parameterType) + " is unknown.");
        }
        gddParameter.decodeAFP(sfData, offset, length, config);
        return gddParameter;
    }

    public static SetCurrentDefaultInstruction buildSetCurrentDefaultInstruction(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        short attributeType = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
        SetCurrentDefaultInstruction setCurrentDefaultInstruction = null;
        if (attributeType == 0) {
            setCurrentDefaultInstruction = new SetCurrentDefaultInstruction.DrawingAttributes();
        } else if (attributeType == 1) {
            setCurrentDefaultInstruction = new SetCurrentDefaultInstruction.LineAttributes();
        } else if (attributeType == 2) {
            setCurrentDefaultInstruction = new SetCurrentDefaultInstruction.CharacterAttributes();
        } else if (attributeType == 3) {
            setCurrentDefaultInstruction = new SetCurrentDefaultInstruction.MarkerAttributes();
        } else if (attributeType == 4) {
            setCurrentDefaultInstruction = new SetCurrentDefaultInstruction.PatternAttributes();
        } else if (attributeType == 11) {
            setCurrentDefaultInstruction = new SetCurrentDefaultInstruction.ArcParameters();
        } else if (attributeType == 16) {
            setCurrentDefaultInstruction = new SetCurrentDefaultInstruction.ProcessColorAttributes();
        } else if (attributeType == 17) {
            setCurrentDefaultInstruction = new SetCurrentDefaultInstruction.NormalLineWidthAttribute();
        }
        if (setCurrentDefaultInstruction == null) {
            throw new AFPParserException("The attribute type 0x" + Integer.toHexString(attributeType) + " of GDD parameter SetCurrentDefaultInstruction is unknown.");
        }
        ((SetCurrentDefaultInstruction)setCurrentDefaultInstruction).decodeAFP(sfData, offset, length, config);
        return setCurrentDefaultInstruction;
    }

    public short getParameterType() {
        return this.parameterType;
    }

    public short getLengthOfFollowingData() {
        return this.lengthOfFollowingData;
    }

    public void setLengthOfFollowingData(short lengthOfFollowingData) {
        this.lengthOfFollowingData = lengthOfFollowingData;
    }

    public static class DrawingOrderSubsetParameterRetired
    extends GDD_Parameter {
        @AFPField
        short drawingOrderSubset;
        @AFPField(size=2)
        byte[] reserved3_4;
        @AFPField
        short subsetLevel;
        @AFPField
        short version;
        @AFPField
        short lengthOfFollowingField;
        @AFPField
        short coordinateFormat;

        public DrawingOrderSubsetParameterRetired() {
            this.parameterType = PARAMETERTYPE_DrawingOrderSubset_RETIRED;
            this.lengthOfFollowingData = (short)7;
            this.drawingOrderSubset = (short)176;
            this.reserved3_4 = new byte[]{0, 0};
            this.subsetLevel = (short)2;
            this.version = 0;
            this.lengthOfFollowingField = 1;
            this.coordinateFormat = 0;
        }

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.parameterType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.drawingOrderSubset = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.reserved3_4 = new byte[2];
            System.arraycopy(sfData, offset + 3, this.reserved3_4, 0, this.reserved3_4.length);
            this.subsetLevel = UtilBinaryDecoding.parseShort(sfData, offset + 5, 1);
            this.version = UtilBinaryDecoding.parseShort(sfData, offset + 6, 1);
            this.lengthOfFollowingField = UtilBinaryDecoding.parseShort(sfData, offset + 7, 1);
            this.coordinateFormat = UtilBinaryDecoding.parseShort(sfData, offset + 8, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.parameterType);
            os.write(this.lengthOfFollowingData);
            os.write(this.drawingOrderSubset);
            os.write(this.reserved3_4);
            os.write(this.subsetLevel);
            os.write(this.version);
            os.write(this.lengthOfFollowingField);
            os.write(this.coordinateFormat);
        }
    }

    public static class WindowSpecification
    extends GDD_Parameter {
        static final int PARAMETERTYPE_WINDOWSSPECIFICATION = 246;
        @AFPField
        WindowSpecificationFlag flags;
        @AFPField
        short reserved3 = 0;
        @AFPField
        short geometricParameterFormat = 0;
        @AFPField
        AFPUnitBase unitBaseGPS;
        @AFPField
        int unitsPerUnitBaseX;
        @AFPField
        int unitsPerUnitBaseY;
        @AFPField
        int imageResolutionXY;
        @AFPField
        int leftEdgeOfGPSWindow;
        @AFPField
        int rightEdgeOfGPSWindow;
        @AFPField
        int bottomEdgeOfGPSWindow;
        @AFPField
        int topEdgeOfGPSWindow;
        @AFPField(maxSize=4, isOptional=true)
        byte[] reservedBytesObsolete;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.parameterType = (short)246;
            this.lengthOfFollowingData = sfData[offset + 1];
            this.unitBaseGPS = AFPUnitBase.valueOf(sfData[offset + 2]);
            this.reserved3 = UtilBinaryDecoding.parseShort(sfData, offset + 3, 1);
            this.geometricParameterFormat = UtilBinaryDecoding.parseShort(sfData, offset + 4, 1);
            this.unitBaseGPS = AFPUnitBase.valueOf(sfData[offset + 5]);
            this.unitsPerUnitBaseX = UtilBinaryDecoding.parseInt(sfData, offset + 6, 2);
            this.unitsPerUnitBaseY = UtilBinaryDecoding.parseInt(sfData, offset + 8, 2);
            this.imageResolutionXY = UtilBinaryDecoding.parseInt(sfData, offset + 10, 2);
            this.leftEdgeOfGPSWindow = UtilBinaryDecoding.parseInt(sfData, offset + 12, 2);
            this.rightEdgeOfGPSWindow = UtilBinaryDecoding.parseInt(sfData, offset + 14, 2);
            this.bottomEdgeOfGPSWindow = UtilBinaryDecoding.parseInt(sfData, offset + 16, 2);
            this.topEdgeOfGPSWindow = UtilBinaryDecoding.parseInt(sfData, offset + 18, 2);
            if (this.lengthOfFollowingData >= 22) {
                this.reservedBytesObsolete = new byte[4];
                System.arraycopy(sfData, offset + 20, this.reservedBytesObsolete, 0, 4);
            } else {
                this.reservedBytesObsolete = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = (short)(this.reservedBytesObsolete != null ? (int)(22 + this.reservedBytesObsolete.length) : 22);
            os.write(this.parameterType);
            os.write(this.lengthOfFollowingData);
            os.write(this.reserved3);
            os.write(this.unitBaseGPS.toByte());
            os.write(UtilBinaryDecoding.intToByteArray(this.unitsPerUnitBaseX, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.unitsPerUnitBaseY, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.imageResolutionXY, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.leftEdgeOfGPSWindow, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.rightEdgeOfGPSWindow, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.bottomEdgeOfGPSWindow, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.topEdgeOfGPSWindow, 2));
            if (this.reservedBytesObsolete != null) {
                os.write(this.reservedBytesObsolete);
            }
        }

        public WindowSpecificationFlag getFlags() {
            return this.flags;
        }

        public void setFlags(WindowSpecificationFlag flags) {
            this.flags = flags;
        }

        public short getReserved3() {
            return this.reserved3;
        }

        public void setReserved3(short reserved3) {
            this.reserved3 = reserved3;
        }

        public short getGeometricParameterFormat() {
            return this.geometricParameterFormat;
        }

        public void setGeometricParameterFormat(short geometricParameterFormat) {
            this.geometricParameterFormat = geometricParameterFormat;
        }

        public AFPUnitBase getUnitBaseGPS() {
            return this.unitBaseGPS;
        }

        public void setUnitBaseGPS(AFPUnitBase unitBaseGPS) {
            this.unitBaseGPS = unitBaseGPS;
        }

        public int getUnitsPerUnitBaseX() {
            return this.unitsPerUnitBaseX;
        }

        public void setUnitsPerUnitBaseX(int unitsPerUnitBaseX) {
            this.unitsPerUnitBaseX = unitsPerUnitBaseX;
        }

        public int getUnitsPerUnitBaseY() {
            return this.unitsPerUnitBaseY;
        }

        public void setUnitsPerUnitBaseY(int unitsPerUnitBaseY) {
            this.unitsPerUnitBaseY = unitsPerUnitBaseY;
        }

        public int getImageResolutionXY() {
            return this.imageResolutionXY;
        }

        public void setImageResolutionXY(int imageResolutionXY) {
            this.imageResolutionXY = imageResolutionXY;
        }

        public int getLeftEdgeOfGPSWindow() {
            return this.leftEdgeOfGPSWindow;
        }

        public void setLeftEdgeOfGPSWindow(int leftEdgeOfGPSWindow) {
            this.leftEdgeOfGPSWindow = leftEdgeOfGPSWindow;
        }

        public int getRightEdgeOfGPSWindow() {
            return this.rightEdgeOfGPSWindow;
        }

        public void setRightEdgeOfGPSWindow(int rightEdgeOfGPSWindow) {
            this.rightEdgeOfGPSWindow = rightEdgeOfGPSWindow;
        }

        public int getBottomEdgeOfGPSWindow() {
            return this.bottomEdgeOfGPSWindow;
        }

        public void setBottomEdgeOfGPSWindow(int bottomEdgeOfGPSWindow) {
            this.bottomEdgeOfGPSWindow = bottomEdgeOfGPSWindow;
        }

        public int getTopEdgeOfGPSWindow() {
            return this.topEdgeOfGPSWindow;
        }

        public void setTopEdgeOfGPSWindow(int topEdgeOfGPSWindow) {
            this.topEdgeOfGPSWindow = topEdgeOfGPSWindow;
        }

        public byte[] getReservedBytesObsolete() {
            return this.reservedBytesObsolete;
        }

        public void setReservedBytesObsolete(byte[] reservedBytesObsolete) {
            this.reservedBytesObsolete = reservedBytesObsolete;
            this.lengthOfFollowingData = (short)(reservedBytesObsolete != null ? (int)(22 + reservedBytesObsolete.length) : 22);
        }

        public static enum WindowSpecificationFlag implements IMutualExclusiveGroupedFlag
        {
            PicturePresentationSpace_2D(0),
            PicturePresentationSpace_Undefined(0),
            PictureDimensions_Undefined(1),
            PictureDimensions_Absolute(1),
            PictureResoulution_NotDefined_or_NonSymetric(2),
            PictureResoulution_XYEqual_DefinedByIMXYRES(2),
            SymetricImage_PictureResoulution_NotDefined_or_Symetric(3),
            SymetricImage_PictureResoulution_120x140dpi(3);

            int group;

            private WindowSpecificationFlag(int group) {
                this.group = group;
            }

            public static EnumSet<WindowSpecificationFlag> valueOf(byte flagByte) {
                EnumSet<WindowSpecificationFlag> result = EnumSet.noneOf(WindowSpecificationFlag.class);
                if ((flagByte & 0x80) == 0) {
                    result.add(PicturePresentationSpace_2D);
                } else {
                    result.add(PicturePresentationSpace_Undefined);
                }
                if ((flagByte & 0x40) == 0) {
                    result.add(PictureDimensions_Undefined);
                } else {
                    result.add(PictureDimensions_Absolute);
                }
                if ((flagByte & 0x10) == 0) {
                    result.add(PictureResoulution_NotDefined_or_NonSymetric);
                } else {
                    result.add(PictureResoulution_XYEqual_DefinedByIMXYRES);
                }
                if ((flagByte & 8) == 0) {
                    result.add(SymetricImage_PictureResoulution_NotDefined_or_Symetric);
                } else {
                    result.add(SymetricImage_PictureResoulution_120x140dpi);
                }
                return result;
            }

            public static int toByte(EnumSet<WindowSpecificationFlag> controlFlags) {
                int result = 0;
                if (controlFlags.contains(PicturePresentationSpace_Undefined)) {
                    result |= 0x80;
                }
                if (controlFlags.contains(PictureDimensions_Absolute)) {
                    result |= 0x40;
                }
                if (controlFlags.contains(PictureResoulution_XYEqual_DefinedByIMXYRES)) {
                    result |= 0x10;
                }
                if (controlFlags.contains(SymetricImage_PictureResoulution_120x140dpi)) {
                    result |= 8;
                }
                return result;
            }

            public static void setFlag(EnumSet<WindowSpecificationFlag> set, WindowSpecificationFlag flag) {
                new MutualExclusiveGroupedFlagHandler<WindowSpecificationFlag>().setFlag(set, flag);
            }

            @Override
            public int getGroup() {
                return this.group;
            }
        }
    }

    public static abstract class SetCurrentDefaultInstruction
    extends GDD_Parameter {
        public static final short ATTRIBUTETYPE_DRAWING = 0;
        public static final short ATTRIBUTETYPE_LINE = 1;
        public static final short ATTRIBUTETYPE_Character = 2;
        public static final short ATTRIBUTETYPE_Marker = 3;
        public static final short ATTRIBUTETYPE_PATTERN = 4;
        public static final short ATTRIBUTETYPE_ARC = 11;
        public static final short ATTRIBUTETYPE_PROZESSCOLOR = 16;
        public static final short ATTRIBUTETYPE_NORMALLINEWIDTH = 17;
        @AFPField(isEditable=false)
        short attributeType;
        @AFPField
        BitSet mask;
        @AFPField
        Flag flag;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.parameterType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.attributeType = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.mask = UtilBinaryDecoding.parseBitSet(sfData, offset + 3, 2);
            this.flag = Flag.valueOf(sfData[offset + 5]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.parameterType);
            os.write(this.lengthOfFollowingData);
            os.write(this.attributeType);
            os.write(UtilBinaryDecoding.bitSetToByteArray(this.mask, 2));
            os.write(this.flag.toByte());
        }

        public short getAttributeType() {
            return this.attributeType;
        }

        public BitSet getMask() {
            return this.mask;
        }

        public void setMask(BitSet mask) {
            this.mask = mask;
        }

        public void setMask(byte[] mask) {
            this.mask = UtilBinaryDecoding.parseBitSet(mask, 0, Math.min(2, mask.length));
        }

        public Flag getFlag() {
            return this.flag;
        }

        public void setFlag(Flag flag) {
            this.flag = flag;
        }

        public static class NormalLineWidthAttribute
        extends SetCurrentDefaultInstruction {
            @AFPField
            Integer normalLineWidth;

            public NormalLineWidthAttribute() {
                this.attributeType = (short)17;
            }

            @Override
            public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
                super.decodeAFP(sfData, offset, length, config);
                if (this.flag == Flag.UseValuesAsSpecified) {
                    this.normalLineWidth = this.mask.get(0) ? Integer.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 6, 2)) : null;
                }
            }

            @Override
            public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
                this.lengthOfFollowingData = this.flag == Flag.UseValuesAsSpecified && this.mask.get(0) ? (short)6 : (short)4;
                super.writeAFP(os, config);
                if (this.flag == Flag.UseValuesAsSpecified && this.mask.get(0)) {
                    os.write(UtilBinaryDecoding.intToByteArray(this.normalLineWidth != null ? this.normalLineWidth : 0, 2));
                }
            }

            public Integer getNormalLineWidth() {
                return this.normalLineWidth;
            }

            public void setNormalLineWidth(Integer normalLineWidth) {
                this.normalLineWidth = normalLineWidth;
                this.mask.set(0, normalLineWidth != null);
            }
        }

        public static class ProcessColorAttributes
        extends SetCurrentDefaultInstruction {
            @AFPField
            AFPForegroundMix foregroundMix;
            @AFPField
            AFPBackgroundMix backgroundMix;
            @AFPField(minSize=12, maxSize=14)
            byte[] processColor;

            public ProcessColorAttributes() {
                this.attributeType = (short)16;
            }

            @Override
            public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
                super.decodeAFP(sfData, offset, length, config);
                if (this.flag == Flag.UseValuesAsSpecified) {
                    int actualLength = StructuredField.getActualLength(sfData, offset, length);
                    int pos = 6;
                    this.foregroundMix = this.mask.get(0) && pos < actualLength ? AFPForegroundMix.valueOf(sfData[offset + pos++]) : null;
                    AFPBackgroundMix aFPBackgroundMix = this.backgroundMix = this.mask.get(1) && pos < actualLength ? AFPBackgroundMix.valueOf(sfData[offset + pos++]) : null;
                    if (this.mask.get(2) && pos < actualLength) {
                        this.processColor = new byte[this.lengthOfFollowingData - 7 + 1];
                        System.arraycopy(sfData, offset + 8, this.processColor, 0, this.processColor.length);
                    } else {
                        this.processColor = null;
                    }
                }
            }

            @Override
            public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
                byte[] attributeData = null;
                if (this.flag == Flag.UseValuesAsSpecified) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (this.mask.get(0)) {
                        baos.write(this.foregroundMix != null ? this.foregroundMix.toByte() : AFPForegroundMix.Default.toByte());
                    }
                    if (this.mask.get(1)) {
                        baos.write(this.backgroundMix != null ? this.backgroundMix.toByte() : AFPBackgroundMix.Default.toByte());
                    }
                    if (this.mask.get(2)) {
                        baos.write(this.processColor != null ? this.processColor : Constants.EMPTYBYTES_3);
                    }
                    attributeData = baos.toByteArray();
                }
                this.lengthOfFollowingData = (short)(attributeData != null ? (int)(4 + attributeData.length) : 4);
                super.writeAFP(os, config);
                if (attributeData != null) {
                    os.write(attributeData);
                }
            }

            public AFPForegroundMix getForegroundMix() {
                return this.foregroundMix;
            }

            public void setForegroundMix(AFPForegroundMix foregroundMix) {
                this.foregroundMix = foregroundMix;
                this.mask.set(0, foregroundMix != null);
            }

            public AFPBackgroundMix getBackgroundMix() {
                return this.backgroundMix;
            }

            public void setBackgroundMix(AFPBackgroundMix backgroundMix) {
                this.backgroundMix = backgroundMix;
                this.mask.set(1, backgroundMix != null);
            }

            public byte[] getProcessColor() {
                return this.processColor;
            }

            public void setProcessColor(byte[] processColor) {
                this.processColor = processColor;
                this.mask.set(2, processColor != null);
            }
        }

        public static class ArcParameters
        extends SetCurrentDefaultInstruction {
            @AFPField
            Short arcTransformP;
            @AFPField
            Short arcTransformQ;
            @AFPField
            Short arcTransformR;
            @AFPField
            Short arcTransformS;

            public ArcParameters() {
                this.attributeType = (short)11;
            }

            @Override
            public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
                super.decodeAFP(sfData, offset, length, config);
                if (this.flag == Flag.UseValuesAsSpecified) {
                    int actualLength = StructuredField.getActualLength(sfData, offset, length);
                    int pos = 6;
                    if (this.mask.get(0) && pos < actualLength) {
                        this.arcTransformP = UtilBinaryDecoding.parseShort(sfData, offset + pos, 2);
                        pos += 2;
                    } else {
                        this.arcTransformP = null;
                    }
                    if (this.mask.get(1) && pos < actualLength) {
                        this.arcTransformQ = UtilBinaryDecoding.parseShort(sfData, offset + pos, 2);
                        pos += 2;
                    } else {
                        this.arcTransformQ = null;
                    }
                    if (this.mask.get(2) && pos < actualLength) {
                        this.arcTransformR = UtilBinaryDecoding.parseShort(sfData, offset + pos, 2);
                        pos += 2;
                    } else {
                        this.arcTransformR = null;
                    }
                    if (this.mask.get(3) && pos < actualLength) {
                        this.arcTransformS = UtilBinaryDecoding.parseShort(sfData, offset + pos, 2);
                        pos += 2;
                    } else {
                        this.arcTransformS = null;
                    }
                }
            }

            @Override
            public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
                byte[] attributeData = null;
                if (this.flag == Flag.UseValuesAsSpecified) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (this.mask.get(0)) {
                        baos.write(this.arcTransformP != null ? UtilBinaryDecoding.shortToByteArray(this.arcTransformP, 2) : Constants.EMPTYBYTES_2);
                    }
                    if (this.mask.get(1)) {
                        baos.write(this.arcTransformQ != null ? UtilBinaryDecoding.shortToByteArray(this.arcTransformQ, 2) : Constants.EMPTYBYTES_2);
                    }
                    if (this.mask.get(2)) {
                        baos.write(this.arcTransformR != null ? UtilBinaryDecoding.shortToByteArray(this.arcTransformR, 2) : Constants.EMPTYBYTES_2);
                    }
                    if (this.mask.get(3)) {
                        baos.write(this.arcTransformS != null ? UtilBinaryDecoding.shortToByteArray(this.arcTransformS, 2) : Constants.EMPTYBYTES_2);
                    }
                    attributeData = baos.toByteArray();
                }
                this.lengthOfFollowingData = (short)(attributeData != null ? (int)(4 + attributeData.length) : 4);
                super.writeAFP(os, config);
                os.write(attributeData);
            }

            public Short getArcTransformP() {
                return this.arcTransformP;
            }

            public void setArcTransformP(Short arcTransformP) {
                this.arcTransformP = arcTransformP;
                this.mask.set(0, arcTransformP != null);
            }

            public Short getArcTransformQ() {
                return this.arcTransformQ;
            }

            public void setArcTransformQ(Short arcTransformQ) {
                this.arcTransformQ = arcTransformQ;
                this.mask.set(1, arcTransformQ != null);
            }

            public Short getArcTransformR() {
                return this.arcTransformR;
            }

            public void setArcTransformR(Short arcTransformR) {
                this.arcTransformR = arcTransformR;
                this.mask.set(2, arcTransformR != null);
            }

            public Short getArcTransformS() {
                return this.arcTransformS;
            }

            public void setArcTransformS(Short arcTransformS) {
                this.arcTransformS = arcTransformS;
                this.mask.set(3, arcTransformS != null);
            }
        }

        public static class PatternAttributes
        extends SetCurrentDefaultInstruction {
            @AFPField
            Byte patternSet;
            @AFPField
            Byte patternSymbol;

            public PatternAttributes() {
                this.attributeType = (short)4;
            }

            @Override
            public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
                super.decodeAFP(sfData, offset, length, config);
                int actualLength = StructuredField.getActualLength(sfData, offset, length);
                if (this.flag == Flag.UseValuesAsSpecified) {
                    int pos = 6;
                    this.patternSet = this.mask.get(0) && pos < actualLength ? Byte.valueOf(sfData[offset + pos++]) : null;
                    this.patternSymbol = this.mask.get(1) && pos < actualLength ? Byte.valueOf(sfData[offset + pos++]) : null;
                }
            }

            @Override
            public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
                byte[] attributeData = null;
                if (this.flag == Flag.UseValuesAsSpecified) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (this.mask.get(0)) {
                        baos.write(this.patternSet != null ? (int)this.patternSet.byteValue() : 0);
                    }
                    if (this.mask.get(1)) {
                        baos.write(this.patternSymbol != null ? (int)this.patternSymbol.byteValue() : 0);
                    }
                    attributeData = baos.toByteArray();
                }
                this.lengthOfFollowingData = (short)(attributeData != null ? (int)(4 + attributeData.length) : 4);
                super.writeAFP(os, config);
                if (attributeData != null) {
                    os.write(attributeData);
                }
            }

            public Byte getPatternSet() {
                return this.patternSet;
            }

            public void setPatternSet(Byte patternSet) {
                this.patternSet = patternSet;
                this.mask.set(0, patternSet != null);
            }

            public Byte getPatternSymbol() {
                return this.patternSymbol;
            }

            public void setPatternSymbol(Byte patternSymbol) {
                this.patternSymbol = patternSymbol;
                this.mask.set(1, patternSymbol != null);
            }
        }

        public static class MarkerAttributes
        extends SetCurrentDefaultInstruction {
            @AFPField
            Byte markerPrecision;
            @AFPField
            Byte markerSet;
            @AFPField
            Byte markerSymbol;

            public MarkerAttributes() {
                this.attributeType = (short)3;
            }

            @Override
            public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
                super.decodeAFP(sfData, offset, length, config);
                int actualLength = StructuredField.getActualLength(sfData, offset, length);
                if (this.flag == Flag.UseValuesAsSpecified) {
                    int pos = 6;
                    this.markerPrecision = this.mask.get(0) && pos < actualLength ? Byte.valueOf(sfData[offset + pos++]) : null;
                    this.markerSet = this.mask.get(1) && pos < actualLength ? Byte.valueOf(sfData[offset + pos++]) : null;
                    this.markerSymbol = this.mask.get(2) && pos < actualLength ? Byte.valueOf(sfData[offset + pos++]) : null;
                }
            }

            @Override
            public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
                byte[] attributeData = null;
                if (this.flag == Flag.UseValuesAsSpecified) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (this.mask.get(0)) {
                        baos.write(this.markerPrecision != null ? (int)this.markerPrecision.byteValue() : 0);
                    }
                    if (this.mask.get(1)) {
                        baos.write(this.markerSet != null ? (int)this.markerSet.byteValue() : 0);
                    }
                    if (this.mask.get(2)) {
                        baos.write(this.markerSymbol != null ? (int)this.markerSymbol.byteValue() : 0);
                    }
                    attributeData = baos.toByteArray();
                }
                this.lengthOfFollowingData = (short)(attributeData != null ? (int)(4 + attributeData.length) : 4);
                super.writeAFP(os, config);
                if (attributeData != null) {
                    os.write(attributeData);
                }
            }

            public Byte getMarkerPrecision() {
                return this.markerPrecision;
            }

            public void setMarkerPrecision(Byte markerPrecision) {
                this.markerPrecision = markerPrecision;
                this.mask.set(0, markerPrecision != null);
            }

            public Byte getMarkerSet() {
                return this.markerSet;
            }

            public void setMarkerSet(Byte markerSet) {
                this.markerSet = markerSet;
                this.mask.set(1, markerSet != null);
            }

            public Byte getMarkerSymbol() {
                return this.markerSymbol;
            }

            public void setMarkerSymbol(Byte markerSymbol) {
                this.markerSymbol = markerSymbol;
                this.mask.set(2, markerSymbol != null);
            }
        }

        public static class CharacterAttributes
        extends SetCurrentDefaultInstruction {
            @AFPField
            Long characterAngleXY;
            @AFPField
            Long characterCellSizeWH;
            @AFPField
            Byte characterDirection;
            @AFPField
            Byte characterPrecision;
            @AFPField
            Short characterSet;
            @AFPField
            Long characterShearXY;

            public CharacterAttributes() {
                this.attributeType = (short)2;
            }

            @Override
            public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
                super.decodeAFP(sfData, offset, length, config);
                int actualLength = StructuredField.getActualLength(sfData, offset, length);
                if (this.flag == Flag.UseValuesAsSpecified) {
                    int pos = 6;
                    if (this.mask.get(0) && pos < actualLength) {
                        this.characterAngleXY = UtilBinaryDecoding.parseLong(sfData, offset + pos, 4);
                        pos += 4;
                    } else {
                        this.characterAngleXY = null;
                    }
                    if (this.mask.get(1) && pos < actualLength) {
                        this.characterCellSizeWH = UtilBinaryDecoding.parseLong(sfData, offset + pos, 4);
                        pos += 4;
                    } else {
                        this.characterCellSizeWH = null;
                    }
                    this.characterDirection = this.mask.get(2) ? Byte.valueOf(sfData[offset + pos++]) : null;
                    this.characterPrecision = this.mask.get(3) ? Byte.valueOf(sfData[offset + pos++]) : null;
                    this.characterSet = this.mask.get(4) ? Short.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + pos++, 1)) : null;
                    this.characterShearXY = this.mask.get(5) ? Long.valueOf(UtilBinaryDecoding.parseLong(sfData, offset + pos, 4)) : null;
                }
            }

            @Override
            public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
                byte[] attributeData = null;
                if (this.flag == Flag.UseValuesAsSpecified) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (this.mask.get(0)) {
                        baos.write(this.characterAngleXY != null ? UtilBinaryDecoding.longToByteArray(this.characterAngleXY, 4) : Constants.EMPTYBYTES_4);
                    }
                    if (this.mask.get(1)) {
                        baos.write(this.characterCellSizeWH != null ? UtilBinaryDecoding.longToByteArray(this.characterCellSizeWH, 4) : Constants.EMPTYBYTES_4);
                    }
                    if (this.mask.get(2)) {
                        baos.write(this.characterDirection != null ? (int)this.characterDirection.byteValue() : 0);
                    }
                    if (this.mask.get(3)) {
                        baos.write(this.characterPrecision != null ? (int)this.characterPrecision.byteValue() : 0);
                    }
                    if (this.mask.get(4)) {
                        baos.write(this.characterSet != null ? (int)this.characterSet.shortValue() : 0);
                    }
                    if (this.mask.get(5)) {
                        baos.write(this.characterShearXY != null ? UtilBinaryDecoding.longToByteArray(this.characterShearXY, 4) : Constants.EMPTYBYTES_4);
                    }
                    attributeData = baos.toByteArray();
                }
                this.lengthOfFollowingData = (short)(attributeData != null ? (int)(4 + attributeData.length) : 4);
                super.writeAFP(os, config);
                if (attributeData != null) {
                    os.write(attributeData);
                }
            }

            public Long getCharacterAngleXY() {
                return this.characterAngleXY;
            }

            public void setCharacterAngleXY(Long characterAngleXY) {
                this.characterAngleXY = characterAngleXY;
                this.mask.set(0, characterAngleXY != null);
            }

            public Long getCharacterCellSizeWH() {
                return this.characterCellSizeWH;
            }

            public void setCharacterCellSizeWH(Long characterCellSizeWH) {
                this.characterCellSizeWH = characterCellSizeWH;
                this.mask.set(1, characterCellSizeWH != null);
            }

            public Byte getCharacterDirection() {
                return this.characterDirection;
            }

            public void setCharacterDirection(Byte characterDirection) {
                this.characterDirection = characterDirection;
                this.mask.set(2, characterDirection != null);
            }

            public Byte getCharacterPrecision() {
                return this.characterPrecision;
            }

            public void setCharacterPrecision(Byte characterPrecision) {
                this.characterPrecision = characterPrecision;
                this.mask.set(3, characterPrecision != null);
            }

            public Short getCharacterSet() {
                return this.characterSet;
            }

            public void setCharacterSet(Short characterSet) {
                this.characterSet = characterSet;
                this.mask.set(4, characterSet != null);
            }

            public Long getCharacterShearXY() {
                return this.characterShearXY;
            }

            public void setCharacterShearXY(Long characterShearXY) {
                this.characterShearXY = characterShearXY;
                this.mask.set(5, characterShearXY != null);
            }
        }

        public static class LineAttributes
        extends SetCurrentDefaultInstruction {
            @AFPField
            GAD_DrawingOrder.GSLT_SetLineType.LineType lineType;
            @AFPField
            Short lineWidth;
            @AFPField
            GAD_DrawingOrder.GSLE_SetLineEnd.LineEnd lineEnd;
            @AFPField
            GAD_DrawingOrder.GSLJ_SetLineJoin.LineJoin lineJoin;

            public LineAttributes() {
                this.attributeType = 1;
            }

            @Override
            public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
                super.decodeAFP(sfData, offset, length, config);
                int actualLength = StructuredField.getActualLength(sfData, offset, length);
                if (this.flag == Flag.UseValuesAsSpecified) {
                    int pos = 6;
                    this.lineType = this.mask.get(0) && pos < actualLength ? GAD_DrawingOrder.GSLT_SetLineType.LineType.valueOf(sfData[offset + pos++]) : null;
                    this.lineWidth = this.mask.get(1) && pos < actualLength ? Short.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + pos++, 1)) : null;
                    this.lineEnd = this.mask.get(2) && pos < actualLength ? GAD_DrawingOrder.GSLE_SetLineEnd.LineEnd.valueOf(sfData[offset + pos++]) : null;
                    this.lineJoin = this.mask.get(3) && pos < actualLength ? GAD_DrawingOrder.GSLJ_SetLineJoin.LineJoin.valueOf(sfData[offset + pos++]) : null;
                }
            }

            @Override
            public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
                byte[] attributeData = null;
                if (this.flag == Flag.UseValuesAsSpecified) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (this.mask.get(0)) {
                        baos.write(this.lineType != null ? this.lineType.toByte() : GAD_DrawingOrder.GSLT_SetLineType.LineType.Default.toByte());
                    }
                    if (this.mask.get(1)) {
                        baos.write(this.lineWidth != null ? (int)this.lineWidth.shortValue() : 0);
                    }
                    if (this.mask.get(2)) {
                        baos.write(this.lineEnd != null ? this.lineEnd.toByte() : GAD_DrawingOrder.GSLE_SetLineEnd.LineEnd.Default.toByte());
                    }
                    if (this.mask.get(3)) {
                        baos.write(this.lineJoin != null ? this.lineJoin.toByte() : GAD_DrawingOrder.GSLJ_SetLineJoin.LineJoin.Default.toByte());
                    }
                    attributeData = baos.toByteArray();
                }
                this.lengthOfFollowingData = (short)(attributeData != null ? (int)(4 + attributeData.length) : 4);
                super.writeAFP(os, config);
                if (attributeData != null) {
                    os.write(attributeData);
                }
            }

            public GAD_DrawingOrder.GSLT_SetLineType.LineType getLineType() {
                return this.lineType;
            }

            public void setLineType(GAD_DrawingOrder.GSLT_SetLineType.LineType lineType) {
                this.lineType = lineType;
                this.mask.set(0, lineType != null);
            }

            public Short getLineWidth() {
                return this.lineWidth;
            }

            public void setLineWidth(Short lineWidth) {
                this.lineWidth = lineWidth;
                this.mask.set(1, lineWidth != null);
            }

            public GAD_DrawingOrder.GSLE_SetLineEnd.LineEnd getLineEnd() {
                return this.lineEnd;
            }

            public void setLineEnd(GAD_DrawingOrder.GSLE_SetLineEnd.LineEnd lineEnd) {
                this.lineEnd = lineEnd;
                this.mask.set(2, lineEnd != null);
            }

            public GAD_DrawingOrder.GSLJ_SetLineJoin.LineJoin getLineJoin() {
                return this.lineJoin;
            }

            public void setLineJoin(GAD_DrawingOrder.GSLJ_SetLineJoin.LineJoin lineJoin) {
                this.lineJoin = lineJoin;
                this.mask.set(3, lineJoin != null);
            }
        }

        public static class DrawingAttributes
        extends SetCurrentDefaultInstruction {
            @AFPField
            AFPColorValue color;
            @AFPField
            AFPForegroundMix foregroundMix;
            @AFPField
            AFPBackgroundMix backgroundMix;

            public DrawingAttributes() {
                this.attributeType = 0;
            }

            @Override
            public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
                super.decodeAFP(sfData, offset, length, config);
                int actualLength = StructuredField.getActualLength(sfData, offset, length);
                if (this.flag == Flag.UseValuesAsSpecified) {
                    int pos = 6;
                    if (this.mask.get(0) && pos < actualLength) {
                        this.color = AFPColorValue.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + pos, 2));
                        pos += 2;
                    } else {
                        this.color = null;
                    }
                    this.foregroundMix = this.mask.get(2) && pos < actualLength ? AFPForegroundMix.valueOf(sfData[offset + pos++]) : null;
                    this.backgroundMix = this.mask.get(3) && pos < actualLength ? AFPBackgroundMix.valueOf(sfData[offset + pos++]) : null;
                }
            }

            @Override
            public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
                byte[] attributeData = null;
                if (this.flag == Flag.UseValuesAsSpecified) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (this.mask.get(0)) {
                        baos.write(this.color != null ? this.color.toByte2() : AFPColorValue.DeviceDefault_0xFF00.toByte2());
                    }
                    if (this.mask.get(2)) {
                        baos.write(this.foregroundMix != null ? this.foregroundMix.toByte() : 0);
                    }
                    if (this.mask.get(3)) {
                        baos.write(this.backgroundMix != null ? this.backgroundMix.toByte() : 0);
                    }
                    attributeData = baos.toByteArray();
                }
                this.lengthOfFollowingData = (short)(attributeData != null ? (int)(4 + attributeData.length) : 4);
                super.writeAFP(os, config);
                if (attributeData != null) {
                    os.write(attributeData);
                }
            }

            public AFPColorValue getColor() {
                return this.color;
            }

            public void setColor(AFPColorValue color) {
                this.color = color;
                this.mask.set(0, color != null);
            }

            public AFPForegroundMix getForegroundMix() {
                return this.foregroundMix;
            }

            public void setForegroundMix(AFPForegroundMix foregroundMix) {
                this.foregroundMix = foregroundMix;
                this.mask.set(2, foregroundMix != null);
            }

            public AFPBackgroundMix getBackgroundMix() {
                return this.backgroundMix;
            }

            public void setBackgroundMix(AFPBackgroundMix backgroundMix) {
                this.backgroundMix = backgroundMix;
                this.mask.set(3, backgroundMix != null);
            }
        }

        public static enum Flag {
            UseStandardDefault,
            UseValuesAsSpecified;


            public static Flag valueOf(byte code) {
                if (code == 15) {
                    return UseStandardDefault;
                }
                return UseValuesAsSpecified;
            }

            public int toByte() {
                if (this == UseStandardDefault) {
                    return 15;
                }
                return 143;
            }
        }
    }
}

