/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.ioca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.enums.AFPUnitBase;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.ioca.IDD_SelfDefiningField;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class IDD_ImageDataDescriptor
extends StructuredField {
    AFPUnitBase unitBase;
    short xImagePointsPerUnitBase;
    short yImagePointsPerUnitBase;
    short widthOfImageInImagePoints;
    short heightOfImageInImagePoints;
    List<IDD_SelfDefiningField> selfDefiningFields;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        IDD_ImageDataDescriptor.checkDataLength(sfData, offset, length, 9);
        this.unitBase = AFPUnitBase.valueOf(sfData[offset]);
        this.xImagePointsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 1, 2);
        this.yImagePointsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 3, 2);
        this.widthOfImageInImagePoints = UtilBinaryDecoding.parseShort(sfData, offset + 5, 2);
        this.heightOfImageInImagePoints = UtilBinaryDecoding.parseShort(sfData, offset + 7, 2);
        int actualLength = IDD_ImageDataDescriptor.getActualLength(sfData, offset, length);
        if (actualLength > 9) {
            IDD_SelfDefiningField sdf;
            this.selfDefiningFields = new ArrayList<IDD_SelfDefiningField>();
            for (int pos = 9; pos < actualLength; pos += sdf.lengthOfFollowingData + 2) {
                sdf = null;
                IDD_SelfDefiningField.SelfDefiningFieldType fieldType = IDD_SelfDefiningField.SelfDefiningFieldType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + pos, 1));
                sdf = fieldType == IDD_SelfDefiningField.SelfDefiningFieldType.SetBilevelImageColor ? new IDD_SelfDefiningField.SetBilevelImageColor() : (fieldType == IDD_SelfDefiningField.SelfDefiningFieldType.SetExtendedBilevelImageColor ? new IDD_SelfDefiningField.SetExtendedBilevelImageColor() : (fieldType == IDD_SelfDefiningField.SelfDefiningFieldType.IOCAFunctionSetIdentification ? new IDD_SelfDefiningField.IOCAFunctionSetIdentification() : new IDD_SelfDefiningField.UnknownSelfDefiningField()));
                sdf.decodeAFP(sfData, offset + pos, -1, config);
                this.selfDefiningFields.add(sdf);
            }
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.unitBase.toByte());
        baos.write(UtilBinaryDecoding.shortToByteArray(this.xImagePointsPerUnitBase, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.yImagePointsPerUnitBase, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.widthOfImageInImagePoints, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.heightOfImageInImagePoints, 2));
        if (this.selfDefiningFields != null) {
            for (IDD_SelfDefiningField sdf : this.selfDefiningFields) {
                sdf.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public AFPUnitBase getUnitBase() {
        return this.unitBase;
    }

    public void setUnitBase(AFPUnitBase unitBase) {
        this.unitBase = unitBase;
    }

    public short getxImagePointsPerUnitBase() {
        return this.xImagePointsPerUnitBase;
    }

    public void setxImagePointsPerUnitBase(short xImagePointsPerUnitBase) {
        this.xImagePointsPerUnitBase = xImagePointsPerUnitBase;
    }

    public short getyImagePointsPerUnitBase() {
        return this.yImagePointsPerUnitBase;
    }

    public void setyImagePointsPerUnitBase(short yImagePointsPerUnitBase) {
        this.yImagePointsPerUnitBase = yImagePointsPerUnitBase;
    }

    public short getWidthOfImageInImagePoints() {
        return this.widthOfImageInImagePoints;
    }

    public void setWidthOfImageInImagePoints(short widthOfImageInImagePoints) {
        this.widthOfImageInImagePoints = widthOfImageInImagePoints;
    }

    public short getHeightOfImageInImagePoints() {
        return this.heightOfImageInImagePoints;
    }

    public void setHeightOfImageInImagePoints(short heightOfImageInImagePoints) {
        this.heightOfImageInImagePoints = heightOfImageInImagePoints;
    }

    public List<IDD_SelfDefiningField> getSelfDefiningFields() {
        return this.selfDefiningFields;
    }

    public void setSelfDefiningFields(List<IDD_SelfDefiningField> selfDefiningFields) {
        this.selfDefiningFields = selfDefiningFields;
    }

    public void addSelfDefiningFields(IDD_SelfDefiningField selfDefiningField) {
        if (this.selfDefiningFields == null) {
            this.selfDefiningFields = new ArrayList<IDD_SelfDefiningField>();
        }
        this.selfDefiningFields.add(selfDefiningField);
    }

    public void removeSelfDefiningFields(IDD_SelfDefiningField selfDefiningField) {
        if (this.selfDefiningFields == null) {
            return;
        }
        this.selfDefiningFields.remove(selfDefiningField);
    }
}

