/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.ioca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.ioca.IPD_Segment;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class IPD_ImagePictureData
extends StructuredField {
    List<IPD_Segment> listOfSegments;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        int actualLength = StructuredField.getActualLength(sfData, offset, length);
        this.listOfSegments = new ArrayList<IPD_Segment>();
        int pos = 0;
        while (pos < actualLength) {
            int segmentTypeCode = sfData[offset + pos] & 0xFF;
            if (segmentTypeCode == 254) {
                segmentTypeCode = UtilBinaryDecoding.parseInt(sfData, offset + pos, 2);
            }
            IPD_Segment.IPD_SegmentType segmentType = IPD_Segment.IPD_SegmentType.valueOf(segmentTypeCode);
            IPD_Segment ipdSegment = null;
            switch (segmentType) {
                case BeginSegment: {
                    ipdSegment = new IPD_Segment.BeginSegment();
                    break;
                }
                case EndSegment: {
                    ipdSegment = new IPD_Segment.EndSegment();
                    break;
                }
                case BeginImageContent: {
                    ipdSegment = new IPD_Segment.BeginImageContent();
                    break;
                }
                case EndImageContent: {
                    ipdSegment = new IPD_Segment.EndImageContent();
                    break;
                }
                case ImageSize: {
                    ipdSegment = new IPD_Segment.ImageSize();
                    break;
                }
                case ImageEncoding: {
                    ipdSegment = new IPD_Segment.ImageEncoding();
                    break;
                }
                case IDESize: {
                    ipdSegment = new IPD_Segment.IDESize();
                    break;
                }
                case BandImage: {
                    ipdSegment = new IPD_Segment.BandImage();
                    break;
                }
                case IDEStructure: {
                    ipdSegment = new IPD_Segment.IDEStructure();
                    break;
                }
                case ExternalAlgorithmSpecification: {
                    ipdSegment = new IPD_Segment.ExternalAlgorithmSpecification();
                    break;
                }
                case ImageSubsampling: {
                    ipdSegment = new IPD_Segment.ImageSubsampling();
                    break;
                }
                case BeginTile: {
                    ipdSegment = new IPD_Segment.BeginTile();
                    break;
                }
                case EndTile: {
                    ipdSegment = new IPD_Segment.EndTile();
                    break;
                }
                case TilePosition: {
                    ipdSegment = new IPD_Segment.TilePosition();
                    break;
                }
                case TileSize: {
                    ipdSegment = new IPD_Segment.TileSize();
                    break;
                }
                case TileSetColor: {
                    ipdSegment = new IPD_Segment.TileSetColor();
                    break;
                }
                case IncludeTile: {
                    ipdSegment = new IPD_Segment.IncludeTile();
                    break;
                }
                case TileTOC: {
                    ipdSegment = new IPD_Segment.TileTOC();
                    break;
                }
                case BeginTransparencyMask: {
                    ipdSegment = new IPD_Segment.BeginTransparencyMask();
                    break;
                }
                case EndTransparencyMask: {
                    ipdSegment = new IPD_Segment.EndTransparencyMask();
                    break;
                }
                case ImageData: {
                    ipdSegment = new IPD_Segment.ImageData();
                    break;
                }
                case BandImageData: {
                    ipdSegment = new IPD_Segment.BandImageData();
                    break;
                }
                case UnknownIPDSegmentLong: {
                    ipdSegment = new IPD_Segment.UnknownSegmentLong();
                    break;
                }
                case UnknownIPDSegmentExtended: {
                    ipdSegment = new IPD_Segment.UnknownSegmentExtended();
                }
            }
            ipdSegment.decodeAFP(sfData, offset + pos, actualLength - pos, config);
            this.listOfSegments.add(ipdSegment);
            if (ipdSegment instanceof IPD_Segment.IPD_SegmentExtended) {
                pos += 4 + ipdSegment.lengthOfFollowingData;
                continue;
            }
            pos += 2 + ipdSegment.lengthOfFollowingData;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        if (this.listOfSegments != null && !this.listOfSegments.isEmpty()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (IPD_Segment segment : this.listOfSegments) {
                segment.writeAFP(baos, config);
            }
            this.writeFullStructuredField(os, baos.toByteArray());
        } else {
            this.writeFullStructuredField(os, null);
        }
    }
}

