/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.ioca;

import com.mgz.afp.enums.AFPColorSpace;
import com.mgz.afp.enums.AFPUnitBase;
import com.mgz.afp.enums.IMutualExclusiveGroupedFlag;
import com.mgz.afp.enums.MutualExclusiveGroupedFlagHandler;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

abstract class IPD_Segment
implements IAFPDecodeableWriteable {
    IPD_SegmentType segmentType;
    int lengthOfFollowingData;

    IPD_Segment() {
    }

    public IPD_SegmentType getSegmentType() {
        return this.segmentType;
    }

    public void setSegmentType(IPD_SegmentType segmentType) {
        this.segmentType = segmentType;
    }

    public int getLengthOfFollowingData() {
        return this.lengthOfFollowingData;
    }

    public void setLengthOfFollowingData(int lengthOfFollowingData) {
        this.lengthOfFollowingData = lengthOfFollowingData;
    }

    public static class BandImageData
    extends IPD_SegmentExtended {
        short bandNumber;
        byte[] reserved5_6 = new byte[]{0, 0};
        byte[] bandData;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseInt(sfData, offset, 2));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.bandNumber = UtilBinaryDecoding.parseShort(sfData, offset + 4, 1);
            this.reserved5_6 = new byte[2];
            System.arraycopy(sfData, offset + 5, this.reserved5_6, 0, this.reserved5_6.length);
            if (this.lengthOfFollowingData > 3) {
                this.bandData = new byte[this.lengthOfFollowingData - 3];
                System.arraycopy(sfData, offset + 7, this.bandData, 0, this.bandData.length);
            } else {
                this.bandData = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = this.bandData == null ? 3 : this.bandData.length + 3;
            os.write(this.segmentType.toBytes());
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 2));
            os.write(this.bandNumber);
            os.write(this.reserved5_6);
            if (this.bandData != null) {
                os.write(this.bandData);
            }
        }
    }

    public static class ImageData
    extends IPD_SegmentExtended {
        byte[] imageData;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseInt(sfData, offset, 2));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.imageData = new byte[this.lengthOfFollowingData];
            System.arraycopy(sfData, offset + 4, this.imageData, 0, this.imageData.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = this.imageData.length;
            os.write(this.segmentType.toBytes());
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 2));
            os.write(this.imageData);
        }
    }

    public static class EndTransparencyMask
    extends IPD_SegmentLong {
        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            os.write(this.lengthOfFollowingData);
        }
    }

    public static class BeginTransparencyMask
    extends IPD_SegmentLong {
        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            os.write(this.lengthOfFollowingData);
        }
    }

    public static class TileTOC
    extends IPD_SegmentExtended {
        byte[] reserved4_5 = new byte[]{0, 0};
        List<TileTOC_RepeatingGroup> listOfRepeatingGroups;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            int pos;
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseInt(sfData, offset, 2));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.reserved4_5 = new byte[2];
            System.arraycopy(sfData, offset + 4, this.reserved4_5, 0, this.reserved4_5.length);
            if (pos < this.lengthOfFollowingData) {
                this.listOfRepeatingGroups = new ArrayList<TileTOC_RepeatingGroup>();
                for (pos = 2; pos < this.lengthOfFollowingData; pos += 26) {
                    TileTOC_RepeatingGroup rg = new TileTOC_RepeatingGroup();
                    rg.decodeAFP(sfData, offset + 4 + pos, 26, config);
                    this.listOfRepeatingGroups.add(rg);
                }
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = this.listOfRepeatingGroups == null || this.listOfRepeatingGroups.isEmpty() ? 2 : 2 + this.listOfRepeatingGroups.size() * 26;
            os.write(this.segmentType.toBytes());
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 2));
            os.write(this.reserved4_5);
            if (this.listOfRepeatingGroups != null) {
                for (TileTOC_RepeatingGroup rg : this.listOfRepeatingGroups) {
                    rg.writeAFP(os, config);
                }
            }
        }

        public static class TileTOC_RepeatingGroup
        implements IAFPDecodeableWriteable {
            int horizontalOffset;
            int verticalOffset;
            int horizontalSize;
            int verticalSize;
            TileSize.RelativeTileResolution relativeTileResolution;
            AlgorithmSpecificationCompression.CompressionAlgorithmID compressionAlgorithmID;
            long offsetInBytesFromBeginSegmentToBeginTile;

            @Override
            public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
                this.horizontalOffset = UtilBinaryDecoding.parseInt(sfData, offset, 4);
                this.verticalOffset = UtilBinaryDecoding.parseInt(sfData, offset + 4, 4);
                this.horizontalSize = UtilBinaryDecoding.parseInt(sfData, offset + 8, 4);
                this.verticalSize = UtilBinaryDecoding.parseInt(sfData, offset + 12, 4);
                this.relativeTileResolution = TileSize.RelativeTileResolution.valueOf(sfData[offset + 16]);
                this.compressionAlgorithmID = AlgorithmSpecificationCompression.CompressionAlgorithmID.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 17, 1));
                this.offsetInBytesFromBeginSegmentToBeginTile = UtilBinaryDecoding.parseLong(sfData, offset + 17, 8);
            }

            @Override
            public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
                os.write(UtilBinaryDecoding.intToByteArray(this.horizontalOffset, 4));
                os.write(UtilBinaryDecoding.intToByteArray(this.verticalOffset, 4));
                os.write(UtilBinaryDecoding.intToByteArray(this.horizontalSize, 4));
                os.write(UtilBinaryDecoding.intToByteArray(this.verticalSize, 4));
                os.write(this.relativeTileResolution.toByte());
                os.write(this.compressionAlgorithmID.toByte());
                os.write(UtilBinaryDecoding.longToByteArray(this.offsetInBytesFromBeginSegmentToBeginTile, 8));
            }

            public int getHorizontalOffset() {
                return this.horizontalOffset;
            }

            public void setHorizontalOffset(int horizontalOffset) {
                this.horizontalOffset = horizontalOffset;
            }

            public int getVerticalOffset() {
                return this.verticalOffset;
            }

            public void setVerticalOffset(int verticalOffset) {
                this.verticalOffset = verticalOffset;
            }

            public int getHorizontalSize() {
                return this.horizontalSize;
            }

            public void setHorizontalSize(int horizontalSize) {
                this.horizontalSize = horizontalSize;
            }

            public int getVerticalSize() {
                return this.verticalSize;
            }

            public void setVerticalSize(int verticalSize) {
                this.verticalSize = verticalSize;
            }

            public TileSize.RelativeTileResolution getRelativeTileResolution() {
                return this.relativeTileResolution;
            }

            public void setRelativeTileResolution(TileSize.RelativeTileResolution relativeTileResolution) {
                this.relativeTileResolution = relativeTileResolution;
            }

            public AlgorithmSpecificationCompression.CompressionAlgorithmID getCompressionAlgorithmID() {
                return this.compressionAlgorithmID;
            }

            public void setCompressionAlgorithmID(AlgorithmSpecificationCompression.CompressionAlgorithmID compressionAlgorithmID) {
                this.compressionAlgorithmID = compressionAlgorithmID;
            }

            public long getOffsetInBytesFromBeginSegmentToBeginTile() {
                return this.offsetInBytesFromBeginSegmentToBeginTile;
            }

            public void setOffsetInBytesFromBeginSegmentToBeginTile(long offsetInBytesFromBeginSegmentToBeginTile) {
                this.offsetInBytesFromBeginSegmentToBeginTile = offsetInBytesFromBeginSegmentToBeginTile;
            }
        }
    }

    public static class IncludeTile
    extends IPD_SegmentExtended {
        long tileResourceLocalID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseInt(sfData, offset, 2));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.tileResourceLocalID = UtilBinaryDecoding.parseLong(sfData, offset + 4, 4);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 2));
            os.write(UtilBinaryDecoding.longToByteArray(this.tileResourceLocalID, 4));
        }
    }

    public static class TileSetColor
    extends IPD_SegmentLong {
        AFPColorSpace colorSpace;
        byte[] reserved3_5 = new byte[]{0, 0, 0};
        short nrOfBitsIDEsComponent1;
        short nrOfBitsIDEsComponent2;
        short nrOfBitsIDEsComponent3;
        short nrOfBitsIDEsComponent4;
        byte[] color;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.colorSpace = AFPColorSpace.valueOf(sfData[offset + 2]);
            this.reserved3_5 = new byte[3];
            System.arraycopy(sfData, offset + 6, this.reserved3_5, 0, this.reserved3_5.length);
            this.nrOfBitsIDEsComponent1 = UtilBinaryDecoding.parseShort(sfData, offset + 6, 1);
            this.nrOfBitsIDEsComponent2 = UtilBinaryDecoding.parseShort(sfData, offset + 7, 1);
            this.nrOfBitsIDEsComponent3 = UtilBinaryDecoding.parseShort(sfData, offset + 8, 1);
            this.nrOfBitsIDEsComponent4 = UtilBinaryDecoding.parseShort(sfData, offset + 9, 1);
            this.color = new byte[this.lengthOfFollowingData - 8];
            System.arraycopy(sfData, offset + 10, this.color, 0, this.color.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = 8 + this.color.length;
            os.write(this.segmentType.toBytes());
            os.write(this.lengthOfFollowingData);
            os.write(this.colorSpace.toByte());
            os.write(this.reserved3_5);
            os.write(this.nrOfBitsIDEsComponent1);
            os.write(this.nrOfBitsIDEsComponent2);
            os.write(this.nrOfBitsIDEsComponent3);
            os.write(this.nrOfBitsIDEsComponent4);
            os.write(this.color);
        }
    }

    public static class TileSize
    extends IPD_SegmentLong {
        int horizontalSizeInImagePoints;
        int verticalSizeInImagePoints;
        RelativeTileResolution relativeResolution;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.horizontalSizeInImagePoints = UtilBinaryDecoding.parseInt(sfData, offset + 2, 4);
            this.verticalSizeInImagePoints = UtilBinaryDecoding.parseInt(sfData, offset + 6, 4);
            this.relativeResolution = this.lengthOfFollowingData == 9 ? RelativeTileResolution.valueOf(sfData[offset + 10]) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = this.relativeResolution == null ? 8 : 9;
            os.write(this.segmentType.toBytes());
            os.write(this.lengthOfFollowingData);
            os.write(UtilBinaryDecoding.intToByteArray(this.horizontalSizeInImagePoints, 4));
            os.write(UtilBinaryDecoding.intToByteArray(this.verticalSizeInImagePoints, 4));
            if (this.relativeResolution != null) {
                os.write(this.relativeResolution.toByte());
            }
        }

        public static enum RelativeTileResolution {
            SameAsImagePresentationSpace(1),
            HalfOfImagePresentationSpace(2);

            int code;

            private RelativeTileResolution(int code) {
                this.code = code;
            }

            public static RelativeTileResolution valueOf(byte codeByte) {
                int n = 0;
                RelativeTileResolution[] relativeTileResolutionArray = RelativeTileResolution.values();
                int n2 = relativeTileResolutionArray.length;
                if (n < n2) {
                    RelativeTileResolution rtr = relativeTileResolutionArray[n];
                    return rtr;
                }
                return null;
            }

            public int toByte() {
                return this.code;
            }
        }
    }

    public static class TilePosition
    extends IPD_SegmentLong {
        int horizontalOffset;
        int verticalOffset;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.horizontalOffset = UtilBinaryDecoding.parseInt(sfData, offset + 2, 4);
            this.verticalOffset = UtilBinaryDecoding.parseInt(sfData, offset + 6, 4);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            os.write(this.lengthOfFollowingData);
            os.write(UtilBinaryDecoding.intToByteArray(this.horizontalOffset, 4));
            os.write(UtilBinaryDecoding.intToByteArray(this.verticalOffset, 4));
        }
    }

    public static class EndTile
    extends IPD_SegmentLong {
        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            os.write(this.lengthOfFollowingData);
        }
    }

    public static class BeginTile
    extends IPD_SegmentLong {
        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            os.write(this.lengthOfFollowingData);
        }
    }

    public static class ImageSubsampling
    extends IPD_SegmentExtended {
        List<ImageSubsamplingField> listOfFields;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseInt(sfData, offset, 2));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseInt(sfData, offset + 2, 2);
            this.listOfFields = this.lengthOfFollowingData > 0 ? ImageSubsamplingField.buildListOfFields(sfData, offset + 4, this.lengthOfFollowingData, config) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            byte[] fieldsData = null;
            if (this.listOfFields != null && !this.listOfFields.isEmpty()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                for (ImageSubsamplingField field : this.listOfFields) {
                    if (field == null) continue;
                    field.writeAFP(baos, config);
                }
                fieldsData = baos.toByteArray();
                this.lengthOfFollowingData = (short)fieldsData.length;
            } else {
                this.lengthOfFollowingData = 0;
            }
            os.write(this.segmentType.toBytes());
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 2));
            if (fieldsData != null) {
                os.write(fieldsData);
            }
        }

        public static abstract class ImageSubsamplingField
        implements IAFPDecodeableWriteable {
            short fieldType;

            public static List<ImageSubsamplingField> buildListOfFields(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
                SamplingRatios ratios;
                ArrayList<ImageSubsamplingField> result = new ArrayList<ImageSubsamplingField>();
                int actualLength = length != -1 ? length : sfData.length - offset;
                for (int pos = 0; pos < actualLength; pos += 2 + ratios.lengthOfFollowingData) {
                    short fieldType = UtilBinaryDecoding.parseShort(sfData, offset + pos, 1);
                    if (fieldType == 1) {
                        ratios = new SamplingRatios();
                        ratios.decodeAFP(sfData, offset + pos, actualLength - pos, config);
                        continue;
                    }
                    throw new AFPParserException("The image subsampling field type 0x" + Integer.toHexString(fieldType) + " is undefined.");
                }
                return result;
            }

            public short getFieldType() {
                return this.fieldType;
            }

            public void setFieldType(short fieldType) {
                this.fieldType = fieldType;
            }

            public static class SamplingRatios
            extends ImageSubsamplingField {
                short lengthOfFollowingData;
                List<SamplingRatiosRepeatingGroup> samplingRatiosRepeatingGroups;

                @Override
                public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
                    this.fieldType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
                    this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
                    short pos = 0;
                    this.samplingRatiosRepeatingGroups = new ArrayList<SamplingRatiosRepeatingGroup>();
                    while (pos < this.lengthOfFollowingData) {
                        SamplingRatiosRepeatingGroup rg = new SamplingRatiosRepeatingGroup();
                        rg.nrOfHorizontalSamples = sfData[offset + 2 + pos];
                        rg.nrOfVerticalSamples = sfData[offset + 2 + pos + 1];
                        this.samplingRatiosRepeatingGroups.add(rg);
                    }
                }

                @Override
                public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
                    this.lengthOfFollowingData = (short)(this.samplingRatiosRepeatingGroups != null ? this.samplingRatiosRepeatingGroups.size() * 2 : 0);
                    os.write(this.fieldType);
                    os.write(this.lengthOfFollowingData);
                    if (this.samplingRatiosRepeatingGroups != null) {
                        for (SamplingRatiosRepeatingGroup rg : this.samplingRatiosRepeatingGroups) {
                            os.write(rg.nrOfHorizontalSamples);
                            os.write(rg.nrOfVerticalSamples);
                        }
                    }
                }

                public short getLengthOfFollowingData() {
                    this.lengthOfFollowingData = this.samplingRatiosRepeatingGroups == null ? (short)0 : (short)(this.samplingRatiosRepeatingGroups.size() * 2);
                    return this.lengthOfFollowingData;
                }

                public List<SamplingRatiosRepeatingGroup> getSamplingRatiosRepeatingGroups() {
                    return this.samplingRatiosRepeatingGroups;
                }

                public void setSamplingRatiosRepeatingGroups(List<SamplingRatiosRepeatingGroup> samplingRatiosRepeatingGroups) {
                    this.samplingRatiosRepeatingGroups = samplingRatiosRepeatingGroups;
                    if (samplingRatiosRepeatingGroups != null) {
                        this.lengthOfFollowingData = (short)(samplingRatiosRepeatingGroups.size() * 2);
                    }
                }

                public static class SamplingRatiosRepeatingGroup {
                    byte nrOfHorizontalSamples;
                    byte nrOfVerticalSamples;

                    public byte getNrOfHorizontalSamples() {
                        return this.nrOfHorizontalSamples;
                    }

                    public void setNrOfHorizontalSamples(byte nrOfHorizontalSamples) {
                        this.nrOfHorizontalSamples = nrOfHorizontalSamples;
                    }

                    public byte getNrOfVerticalSamples() {
                        return this.nrOfVerticalSamples;
                    }

                    public void setNrOfVerticalSamples(byte nrOfVerticalSamples) {
                        this.nrOfVerticalSamples = nrOfVerticalSamples;
                    }
                }
            }
        }
    }

    public static class UserDefinedCompressionAlgorithmSpecification
    extends AlgorithmSpecificationCompression {
        short lengthOfData;
        long compressionAlgorithmCodePoint;
        byte[] userDefinedSpecification;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.compressionAlgorithmID = AlgorithmSpecificationCompression.CompressionAlgorithmID.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.compressionAlgorithmCodePoint = UtilBinaryDecoding.parseLong(sfData, offset + 1, 4);
            if (this.lengthOfData > 4) {
                this.userDefinedSpecification = new byte[this.lengthOfData - 4];
                System.arraycopy(sfData, offset + 4, this.userDefinedSpecification, 0, this.userDefinedSpecification.length);
            } else {
                this.userDefinedSpecification = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfData = this.userDefinedSpecification == null ? (short)4 : (short)(4 + this.userDefinedSpecification.length);
            os.write(this.compressionAlgorithmID.toByte());
            os.write(this.lengthOfData);
            os.write(UtilBinaryDecoding.longToByteArray(this.compressionAlgorithmCodePoint, 4));
            if (this.userDefinedSpecification != null) {
                os.write(this.userDefinedSpecification);
            }
        }
    }

    public static class JPEGCompressionAlgorithmSpecification
    extends AlgorithmSpecificationCompression {
        short reserved1 = 0;
        short version;
        short reserved3 = 0;
        JPEGCompressionAlgorithmSpecificationMarker marker;
        byte[] reserved5_7 = new byte[]{0, 0, 0};

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.compressionAlgorithmID = AlgorithmSpecificationCompression.CompressionAlgorithmID.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.reserved1 = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.version = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.reserved3 = UtilBinaryDecoding.parseShort(sfData, offset + 3, 1);
            this.marker = JPEGCompressionAlgorithmSpecificationMarker.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 4, 1));
            this.reserved5_7 = new byte[3];
            System.arraycopy(sfData, offset + 5, this.reserved5_7, 0, this.reserved5_7.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.compressionAlgorithmID.toByte());
            os.write(this.reserved1);
            os.write(this.version);
            os.write(this.reserved3);
            os.write(this.marker.toByte());
            os.write(this.reserved5_7);
        }

        public static enum JPEGCompressionAlgorithmSpecificationMarker {
            NonDifferentialHuffman_BaselineDCT(192),
            NonDifferentialHuffman_ExtendedSequentialDCT(193),
            NonDifferentialHuffman_ProgressiveDCT(194),
            NonDifferentialHuffman_LosslessSequential(195),
            DifferentialHuffman_Sequential(197),
            DifferentialHuffman_ProgressiveDCT(198),
            DifferentialHuffman_Lossless(199),
            NonDifferentialArithmethic_ExtendedSequentialDCT(201),
            NonDifferentialArithmethic_ProgressiveDCT(202),
            NonDifferentialArithmethic_LosslessSequential(203),
            DifferentialArithmethic_SequentialDCT(205),
            DifferentialArithmethic_ProgressiveDCT(206),
            DifferentialArithmethic_Lossless(207);

            int code;

            private JPEGCompressionAlgorithmSpecificationMarker(int code) {
                this.code = code;
            }

            public static JPEGCompressionAlgorithmSpecificationMarker valueOf(short codeByte) {
                for (JPEGCompressionAlgorithmSpecificationMarker marker : JPEGCompressionAlgorithmSpecificationMarker.values()) {
                    if (marker.code != codeByte) continue;
                    return marker;
                }
                return null;
            }

            public int toByte() {
                return this.code;
            }
        }
    }

    public static abstract class AlgorithmSpecificationCompression
    extends AlgorithmSpecification {
        CompressionAlgorithmID compressionAlgorithmID;

        public static AlgorithmSpecificationCompression buildCompressionAlgorithmSpecification(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            AlgorithmSpecificationCompression result = null;
            CompressionAlgorithmID caid = CompressionAlgorithmID.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            result = caid == CompressionAlgorithmID.JPEG ? new JPEGCompressionAlgorithmSpecification() : new UserDefinedCompressionAlgorithmSpecification();
            result.decodeAFP(sfData, offset, length, config);
            return result;
        }

        public CompressionAlgorithmID getCompressionAlgorithmID() {
            return this.compressionAlgorithmID;
        }

        public void setCompressionAlgorithmID(CompressionAlgorithmID compressionAlgorithmID) {
            this.compressionAlgorithmID = compressionAlgorithmID;
        }

        public static enum CompressionAlgorithmID {
            JPEG(131),
            Userdefined(254);

            int code;

            private CompressionAlgorithmID(int code) {
                this.code = code;
            }

            public static CompressionAlgorithmID valueOf(short compressionIDByte) {
                if (compressionIDByte == 131) {
                    return JPEG;
                }
                return Userdefined;
            }

            public int toByte() {
                return this.code;
            }
        }
    }

    public static class AlgorithmSpecificationRecording
    extends AlgorithmSpecification {
        short direction;
        short boundaryLengthForPadding;
        short allignmentForPadding;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.direction = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.boundaryLengthForPadding = UtilBinaryDecoding.parseShort(sfData, offset + 1, 2);
            this.allignmentForPadding = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.direction);
            os.write(this.boundaryLengthForPadding);
            os.write(this.allignmentForPadding);
        }
    }

    protected static abstract class AlgorithmSpecification
    implements IAFPDecodeableWriteable {
        protected AlgorithmSpecification() {
        }
    }

    public static class ExternalAlgorithmSpecification
    extends IPD_SegmentLong {
        AlgorithmType algorithmType;
        short reserved3 = 0;
        AlgorithmSpecification algorithmSpecification;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.algorithmType = AlgorithmType.valueOF(sfData[offset + 2]);
            this.reserved3 = UtilBinaryDecoding.parseShort(sfData, offset + 3, 1);
            if (this.lengthOfFollowingData > 3) {
                if (this.algorithmType == AlgorithmType.Recording) {
                    this.algorithmSpecification = new AlgorithmSpecificationRecording();
                    this.algorithmSpecification.decodeAFP(sfData, offset + 4, -1, config);
                } else {
                    this.algorithmSpecification = AlgorithmSpecificationCompression.buildCompressionAlgorithmSpecification(sfData, offset + 4, -1, config);
                }
            } else {
                this.algorithmSpecification = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            byte[] algorithmSpecificationData = null;
            if (this.algorithmSpecification != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.algorithmSpecification.writeAFP(baos, config);
                algorithmSpecificationData = baos.toByteArray();
                this.lengthOfFollowingData = (short)(2 + algorithmSpecificationData.length);
            } else {
                this.lengthOfFollowingData = 2;
            }
            os.write(this.segmentType.toBytes());
            os.write(this.lengthOfFollowingData);
            os.write(this.algorithmType.toByte());
            os.write(this.reserved3);
            os.write(algorithmSpecificationData);
        }

        public static enum AlgorithmType {
            Recording(0),
            Compressing(16);

            int code;

            private AlgorithmType(int code) {
                this.code = code;
            }

            public static AlgorithmType valueOF(byte codeByte) {
                if (codeByte == 0) {
                    return Recording;
                }
                return Compressing;
            }

            public int toByte() {
                return this.code;
            }
        }
    }

    public static class IDEStructure
    extends IPD_SegmentLong {
        EnumSet<IDEStructureFlag> flags;
        AFPColorSpace colorSpace;
        byte[] reserved4_6 = new byte[]{0, 0, 0};
        short nrOfBitsIDEsComponent1;
        Short nrOfBitsIDEsComponent2;
        Short nrOfBitsIDEsComponent3;
        Short nrOfBitsIDEsComponent4;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.flags = IDEStructureFlag.valueOf(sfData[offset + 2]);
            this.colorSpace = AFPColorSpace.valueOf(sfData[offset + 2]);
            this.reserved4_6 = new byte[3];
            System.arraycopy(sfData, offset + 3, this.reserved4_6, 0, this.reserved4_6.length);
            this.nrOfBitsIDEsComponent1 = UtilBinaryDecoding.parseShort(sfData, offset + 6, 1);
            this.nrOfBitsIDEsComponent2 = UtilBinaryDecoding.parseShort(sfData, offset + 7, 1);
            this.nrOfBitsIDEsComponent3 = UtilBinaryDecoding.parseShort(sfData, offset + 8, 1);
            this.nrOfBitsIDEsComponent4 = UtilBinaryDecoding.parseShort(sfData, offset + 9, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            int actualLengthOfData = 6;
            if (this.nrOfBitsIDEsComponent2 != null) {
                actualLengthOfData = 7;
                if (this.nrOfBitsIDEsComponent3 != null) {
                    actualLengthOfData = 8;
                    if (this.nrOfBitsIDEsComponent4 != null) {
                        actualLengthOfData = 9;
                    }
                }
            }
            this.lengthOfFollowingData = actualLengthOfData;
            os.write(this.segmentType.toBytes());
            os.write(this.lengthOfFollowingData);
            os.write(IDEStructureFlag.toByte(this.flags));
            os.write(this.colorSpace.toByte());
            os.write(this.reserved4_6);
            os.write(this.nrOfBitsIDEsComponent1);
            if (this.lengthOfFollowingData >= 7) {
                os.write(this.nrOfBitsIDEsComponent2.shortValue());
            }
            if (this.lengthOfFollowingData >= 8) {
                os.write(this.nrOfBitsIDEsComponent3.shortValue());
            }
            if (this.lengthOfFollowingData >= 9) {
                os.write(this.nrOfBitsIDEsComponent4.shortValue());
            }
        }

        public void setFlag(IDEStructureFlag flag) {
            if (this.flags == null) {
                this.flags = EnumSet.noneOf(IDEStructureFlag.class);
            }
            MutualExclusiveGroupedFlagHandler<IDEStructureFlag> handler = new MutualExclusiveGroupedFlagHandler<IDEStructureFlag>();
            handler.setFlag(this.flags, flag);
        }

        public EnumSet<IDEStructureFlag> getFlags() {
            return this.flags;
        }

        public void setFlags(EnumSet<IDEStructureFlag> flags) {
            this.flags = flags;
        }

        public AFPColorSpace getColorSpace() {
            return this.colorSpace;
        }

        public void setColorSpace(AFPColorSpace colorSpace) {
            this.colorSpace = colorSpace;
        }

        public byte[] getReserved4_6() {
            return this.reserved4_6;
        }

        public void setReserved4_6(byte[] reserved4_6) {
            this.reserved4_6 = reserved4_6;
        }

        public short getNrOfBitsIDEsComponent1() {
            return this.nrOfBitsIDEsComponent1;
        }

        public void setNrOfBitsIDEsComponent1(short nrOfBitsIDEsComponent1) {
            this.nrOfBitsIDEsComponent1 = nrOfBitsIDEsComponent1;
        }

        public Short getNrOfBitsIDEsComponent2() {
            return this.nrOfBitsIDEsComponent2;
        }

        public void setNrOfBitsIDEsComponent2(Short nrOfBitsIDEsComponent2) {
            this.nrOfBitsIDEsComponent2 = nrOfBitsIDEsComponent2;
        }

        public Short getNrOfBitsIDEsComponent3() {
            return this.nrOfBitsIDEsComponent3;
        }

        public void setNrOfBitsIDEsComponent3(Short nrOfBitsIDEsComponent3) {
            this.nrOfBitsIDEsComponent3 = nrOfBitsIDEsComponent3;
        }

        public Short getNrOfBitsIDEsComponent4() {
            return this.nrOfBitsIDEsComponent4;
        }

        public void setNrOfBitsIDEsComponent4(Short nrOfBitsIDEsComponent4) {
            this.nrOfBitsIDEsComponent4 = nrOfBitsIDEsComponent4;
        }

        public static enum IDEStructureFlag implements IMutualExclusiveGroupedFlag
        {
            Additive(0),
            Subtractive(0),
            GrayCodingOff(1),
            GrayCodingOn(1);

            int group;

            private IDEStructureFlag(int group) {
                this.group = group;
            }

            public static EnumSet<IDEStructureFlag> valueOf(byte flagByte) {
                EnumSet<IDEStructureFlag> result = EnumSet.noneOf(IDEStructureFlag.class);
                if ((flagByte & 0x80) == 0) {
                    result.add(Additive);
                } else {
                    result.add(Subtractive);
                }
                if ((flagByte & 0x40) == 0) {
                    result.add(GrayCodingOff);
                } else {
                    result.add(GrayCodingOn);
                }
                return result;
            }

            public static int toByte(EnumSet<IDEStructureFlag> flags) {
                int result = 0;
                if (flags.contains(Subtractive)) {
                    result |= 0x80;
                }
                if (flags.contains(GrayCodingOn)) {
                    result |= 0x40;
                }
                return result;
            }

            @Override
            public int getGroup() {
                return this.group;
            }
        }
    }

    public static class BandImage
    extends IPD_SegmentLong {
        short numberOfBands;
        List<Short> bandSizes;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.numberOfBands = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.bandSizes = new ArrayList<Short>(this.numberOfBands);
            for (int i = 0; i < this.numberOfBands; ++i) {
                this.bandSizes.add(UtilBinaryDecoding.parseShort(sfData, offset + 3 + i, 1));
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.numberOfBands = (short)this.bandSizes.size();
            this.lengthOfFollowingData = (short)(2 + this.bandSizes.size());
            os.write(this.segmentType.toBytes());
            os.write(this.lengthOfFollowingData);
            os.write(this.numberOfBands);
            for (Short s : this.bandSizes) {
                os.write(s.shortValue());
            }
        }
    }

    public static class IDESize
    extends IPD_SegmentLong {
        short numberOfBitsInEachIDE;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.numberOfBitsInEachIDE = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 1));
            os.write(UtilBinaryDecoding.shortToByteArray(this.numberOfBitsInEachIDE, 1));
        }
    }

    public static class ImageEncoding
    extends IPD_SegmentLong {
        IPD_CompressionAlgorithm compressionAlgorithm;
        IPD_RecordingAlgorithm recordingAlgorithm;
        IPD_BitOrder bitOrder;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.compressionAlgorithm = IPD_CompressionAlgorithm.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 2, 1));
            this.recordingAlgorithm = IPD_RecordingAlgorithm.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 3, 1));
            if (this.lengthOfFollowingData > 2) {
                this.bitOrder = IPD_BitOrder.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 4, 1));
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            this.lengthOfFollowingData = this.bitOrder != null ? 3 : 2;
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 1));
            os.write(this.compressionAlgorithm.toByte());
            os.write(this.recordingAlgorithm.toByte());
            if (this.bitOrder != null) {
                os.write(this.bitOrder.toByte());
            }
        }
    }

    public static class ImageSize
    extends IPD_SegmentLong {
        AFPUnitBase unitBase;
        short xUnitsPerUnitBase;
        short yUnitsPerUnitBase;
        short xImageSize;
        short yImageSize;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.unitBase = AFPUnitBase.valueOf(sfData[offset + 2]);
            this.xUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 3, 2);
            this.yUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 5, 2);
            this.xImageSize = UtilBinaryDecoding.parseShort(sfData, offset + 7, 2);
            this.yImageSize = UtilBinaryDecoding.parseShort(sfData, offset + 9, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 1));
            os.write(this.unitBase.toByte());
            os.write(UtilBinaryDecoding.shortToByteArray(this.xUnitsPerUnitBase, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.yUnitsPerUnitBase, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.xImageSize, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.yImageSize, 2));
        }
    }

    public static class EndImageContent
    extends IPD_SegmentLong {
        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 1));
        }
    }

    public static class BeginImageContent
    extends IPD_SegmentLong {
        short objectType;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.objectType = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 1));
            os.write(this.objectType);
        }
    }

    public static class EndSegment
    extends IPD_SegmentLong {
        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 1));
        }
    }

    public static class BeginSegment
    extends IPD_SegmentLong {
        byte[] name;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            if (this.lengthOfFollowingData > 0) {
                this.name = new byte[this.lengthOfFollowingData];
                System.arraycopy(sfData, offset + 2, this.name, 0, this.name.length);
            } else {
                this.name = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            this.lengthOfFollowingData = this.name != null ? this.name.length : 0;
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 1));
            if (this.name != null) {
                os.write(this.name);
            }
        }

        public byte[] getName() {
            return this.name;
        }

        public void setName(byte[] name) {
            this.name = name;
        }
    }

    public static class UnknownSegmentExtended
    extends IPD_SegmentExtended {
        byte[] data;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 2));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            if (this.lengthOfFollowingData > 0) {
                this.data = new byte[this.lengthOfFollowingData];
                System.arraycopy(sfData, offset + 2, this.data, 0, this.data.length);
            } else {
                this.data = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            this.lengthOfFollowingData = this.data != null ? this.data.length : 0;
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 2));
            if (this.data != null) {
                os.write(this.data);
            }
        }
    }

    public static class UnknownSegmentLong
    extends IPD_SegmentLong {
        byte[] data;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.segmentType = IPD_SegmentType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            if (this.lengthOfFollowingData > 0) {
                this.data = new byte[this.lengthOfFollowingData];
                System.arraycopy(sfData, offset + 2, this.data, 0, this.data.length);
            } else {
                this.data = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.segmentType.toBytes());
            this.lengthOfFollowingData = this.data != null ? (int)((short)this.data.length) : 0;
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfFollowingData, 1));
            if (this.data != null) {
                os.write(this.data);
            }
        }
    }

    protected static abstract class IPD_SegmentExtended
    extends IPD_Segment {
        protected IPD_SegmentExtended() {
        }
    }

    protected static abstract class IPD_SegmentLong
    extends IPD_Segment {
        protected IPD_SegmentLong() {
        }
    }

    public static enum IPD_BitOrder {
        LeftToRight(0),
        RightToLeft(1);

        int type;

        private IPD_BitOrder(int codeByte) {
            this.type = codeByte;
        }

        public static IPD_BitOrder valueOf(short segmentTypeByte) {
            for (IPD_BitOrder t : IPD_BitOrder.values()) {
                if (t.type != segmentTypeByte) continue;
                return t;
            }
            return null;
        }

        public int toByte() {
            return this.type;
        }
    }

    public static enum IPD_RecordingAlgorithm {
        Retired(0),
        RIDIC_RecordingImageDataInlineCoding(1),
        BottomToTop(3),
        UnpaddedRIDIC(4),
        ExternalAlgorithm(254);

        int type;

        private IPD_RecordingAlgorithm(int codeByte) {
            this.type = codeByte;
        }

        public static IPD_RecordingAlgorithm valueOf(short segmentTypeByte) {
            for (IPD_RecordingAlgorithm t : IPD_RecordingAlgorithm.values()) {
                if (t.type != segmentTypeByte) continue;
                return t;
            }
            return null;
        }

        public int toByte() {
            return this.type;
        }
    }

    public static enum IPD_CompressionAlgorithm {
        IBM_MMR_ModfiedModifiedRead(1),
        NoCompression(3),
        RL4_RunLength4(6),
        ABIC_BilevelQCoder(8),
        TIFF_Algorithm2(9),
        ConcatenatedABIC(10),
        ColorCompressionUsedByOS2(11),
        TIFF_PackBits(12),
        TIFF_LZW(13),
        SolidFillRectangle(32),
        G3_ModifiedHuffman(128),
        G3_ModifiedREAD(129),
        G4_ModifiedModifiedREAD(130),
        JPEG(131),
        JBIG2(132),
        UserDefinedAlgorithm(133);

        int type;

        private IPD_CompressionAlgorithm(int type) {
            this.type = type;
        }

        public static IPD_CompressionAlgorithm valueOf(short segmentTypeByte) {
            for (IPD_CompressionAlgorithm t : IPD_CompressionAlgorithm.values()) {
                if (t.type != segmentTypeByte) continue;
                return t;
            }
            return null;
        }

        public int toByte() {
            return this.type;
        }
    }

    public static enum IPD_SegmentType {
        BeginSegment(112),
        EndSegment(113),
        BeginImageContent(145),
        EndImageContent(147),
        ImageSize(148),
        ImageEncoding(149),
        IDESize(150),
        BandImage(152),
        IDEStructure(155),
        ExternalAlgorithmSpecification(159),
        ImageSubsampling(65230),
        BeginTile(140),
        EndTile(141),
        TilePosition(181),
        TileSize(182),
        TileSetColor(183),
        IncludeTile(65208),
        TileTOC(65211),
        BeginTransparencyMask(142),
        EndTransparencyMask(143),
        ImageData(65170),
        BandImageData(65180),
        UnknownIPDSegmentLong(-1),
        UnknownIPDSegmentExtended(-2);

        int type;

        private IPD_SegmentType(int type) {
            this.type = type;
        }

        public static IPD_SegmentType valueOf(int segmentTypeCode) {
            for (IPD_SegmentType t : IPD_SegmentType.values()) {
                if (t.type != segmentTypeCode) continue;
                return t;
            }
            return segmentTypeCode > 255 ? UnknownIPDSegmentExtended : UnknownIPDSegmentLong;
        }

        public byte[] toBytes() {
            if (this.type >= 65024) {
                return UtilBinaryDecoding.intToByteArray(this.type, 2);
            }
            return UtilBinaryDecoding.shortToByteArray((short)this.type, 1);
        }
    }
}

