/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.lineData;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CCP_ConditionalProcessingControl
extends StructuredField {
    int ccpIdentifier;
    int nextCcpIdentifier;
    CCP_Flag flag;
    byte reserved5 = 0;
    int numberOfRepeatingGroups;
    int lengthOfRepeatingGroup;
    int lengthOfComparisonString;
    List<CCP_RepeatingGroup> repeatingGroups;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.ccpIdentifier = UtilBinaryDecoding.parseInt(sfData, offset, 2);
        this.nextCcpIdentifier = UtilBinaryDecoding.parseInt(sfData, offset + 2, 2);
        this.flag = CCP_Flag.valueOf(sfData[offset + 4]);
        this.reserved5 = sfData[offset + 5];
        this.numberOfRepeatingGroups = UtilBinaryDecoding.parseInt(sfData, offset + 6, 2);
        this.lengthOfRepeatingGroup = UtilBinaryDecoding.parseInt(sfData, offset + 8, 2);
        this.lengthOfComparisonString = UtilBinaryDecoding.parseInt(sfData, offset + 10, 2);
        this.repeatingGroups = new ArrayList<CCP_RepeatingGroup>();
        int actualLength = CCP_ConditionalProcessingControl.getActualLength(sfData, offset, length);
        for (int pos = 12; pos < actualLength; pos += this.lengthOfRepeatingGroup) {
            CCP_RepeatingGroup rg = new CCP_RepeatingGroup();
            rg.decodeAFP(sfData, offset + pos, this.lengthOfRepeatingGroup, config);
            this.repeatingGroups.add(rg);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(UtilBinaryDecoding.intToByteArray(this.ccpIdentifier, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.nextCcpIdentifier, 2));
        baos.write(this.flag.toByte());
        baos.write(this.reserved5);
        baos.write(UtilBinaryDecoding.intToByteArray(this.numberOfRepeatingGroups, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.lengthOfRepeatingGroup, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.lengthOfComparisonString, 2));
        for (CCP_RepeatingGroup rg : this.repeatingGroups) {
            rg.writeAFP(baos, config);
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public int getCcpIdentifier() {
        return this.ccpIdentifier;
    }

    public void setCcpIdentifier(int ccpIdentifier) {
        this.ccpIdentifier = ccpIdentifier;
    }

    public int getNextCcpIdentifier() {
        return this.nextCcpIdentifier;
    }

    public void setNextCcpIdentifier(int nextCcpIdentifier) {
        this.nextCcpIdentifier = nextCcpIdentifier;
    }

    public CCP_Flag getFlag() {
        return this.flag;
    }

    public void setFlag(CCP_Flag flag) {
        this.flag = flag;
    }

    public byte getReserved5() {
        return this.reserved5;
    }

    public void setReserved5(byte reserved5) {
        this.reserved5 = reserved5;
    }

    public int getNumberOfRepeatingGroups() {
        return this.numberOfRepeatingGroups;
    }

    public void setNumberOfRepeatingGroups(int numberOfRepeatingGroups) {
        this.numberOfRepeatingGroups = numberOfRepeatingGroups;
    }

    public int getLengthOfRepeatingGroup() {
        return this.lengthOfRepeatingGroup;
    }

    public void setLengthOfRepeatingGroup(int lengthOfRepeatingGroup) {
        this.lengthOfRepeatingGroup = lengthOfRepeatingGroup;
    }

    public int getLengthOfComparisonString() {
        return this.lengthOfComparisonString;
    }

    public void setLengthOfComparisonString(int lengthOfComparisonString) {
        this.lengthOfComparisonString = lengthOfComparisonString;
    }

    public List<CCP_RepeatingGroup> getRepeatingGroups() {
        return this.repeatingGroups;
    }

    public void setRepeatingGroups(List<CCP_RepeatingGroup> repeatingGroups) {
        this.repeatingGroups = repeatingGroups;
    }

    public static class CCP_RepeatingGroup
    implements IAFPDecodeableWriteable {
        CCP_TimingOfAction timingOfAction;
        CCP_MediumMapAction mediumMapAction;
        String mediumMapName;
        CCP_DataMapAction dataMapAction;
        String dataMapName;
        CCP_Comparison comparison;
        String comparisonString;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            this.timingOfAction = actualLength >= 1 ? CCP_TimingOfAction.valueOf(UtilBinaryDecoding.parseInt(sfData, offset, 1)) : null;
            this.mediumMapAction = actualLength >= 2 ? CCP_MediumMapAction.valueOf(sfData[offset + 1]) : null;
            this.mediumMapName = actualLength >= 10 ? new String(sfData, offset + 2, 8, config.getAfpCharSet()) : null;
            this.dataMapAction = actualLength >= 11 ? CCP_DataMapAction.valueOf(sfData[offset + 10]) : null;
            this.dataMapName = actualLength >= 19 ? new String(sfData, offset + 11, 8, config.getAfpCharSet()) : null;
            this.comparison = actualLength >= 20 ? CCP_Comparison.valueOf(sfData[offset + 19]) : null;
            this.comparisonString = actualLength >= 21 ? new String(sfData, offset + 20, actualLength - 20, config.getAfpCharSet()) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            if (this.timingOfAction != null) {
                os.write(this.timingOfAction.toByte());
                if (this.mediumMapAction != null) {
                    os.write(this.mediumMapAction.toByte());
                    if (this.mediumMapName != null) {
                        os.write(this.mediumMapName.getBytes(config.getAfpCharSet()));
                        if (this.dataMapAction != null) {
                            os.write(this.dataMapAction.toByte());
                            if (this.dataMapName != null) {
                                os.write(this.dataMapName.getBytes(config.getAfpCharSet()));
                                if (this.comparison != null) {
                                    os.write(this.comparison.toByte());
                                    if (this.comparisonString != null) {
                                        os.write(this.comparisonString.getBytes(config.getAfpCharSet()));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        public CCP_TimingOfAction getTimingOfAction() {
            return this.timingOfAction;
        }

        public void setTimingOfAction(CCP_TimingOfAction timingOfAction) {
            this.timingOfAction = timingOfAction;
        }

        public CCP_MediumMapAction getMediumMapAction() {
            return this.mediumMapAction;
        }

        public void setMediumMapAction(CCP_MediumMapAction mediumMapAction) {
            this.mediumMapAction = mediumMapAction;
        }

        public String getMediumMapName() {
            return this.mediumMapName;
        }

        public void setMediumMapName(String mediumMapName) {
            this.mediumMapName = mediumMapName;
        }

        public CCP_DataMapAction getDataMapAction() {
            return this.dataMapAction;
        }

        public void setDataMapAction(CCP_DataMapAction dataMapAction) {
            this.dataMapAction = dataMapAction;
        }

        public String getDataMapName() {
            return this.dataMapName;
        }

        public void setDataMapName(String dataMapName) {
            this.dataMapName = dataMapName;
        }

        public CCP_Comparison getComparison() {
            return this.comparison;
        }

        public void setComparison(CCP_Comparison comparison) {
            this.comparison = comparison;
        }

        public String getComparisonString() {
            return this.comparisonString;
        }

        public void setComparisonString(String comparisonString) {
            this.comparisonString = comparisonString;
        }

        public static enum CCP_Comparison {
            AnyChange,
            EqualTo,
            LessThan,
            EqualToOrLessThan,
            GreaterThan,
            EqualToOrGreaterThan,
            NotEqual,
            TakeTheActionWithoutComparison;


            public static CCP_Comparison valueOf(byte codeByte) {
                for (CCP_Comparison comp : CCP_Comparison.values()) {
                    if (comp.ordinal() != codeByte) continue;
                    return comp;
                }
                return null;
            }

            public int toByte() {
                return this.ordinal();
            }
        }

        public static enum CCP_DataMapAction {
            Ignore,
            CurrentDataMap_PageEject,
            InvokeNamedDataMap,
            InvokeFirstDataMap,
            InvokeNextDataMap;


            public static CCP_DataMapAction valueOf(byte codeByte) {
                for (CCP_DataMapAction dma : CCP_DataMapAction.values()) {
                    if (dma.ordinal() != codeByte) continue;
                    return dma;
                }
                return null;
            }

            public int toByte() {
                return this.ordinal();
            }
        }

        public static enum CCP_MediumMapAction {
            Ignore,
            CurrentMediumMap_PageEject,
            InvokeNamedMediumMap,
            InvokeFirstMediumMap,
            InvokeNextMediumMap;


            public static CCP_MediumMapAction valueOf(byte codeByte) {
                for (CCP_MediumMapAction mma : CCP_MediumMapAction.values()) {
                    if (mma.ordinal() != codeByte) continue;
                    return mma;
                }
                return null;
            }

            public int toByte() {
                return this.ordinal();
            }
        }

        public static enum CCP_TimingOfAction {
            Default_Immediately(0),
            Immediately(1),
            BeforeCurrentSubPage(2),
            AfterCurrentLine(129),
            AfterCurrentSubPage(130);

            int code;

            private CCP_TimingOfAction(int code) {
                this.code = code;
            }

            public static CCP_TimingOfAction valueOf(int codeByte) {
                for (CCP_TimingOfAction toa : CCP_TimingOfAction.values()) {
                    if (toa.code != codeByte) continue;
                    return toa;
                }
                return null;
            }

            public int toByte() {
                return this.code;
            }
        }
    }

    public static enum CCP_Flag {
        BeforeSubpageActions(128),
        AfterSubpageActions(64),
        SpacingActions(32);

        int code;

        private CCP_Flag(int code) {
            this.code = code;
        }

        public static CCP_Flag valueOf(byte flagByte) {
            for (CCP_Flag flag : CCP_Flag.values()) {
                if (flag.code != flagByte) continue;
                return flag;
            }
            return null;
        }

        public int toByte() {
            return this.code;
        }
    }
}

