/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.lineData;

import com.mgz.afp.base.StructuredFieldBaseTriplets;
import com.mgz.afp.enums.AFPOrientation;
import com.mgz.afp.enums.MutualExclusiveGroupedFlagHandler;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.lineData.RCD_XMD_RecordTypeElementType;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;

public class RCD_RecordDescriptor
extends StructuredFieldBaseTriplets {
    String recordDescriptorID;
    RCD_XMD_RecordTypeElementType recordType;
    EnumSet<RCD_Flag> flags;
    byte reserved14 = 0;
    int inlinePosition;
    int baselinePosition;
    AFPOrientation inlineOrientation;
    AFPOrientation baselineOrientation;
    short primaryFontLocalId;
    int fieldRCDPointer;
    String suppressionTokenName;
    short shiftOutFontLocalID;
    int dataStartPosition;
    int dataLength;
    int conditionalProcessingRCDPointer;
    byte subpageID;
    int ccpIdentifier;
    int startingPageNumber;
    int endSpace;
    byte fieldAllignment;
    int fieldDelimiter;
    int fieldNumber;
    int additionalBaselineIncrement;
    byte[] reserved57_69 = new byte[13];

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.recordDescriptorID = new String(sfData, offset, 10, config.getAfpCharSet());
        this.recordType = RCD_XMD_RecordTypeElementType.valuesOf(sfData[offset + 10]);
        this.flags = RCD_Flag.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 11, 3));
        this.reserved14 = sfData[offset + 14];
        this.inlinePosition = UtilBinaryDecoding.parseInt(sfData, offset + 15, 2);
        this.baselinePosition = this.flags.contains((Object)RCD_Flag.RelativeBaselinePosition_AbsolutePosition) ? UtilBinaryDecoding.parseInt(sfData, offset + 17, 2) : (int)UtilBinaryDecoding.parseShort(sfData, offset + 17, 2);
        this.inlineOrientation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 19, 2));
        this.baselineOrientation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 21, 2));
        this.primaryFontLocalId = UtilBinaryDecoding.parseShort(sfData, offset + 23, 1);
        this.fieldRCDPointer = UtilBinaryDecoding.parseInt(sfData, offset + 24, 2);
        this.suppressionTokenName = new String(sfData, offset + 26, 8, config.getAfpCharSet());
        this.shiftOutFontLocalID = UtilBinaryDecoding.parseShort(sfData, offset + 34, 1);
        this.dataStartPosition = UtilBinaryDecoding.parseInt(sfData, offset + 35, 4);
        this.dataLength = UtilBinaryDecoding.parseInt(sfData, offset + 39, 2);
        this.conditionalProcessingRCDPointer = UtilBinaryDecoding.parseInt(sfData, offset + 41, 2);
        this.subpageID = sfData[offset + 43];
        this.ccpIdentifier = UtilBinaryDecoding.parseInt(sfData, offset + 44, 2);
        this.startingPageNumber = UtilBinaryDecoding.parseInt(sfData, offset + 46, 2);
        this.endSpace = UtilBinaryDecoding.parseInt(sfData, offset + 48, 2);
        this.fieldAllignment = sfData[offset + 50];
        this.fieldDelimiter = UtilBinaryDecoding.parseInt(sfData, offset + 51, 2);
        this.fieldNumber = UtilBinaryDecoding.parseInt(sfData, offset + 53, 2);
        this.additionalBaselineIncrement = UtilBinaryDecoding.parseInt(sfData, offset + 55, 2);
        this.reserved57_69 = new byte[13];
        System.arraycopy(sfData, offset + 48, this.reserved57_69, 0, this.reserved57_69.length);
        int actualLength = RCD_RecordDescriptor.getActualLength(sfData, offset, length);
        if (actualLength > 71) {
            super.decodeAFP(sfData, offset + 70, actualLength - 70, config);
        } else {
            this.triplets = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(UtilCharacterEncoding.stringToByteArray(this.recordDescriptorID, config.getAfpCharSet(), 10, (byte)64));
        baos.write(this.recordType.toByte());
        baos.write(RCD_Flag.toBytes(this.flags));
        baos.write(this.reserved14);
        baos.write(UtilBinaryDecoding.intToByteArray(this.inlinePosition, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.baselinePosition, 2));
        baos.write(this.inlineOrientation.toBytes());
        baos.write(this.baselineOrientation.toBytes());
        baos.write(this.primaryFontLocalId);
        baos.write(UtilBinaryDecoding.intToByteArray(this.fieldRCDPointer, 2));
        baos.write(UtilCharacterEncoding.stringToByteArray(this.suppressionTokenName, config.getAfpCharSet(), 8, (byte)64));
        baos.write(this.shiftOutFontLocalID);
        baos.write(UtilBinaryDecoding.intToByteArray(this.dataStartPosition, 4));
        baos.write(UtilBinaryDecoding.intToByteArray(this.dataLength, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.conditionalProcessingRCDPointer, 2));
        baos.write(this.subpageID);
        baos.write(UtilBinaryDecoding.intToByteArray(this.ccpIdentifier, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.startingPageNumber, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.endSpace, 2));
        baos.write(this.fieldAllignment);
        baos.write(UtilBinaryDecoding.intToByteArray(this.fieldDelimiter, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.fieldNumber, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.additionalBaselineIncrement, 2));
        baos.write(this.reserved57_69);
        if (this.triplets != null) {
            for (Triplet t : this.triplets) {
                t.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public String getRecordDescriptorID() {
        return this.recordDescriptorID;
    }

    public void setRecordDescriptorID(String recordDescriptorID) {
        this.recordDescriptorID = recordDescriptorID;
    }

    public RCD_XMD_RecordTypeElementType getRecordType() {
        return this.recordType;
    }

    public void setRecordType(RCD_XMD_RecordTypeElementType recordType) {
        this.recordType = recordType;
    }

    public EnumSet<RCD_Flag> getFlags() {
        return this.flags;
    }

    public void setFlags(EnumSet<RCD_Flag> flags) {
        this.flags = flags;
    }

    public byte getReserved14() {
        return this.reserved14;
    }

    public void setReserved14(byte reserved14) {
        this.reserved14 = reserved14;
    }

    public int getInlinePosition() {
        return this.inlinePosition;
    }

    public void setInlinePosition(int inlinePosition) {
        this.inlinePosition = inlinePosition;
    }

    public int getBaselinePosition() {
        return this.baselinePosition;
    }

    public void setBaselinePosition(int baselinePosition) {
        this.baselinePosition = baselinePosition;
    }

    public AFPOrientation getInlineOrientation() {
        return this.inlineOrientation;
    }

    public void setInlineOrientation(AFPOrientation inlineOrientation) {
        this.inlineOrientation = inlineOrientation;
    }

    public AFPOrientation getBaselineOrientation() {
        return this.baselineOrientation;
    }

    public void setBaselineOrientation(AFPOrientation baselineOrientation) {
        this.baselineOrientation = baselineOrientation;
    }

    public short getPrimaryFontLocalId() {
        return this.primaryFontLocalId;
    }

    public void setPrimaryFontLocalId(short primaryFontLocalId) {
        this.primaryFontLocalId = primaryFontLocalId;
    }

    public int getFieldRCDPointer() {
        return this.fieldRCDPointer;
    }

    public void setFieldRCDPointer(int fieldRCDPointer) {
        this.fieldRCDPointer = fieldRCDPointer;
    }

    public String getSuppressionTokenName() {
        return this.suppressionTokenName;
    }

    public void setSuppressionTokenName(String suppressionTokenName) {
        this.suppressionTokenName = suppressionTokenName;
    }

    public short getShiftOutFontLocalID() {
        return this.shiftOutFontLocalID;
    }

    public void setShiftOutFontLocalID(short shiftOutFontLocalID) {
        this.shiftOutFontLocalID = shiftOutFontLocalID;
    }

    public int getDataStartPosition() {
        return this.dataStartPosition;
    }

    public void setDataStartPosition(int dataStartPosition) {
        this.dataStartPosition = dataStartPosition;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public int getConditionalProcessingRCDPointer() {
        return this.conditionalProcessingRCDPointer;
    }

    public void setConditionalProcessingRCDPointer(int conditionalProcessingRCDPointer) {
        this.conditionalProcessingRCDPointer = conditionalProcessingRCDPointer;
    }

    public byte getSubpageID() {
        return this.subpageID;
    }

    public void setSubpageID(byte subpageID) {
        this.subpageID = subpageID;
    }

    public int getCcpIdentifier() {
        return this.ccpIdentifier;
    }

    public void setCcpIdentifier(int ccpIdentifier) {
        this.ccpIdentifier = ccpIdentifier;
    }

    public int getStartingPageNumber() {
        return this.startingPageNumber;
    }

    public void setStartingPageNumber(int startingPageNumber) {
        this.startingPageNumber = startingPageNumber;
    }

    public int getEndSpace() {
        return this.endSpace;
    }

    public void setEndSpace(int endSpace) {
        this.endSpace = endSpace;
    }

    public byte getFieldAllignment() {
        return this.fieldAllignment;
    }

    public void setFieldAllignment(byte fieldAllignment) {
        this.fieldAllignment = fieldAllignment;
    }

    public int getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(int fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public int getFieldNumber() {
        return this.fieldNumber;
    }

    public void setFieldNumber(int fieldNumber) {
        this.fieldNumber = fieldNumber;
    }

    public int getAdditionalBaselineIncrement() {
        return this.additionalBaselineIncrement;
    }

    public void setAdditionalBaselineIncrement(int additionalBaselineIncrement) {
        this.additionalBaselineIncrement = additionalBaselineIncrement;
    }

    public byte[] getReserved57_69() {
        return this.reserved57_69;
    }

    public void setReserved57_69(byte[] reserved57_69) {
        this.reserved57_69 = reserved57_69;
    }

    public static enum RCD_Flag {
        GenerateInlinePosition_CurrentPosition(2),
        GenerateInlinePosition_NewPosition(2),
        GenerateBaselinePosition_CurrentPosition(3),
        GenerateBaselinePosition_NewPosition(3),
        GenerateFontChange_TRC_MRC_Default(4),
        GenerateFontChange_AsSpecified(4),
        GenerateSuppression_TextIsNotSuppressible(5),
        GenerateSuppression_TextIsSuppressible(5),
        FieldRCD_RecordRCD(6),
        FieldRCD_FieldRCD(6),
        UseFixedData_DoNotPresent(7),
        UseFixedData_DoPresent(7),
        ConditionalProcessing_DoNotPerformCP(11),
        ConditionalProcessing_DoPerformCP(11),
        RelativeBaselinePosition_AbsolutePosition(13),
        RelativeBaselinePosition_RelativePosition(13),
        NewPage_NoEffect(16),
        NewPage_LogicalPageEject(16),
        PrintPageNumber_NoEffect(17),
        PrintPageNumber_PrintPageNumber(17),
        ResetPageNumber_NoEffect(18),
        ResetPageNumber_ResetPageNumberToSpecifiedValue(18),
        GroupIndicator_InputDataIsNotPartOfAGroup(19),
        GroupIndicator_SaveGroupHeader(19),
        FieldDelimeterSize_1Byte(20),
        FieldDelimeterSize_2Bytes(20),
        UseRecordID_DoNotSelectRecordID(21),
        UseRecordID_SelectRecordID(21);

        private static MutualExclusiveGroupedFlagHandler<RCD_Flag> handler;
        int group;

        private RCD_Flag(int group) {
            this.group = group;
        }

        public static EnumSet<RCD_Flag> valueOf(int flagBytes) {
            EnumSet<RCD_Flag> result = EnumSet.noneOf(RCD_Flag.class);
            if ((flagBytes & 0x200000) != 0) {
                result.add(GenerateInlinePosition_NewPosition);
            } else {
                result.add(GenerateInlinePosition_CurrentPosition);
            }
            if ((flagBytes & 0x100000) != 0) {
                result.add(GenerateBaselinePosition_NewPosition);
            } else {
                result.add(GenerateBaselinePosition_CurrentPosition);
            }
            if ((flagBytes & 0x80000) != 0) {
                result.add(GenerateFontChange_AsSpecified);
            } else {
                result.add(GenerateFontChange_TRC_MRC_Default);
            }
            if ((flagBytes & 0x40000) != 0) {
                result.add(GenerateSuppression_TextIsSuppressible);
            } else {
                result.add(GenerateSuppression_TextIsNotSuppressible);
            }
            if ((flagBytes & 0x20000) != 0) {
                result.add(FieldRCD_FieldRCD);
            } else {
                result.add(FieldRCD_RecordRCD);
            }
            if ((flagBytes & 0x10000) != 0) {
                result.add(UseFixedData_DoPresent);
            } else {
                result.add(UseFixedData_DoNotPresent);
            }
            if ((flagBytes & 0x1000) != 0) {
                result.add(ConditionalProcessing_DoPerformCP);
            } else {
                result.add(ConditionalProcessing_DoNotPerformCP);
            }
            if ((flagBytes & 0x400) != 0) {
                result.add(RelativeBaselinePosition_RelativePosition);
            } else {
                result.add(RelativeBaselinePosition_AbsolutePosition);
            }
            if ((flagBytes & 0x80) != 0) {
                result.add(NewPage_LogicalPageEject);
            } else {
                result.add(NewPage_NoEffect);
            }
            if ((flagBytes & 0x40) != 0) {
                result.add(PrintPageNumber_PrintPageNumber);
            } else {
                result.add(PrintPageNumber_NoEffect);
            }
            if ((flagBytes & 0x20) != 0) {
                result.add(ResetPageNumber_ResetPageNumberToSpecifiedValue);
            } else {
                result.add(ResetPageNumber_NoEffect);
            }
            if ((flagBytes & 0x10) != 0) {
                result.add(GroupIndicator_SaveGroupHeader);
            } else {
                result.add(GroupIndicator_InputDataIsNotPartOfAGroup);
            }
            if ((flagBytes & 8) != 0) {
                result.add(FieldDelimeterSize_2Bytes);
            } else {
                result.add(FieldDelimeterSize_1Byte);
            }
            if ((flagBytes & 4) != 0) {
                result.add(UseRecordID_SelectRecordID);
            } else {
                result.add(UseRecordID_DoNotSelectRecordID);
            }
            return result;
        }

        public static byte[] toBytes(EnumSet<RCD_Flag> flags) {
            int result = 0;
            if (flags.contains((Object)GenerateInlinePosition_NewPosition)) {
                result |= 0x200000;
            }
            if (flags.contains((Object)GenerateBaselinePosition_NewPosition)) {
                result |= 0x100000;
            }
            if (flags.contains((Object)GenerateFontChange_AsSpecified)) {
                result |= 0x80000;
            }
            if (flags.contains((Object)GenerateSuppression_TextIsSuppressible)) {
                result |= 0x40000;
            }
            if (flags.contains((Object)FieldRCD_FieldRCD)) {
                result |= 0x20000;
            }
            if (flags.contains((Object)UseFixedData_DoPresent)) {
                result |= 0x10000;
            }
            if (flags.contains((Object)ConditionalProcessing_DoPerformCP)) {
                result |= 0x1000;
            }
            if (flags.contains((Object)RelativeBaselinePosition_RelativePosition)) {
                result |= 0x400;
            }
            if (flags.contains((Object)NewPage_LogicalPageEject)) {
                result |= 0x80;
            }
            if (flags.contains((Object)PrintPageNumber_PrintPageNumber)) {
                result |= 0x40;
            }
            if (flags.contains((Object)ResetPageNumber_ResetPageNumberToSpecifiedValue)) {
                result |= 0x20;
            }
            if (flags.contains((Object)GroupIndicator_SaveGroupHeader)) {
                result |= 0x10;
            }
            if (flags.contains((Object)FieldDelimeterSize_2Bytes)) {
                result |= 8;
            }
            if (flags.contains((Object)UseRecordID_SelectRecordID)) {
                result |= 4;
            }
            return UtilBinaryDecoding.intToByteArray(result, 3);
        }

        public static void setFlag(EnumSet<RCD_Flag> flags, RCD_Flag flag) {
            handler.setFlag(flags, flag);
        }

        static {
            handler = new MutualExclusiveGroupedFlagHandler();
        }
    }
}

