/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.lineData;

import com.mgz.afp.base.StructuredFieldBaseTriplets;
import com.mgz.afp.enums.AFPOrientation;
import com.mgz.afp.enums.MutualExclusiveGroupedFlagHandler;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.lineData.RCD_XMD_RecordTypeElementType;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;

public class XMD_XMLDescriptor
extends StructuredFieldBaseTriplets {
    RCD_XMD_RecordTypeElementType elementType;
    EnumSet<XMD_Flag> flags;
    byte reserved4 = 0;
    int inlinePosition;
    int baselinePosition;
    AFPOrientation inlineOrientation;
    AFPOrientation baselineOrientation;
    short primaryFontLocalId;
    int fieldXMDPointer;
    byte[] reserved16_17 = new byte[2];
    String suppressionTokenName;
    byte reserved26 = 0;
    int dataStartPosition;
    int dataLength;
    int conditionalProcessingRCDPointer;
    byte subpageID;
    int ccpIdentifier;
    int startingPageNumber;
    int endSpace;
    byte fieldAllignment;
    int fieldDelimiter;
    int fieldNumber;
    int additionalBaselineIncrement;
    byte[] reserved49_61 = new byte[13];

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.elementType = RCD_XMD_RecordTypeElementType.valuesOf(sfData[offset]);
        this.flags = XMD_Flag.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 1, 3));
        this.reserved4 = sfData[offset + 4];
        this.inlinePosition = UtilBinaryDecoding.parseInt(sfData, offset + 5, 2);
        this.baselinePosition = UtilBinaryDecoding.parseInt(sfData, offset + 7, 2);
        this.inlineOrientation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 9, 2));
        this.baselineOrientation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 11, 2));
        this.primaryFontLocalId = UtilBinaryDecoding.parseShort(sfData, offset + 13, 1);
        this.fieldXMDPointer = UtilBinaryDecoding.parseInt(sfData, offset + 14, 2);
        this.reserved16_17 = new byte[2];
        System.arraycopy(sfData, offset + 16, this.reserved16_17, 0, this.reserved16_17.length);
        this.suppressionTokenName = new String(sfData, offset + 18, 8, config.getAfpCharSet());
        this.reserved26 = sfData[offset + 26];
        this.dataStartPosition = UtilBinaryDecoding.parseInt(sfData, offset + 27, 3);
        this.dataLength = UtilBinaryDecoding.parseInt(sfData, offset + 31, 2);
        this.conditionalProcessingRCDPointer = UtilBinaryDecoding.parseInt(sfData, offset + 33, 2);
        this.subpageID = sfData[offset + 35];
        this.ccpIdentifier = UtilBinaryDecoding.parseInt(sfData, offset + 36, 2);
        this.startingPageNumber = UtilBinaryDecoding.parseInt(sfData, offset + 38, 2);
        this.endSpace = UtilBinaryDecoding.parseInt(sfData, offset + 40, 2);
        this.fieldAllignment = sfData[offset + 42];
        this.fieldDelimiter = UtilBinaryDecoding.parseInt(sfData, offset + 43, 2);
        this.fieldNumber = UtilBinaryDecoding.parseInt(sfData, offset + 45, 2);
        this.additionalBaselineIncrement = UtilBinaryDecoding.parseInt(sfData, offset + 47, 2);
        this.reserved49_61 = new byte[13];
        System.arraycopy(sfData, offset + 49, this.reserved49_61, 0, this.reserved49_61.length);
        int actualLength = XMD_XMLDescriptor.getActualLength(sfData, offset, length);
        if (actualLength > 63) {
            super.decodeAFP(sfData, offset, actualLength, config);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.elementType.toByte());
        baos.write(XMD_Flag.toBytes(this.flags));
        baos.write(this.reserved4);
        baos.write(UtilBinaryDecoding.intToByteArray(this.inlinePosition, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.baselinePosition, 2));
        baos.write(this.inlineOrientation.toBytes());
        baos.write(this.baselineOrientation.toBytes());
        baos.write(UtilBinaryDecoding.shortToByteArray(this.primaryFontLocalId, 1));
        baos.write(UtilBinaryDecoding.intToByteArray(this.fieldXMDPointer, 2));
        baos.write(this.reserved16_17);
        baos.write(UtilCharacterEncoding.stringToByteArray(this.suppressionTokenName, config.getAfpCharSet(), 8, (byte)64));
        baos.write(this.reserved26);
        baos.write(UtilBinaryDecoding.intToByteArray(this.dataStartPosition, 3));
        baos.write(UtilBinaryDecoding.intToByteArray(this.dataLength, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.conditionalProcessingRCDPointer, 2));
        baos.write(this.subpageID);
        baos.write(UtilBinaryDecoding.intToByteArray(this.ccpIdentifier, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.startingPageNumber, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.endSpace, 2));
        baos.write(this.fieldAllignment);
        baos.write(UtilBinaryDecoding.intToByteArray(this.fieldDelimiter, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.fieldNumber, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.additionalBaselineIncrement, 2));
        baos.write(this.reserved49_61);
        if (this.triplets != null) {
            for (Triplet t : this.triplets) {
                t.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public RCD_XMD_RecordTypeElementType getElementType() {
        return this.elementType;
    }

    public void setElementType(RCD_XMD_RecordTypeElementType elementType) {
        this.elementType = elementType;
    }

    public EnumSet<XMD_Flag> getFlags() {
        return this.flags;
    }

    public void setFlags(EnumSet<XMD_Flag> flags) {
        this.flags = flags;
    }

    public byte getReserved4() {
        return this.reserved4;
    }

    public void setReserved4(byte reserved4) {
        this.reserved4 = reserved4;
    }

    public int getInlinePosition() {
        return this.inlinePosition;
    }

    public void setInlinePosition(int inlinePosition) {
        this.inlinePosition = inlinePosition;
    }

    public int getBaselinePosition() {
        return this.baselinePosition;
    }

    public void setBaselinePosition(int baselinePosition) {
        this.baselinePosition = baselinePosition;
    }

    public AFPOrientation getInlineOrientation() {
        return this.inlineOrientation;
    }

    public void setInlineOrientation(AFPOrientation inlineOrientation) {
        this.inlineOrientation = inlineOrientation;
    }

    public AFPOrientation getBaselineOrientation() {
        return this.baselineOrientation;
    }

    public void setBaselineOrientation(AFPOrientation baselineOrientation) {
        this.baselineOrientation = baselineOrientation;
    }

    public short getPrimaryFontLocalId() {
        return this.primaryFontLocalId;
    }

    public void setPrimaryFontLocalId(short primaryFontLocalId) {
        this.primaryFontLocalId = primaryFontLocalId;
    }

    public int getFieldXMDPointer() {
        return this.fieldXMDPointer;
    }

    public void setFieldXMDPointer(int fieldXMDPointer) {
        this.fieldXMDPointer = fieldXMDPointer;
    }

    public byte[] getReserved16_17() {
        return this.reserved16_17;
    }

    public void setReserved16_17(byte[] reserved16_17) {
        this.reserved16_17 = reserved16_17;
    }

    public String getSuppressionTokenName() {
        return this.suppressionTokenName;
    }

    public void setSuppressionTokenName(String suppressionTokenName) {
        this.suppressionTokenName = suppressionTokenName;
    }

    public byte getReserved26() {
        return this.reserved26;
    }

    public void setReserved26(byte reserved26) {
        this.reserved26 = reserved26;
    }

    public int getDataStartPosition() {
        return this.dataStartPosition;
    }

    public void setDataStartPosition(int dataStartPosition) {
        this.dataStartPosition = dataStartPosition;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public int getConditionalProcessingRCDPointer() {
        return this.conditionalProcessingRCDPointer;
    }

    public void setConditionalProcessingRCDPointer(int conditionalProcessingRCDPointer) {
        this.conditionalProcessingRCDPointer = conditionalProcessingRCDPointer;
    }

    public byte getSubpageID() {
        return this.subpageID;
    }

    public void setSubpageID(byte subpageID) {
        this.subpageID = subpageID;
    }

    public int getCcpIdentifier() {
        return this.ccpIdentifier;
    }

    public void setCcpIdentifier(int ccpIdentifier) {
        this.ccpIdentifier = ccpIdentifier;
    }

    public int getStartingPageNumber() {
        return this.startingPageNumber;
    }

    public void setStartingPageNumber(int startingPageNumber) {
        this.startingPageNumber = startingPageNumber;
    }

    public int getEndSpace() {
        return this.endSpace;
    }

    public void setEndSpace(int endSpace) {
        this.endSpace = endSpace;
    }

    public byte getFieldAllignment() {
        return this.fieldAllignment;
    }

    public void setFieldAllignment(byte fieldAllignment) {
        this.fieldAllignment = fieldAllignment;
    }

    public int getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(int fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public int getFieldNumber() {
        return this.fieldNumber;
    }

    public void setFieldNumber(int fieldNumber) {
        this.fieldNumber = fieldNumber;
    }

    public int getAdditionalBaselineIncrement() {
        return this.additionalBaselineIncrement;
    }

    public void setAdditionalBaselineIncrement(int additionalBaselineIncrement) {
        this.additionalBaselineIncrement = additionalBaselineIncrement;
    }

    public byte[] getReserved49_61() {
        return this.reserved49_61;
    }

    public void setReserved49_61(byte[] reserved49_61) {
        this.reserved49_61 = reserved49_61;
    }

    public static enum XMD_Flag {
        GenerateInlinePosition_CurrentPosition(2),
        GenerateInlinePosition_NewPosition(2),
        GenerateBaselinePosition_CurrentPosition(3),
        GenerateBaselinePosition_NewPosition(3),
        GenerateFontChange_TRC_MRC_Default(4),
        GenerateFontChange_AsSpecified(4),
        GenerateSuppression_TextIsNotSuppressible(5),
        GenerateSuppression_TextIsSuppressible(5),
        FieldXMD_Element(6),
        FieldXMD_Field(6),
        UseFixedData_DoNotPresent(7),
        UseFixedData_DoPresent(7),
        AttributeXMD_Element(10),
        AttributeXMD_Attribute(10),
        ConditionalProcessing_DoNotPerformCP(11),
        ConditionalProcessing_DoPerformCP(11),
        RelativeBaselinePosition_AbsolutePosition(13),
        RelativeBaselinePosition_RelativePosition(13),
        NewPage_NoEffect(16),
        NewPage_LogicalPageEject(16),
        PrintPageNumber_NoEffect(17),
        PrintPageNumber_PrintPageNumber(17),
        ResetPageNumber_NoEffect(18),
        ResetPageNumber_ResetPageNumberToSpecifiedValue(18),
        GroupIndicator_InputDataIsNotPartOfAGroup(19),
        GroupIndicator_SaveGroupHeader(19),
        FieldDelimeterSize_1Byte(20),
        FieldDelimeterSize_2Bytes(20),
        UseStartTag_DoNotSelectStartTag(21),
        UseStartTag_DoSelectStartTag(21),
        HaiderTrailerContinued_IsNotAContinuationOfHeaderTrailer(23),
        HaiderTrailerContinued_IsAContinuationOfHeaderTrailer(23);

        private static MutualExclusiveGroupedFlagHandler<XMD_Flag> handler;
        int group;

        private XMD_Flag(int group) {
            this.group = group;
        }

        public static EnumSet<XMD_Flag> valueOf(int flagBytes) {
            EnumSet<XMD_Flag> result = EnumSet.noneOf(XMD_Flag.class);
            if ((flagBytes & 0x200000) != 0) {
                result.add(GenerateInlinePosition_NewPosition);
            } else {
                result.add(GenerateInlinePosition_CurrentPosition);
            }
            if ((flagBytes & 0x100000) != 0) {
                result.add(GenerateBaselinePosition_NewPosition);
            } else {
                result.add(GenerateBaselinePosition_CurrentPosition);
            }
            if ((flagBytes & 0x80000) != 0) {
                result.add(GenerateFontChange_AsSpecified);
            } else {
                result.add(GenerateFontChange_TRC_MRC_Default);
            }
            if ((flagBytes & 0x40000) != 0) {
                result.add(GenerateSuppression_TextIsSuppressible);
            } else {
                result.add(GenerateSuppression_TextIsNotSuppressible);
            }
            if ((flagBytes & 0x20000) != 0) {
                result.add(FieldXMD_Field);
            } else {
                result.add(FieldXMD_Element);
            }
            if ((flagBytes & 0x10000) != 0) {
                result.add(UseFixedData_DoPresent);
            } else {
                result.add(UseFixedData_DoNotPresent);
            }
            if ((flagBytes & 0x2000) != 0) {
                result.add(AttributeXMD_Attribute);
            } else {
                result.add(AttributeXMD_Element);
            }
            if ((flagBytes & 0x1000) != 0) {
                result.add(ConditionalProcessing_DoPerformCP);
            } else {
                result.add(ConditionalProcessing_DoNotPerformCP);
            }
            if ((flagBytes & 0x400) != 0) {
                result.add(RelativeBaselinePosition_RelativePosition);
            } else {
                result.add(RelativeBaselinePosition_AbsolutePosition);
            }
            if ((flagBytes & 0x80) != 0) {
                result.add(NewPage_LogicalPageEject);
            } else {
                result.add(NewPage_NoEffect);
            }
            if ((flagBytes & 0x40) != 0) {
                result.add(PrintPageNumber_PrintPageNumber);
            } else {
                result.add(PrintPageNumber_NoEffect);
            }
            if ((flagBytes & 0x20) != 0) {
                result.add(ResetPageNumber_ResetPageNumberToSpecifiedValue);
            } else {
                result.add(ResetPageNumber_NoEffect);
            }
            if ((flagBytes & 0x10) != 0) {
                result.add(GroupIndicator_SaveGroupHeader);
            } else {
                result.add(GroupIndicator_InputDataIsNotPartOfAGroup);
            }
            if ((flagBytes & 8) != 0) {
                result.add(FieldDelimeterSize_2Bytes);
            } else {
                result.add(FieldDelimeterSize_1Byte);
            }
            if ((flagBytes & 4) != 0) {
                result.add(UseStartTag_DoSelectStartTag);
            } else {
                result.add(UseStartTag_DoNotSelectStartTag);
            }
            if ((flagBytes & 1) != 0) {
                result.add(HaiderTrailerContinued_IsAContinuationOfHeaderTrailer);
            } else {
                result.add(HaiderTrailerContinued_IsNotAContinuationOfHeaderTrailer);
            }
            return result;
        }

        public static byte[] toBytes(EnumSet<XMD_Flag> flags) {
            int result = 0;
            if (flags.contains((Object)GenerateInlinePosition_NewPosition)) {
                result |= 0x200000;
            }
            if (flags.contains((Object)GenerateBaselinePosition_NewPosition)) {
                result |= 0x100000;
            }
            if (flags.contains((Object)GenerateFontChange_AsSpecified)) {
                result |= 0x80000;
            }
            if (flags.contains((Object)GenerateSuppression_TextIsSuppressible)) {
                result |= 0x40000;
            }
            if (flags.contains((Object)FieldXMD_Field)) {
                result |= 0x20000;
            }
            if (flags.contains((Object)UseFixedData_DoPresent)) {
                result |= 0x10000;
            }
            if (flags.contains((Object)AttributeXMD_Attribute)) {
                result |= 0x2000;
            }
            if (flags.contains((Object)ConditionalProcessing_DoPerformCP)) {
                result |= 0x1000;
            }
            if (flags.contains((Object)RelativeBaselinePosition_RelativePosition)) {
                result |= 0x400;
            }
            if (flags.contains((Object)NewPage_LogicalPageEject)) {
                result |= 0x80;
            }
            if (flags.contains((Object)PrintPageNumber_PrintPageNumber)) {
                result |= 0x40;
            }
            if (flags.contains((Object)ResetPageNumber_ResetPageNumberToSpecifiedValue)) {
                result |= 0x20;
            }
            if (flags.contains((Object)GroupIndicator_SaveGroupHeader)) {
                result |= 0x10;
            }
            if (flags.contains((Object)FieldDelimeterSize_2Bytes)) {
                result |= 8;
            }
            if (flags.contains((Object)UseStartTag_DoSelectStartTag)) {
                result |= 4;
            }
            if (flags.contains((Object)HaiderTrailerContinued_IsAContinuationOfHeaderTrailer)) {
                result |= 1;
            }
            return UtilBinaryDecoding.intToByteArray(result, 3);
        }

        public static void setFlag(EnumSet<XMD_Flag> flags, XMD_Flag flag) {
            handler.setFlag(flags, flag);
        }

        static {
            handler = new MutualExclusiveGroupedFlagHandler();
        }
    }
}

