/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredFieldBaseName;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.parser.TripletParser;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class BRS_BeginResource
extends StructuredFieldBaseName {
    protected List<Triplet> triplets;
    byte[] reserved8_9 = new byte[]{0, 0};

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        super.decodeAFP(sfData, offset, length, config);
        int actualLength = BRS_BeginResource.getActualLength(sfData, offset, length);
        this.reserved8_9 = (byte[])(actualLength > 8 ? new byte[]{sfData[offset + 8], sfData[offset + 9]} : null);
        this.triplets = actualLength > 10 ? TripletParser.parseTriplets(sfData, offset + 10, actualLength - 10, config) : null;
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(UtilCharacterEncoding.stringToByteArray(this.name, config.getAfpCharSet(), 8, (byte)64));
        if (this.reserved8_9 != null) {
            baos.write(this.reserved8_9);
        }
        if (this.triplets != null) {
            for (Triplet triplet : this.triplets) {
                triplet.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public final List<Triplet> getTriplets() {
        return this.triplets;
    }

    public final void setTriplets(List<Triplet> triplets) {
        this.triplets = triplets;
    }

    public final void addTriplet(Triplet triplet) {
        if (triplet == null) {
            return;
        }
        if (this.triplets == null) {
            this.triplets = new ArrayList<Triplet>();
        }
        this.triplets.add(triplet);
    }

    public final void removeTriplet(Triplet triplet) {
        if (triplet == null || this.triplets == null) {
            return;
        }
        this.triplets.remove(triplet);
    }
}

