/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.IHasTriplets;
import com.mgz.afp.base.StructuredField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.parser.TripletParser;
import com.mgz.afp.triplets.Triplet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CDD_ContainerDataDescriptor
extends StructuredField
implements IHasTriplets {
    byte[] retiredParameters;
    List<Triplet> triplets;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        CDD_ContainerDataDescriptor.checkDataLength(sfData, offset, length, -1);
        this.retiredParameters = new byte[12];
        System.arraycopy(sfData, 0, this.retiredParameters, 0, 12);
        this.triplets = TripletParser.parseTriplets(sfData, 12, -1, config);
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.retiredParameters);
        if (this.triplets != null) {
            for (Triplet triplet : this.triplets) {
                triplet.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    @Override
    public List<Triplet> getTriplets() {
        return this.triplets;
    }

    @Override
    public void setTriplets(List<Triplet> triplets) {
        this.triplets = triplets;
    }

    @Override
    public void addTriplet(Triplet triplet) {
        if (triplet == null) {
            return;
        }
        if (this.triplets == null) {
            this.triplets = new ArrayList<Triplet>();
        }
        this.triplets.add(triplet);
    }

    @Override
    public void removeTriplet(Triplet triplet) {
        if (this.triplets == null) {
            return;
        }
        this.triplets.remove(triplet);
    }
}

