/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredFieldBaseName;
import com.mgz.afp.enums.AFPObjectType;
import com.mgz.afp.enums.AFPOrientation;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.parser.TripletParser;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class IOB_IncludeObject
extends StructuredFieldBaseName {
    byte reserved8 = 0;
    AFPObjectType objectType;
    int xOrigin;
    int yOrigin;
    AFPOrientation xRotation;
    AFPOrientation yRotation;
    int xOriginOfContent;
    int yOriginOfContent;
    byte referenceCoordinateSystem;
    List<Triplet> triplets;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        IOB_IncludeObject.checkDataLength(sfData, offset, length, 28);
        super.decodeAFP(sfData, offset, length, config);
        this.reserved8 = sfData[offset + 8];
        this.objectType = AFPObjectType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 9, 1));
        this.xOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 10, 3);
        this.yOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 13, 3);
        this.xRotation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 16, 2));
        this.yRotation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 18, 2));
        this.xOriginOfContent = UtilBinaryDecoding.parseInt(sfData, offset + 20, 3);
        this.yOriginOfContent = UtilBinaryDecoding.parseInt(sfData, offset + 23, 3);
        this.referenceCoordinateSystem = sfData[26];
        this.triplets = TripletParser.parseTriplets(sfData, offset + 27, -1, config);
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(UtilCharacterEncoding.stringToByteArray(this.getName(), config.getAfpCharSet(), 8, (byte)64));
        baos.write(this.reserved8);
        baos.write(this.objectType.toByte());
        baos.write(UtilBinaryDecoding.intToByteArray(this.xOrigin, 3));
        baos.write(UtilBinaryDecoding.intToByteArray(this.yOrigin, 3));
        baos.write(this.xRotation.toBytes());
        baos.write(this.yRotation.toBytes());
        baos.write(UtilBinaryDecoding.intToByteArray(this.xOriginOfContent, 3));
        baos.write(UtilBinaryDecoding.intToByteArray(this.yOriginOfContent, 3));
        baos.write(this.referenceCoordinateSystem);
        if (this.triplets != null) {
            for (Triplet triplet : this.triplets) {
                triplet.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public byte getReserved8() {
        return this.reserved8;
    }

    public void setReserved8(byte reserved8) {
        this.reserved8 = reserved8;
    }

    public AFPObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(AFPObjectType objectType) {
        this.objectType = objectType;
    }

    public int getxOrigin() {
        return this.xOrigin;
    }

    public void setxOrigin(int xOrigin) {
        this.xOrigin = xOrigin;
    }

    public int getyOrigin() {
        return this.yOrigin;
    }

    public void setyOrigin(int yOrigin) {
        this.yOrigin = yOrigin;
    }

    public AFPOrientation getxRotation() {
        return this.xRotation;
    }

    public void setxRotation(AFPOrientation xRotation) {
        this.xRotation = xRotation;
    }

    public AFPOrientation getyRotation() {
        return this.yRotation;
    }

    public void setyRotation(AFPOrientation yRotation) {
        this.yRotation = yRotation;
    }

    public int getxOriginOfContent() {
        return this.xOriginOfContent;
    }

    public void setxOriginOfContent(int xOriginOfContent) {
        this.xOriginOfContent = xOriginOfContent;
    }

    public int getyOriginOfContent() {
        return this.yOriginOfContent;
    }

    public void setyOriginOfContent(int yOriginOfContent) {
        this.yOriginOfContent = yOriginOfContent;
    }

    public byte getReferenceCoordinateSystem() {
        return this.referenceCoordinateSystem;
    }

    public void setReferenceCoordinateSystem(byte referenceCoordinateSystem) {
        this.referenceCoordinateSystem = referenceCoordinateSystem;
    }

    public List<Triplet> getTriplets() {
        return this.triplets;
    }

    public void setTriplets(List<Triplet> triplets) {
        this.triplets = triplets;
    }

    public final void addTriplet(Triplet triplet) {
        if (triplet == null) {
            return;
        }
        if (this.triplets == null) {
            this.triplets = new ArrayList<Triplet>();
        }
        this.triplets.add(triplet);
    }

    public final void removeTriplet(Triplet triplet) {
        if (this.triplets == null) {
            return;
        }
        this.triplets.remove(triplet);
    }
}

