/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredFieldBaseTriplets;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class IPG_IncludePage
extends StructuredFieldBaseTriplets {
    String pageName;
    byte[] reserved8_15 = new byte[8];
    IPG_Flag flags;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.pageName = new String(sfData, 0, 8, config.getAfpCharSet());
        this.reserved8_15 = new byte[8];
        System.arraycopy(sfData, offset + 8, this.reserved8_15, 0, this.reserved8_15.length);
        this.flags = IPG_Flag.valueOf(sfData[offset + 16]);
        int actualLength = IPG_IncludePage.getActualLength(sfData, offset, length);
        super.decodeAFP(sfData, offset + 17, actualLength - 17, config);
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(UtilCharacterEncoding.stringToByteArray(this.pageName, config.getAfpCharSet(), 8, (byte)64));
        baos.write(this.reserved8_15);
        baos.write(this.flags.toByte());
        for (Triplet t : this.triplets) {
            t.writeAFP(baos, config);
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public byte[] getReserved8_15() {
        return this.reserved8_15;
    }

    public void setReserved8_15(byte[] reserved8_15) {
        this.reserved8_15 = reserved8_15;
    }

    public IPG_Flag getFlags() {
        return this.flags;
    }

    public void setFlags(IPG_Flag flags) {
        this.flags = flags;
    }

    public static enum IPG_Flag {
        Reserved,
        PageIsContainedInResourceDocument;


        public static IPG_Flag valueOf(byte flagByte) {
            if ((flagByte & 0x80) != 0) {
                return PageIsContainedInResourceDocument;
            }
            return Reserved;
        }

        public int toByte() {
            if (this == PageIsContainedInResourceDocument) {
                return 128;
            }
            return 0;
        }
    }
}

