/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class MMC_MediumModificationControl
extends StructuredField {
    byte mmcIdentifier;
    byte constantData1;
    List<MMC_KeyWord> keywords;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.mmcIdentifier = sfData[offset];
        this.constantData1 = sfData[offset + 1];
        int actualLength = MMC_MediumModificationControl.getActualLength(sfData, offset, length);
        if (actualLength > 2) {
            this.keywords = new ArrayList<MMC_KeyWord>();
            int pos = 2;
            MMC_KeyWord kw = new MMC_KeyWord();
            kw.decodeAFP(sfData, offset + pos, actualLength - pos, config);
            this.keywords.add(kw);
            pos += 2;
        } else {
            this.keywords = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.mmcIdentifier);
        baos.write(this.constantData1);
        if (this.keywords != null) {
            for (MMC_KeyWord kw : this.keywords) {
                kw.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public byte getMmcIdentifier() {
        return this.mmcIdentifier;
    }

    public void setMmcIdentifier(byte mmcIdentifier) {
        this.mmcIdentifier = mmcIdentifier;
    }

    public byte getConstantData1() {
        return this.constantData1;
    }

    public void setConstantData1(byte constantData1) {
        this.constantData1 = constantData1;
    }

    public List<MMC_KeyWord> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<MMC_KeyWord> keywords) {
        this.keywords = keywords;
    }

    public void addKeyword(MMC_KeyWord keyword) {
        if (keyword == null) {
            return;
        }
        if (this.keywords == null) {
            this.keywords = new ArrayList<MMC_KeyWord>();
        }
        this.keywords.add(keyword);
    }

    public void removeKeyword(MMC_KeyWord keyword) {
        if (this.keywords == null) {
            return;
        }
        this.keywords.remove(keyword);
    }

    public static class MMC_KeyWord
    implements IAFPDecodeableWriteable {
        MMC_KeyWordID keywordID;
        short parameter;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.keywordID = MMC_KeyWordID.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.parameter = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.keywordID.toByte());
            os.write(this.parameter);
        }

        public MMC_KeyWordID getKeywordID() {
            return this.keywordID;
        }

        public void setKeywordID(MMC_KeyWordID keywordID) {
            this.keywordID = keywordID;
        }

        public short getParameter() {
            return this.parameter;
        }

        public void setParameter(short parameter) {
            this.parameter = parameter;
        }

        public static enum MMC_KeyWordID {
            HorizontalPrintAdjustment_RetiredFor3800(14),
            MediumDestinationSelector_high(144),
            MediumDestinationSelector_low(145),
            FixedMediumInformation(160),
            FixedPerforationCut(161),
            FixedSeparationCut(162),
            PresentationSubsystemSetUpID_high(180),
            PresentationSubsystemSetUpID_low(181),
            OffsetStackEdgeMarkChange(209),
            MediaSourceSelectionFormat(224),
            MediaSourceSelector(225),
            MediaTypeLocalID_high(232),
            MediaTypeLocalID_low(233),
            FormsFlash_RetiredFor3800(241),
            MediumOverlayLocalID(242),
            TextSuppressionLocalID(243),
            DuplexControl(244),
            PrintQualityControl(248),
            ConstantFormsControl(249),
            NUpFormatConrol(252);

            int code;

            private MMC_KeyWordID(int code) {
                this.code = code;
            }

            public static MMC_KeyWordID valueOf(short codeByte) {
                for (MMC_KeyWordID kwid : MMC_KeyWordID.values()) {
                    if (kwid.code != codeByte) continue;
                    return kwid;
                }
                return null;
            }

            public int toByte() {
                return this.code;
            }
        }
    }
}

