/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.IRepeatingGroup;
import com.mgz.afp.base.StructuredFieldBaseRepeatingGroups;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MMO_MapMediumOverlay
extends StructuredFieldBaseRepeatingGroups {
    short lengtOfEachRepeatingGroup;
    byte[] reserved1_3 = new byte[3];

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.lengtOfEachRepeatingGroup = UtilBinaryDecoding.parseShort(sfData, offset, 1);
        this.reserved1_3 = new byte[3];
        System.arraycopy(sfData, offset + 1, this.reserved1_3, 0, this.reserved1_3.length);
        int actualLength = MMO_MapMediumOverlay.getActualLength(sfData, offset, length);
        if (actualLength > 4) {
            for (int pos = 4; pos < actualLength; pos += this.lengtOfEachRepeatingGroup) {
                MMO_PrepeatingGroup rg = new MMO_PrepeatingGroup();
                rg.decodeAFP(sfData, offset + pos, actualLength - pos, config);
                this.addRepeatingGroup(rg);
            }
        } else {
            this.repeatingGroups = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.lengtOfEachRepeatingGroup);
        baos.write(this.reserved1_3);
        if (this.repeatingGroups != null) {
            for (IRepeatingGroup rg : this.repeatingGroups) {
                rg.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public short getLengtOfEachRepeatingGroup() {
        return this.lengtOfEachRepeatingGroup;
    }

    public void setLengtOfEachRepeatingGroup(short lengtOfEachRepeatingGroup) {
        this.lengtOfEachRepeatingGroup = lengtOfEachRepeatingGroup;
    }

    public byte[] getReserved1_3() {
        return this.reserved1_3;
    }

    public void setReserved1_3(byte[] reserved1_3) {
        this.reserved1_3 = reserved1_3;
    }

    public static class MMO_PrepeatingGroup
    implements IRepeatingGroup {
        short mediumOverlayLocalId;
        MMO_Flag flag;
        byte[] reserved2_3 = new byte[2];
        String nameOfMediumOverlay;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.mediumOverlayLocalId = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.flag = MMO_Flag.valueOf(sfData[offset + 1]);
            this.reserved2_3 = new byte[2];
            System.arraycopy(sfData, offset + 3, this.reserved2_3, 0, this.reserved2_3.length);
            this.nameOfMediumOverlay = new String(sfData, offset + 4, 8, config.getAfpCharSet());
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.mediumOverlayLocalId);
            os.write(this.flag.toByte());
            os.write(this.reserved2_3);
            os.write(UtilCharacterEncoding.stringToByteArray(this.nameOfMediumOverlay, config.getAfpCharSet(), 8, (byte)64));
        }

        public short getMediumOverlayLocalId() {
            return this.mediumOverlayLocalId;
        }

        public void setMediumOverlayLocalId(short mediumOverlayLocalId) {
            this.mediumOverlayLocalId = mediumOverlayLocalId;
        }

        public MMO_Flag getFlag() {
            return this.flag;
        }

        public void setFlag(MMO_Flag flag) {
            this.flag = flag;
        }

        public byte[] getReserved2_3() {
            return this.reserved2_3;
        }

        public void setReserved2_3(byte[] reserved2_3) {
            this.reserved2_3 = reserved2_3;
        }

        public String getNameOfMediumOverlay() {
            return this.nameOfMediumOverlay;
        }

        public void setNameOfMediumOverlay(String nameOfMediumOverlay) {
            this.nameOfMediumOverlay = nameOfMediumOverlay;
        }

        public static enum MMO_Flag {
            RasterIndicator_CodedOverlay,
            RasterIndicator_RasterOverlay;


            public static MMO_Flag valueOf(byte codeByte) {
                if ((codeByte & 0x80) == 0) {
                    return RasterIndicator_CodedOverlay;
                }
                return RasterIndicator_RasterOverlay;
            }

            public int toByte() {
                if (this == RasterIndicator_CodedOverlay) {
                    return 0;
                }
                return 128;
            }
        }
    }
}

