/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.IRepeatingGroup;
import com.mgz.afp.base.StructuredFieldBaseRepeatingGroups;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MSU_MapSuppression
extends StructuredFieldBaseRepeatingGroups {
    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        int actualLength = MSU_MapSuppression.getActualLength(sfData, offset, length);
        if (actualLength > 0) {
            for (int pos = 0; pos < actualLength; pos += 10) {
                MSU_RepeatingGroup rg = new MSU_RepeatingGroup();
                rg.decodeAFP(sfData, offset + pos, actualLength - pos, config);
                this.addRepeatingGroup(rg);
            }
        } else {
            this.repeatingGroups = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.repeatingGroups != null) {
            for (IRepeatingGroup rg : this.repeatingGroups) {
                rg.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public static class MSU_RepeatingGroup
    implements IRepeatingGroup {
        String nameOfTextSuppresstion;
        byte reserved8 = 0;
        byte localID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.nameOfTextSuppresstion = new String(sfData, offset, 8, config.getAfpCharSet());
            this.reserved8 = sfData[offset + 8];
            this.localID = sfData[offset + 9];
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilCharacterEncoding.stringToByteArray(this.nameOfTextSuppresstion, config.getAfpCharSet(), 8, (byte)64));
            os.write(this.reserved8);
            os.write(this.localID);
        }

        public String getNameOfTextSuppresstion() {
            return this.nameOfTextSuppresstion;
        }

        public void setNameOfTextSuppresstion(String nameOfTextSuppresstion) {
            this.nameOfTextSuppresstion = nameOfTextSuppresstion;
        }

        public byte getReserved8() {
            return this.reserved8;
        }

        public void setReserved8(byte reserved8) {
            this.reserved8 = reserved8;
        }

        public byte getLocalID() {
            return this.localID;
        }

        public void setLocalID(byte localID) {
            this.localID = localID;
        }
    }
}

