/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.enums.AFPOrientation;
import com.mgz.afp.enums.AFPReferenceCoordinateSystem;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OBP_ObjectAreaPosition
extends StructuredField {
    byte objectAreaPositionID;
    OBP_RepeatingGroup repeatingGroup;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.objectAreaPositionID = sfData[offset];
        this.repeatingGroup = new OBP_RepeatingGroup();
        this.repeatingGroup.decodeAFP(sfData, offset + 1, OBP_ObjectAreaPosition.getActualLength(sfData, offset, length) - 1, config);
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(24);
        baos.write(this.objectAreaPositionID);
        this.repeatingGroup.writeAFP(baos, config);
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public byte getObjectAreaPositionID() {
        return this.objectAreaPositionID;
    }

    public void setObjectAreaPositionID(byte objectAreaPositionID) {
        this.objectAreaPositionID = objectAreaPositionID;
    }

    public OBP_RepeatingGroup getRepeatingGroup() {
        return this.repeatingGroup;
    }

    public void setRepeatingGroup(OBP_RepeatingGroup repeatingGroup) {
        this.repeatingGroup = repeatingGroup;
    }

    public static class OBP_RepeatingGroup {
        byte repeatingGroupLength;
        int xOrigin;
        int yOrigin;
        AFPOrientation xRotation;
        AFPOrientation yRotation;
        byte reserved11 = 0;
        int xOriginOfContent;
        int yOriginOfContent;
        AFPOrientation xRotationOfContent;
        AFPOrientation yRotationOfContent;
        AFPReferenceCoordinateSystem referenceCoordinateSystem;

        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.repeatingGroupLength = sfData[offset];
            this.xOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 1, 3);
            this.yOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 4, 3);
            this.xRotation = AFPOrientation.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 7, 2));
            this.yRotation = AFPOrientation.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 9, 2));
            this.reserved11 = sfData[offset + 11];
            this.xOriginOfContent = UtilBinaryDecoding.parseInt(sfData, offset + 12, 3);
            this.yOriginOfContent = UtilBinaryDecoding.parseInt(sfData, offset + 15, 3);
            this.xRotationOfContent = AFPOrientation.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 18, 2));
            this.yRotationOfContent = AFPOrientation.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 20, 2));
            this.referenceCoordinateSystem = AFPReferenceCoordinateSystem.valueOf(sfData[offset + 22]);
        }

        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.repeatingGroupLength);
            os.write(UtilBinaryDecoding.intToByteArray(this.xOrigin, 3));
            os.write(UtilBinaryDecoding.intToByteArray(this.yOrigin, 3));
            os.write(this.xRotation.toBytes());
            os.write(this.yRotation.toBytes());
            os.write(this.reserved11);
            os.write(UtilBinaryDecoding.intToByteArray(this.xOriginOfContent, 3));
            os.write(UtilBinaryDecoding.intToByteArray(this.yOriginOfContent, 3));
            os.write(this.xRotationOfContent.toBytes());
            os.write(this.yRotationOfContent.toBytes());
            os.write(this.referenceCoordinateSystem.toByte());
        }

        public byte getRepeatingGroupLength() {
            return this.repeatingGroupLength;
        }

        public void setRepeatingGroupLength(byte repeatingGroupLength) {
            this.repeatingGroupLength = repeatingGroupLength;
        }

        public int getxOrigin() {
            return this.xOrigin;
        }

        public void setxOrigin(int xOrigin) {
            this.xOrigin = xOrigin;
        }

        public int getyOrigin() {
            return this.yOrigin;
        }

        public void setyOrigin(int yOrigin) {
            this.yOrigin = yOrigin;
        }

        public AFPOrientation getxRotation() {
            return this.xRotation;
        }

        public void setxRotation(AFPOrientation xRotation) {
            this.xRotation = xRotation;
        }

        public AFPOrientation getyRotation() {
            return this.yRotation;
        }

        public void setyRotation(AFPOrientation yRotation) {
            this.yRotation = yRotation;
        }

        public byte getReserved11() {
            return this.reserved11;
        }

        public void setReserved11(byte reserved11) {
            this.reserved11 = reserved11;
        }

        public int getxOriginOfContent() {
            return this.xOriginOfContent;
        }

        public void setxOriginOfContent(int xOriginOfContent) {
            this.xOriginOfContent = xOriginOfContent;
        }

        public int getyOriginOfContent() {
            return this.yOriginOfContent;
        }

        public void setyOriginOfContent(int yOriginOfContent) {
            this.yOriginOfContent = yOriginOfContent;
        }

        public AFPOrientation getxRotationOfContent() {
            return this.xRotationOfContent;
        }

        public void setxRotationOfContent(AFPOrientation xRotationOfContent) {
            this.xRotationOfContent = xRotationOfContent;
        }

        public AFPOrientation getyRotationOfContent() {
            return this.yRotationOfContent;
        }

        public void setyRotationOfContent(AFPOrientation yRotationOfContent) {
            this.yRotationOfContent = yRotationOfContent;
        }

        public AFPReferenceCoordinateSystem getReferenceCoordinateSystem() {
            return this.referenceCoordinateSystem;
        }

        public void setReferenceCoordinateSystem(AFPReferenceCoordinateSystem referenceCoordinateSystem) {
            this.referenceCoordinateSystem = referenceCoordinateSystem;
        }
    }
}

