/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredFieldBaseTriplets;
import com.mgz.afp.enums.AFPUnitBase;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PGD_PageDescriptor
extends StructuredFieldBaseTriplets {
    AFPUnitBase xUnitBase;
    AFPUnitBase yUnitBase;
    short xUnitsPerUnitBase;
    short yUnitsPerUnitBase;
    int xSize;
    int ySize;
    byte[] reserved12_14;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.xUnitBase = AFPUnitBase.valueOf(sfData[offset]);
        this.yUnitBase = AFPUnitBase.valueOf(sfData[offset + 1]);
        this.xUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
        this.yUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
        this.xSize = UtilBinaryDecoding.parseInt(sfData, offset + 6, 3);
        this.ySize = UtilBinaryDecoding.parseInt(sfData, offset + 9, 3);
        int actualLength = PGD_PageDescriptor.getActualLength(sfData, offset, length);
        if (actualLength > 12) {
            this.reserved12_14 = new byte[Math.min(actualLength - 12, 3)];
            System.arraycopy(sfData, offset + 12, this.reserved12_14, 0, this.reserved12_14.length);
        }
        if (actualLength > 15) {
            super.decodeAFP(sfData, offset + 15, actualLength - 15, config);
        } else {
            this.triplets = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.xUnitBase.toByte());
        baos.write(this.yUnitBase.toByte());
        baos.write(UtilBinaryDecoding.shortToByteArray(this.xUnitsPerUnitBase, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.yUnitsPerUnitBase, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.xSize, 3));
        baos.write(UtilBinaryDecoding.intToByteArray(this.ySize, 3));
        baos.write(this.reserved12_14);
        if (this.triplets != null) {
            for (Triplet t : this.triplets) {
                t.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public AFPUnitBase getxUnitBase() {
        return this.xUnitBase;
    }

    public void setxUnitBase(AFPUnitBase xUnitBase) {
        this.xUnitBase = xUnitBase;
    }

    public AFPUnitBase getyUnitBase() {
        return this.yUnitBase;
    }

    public void setyUnitBase(AFPUnitBase yUnitBase) {
        this.yUnitBase = yUnitBase;
    }

    public short getxUnitsPerUnitBase() {
        return this.xUnitsPerUnitBase;
    }

    public void setxUnitsPerUnitBase(short xUnitsPerUnitBase) {
        this.xUnitsPerUnitBase = xUnitsPerUnitBase;
    }

    public short getyUnitsPerUnitBase() {
        return this.yUnitsPerUnitBase;
    }

    public void setyUnitsPerUnitBase(short yUnitsPerUnitBase) {
        this.yUnitsPerUnitBase = yUnitsPerUnitBase;
    }

    public int getxSize() {
        return this.xSize;
    }

    public void setxSize(int xSize) {
        this.xSize = xSize;
    }

    public int getySize() {
        return this.ySize;
    }

    public void setySize(int ySize) {
        this.ySize = ySize;
    }

    public byte[] getReserved12_14() {
        return this.reserved12_14;
    }

    public void setReserved12_14(byte[] reserved12_14) {
        this.reserved12_14 = reserved12_14;
    }
}

