/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.parser;

import com.mgz.afp.bcoca.BDD_BarCodeDataDescriptor;
import com.mgz.afp.foca.CPC_CodePageControl;
import com.mgz.afp.foca.CPD_CodePageDescriptor;
import com.mgz.afp.foca.FNC_FontControl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.DigestInputStream;

public class AFPParserConfiguration
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected boolean isParserOwnsInputStream;
    Charset afpCharSet = Charset.forName("cp500");
    int bufferSize = 102400;
    InputStream inputStream;
    boolean isParseToStructuredFieldsBaseData;
    boolean isBuildShallow;
    boolean escalateParsingErrors = true;
    File afpFile;
    private CPD_CodePageDescriptor currentCodePageDescriptor;
    private CPC_CodePageControl currentPageControl;
    private FNC_FontControl currentFontControl;
    private BDD_BarCodeDataDescriptor currentBarCodeDataDescriptor;

    public Charset getAfpCharSet() {
        return this.afpCharSet;
    }

    public void setAfpCharSet(Charset afpCharSet) {
        this.afpCharSet = afpCharSet;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null && this.afpFile != null) {
            this.inputStream = new BufferedInputStream(new FileInputStream(this.afpFile), this.bufferSize);
            this.isParserOwnsInputStream = true;
        } else if (this.inputStream != null && !(this.inputStream instanceof BufferedInputStream) && !(this.inputStream instanceof DigestInputStream) && this.bufferSize > 0) {
            this.inputStream = new BufferedInputStream(this.inputStream, this.bufferSize);
        }
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public FNC_FontControl getCurrentFontControl() {
        return this.currentFontControl;
    }

    public void setCurrentFontControl(FNC_FontControl fontControl) {
        this.currentFontControl = fontControl;
    }

    public boolean isParseToStructuredFieldsBaseData() {
        return this.isParseToStructuredFieldsBaseData;
    }

    public void setParseToStructuredFieldsBaseData(boolean isParseToStructuredFieldsBaseData) {
        this.isParseToStructuredFieldsBaseData = isParseToStructuredFieldsBaseData;
    }

    public CPD_CodePageDescriptor getCurrentCPD_CodePageDescriptor() {
        return this.currentCodePageDescriptor;
    }

    public CPC_CodePageControl getCurrentCodePageControl() {
        return this.currentPageControl;
    }

    public boolean isBuildShallow() {
        return this.isBuildShallow;
    }

    public void setBuildShallow(boolean isBuildShallow) {
        this.isBuildShallow = isBuildShallow;
    }

    public boolean isEscalateParsingErrors() {
        return this.escalateParsingErrors;
    }

    public void setEscalateParsingErrors(boolean escalateParsingErrors) {
        this.escalateParsingErrors = escalateParsingErrors;
    }

    public AFPParserConfiguration clone() {
        try {
            return (AFPParserConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public BDD_BarCodeDataDescriptor getCurrentBarCodeDataDescriptor() {
        return this.currentBarCodeDataDescriptor;
    }

    public void setCurrentBarCodeDataDescriptor(BDD_BarCodeDataDescriptor currentBarCodeDataDescriptor) {
        this.currentBarCodeDataDescriptor = currentBarCodeDataDescriptor;
    }

    public CPD_CodePageDescriptor getCurrentCodePageDescriptor() {
        return this.currentCodePageDescriptor;
    }

    public void setCurrentCodePageDescriptor(CPD_CodePageDescriptor currentCodePageDescriptor) {
        this.currentCodePageDescriptor = currentCodePageDescriptor;
    }

    public CPC_CodePageControl getCurrentPageControl() {
        return this.currentPageControl;
    }

    public void setCurrentPageControl(CPC_CodePageControl currentPageControl) {
        this.currentPageControl = currentPageControl;
    }

    public File getAFPFile() {
        return this.afpFile;
    }

    public void setAFPFile(File afpFile) {
        this.afpFile = afpFile;
    }

    public void resetCurrentAFPObjects() {
        this.currentBarCodeDataDescriptor = null;
        this.currentCodePageDescriptor = null;
        this.currentFontControl = null;
        this.currentPageControl = null;
    }
}

