/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.parser;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.ptoca.controlSequence.PTOCAControlSequence;
import com.mgz.afp.ptoca.controlSequence.Undefined;
import java.util.ArrayList;
import java.util.List;

public class PTOCAControlSequenceParser {
    public static List<PTOCAControlSequence> parseControlSequences(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        PTOCAControlSequence.ControlSequenceIntroducer csi;
        ArrayList<PTOCAControlSequence> controlSequences = new ArrayList<PTOCAControlSequence>();
        int actualLength = StructuredField.getActualLength(sfData, offset, length);
        boolean isChained = false;
        for (int pos = 0; pos < actualLength; pos += csi.getLength() - 2) {
            csi = PTOCAControlSequence.ControlSequenceIntroducer.parseCSI(isChained, sfData, offset + pos, -1, config);
            PTOCAControlSequence cs = PTOCAControlSequenceParser.createControlSequenceInstance(csi);
            pos = isChained ? (pos += 2) : (pos += 4);
            cs.decodeAFP(sfData, offset + pos, csi.getLength() - 2, config);
            isChained = cs.getCsi().isChained();
            controlSequences.add(cs);
        }
        return controlSequences;
    }

    public static final PTOCAControlSequence createControlSequenceInstance(PTOCAControlSequence.ControlSequenceIntroducer csi) throws AFPParserException {
        PTOCAControlSequence cs = null;
        String className = null;
        try {
            className = PTOCAControlSequence.class.getName() + "$" + csi.getControlSequenceFunctionType().name();
            Class<?> clazz = Class.forName(className);
            cs = (PTOCAControlSequence)clazz.newInstance();
        }
        catch (Throwable cnfex) {
            throw new AFPParserException(PTOCAControlSequence.class.getSimpleName() + ": failed to instantiate control sequence class '" + className + "'.");
        }
        if (cs == null) {
            cs = new Undefined();
        }
        cs.setCsi(csi);
        return cs;
    }
}

