/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.parser;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilBinaryDecoding;
import java.util.ArrayList;
import java.util.List;

public class TripletParser {
    public static List<Triplet> parseTriplets(byte[] sfData, int offset, int length, AFPParserConfiguration config) {
        Triplet triplet;
        ArrayList<Triplet> resultingTriplets = new ArrayList<Triplet>();
        int actualLength = StructuredField.getActualLength(sfData, offset, length);
        for (int pos = 0; pos < actualLength; pos += triplet.getLength()) {
            try {
                triplet = TripletParser.parseTriplet(sfData, offset + pos, actualLength - pos, config);
            }
            catch (AFPParserException pex) {
                Triplet.Undefined undef = null;
                undef = new Triplet.Undefined();
                triplet = undef;
                undef.setParsingException(pex);
                byte[] tripletData = new byte[actualLength];
                System.arraycopy(sfData, offset, tripletData, 0, actualLength);
                undef.setTripletData(tripletData);
                undef.setLength((short)(sfData[offset + pos] & 0xFF));
                undef.setTripletID(Triplet.TripletID.Undefined);
            }
            resultingTriplets.add(triplet);
        }
        return resultingTriplets;
    }

    public static Triplet parseTriplet(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        Triplet resultingTriplet = null;
        short tripletLength = UtilBinaryDecoding.parseShort(sfData, offset, 1);
        short actualTripletID = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
        Triplet.TripletID tripletID = null;
        if (actualTripletID != Triplet.UNFORTUNATE_TRIPLETID) {
            try {
                tripletID = Triplet.TripletID.valueOf(actualTripletID);
            }
            catch (AFPParserException ex) {
                tripletID = Triplet.TripletID.Undefined;
            }
        } else {
            int significantNumber = UtilBinaryDecoding.parseInt(sfData, offset + 4, 2);
            tripletID = significantNumber == 32768 ? Triplet.TripletID.ObjectFunctionSetSpecification_Retired : Triplet.TripletID.ResourceObjectType;
        }
        if (tripletID == Triplet.TripletID.Undefined) {
            resultingTriplet = new Triplet.Undefined();
            resultingTriplet.setLength(tripletLength);
            resultingTriplet.setTripletID(Triplet.TripletID.Undefined);
        } else {
            resultingTriplet = TripletParser.createTripletInstance(tripletID);
            resultingTriplet.setLength(tripletLength);
        }
        resultingTriplet.decodeAFP(sfData, offset, tripletLength, config);
        return resultingTriplet;
    }

    public static final Triplet createTripletInstance(Triplet.TripletID tid) {
        Triplet cs = null;
        try {
            String classname = Triplet.class.getName() + "$" + tid.name();
            Class<?> clazz = Class.forName(classname);
            cs = (Triplet)clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cs == null) {
            cs = new Triplet.Undefined();
        }
        cs.setTripletID(tid);
        return cs;
    }
}

