/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.ptoca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.enums.AFPUnitBase;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PTD_PresentationTextDataDescriptor_Format1
extends StructuredField {
    AFPUnitBase xUnitBase;
    AFPUnitBase yUnitBase;
    short xUnitsPerUnitBase;
    short yUnitsPerUnitBase;
    short xSize;
    short ySize;
    byte[] reserved10_11;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        PTD_PresentationTextDataDescriptor_Format1.checkDataLength(sfData, offset, length, 10);
        this.xUnitBase = AFPUnitBase.valueOf(sfData[offset]);
        this.yUnitBase = AFPUnitBase.valueOf(sfData[offset + 1]);
        this.xUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
        this.yUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
        this.xSize = UtilBinaryDecoding.parseShort(sfData, offset + 6, 2);
        this.ySize = UtilBinaryDecoding.parseShort(sfData, offset + 8, 2);
        int actualLength = StructuredField.getActualLength(sfData, offset, length);
        if (actualLength > 10) {
            this.reserved10_11 = new byte[2];
            System.arraycopy(sfData, offset + 10, this.reserved10_11, 0, this.reserved10_11.length);
        } else {
            this.reserved10_11 = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.xUnitBase.toByte());
        baos.write(this.yUnitBase.toByte());
        baos.write(UtilBinaryDecoding.shortToByteArray(this.xUnitsPerUnitBase, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.yUnitsPerUnitBase, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.xSize, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.ySize, 2));
        if (this.reserved10_11 != null) {
            baos.write(this.reserved10_11, 0, 2);
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public AFPUnitBase getxUnitBase() {
        return this.xUnitBase;
    }

    public void setxUnitBase(AFPUnitBase xUnitBase) {
        this.xUnitBase = xUnitBase;
    }

    public AFPUnitBase getyUnitBase() {
        return this.yUnitBase;
    }

    public void setyUnitBase(AFPUnitBase yUnitBase) {
        this.yUnitBase = yUnitBase;
    }

    public short getxUnitsPerUnitBase() {
        return this.xUnitsPerUnitBase;
    }

    public void setxUnitsPerUnitBase(short xUnitsPerUnitBase) {
        this.xUnitsPerUnitBase = xUnitsPerUnitBase;
    }

    public short getyUnitsPerUnitBase() {
        return this.yUnitsPerUnitBase;
    }

    public void setyUnitsPerUnitBase(short yUnitsPerUnitBase) {
        this.yUnitsPerUnitBase = yUnitsPerUnitBase;
    }

    public short getxSize() {
        return this.xSize;
    }

    public void setxSize(short xSize) {
        this.xSize = xSize;
    }

    public short getySize() {
        return this.ySize;
    }

    public void setySize(short ySize) {
        this.ySize = ySize;
    }

    public byte[] getReserved10_11() {
        return this.reserved10_11;
    }

    public void setReserved10_11(byte[] reserved10_11) {
        this.reserved10_11 = reserved10_11;
    }
}

