/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.ptoca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.enums.AFPUnitBase;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.parser.PTOCAControlSequenceParser;
import com.mgz.afp.ptoca.controlSequence.PTOCAControlSequence;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PTD_PresentationTextDataDescriptor_Format2
extends StructuredField {
    AFPUnitBase xUnitBase;
    AFPUnitBase yUnitBase;
    short xUnitsPerUnitBase;
    short yUnitsPerUnitBase;
    short xSize;
    short ySize;
    byte[] reserved12_13;
    List<PTOCAControlSequence> controlSequences;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        PTD_PresentationTextDataDescriptor_Format2.checkDataLength(sfData, offset, length, 12);
        this.xUnitBase = AFPUnitBase.valueOf(sfData[offset]);
        this.yUnitBase = AFPUnitBase.valueOf(sfData[offset + 1]);
        this.xUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
        this.yUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
        this.xSize = UtilBinaryDecoding.parseShort(sfData, offset + 7, 2);
        this.ySize = UtilBinaryDecoding.parseShort(sfData, offset + 10, 2);
        int actualLength = StructuredField.getActualLength(sfData, offset, length);
        if (actualLength > 13) {
            this.reserved12_13 = new byte[2];
            System.arraycopy(sfData, offset + 12, this.reserved12_13, 0, this.reserved12_13.length);
            this.controlSequences = actualLength > 15 ? PTOCAControlSequenceParser.parseControlSequences(sfData, offset + 15, -1, config) : null;
        } else {
            this.reserved12_13 = null;
            this.controlSequences = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.xUnitBase.toByte());
        baos.write(this.yUnitBase.toByte());
        baos.write(UtilBinaryDecoding.shortToByteArray(this.xUnitsPerUnitBase, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.yUnitsPerUnitBase, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.xSize, 3));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.ySize, 3));
        if (this.reserved12_13 != null) {
            baos.write(this.reserved12_13, 0, 2);
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public AFPUnitBase getxUnitBase() {
        return this.xUnitBase;
    }

    public void setxUnitBase(AFPUnitBase xUnitBase) {
        this.xUnitBase = xUnitBase;
    }

    public AFPUnitBase getyUnitBase() {
        return this.yUnitBase;
    }

    public void setyUnitBase(AFPUnitBase yUnitBase) {
        this.yUnitBase = yUnitBase;
    }

    public short getxUnitsPerUnitBase() {
        return this.xUnitsPerUnitBase;
    }

    public void setxUnitsPerUnitBase(short xUnitsPerUnitBase) {
        this.xUnitsPerUnitBase = xUnitsPerUnitBase;
    }

    public short getyUnitsPerUnitBase() {
        return this.yUnitsPerUnitBase;
    }

    public void setyUnitsPerUnitBase(short yUnitsPerUnitBase) {
        this.yUnitsPerUnitBase = yUnitsPerUnitBase;
    }

    public short getxSize() {
        return this.xSize;
    }

    public void setxSize(short xSize) {
        this.xSize = xSize;
    }

    public short getySize() {
        return this.ySize;
    }

    public void setySize(short ySize) {
        this.ySize = ySize;
    }

    public byte[] getReserved12_13() {
        return this.reserved12_13;
    }

    public void setReserved12_13(byte[] reserved12_13) {
        this.reserved12_13 = reserved12_13;
    }

    public List<PTOCAControlSequence> getControlSeqences() {
        return this.controlSequences;
    }

    public void setControlSeqences(List<PTOCAControlSequence> controlSeqences) {
        this.controlSequences = controlSeqences;
    }

    public void addControlSequence(PTOCAControlSequence controlSequence) {
        if (controlSequence == null) {
            return;
        }
        if (this.controlSequences == null) {
            this.controlSequences = new ArrayList<PTOCAControlSequence>();
        }
        this.controlSequences.add(controlSequence);
    }

    public void remoceControlSequence(PTOCAControlSequence controlSequence) {
        if (this.controlSequences == null) {
            return;
        }
        this.controlSequences.remove(controlSequence);
    }
}

