/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.ptoca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.parser.PTOCAControlSequenceParser;
import com.mgz.afp.ptoca.controlSequence.PTOCAControlSequence;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PTX_PresentationTextData
extends StructuredField {
    @AFPField
    List<PTOCAControlSequence> controlSequences;
    volatile byte[] originalPayload;
    volatile Throwable controlSequenceException;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        int actualLength = PTX_PresentationTextData.getActualLength(sfData, offset, length);
        if (actualLength > 0) {
            this.originalPayload = new byte[actualLength];
            System.arraycopy(sfData, offset, this.originalPayload, 0, actualLength);
            this.controlSequences = PTOCAControlSequenceParser.parseControlSequences(sfData, offset, actualLength, config);
        } else {
            this.originalPayload = null;
            this.controlSequences = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        byte[] actualPayload = null;
        if (this.controlSequences != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (PTOCAControlSequence cs : this.controlSequences) {
                baos.write(cs.getCsi().toBytes());
                cs.writeAFP(baos, config);
            }
            actualPayload = baos.toByteArray();
        } else if (this.originalPayload != null) {
            actualPayload = this.originalPayload;
        }
        this.writeFullStructuredField(os, actualPayload);
    }

    public List<PTOCAControlSequence> getControlSequences() {
        return this.controlSequences;
    }

    public void setControlSequences(List<PTOCAControlSequence> controlSequences) {
        this.controlSequences = controlSequences;
    }

    public void addControlSequence(PTOCAControlSequence cs) {
        if (cs == null) {
            return;
        }
        if (this.controlSequences == null) {
            this.controlSequences = new ArrayList<PTOCAControlSequence>();
        }
        this.controlSequences.add(cs);
    }

    public void removeControlSequence(PTOCAControlSequence cs) {
        if (this.controlSequences == null) {
            return;
        }
        this.controlSequences.remove(cs);
    }
}

