/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.triplets;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.base.annotations.AFPType;
import com.mgz.afp.enums.AFPColorSpace;
import com.mgz.afp.enums.AFPOrientation;
import com.mgz.afp.enums.AFPUnitBase;
import com.mgz.afp.enums.IMutualExclusiveGroupedFlag;
import com.mgz.afp.enums.MutualExclusiveGroupedFlagHandler;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

@AFPType
public abstract class Triplet
implements IAFPDecodeableWriteable {
    public static short UNFORTUNATE_TRIPLETID = (short)33;
    @AFPField(isEditable=false, isHidden=true)
    short length;
    @AFPField(isHidden=true)
    TripletID tripletID;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.length = UtilBinaryDecoding.parseShort(sfData, offset, 1);
        this.tripletID = TripletID.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 1, 1));
    }

    public short getLength() {
        return this.length;
    }

    public void setLength(short length) {
        this.length = length;
    }

    public TripletID getTripletID() {
        return this.tripletID;
    }

    public void setTripletID(TripletID tripletID) {
        this.tripletID = tripletID;
    }

    public static class ObjectContainerPresentationSpaceSize
    extends Triplet {
        byte[] reserved2_3 = new byte[]{0, 0};
        PDFPresentationSpace pdfPresentationSpace;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2_3 = new byte[]{sfData[offset + 2], sfData[offset + 3]};
            this.pdfPresentationSpace = PDFPresentationSpace.valueOf(sfData[offset + 4]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)5;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.reserved2_3);
            os.write(this.pdfPresentationSpace.toByte());
        }

        public static enum PDFPresentationSpace {
            MediaBox,
            CropBox,
            BleedBox,
            TrimBox,
            ArtBox;


            public static PDFPresentationSpace valueOf(byte codeByte) throws AFPParserException {
                for (PDFPresentationSpace ps : PDFPresentationSpace.values()) {
                    if (ps.ordinal() + 1 != codeByte) continue;
                    return ps;
                }
                throw new AFPParserException(PDFPresentationSpace.class.getSimpleName() + ": presentation space code 0x" + Integer.toHexString(codeByte) + " is undfined.");
            }

            public int toByte() {
                return this.ordinal() + 1;
            }
        }
    }

    public static class ImageResolution
    extends Triplet {
        byte[] reserved2_3 = new byte[]{0, 0};
        AFPUnitBase xUnitBase;
        AFPUnitBase yUnitBase;
        short xUnitsPerUnitBase;
        short yUnitsPerUnitBase;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2_3 = new byte[]{sfData[offset + 2], sfData[offset + 3]};
            this.xUnitBase = AFPUnitBase.valueOf(sfData[offset + 4]);
            this.yUnitBase = AFPUnitBase.valueOf(sfData[offset + 5]);
            this.xUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 6, 2);
            this.yUnitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 8, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)10;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.reserved2_3);
            os.write(this.xUnitBase.toByte());
            os.write(this.yUnitBase.toByte());
            os.write(UtilBinaryDecoding.shortToByteArray(this.xUnitsPerUnitBase, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.yUnitsPerUnitBase, 2));
        }
    }

    public static class DeviceAppearance
    extends Triplet {
        byte reserved2 = 0;
        Appearance appearance;
        byte[] reserved5_6 = new byte[]{0, 0};

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2 = sfData[offset + 2];
            this.appearance = Appearance.valueOf(sfData[offset + 3]);
            this.reserved5_6 = new byte[]{sfData[offset + 5], sfData[offset + 6]};
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)7;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.reserved2);
            os.write(this.appearance.toByte());
            os.write(this.reserved5_6);
        }

        public static enum Appearance {
            DeviceDefault,
            DeviceDefaultMonochrome;


            public static Appearance valueOf(byte codeByte) {
                if (codeByte == 0) {
                    return DeviceDefault;
                }
                return DeviceDefaultMonochrome;
            }

            public int toByte() {
                return this.ordinal();
            }
        }
    }

    public static class CMRTagFidelity
    extends Triplet {
        ColorFidelity.ExceptionContinuationRule exceptionContinuationRule;
        byte reserved3 = 0;
        ColorFidelity.ExceptionReportingRule exceptionReportingRule;
        byte[] reserved5_6 = new byte[]{0, 0};

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.exceptionContinuationRule = ColorFidelity.ExceptionContinuationRule.valueOf(sfData[offset + 2]);
            this.reserved3 = sfData[offset + 3];
            this.exceptionReportingRule = ColorFidelity.ExceptionReportingRule.valueOf(sfData[offset + 4]);
            this.reserved5_6 = new byte[2];
            System.arraycopy(sfData, offset + 5, this.reserved5_6, 0, this.reserved5_6.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)7;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.exceptionContinuationRule.toByte());
            os.write(this.reserved3);
            os.write(this.exceptionReportingRule.toByte());
            os.write(this.reserved5_6);
        }
    }

    public static class RenderingIntent
    extends Triplet {
        byte[] reserved2_3 = new byte[2];
        Intent intentForIOCA;
        Intent intentForContainerNonIOCA;
        Intent intentForPTOCA;
        Intent intentForGOCA;
        byte[] reserved8_9 = new byte[2];

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2_3 = new byte[]{sfData[offset + 2], sfData[offset + 3]};
            this.intentForIOCA = Intent.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 4, 1));
            this.intentForContainerNonIOCA = Intent.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 5, 1));
            this.intentForPTOCA = Intent.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 6, 1));
            this.intentForGOCA = Intent.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 7, 1));
            this.reserved8_9 = new byte[]{sfData[offset + 8], sfData[offset + 9]};
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)10;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.reserved2_3);
            os.write(this.intentForIOCA.toByte());
            os.write(this.intentForContainerNonIOCA.toByte());
            os.write(this.intentForPTOCA.toByte());
            os.write(this.intentForGOCA.toByte());
            os.write(this.reserved8_9);
        }

        public static enum Intent {
            Perceptual,
            MediaRelativeColorimetric,
            Saturation,
            iccAbsoluteColorimetric,
            NotSpecified;


            public static Intent valueOf(short codeByte) throws AFPParserException {
                if (codeByte == 255) {
                    return NotSpecified;
                }
                for (Intent intent : Intent.values()) {
                    if (intent.ordinal() != codeByte) continue;
                    return intent;
                }
                throw new AFPParserException(Intent.class.getSimpleName() + ": intent code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                if (this == NotSpecified) {
                    return 255;
                }
                return this.ordinal();
            }
        }
    }

    public static class ColorManagementResourceDescriptor
    extends Triplet {
        byte reserved2;
        CMRProcessingMode cmrProcessingMode;
        CMRScope cmrScope;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2 = sfData[offset + 2];
            this.cmrProcessingMode = CMRProcessingMode.valueOf(sfData[offset + 3]);
            this.cmrScope = CMRScope.valueOf(sfData[offset + 4]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)5;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.cmrProcessingMode.toByte());
            os.write(this.cmrScope.toByte());
        }

        public byte getReserved2() {
            return this.reserved2;
        }

        public void setReserved2(byte reserved2) {
            this.reserved2 = reserved2;
        }

        public CMRProcessingMode getCmrProcessingMode() {
            return this.cmrProcessingMode;
        }

        public void setCmrProcessingMode(CMRProcessingMode cmrProcessingMode) {
            this.cmrProcessingMode = cmrProcessingMode;
        }

        public CMRScope getCmrScope() {
            return this.cmrScope;
        }

        public void setCmrScope(CMRScope cmrScope) {
            this.cmrScope = cmrScope;
        }

        public static enum CMRScope {
            DataObject,
            PageOrOverlay,
            Document,
            PrintFile,
            PageGroup_SheetGroup;


            public static CMRScope valueOf(byte codeByte) throws AFPParserException {
                for (CMRScope sc : CMRScope.values()) {
                    if (sc.ordinal() + 1 != codeByte) continue;
                    return sc;
                }
                throw new AFPParserException(CMRScope.class.getSimpleName() + ": scope code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal() + 1;
            }
        }

        public static enum CMRProcessingMode {
            AuditCMR,
            InstructionCMR,
            LinkCMR;


            public static CMRProcessingMode valueOf(byte codeByte) throws AFPParserException {
                for (CMRProcessingMode pm : CMRProcessingMode.values()) {
                    if (pm.ordinal() + 1 != codeByte) continue;
                    return pm;
                }
                throw new AFPParserException(CMRProcessingMode.class.getSimpleName() + ": processing mode 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal() + 1;
            }
        }
    }

    public static class UP3iFinishingOperation
    extends Triplet {
        short sequenceNumber;
        byte reserved3 = 0;
        byte[] up3iData;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.sequenceNumber = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.reserved3 = sfData[offset + 3];
            this.up3iData = new byte[this.length - 4];
            System.arraycopy(sfData, offset + 4, this.up3iData, 0, this.up3iData.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)(4 + this.up3iData.length);
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.sequenceNumber);
            os.write(this.reserved3);
            os.write(this.up3iData);
        }

        public short getSequenceNumber() {
            return this.sequenceNumber;
        }

        public void setSequenceNumber(short sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public byte getReserved3() {
            return this.reserved3;
        }

        public void setReserved3(byte reserved3) {
            this.reserved3 = reserved3;
        }

        public byte[] getUp3iData() {
            return this.up3iData;
        }

        public void setUp3iData(byte[] up3iData) {
            this.up3iData = up3iData;
        }
    }

    public static class LocaleSelector
    extends Triplet {
        byte reserved2 = 0;
        EnumSet<LocalSelectorFlag> flags;
        String languageCode;
        String scriptCode;
        String regionCode;
        byte[] reserved28_35 = new byte[8];
        String variantCode;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2 = sfData[offset + 2];
            this.flags = LocalSelectorFlag.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 3, 1));
            this.languageCode = new String(sfData, offset + 4, 8);
            this.scriptCode = new String(sfData, offset + 12, 8);
            this.regionCode = new String(sfData, offset + 20, 8);
            this.reserved28_35 = new byte[8];
            System.arraycopy(sfData, offset + 21, this.reserved28_35, 0, this.reserved28_35.length);
            this.variantCode = this.length > 36 ? new String(sfData, offset + 36, this.length - 36) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            byte[] variantCodeData = this.variantCode != null ? this.variantCode.getBytes(Charset.defaultCharset()) : null;
            this.length = (short)(variantCodeData == null ? 36 : 36 + variantCodeData.length);
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.reserved2);
            os.write(LocalSelectorFlag.toByte(this.flags));
            os.write(UtilCharacterEncoding.stringToByteArray(this.languageCode, Charset.defaultCharset(), 8, (byte)0));
            os.write(UtilCharacterEncoding.stringToByteArray(this.scriptCode, Charset.defaultCharset(), 8, (byte)0));
            os.write(UtilCharacterEncoding.stringToByteArray(this.regionCode, Charset.defaultCharset(), 8, (byte)0));
            os.write(this.reserved28_35);
            if (variantCodeData != null) {
                os.write(variantCodeData);
            }
        }

        public byte getReserved2() {
            return this.reserved2;
        }

        public void setReserved2(byte reserved2) {
            this.reserved2 = reserved2;
        }

        public EnumSet<LocalSelectorFlag> getFlags() {
            return this.flags;
        }

        public void setFlags(EnumSet<LocalSelectorFlag> flags) {
            this.flags = flags;
        }

        public void setFlag(LocalSelectorFlag flag) {
            if (flag == null) {
                return;
            }
            if (this.flags == null) {
                this.flags = EnumSet.noneOf(LocalSelectorFlag.class);
            }
            LocalSelectorFlag.handler.setFlag(this.flags, flag);
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        public void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public String getScriptCode() {
            return this.scriptCode;
        }

        public void setScriptCode(String scriptCode) {
            this.scriptCode = scriptCode;
        }

        public String getRegionCode() {
            return this.regionCode;
        }

        public void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }

        public byte[] getReserved28_35() {
            return this.reserved28_35;
        }

        public void setReserved28_35(byte[] reserved28_35) {
            this.reserved28_35 = reserved28_35;
        }

        public String getVariantCode() {
            return this.variantCode;
        }

        public void setVariantCode(String variantCode) {
            this.variantCode = variantCode;
        }

        public static enum LocalSelectorFlag implements IMutualExclusiveGroupedFlag
        {
            LanguageCode_NotSpecified(0),
            LanguageCode_TwoBytes(0),
            LanguageCode_ThreeBytes(0),
            ScriptCode_NotSpecified(1),
            ScriptCode_FourCharacter(1),
            RegionCode_NotSpecified(2),
            RegionCode_TwoBytes(2),
            RegionCode_ThreeBytes(3);

            public static final MutualExclusiveGroupedFlagHandler<LocalSelectorFlag> handler;
            int group;

            private LocalSelectorFlag(int group) {
                this.group = group;
            }

            public static EnumSet<LocalSelectorFlag> valueOf(short codeByte) {
                EnumSet<LocalSelectorFlag> result = EnumSet.noneOf(LocalSelectorFlag.class);
                short languageCode = (short)(codeByte >>> 4);
                short regionCode = (short)(codeByte & 7);
                if (languageCode == 0) {
                    result.add(LanguageCode_NotSpecified);
                } else if (languageCode == 2) {
                    result.add(LanguageCode_TwoBytes);
                } else if (languageCode == 3) {
                    result.add(LanguageCode_ThreeBytes);
                }
                if ((codeByte & 8) == 0) {
                    result.add(ScriptCode_NotSpecified);
                } else {
                    result.add(ScriptCode_FourCharacter);
                }
                if (regionCode == 0) {
                    result.add(RegionCode_NotSpecified);
                } else if (regionCode == 2) {
                    result.add(RegionCode_TwoBytes);
                } else if (regionCode == 3) {
                    result.add(RegionCode_ThreeBytes);
                }
                return result;
            }

            public static int toByte(EnumSet<LocalSelectorFlag> flags) {
                int result = 0;
                if (flags.contains(LanguageCode_TwoBytes)) {
                    result |= 2;
                } else if (flags.contains(LanguageCode_ThreeBytes)) {
                    result |= 3;
                }
                result <<= 1;
                if (flags.contains(ScriptCode_FourCharacter)) {
                    result |= 1;
                }
                result <<= 3;
                if (flags.contains(RegionCode_TwoBytes)) {
                    result |= 2;
                } else if (flags.contains(RegionCode_ThreeBytes)) {
                    result |= 3;
                }
                return result;
            }

            @Override
            public int getGroup() {
                return this.group;
            }

            static {
                handler = new MutualExclusiveGroupedFlagHandler();
            }
        }
    }

    public static class DataObjectFontDescriptor
    extends Triplet {
        EnumSet<FontInformationFlag> fontInformationFlags;
        short fontTechnology;
        short specifiedVerticalFontSize;
        short horizontalScaleFactor;
        AFPOrientation characterOrientation;
        short encodingEnvironment;
        short encodingIdentifier;
        byte[] reserved14_15 = new byte[]{0, 0};

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.fontInformationFlags = FontInformationFlag.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 2, 1));
            this.fontTechnology = UtilBinaryDecoding.parseShort(sfData, offset + 3, 1);
            this.specifiedVerticalFontSize = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            this.horizontalScaleFactor = UtilBinaryDecoding.parseShort(sfData, offset + 6, 2);
            this.characterOrientation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 8, 2));
            this.encodingEnvironment = UtilBinaryDecoding.parseShort(sfData, offset + 10, 2);
            this.encodingIdentifier = UtilBinaryDecoding.parseShort(sfData, offset + 12, 2);
            this.reserved14_15 = new byte[2];
            System.arraycopy(sfData, offset + 14, this.reserved14_15, 0, this.reserved14_15.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)16;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(FontInformationFlag.toByte(this.fontInformationFlags));
            os.write(this.fontTechnology);
            os.write(UtilBinaryDecoding.shortToByteArray(this.specifiedVerticalFontSize, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.horizontalScaleFactor, 2));
            os.write(this.characterOrientation.toBytes());
            os.write(UtilBinaryDecoding.shortToByteArray(this.encodingEnvironment, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.encodingIdentifier, 2));
            os.write(this.reserved14_15);
        }

        public static enum FontInformationFlag implements IMutualExclusiveGroupedFlag
        {
            MICR_NonMICR(0),
            MICR_MICR(0),
            Location_Anyware(1),
            Location_ResourceGroup(1);

            public static final MutualExclusiveGroupedFlagHandler<FontInformationFlag> handler;
            int group;

            private FontInformationFlag(int group) {
                this.group = group;
            }

            public static EnumSet<FontInformationFlag> valueOf(short codeByte) {
                EnumSet<FontInformationFlag> result = EnumSet.noneOf(FontInformationFlag.class);
                if ((codeByte & 0x80) == 0) {
                    result.add(MICR_NonMICR);
                } else {
                    result.add(MICR_MICR);
                }
                if ((codeByte & 0x40) == 0) {
                    result.add(Location_Anyware);
                } else {
                    result.add(Location_ResourceGroup);
                }
                return result;
            }

            public static int toByte(EnumSet<FontInformationFlag> flags) {
                int result = 0;
                if (flags.contains(MICR_MICR)) {
                    result |= 0x80;
                }
                if (flags.contains(Location_ResourceGroup)) {
                    result |= 0x40;
                }
                return result;
            }

            @Override
            public int getGroup() {
                return this.group;
            }

            static {
                handler = new MutualExclusiveGroupedFlagHandler();
            }
        }
    }

    public static class FinishingFidelity
    extends Triplet {
        ColorFidelity.ExceptionContinuationRule exceptionContinuationRule;
        byte reserved3 = 0;
        ColorFidelity.ExceptionReportingRule exceptionReportingRule;
        byte[] reserved5_6 = new byte[]{0, 0};

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.exceptionContinuationRule = ColorFidelity.ExceptionContinuationRule.valueOf(sfData[offset + 2]);
            this.reserved3 = sfData[offset + 3];
            this.exceptionReportingRule = ColorFidelity.ExceptionReportingRule.valueOf(sfData[offset + 4]);
            this.reserved5_6 = new byte[2];
            System.arraycopy(sfData, offset + 5, this.reserved5_6, 0, this.reserved5_6.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)7;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.exceptionContinuationRule.toByte());
            os.write(this.reserved3);
            os.write(this.exceptionReportingRule.toByte());
            os.write(this.reserved5_6);
        }
    }

    public static class MediaFidelity
    extends Triplet {
        ColorFidelity.ExceptionContinuationRule exceptionContinuationRule;
        byte reserved3 = 0;
        ColorFidelity.ExceptionReportingRule exceptionReportingRule;
        byte[] reserved5_6 = new byte[]{0, 0};

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.exceptionContinuationRule = ColorFidelity.ExceptionContinuationRule.valueOf(sfData[offset + 2]);
            this.reserved3 = sfData[offset + 3];
            this.exceptionReportingRule = ColorFidelity.ExceptionReportingRule.valueOf(sfData[offset + 4]);
            this.reserved5_6 = new byte[2];
            System.arraycopy(sfData, offset + 5, this.reserved5_6, 0, this.reserved5_6.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)7;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.exceptionContinuationRule.toByte());
            os.write(this.reserved3);
            os.write(this.exceptionReportingRule.toByte());
            os.write(this.reserved5_6);
        }
    }

    public static class TextFidelity
    extends Triplet {
        ColorFidelity.ExceptionContinuationRule exceptionContinuationRule;
        byte reserved3 = 0;
        ColorFidelity.ExceptionReportingRule exceptionReportingRule;
        byte[] reserved5_6 = new byte[]{0, 0};

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.exceptionContinuationRule = ColorFidelity.ExceptionContinuationRule.valueOf(sfData[offset + 2]);
            this.reserved3 = sfData[offset + 3];
            this.exceptionReportingRule = ColorFidelity.ExceptionReportingRule.valueOf(sfData[offset + 4]);
            this.reserved5_6 = new byte[2];
            System.arraycopy(sfData, offset + 5, this.reserved5_6, 0, this.reserved5_6.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)7;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.exceptionContinuationRule.toByte());
            os.write(this.reserved3);
            os.write(this.exceptionReportingRule.toByte());
            os.write(this.reserved5_6);
        }
    }

    public static class FinishingOperation
    extends Triplet {
        OperationType operationType;
        byte[] reserved3_4 = new byte[2];
        ReferenceCorner referenceCorner;
        byte operationCount;
        int offsetOfOperation;
        List<Short> positions;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.operationType = OperationType.valueOf(sfData[offset + 2]);
            this.reserved3_4 = new byte[2];
            System.arraycopy(sfData, offset + 2, this.reserved3_4, 0, this.reserved3_4.length);
            this.referenceCorner = ReferenceCorner.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 5, 1));
            this.operationCount = sfData[offset + 6];
            offset = UtilBinaryDecoding.parseInt(sfData, offset + 7, 2);
            if (this.length > 9) {
                this.positions = new ArrayList<Short>();
                for (int pos = 9; pos < this.length; pos += 2) {
                    this.positions.add(UtilBinaryDecoding.parseShort(sfData, offset + pos, 2));
                }
            } else {
                this.positions = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)(this.positions == null ? 9 : 9 + this.positions.size());
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.operationType.toByte());
            os.write(this.reserved3_4);
            os.write(this.referenceCorner.toByte());
            os.write(this.operationCount);
            os.write(UtilBinaryDecoding.intToByteArray(this.offsetOfOperation, 2));
            if (this.positions != null) {
                for (Short s : this.positions) {
                    os.write(UtilBinaryDecoding.shortToByteArray(s, 2));
                }
            }
        }

        public static enum ReferenceCorner {
            BottomRightCorner_BottomEdge(0),
            TopRightCorner_RightEdge(1),
            TopLeftCorner_TopEdge(2),
            BottomLeftCorner_LeftEdge(3),
            DefaultCorner_DefaultEdge(255);

            int code;

            private ReferenceCorner(int code) {
                this.code = code;
            }

            public static ReferenceCorner valueOf(short codeByte) throws AFPParserException {
                for (ReferenceCorner rc : ReferenceCorner.values()) {
                    if (rc.code != codeByte) continue;
                    return rc;
                }
                throw new AFPParserException(ReferenceCorner.class.getSimpleName() + ": corner/edge code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.code;
            }
        }

        public static enum OperationType {
            CornerStaple(1),
            SaddleStitchOut(2),
            EdgeStitch(3),
            FoldIn(4),
            SeparationCut(5),
            PerforationCut(6),
            ZFold(7),
            CenterFoldIn(8),
            TrimAfterCenterFoldOrSaddleStitch(9),
            Punch(10),
            PerfectBind(12),
            RingBind(13),
            SaddleStitchIn(18);

            int code;

            private OperationType(int code) {
                this.code = code;
            }

            public static OperationType valueOf(byte codeValue) throws AFPParserException {
                for (OperationType ot : OperationType.values()) {
                    if (ot.code != codeValue) continue;
                    return ot;
                }
                throw new AFPParserException(OperationType.class.getSimpleName() + ": operation type 0x" + Integer.toHexString(codeValue) + " is undefined.");
            }

            public int toByte() {
                return this.code;
            }
        }
    }

    public static class FontResolutionAndMetricTechnology
    extends Triplet {
        MetricTechnology metricTechnology;
        AFPUnitBase unitBase;
        short unitsPerUnitBase;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.metricTechnology = MetricTechnology.valueOf(sfData[offset + 2]);
            this.unitBase = AFPUnitBase.valueOf(sfData[offset + 3]);
            this.unitsPerUnitBase = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)6;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.metricTechnology.toByte());
            os.write(this.unitBase.toByte());
            os.write(UtilBinaryDecoding.shortToByteArray(this.unitsPerUnitBase, 2));
        }

        public static enum MetricTechnology {
            Fixed,
            Relative;


            public static MetricTechnology valueOf(byte codeByte) throws AFPParserException {
                if (codeByte == 1) {
                    return Fixed;
                }
                if (codeByte == 2) {
                    return Relative;
                }
                throw new AFPParserException(MetricTechnology.class.getSimpleName() + ": technology code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal() + 1;
            }
        }
    }

    public static class PresentationControl
    extends Triplet {
        EnumSet<PresentationControlFlags> presentationControlFlags;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.presentationControlFlags = PresentationControlFlags.valueOf(sfData[offset + 2]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)3;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(PresentationControlFlags.toByte(this.presentationControlFlags));
        }

        public EnumSet<PresentationControlFlags> getPresentationControlFlags() {
            return this.presentationControlFlags;
        }

        public void setPresentationControlFlags(EnumSet<PresentationControlFlags> presentationControlFlags) {
            this.presentationControlFlags = presentationControlFlags;
        }

        public void setPresentationControlFlag(PresentationControlFlags presentationControlFlag) {
            if (presentationControlFlag == null) {
                return;
            }
            if (this.presentationControlFlags == null) {
                this.presentationControlFlags = EnumSet.noneOf(PresentationControlFlags.class);
            }
            PresentationControlFlags.handler.setFlag(this.presentationControlFlags, presentationControlFlag);
        }

        public static enum PresentationControlFlags implements IMutualExclusiveGroupedFlag
        {
            ViewControl_View(0),
            ViewControl_DoNotView(0),
            IndexingControl_Indexing(1),
            IndexingControl_NoIndexing(1);

            public static final MutualExclusiveGroupedFlagHandler<PresentationControlFlags> handler;
            int group;

            private PresentationControlFlags(int group) {
                this.group = group;
            }

            public static EnumSet<PresentationControlFlags> valueOf(byte codeByte) {
                EnumSet<PresentationControlFlags> result = EnumSet.noneOf(PresentationControlFlags.class);
                if ((codeByte & 0x80) == 0) {
                    result.add(ViewControl_View);
                } else {
                    result.add(ViewControl_DoNotView);
                }
                if ((codeByte & 0x40) == 0) {
                    result.add(IndexingControl_Indexing);
                } else {
                    result.add(IndexingControl_NoIndexing);
                }
                return result;
            }

            public static int toByte(EnumSet<PresentationControlFlags> flags) {
                if (flags == null) {
                    return 0;
                }
                int result = 0;
                if (flags.contains(ViewControl_DoNotView)) {
                    result |= 0x50;
                }
                if (flags.contains(IndexingControl_NoIndexing)) {
                    result |= 0x28;
                }
                return result;
            }

            @Override
            public int getGroup() {
                return this.group;
            }

            static {
                handler = new MutualExclusiveGroupedFlagHandler();
            }
        }
    }

    public static class ParameterValue
    extends Triplet {
        byte reserved2 = 0;
        ParameterSyntax parameterSyntax;
        byte[] parameterValue;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2 = sfData[offset + 2];
            this.parameterSyntax = ParameterSyntax.valueOf(sfData[offset + 3]);
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            if (actualLength < 4) {
                this.parameterValue = new byte[actualLength - 4];
                System.arraycopy(sfData, offset + 4, this.parameterValue, 0, this.parameterValue.length);
            } else {
                this.parameterValue = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)(this.parameterValue == null ? 4 : 4 + this.parameterValue.length);
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.parameterSyntax.toByte());
            if (this.parameterValue != null) {
                os.write(this.parameterValue);
            }
        }

        public static enum ParameterSyntax {
            Undefined,
            UnsignedNumber,
            SignedNumber,
            BitString,
            DefinedConstant,
            CharacterString,
            Name;


            public static ParameterSyntax valueOf(byte codeByte) throws AFPParserException {
                for (ParameterSyntax ps : ParameterSyntax.values()) {
                    if (ps.ordinal() != codeByte) continue;
                    return ps;
                }
                throw new AFPParserException(ParameterSyntax.class.getSimpleName() + ": systax code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal();
            }
        }
    }

    public static class PagePositionInformation
    extends Triplet {
        byte repeatingGroupNumber;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.repeatingGroupNumber = sfData[offset + 2];
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)3;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.repeatingGroupNumber);
        }
    }

    public static class AttributeQualifier
    extends Triplet {
        int sequenceNumber;
        int levelNumber;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.sequenceNumber = UtilBinaryDecoding.parseInt(sfData, offset + 2, 4);
            this.levelNumber = UtilBinaryDecoding.parseInt(sfData, offset + 6, 4);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)10;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(UtilBinaryDecoding.intToByteArray(this.sequenceNumber, 4));
            os.write(UtilBinaryDecoding.intToByteArray(this.levelNumber, 4));
        }
    }

    public static class FontFidelity
    extends Triplet {
        ColorFidelity.ExceptionContinuationRule exceptionContinuationRule;
        byte[] reserved3_6 = new byte[4];

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.exceptionContinuationRule = ColorFidelity.ExceptionContinuationRule.valueOf(sfData[offset + 2]);
            this.reserved3_6 = new byte[]{sfData[offset + 3], sfData[offset + 4], sfData[offset + 5], sfData[offset + 6]};
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)7;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.exceptionContinuationRule.toByte());
            os.write(this.reserved3_6);
        }
    }

    public static class ColorFidelity
    extends Triplet {
        ExceptionContinuationRule exceptionContinuationRule;
        byte reserved3 = 0;
        ExceptionReportingRule exceptionReportingRule;
        byte reserved5 = 0;
        ExceptionSubstitutionRule exceptionSubstitutionRule;
        byte reserved7 = 0;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.exceptionContinuationRule = ExceptionContinuationRule.valueOf(sfData[offset + 2]);
            this.reserved3 = sfData[offset + 3];
            this.exceptionReportingRule = ExceptionReportingRule.valueOf(sfData[offset + 4]);
            this.reserved5 = sfData[offset + 5];
            this.exceptionSubstitutionRule = ExceptionSubstitutionRule.valueOf(sfData[offset + 6]);
            this.reserved7 = sfData[offset + 7];
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)8;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.exceptionContinuationRule.toByte());
            os.write(this.reserved3);
            os.write(this.exceptionReportingRule.toByte());
            os.write(this.reserved5);
            os.write(this.exceptionSubstitutionRule.toByte());
            os.write(this.reserved7);
        }

        public static enum ExceptionSubstitutionRule {
            AnySubstitution_Default;


            public static ExceptionSubstitutionRule valueOf(byte ruleByte) throws AFPParserException {
                for (ExceptionSubstitutionRule ecr : ExceptionSubstitutionRule.values()) {
                    if (ecr.ordinal() + 1 != ruleByte) continue;
                    return ecr;
                }
                throw new AFPParserException(ExceptionSubstitutionRule.class.getSimpleName() + ": substitution rule 0x" + Integer.toHexString(ruleByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal() + 1;
            }
        }

        public static enum ExceptionReportingRule {
            Report,
            DoNotReport;


            public static ExceptionReportingRule valueOf(byte ruleByte) throws AFPParserException {
                for (ExceptionReportingRule ecr : ExceptionReportingRule.values()) {
                    if (ecr.ordinal() + 1 != ruleByte) continue;
                    return ecr;
                }
                throw new AFPParserException(ExceptionReportingRule.class.getSimpleName() + ": reporting rule 0x" + Integer.toHexString(ruleByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal() + 1;
            }
        }

        public static enum ExceptionContinuationRule {
            Stop,
            DoNotStop;


            public static ExceptionContinuationRule valueOf(byte ruleByte) throws AFPParserException {
                for (ExceptionContinuationRule ecr : ExceptionContinuationRule.values()) {
                    if (ecr.ordinal() + 1 != ruleByte) continue;
                    return ecr;
                }
                throw new AFPParserException(ExceptionContinuationRule.class.getSimpleName() + ": continuation rule 0x" + Integer.toHexString(ruleByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal() + 1;
            }
        }
    }

    public static class TonerSaver
    extends Triplet {
        byte reserved2 = 0;
        TonerSaverFunction tonerSaverFunction;
        byte[] reserved4_5 = new byte[2];

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2 = sfData[offset + 2];
            this.tonerSaverFunction = TonerSaverFunction.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 3, 1));
            this.reserved4_5 = new byte[]{sfData[offset + 4], sfData[offset + 5]};
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)6;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.reserved2);
            os.write(this.tonerSaverFunction.toByte());
            os.write(this.reserved4_5);
        }

        public static enum TonerSaverFunction {
            DeactivateTonerSaver,
            ActivateTonerSaver,
            DefaultTonerSaverSetting;


            public static TonerSaverFunction valueOf(short codeByte) throws AFPParserException {
                if (codeByte == 0) {
                    return DeactivateTonerSaver;
                }
                if (codeByte == 1) {
                    return ActivateTonerSaver;
                }
                if (codeByte == 255) {
                    return DefaultTonerSaverSetting;
                }
                throw new AFPParserException(TonerSaverFunction.class.getSimpleName() + ": tonser saver function code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                if (this == DefaultTonerSaverSetting) {
                    return 255;
                }
                return this.ordinal();
            }
        }
    }

    public static class UniversalDateAndTimeStamp
    extends Triplet {
        byte reserved2 = 0;
        int year;
        byte monthOfYear;
        byte dayOfMonth;
        byte hourOfDay;
        byte minuteOfHour;
        byte secondOfMinute;
        TimeZone timeZone;
        byte diffHours;
        byte diffMinutes;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2 = sfData[offset + 2];
            this.year = UtilBinaryDecoding.parseInt(sfData, offset + 3, 2);
            this.monthOfYear = sfData[offset + 5];
            this.dayOfMonth = sfData[offset + 6];
            this.hourOfDay = sfData[offset + 7];
            this.minuteOfHour = sfData[offset + 8];
            this.secondOfMinute = sfData[offset + 9];
            this.timeZone = TimeZone.valueOf(sfData[offset + 10]);
            this.diffHours = sfData[offset + 11];
            this.diffMinutes = sfData[offset + 12];
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)13;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.reserved2);
            os.write(UtilBinaryDecoding.intToByteArray(this.year, 2));
            os.write(this.monthOfYear);
            os.write(this.dayOfMonth);
            os.write(this.hourOfDay);
            os.write(this.minuteOfHour);
            os.write(this.secondOfMinute);
            os.write(this.timeZone.toByte());
            os.write(this.diffHours);
            os.write(this.diffMinutes);
        }

        public static enum TimeZone {
            CoordinatedUTC,
            AheadUTC,
            BehindUTC;


            public static TimeZone valueOf(byte codeByte) throws AFPParserException {
                for (TimeZone tz : TimeZone.values()) {
                    if (tz.ordinal() != codeByte) continue;
                    return tz;
                }
                throw new AFPParserException(TimeZone.class.getSimpleName() + ": time zone code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal();
            }
        }
    }

    public static class PresentationSpaceMixingRule
    extends Triplet {
        List<MixingKeywordAndRule> mixingRules;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.mixingRules = new ArrayList<MixingKeywordAndRule>((this.length - 2) / 2);
            for (int pos = 2; pos < this.length; pos += 2) {
                MixingKeywordAndRule mr = new MixingKeywordAndRule();
                mr.keyword = MixingKeyword.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + pos, 1));
                mr.rule = MixingRule.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + pos + 1, 1));
                this.mixingRules.add(mr);
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)(2 + 2 * this.mixingRules.size());
            os.write(this.length);
            os.write(this.tripletID.toByte());
            for (MixingKeywordAndRule mr : this.mixingRules) {
                os.write(mr.toBytes());
            }
        }

        public List<MixingKeywordAndRule> getMixingRules() {
            return this.mixingRules;
        }

        public void setMixingRules(List<MixingKeywordAndRule> mixingRules) {
            this.mixingRules = mixingRules;
        }

        public void addMixingRule(MixingKeywordAndRule mixingRule) {
            if (mixingRule == null) {
                return;
            }
            if (this.mixingRules == null) {
                this.mixingRules = new ArrayList<MixingKeywordAndRule>();
            }
            this.mixingRules.add(mixingRule);
        }

        public void removeMixingRule(MixingKeywordAndRule mixingRule) {
            if (this.mixingRules == null) {
                return;
            }
            this.mixingRules.remove(mixingRule);
        }

        public static class MixingKeywordAndRule {
            MixingKeyword keyword;
            MixingRule rule;

            public byte[] toBytes() {
                byte[] result = new byte[]{(byte)this.keyword.toByte(), (byte)this.rule.toByte()};
                return result;
            }

            public MixingKeyword getKeyword() {
                return this.keyword;
            }

            public void setKeyword(MixingKeyword keyword) {
                this.keyword = keyword;
            }

            public MixingRule getRule() {
                return this.rule;
            }

            public void setRule(MixingRule rule) {
                this.rule = rule;
            }
        }

        public static enum MixingRule {
            Overpaint,
            Underpaint,
            Blend,
            MODCADefaultMixing;


            public static MixingRule valueOf(short xodeByte) throws AFPParserException {
                for (MixingRule mr : MixingRule.values()) {
                    if (mr.ordinal() + 1 != xodeByte) continue;
                    return mr;
                }
                throw new AFPParserException(MixingRule.class.getSimpleName() + ": mixing rule code 0x" + Integer.toHexString(xodeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal() + 1;
            }
        }

        public static enum MixingKeyword {
            BackgroudOnBackground,
            BackgroundOnForeground,
            ForegroundOnBackground,
            ForegroundOnForeground;


            public static MixingKeyword valueOf(short codeByte) throws AFPParserException {
                for (MixingKeyword mk : MixingKeyword.values()) {
                    if (mk.ordinal() + 112 != codeByte) continue;
                    return mk;
                }
                throw new AFPParserException(MixingKeyword.class.getSimpleName() + ": mixing keyword 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal() + 112;
            }
        }
    }

    public static class PresentationSpaceResetMixing
    extends Triplet {
        BackgroundMixingFlag backgroundMixingFlag;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.backgroundMixingFlag = BackgroundMixingFlag.valueOf(sfData[offset + 2]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)3;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.backgroundMixingFlag.toByte());
        }

        public static enum BackgroundMixingFlag {
            DoNotResetColor,
            ResetColor;


            public static BackgroundMixingFlag valueOf(byte codeByte) {
                if (codeByte == 0) {
                    return DoNotResetColor;
                }
                return ResetColor;
            }

            public int toByte() {
                if (this == DoNotResetColor) {
                    return 0;
                }
                return 128;
            }
        }
    }

    public static class ResourceObjectInclude
    extends Triplet {
        short objectType = (short)223;
        String objectName;
        int xOrigin;
        int yOrigin;
        AFPOrientation orientation;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.objectType = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.objectName = UtilCharacterEncoding.decodeEBCDIC(sfData, offset + 3, 8, config);
            this.xOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 11, 3);
            this.yOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 14, 3);
            this.orientation = this.length > 17 ? AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 17, 2)) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)(this.orientation == null ? 17 : 19);
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.objectType);
            os.write(UtilCharacterEncoding.stringToByteArray(this.objectName, config.getAfpCharSet(), 8, (byte)64));
            os.write(UtilBinaryDecoding.intToByteArray(this.xOrigin, 3));
            os.write(UtilBinaryDecoding.intToByteArray(this.yOrigin, 3));
            if (this.orientation != null) {
                os.write(this.orientation.toBytes());
            }
        }
    }

    public static class MediumOrientation
    extends Triplet {
        MediumOrientationValue mediumOrientation;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.mediumOrientation = MediumOrientationValue.valueOf(sfData[offset + 2]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)3;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.mediumOrientation.toByte());
        }

        public static enum MediumOrientationValue {
            Portrait,
            Landscape,
            ReversePortrait,
            ReverseLandscape,
            Portrait90,
            Landscape90;


            public static MediumOrientationValue valueOf(byte codeByte) throws AFPParserException {
                for (MediumOrientationValue v : MediumOrientationValue.values()) {
                    if (v.ordinal() != codeByte) continue;
                    return v;
                }
                throw new AFPParserException(MediumOrientationValue.class.getSimpleName() + ": medium orientation value 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal();
            }
        }
    }

    public static class Comment
    extends Triplet {
        String comment;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.comment = UtilCharacterEncoding.decodeEBCDIC(sfData, offset + 2, this.length - 2, config);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            byte[] data = this.comment.getBytes(config.getAfpCharSet());
            this.length = (short)(data.length + 2);
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(data);
        }
    }

    public static class LocalObjectDateAndTimeStamp
    extends Triplet {
        DateAndTimeStampType dateAndTimeStampType;
        short hundreds;
        int tens;
        int dayOfYear;
        int hourOfDay;
        int minuteOfHour;
        int secondOfMinute;
        int hundredthOfSecond;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.dateAndTimeStampType = DateAndTimeStampType.valueOf(sfData[offset + 2]);
            this.hundreds = UtilBinaryDecoding.parseShort(sfData, offset + 3, 1);
            this.tens = UtilBinaryDecoding.parseInt(sfData, offset + 4, 2);
            this.dayOfYear = UtilBinaryDecoding.parseInt(sfData, offset + 6, 3);
            this.hourOfDay = UtilBinaryDecoding.parseInt(sfData, offset + 9, 2);
            this.minuteOfHour = UtilBinaryDecoding.parseInt(sfData, offset + 11, 2);
            this.secondOfMinute = UtilBinaryDecoding.parseInt(sfData, offset + 13, 2);
            this.hundredthOfSecond = UtilBinaryDecoding.parseShort(sfData, offset + 15, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)17;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.dateAndTimeStampType.toByte());
            os.write(this.hundreds);
            os.write(UtilBinaryDecoding.intToByteArray(this.tens, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.dayOfYear, 3));
            os.write(UtilBinaryDecoding.intToByteArray(this.hourOfDay, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.minuteOfHour, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.secondOfMinute, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.hundredthOfSecond, 2));
        }

        public static enum DateAndTimeStampType {
            Creation,
            RMARK_Retired,
            Revision;


            public static DateAndTimeStampType valueOf(byte codeByte) throws AFPParserException {
                if (codeByte == 0) {
                    return Creation;
                }
                if (codeByte == 1) {
                    return RMARK_Retired;
                }
                if (codeByte == 3) {
                    return Revision;
                }
                throw new AFPParserException(DateAndTimeStampType.class.getSimpleName() + ": type 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                if (this == Creation) {
                    return 0;
                }
                if (this == RMARK_Retired) {
                    return 1;
                }
                if (this == Revision) {
                    return 3;
                }
                return 0;
            }
        }
    }

    public static class ObjectCount
    extends Triplet {
        short subordinateObjectType = (short)250;
        byte reserved3 = 0;
        long numberOfObjectsLow;
        Long numberOfObjectsHigh;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.subordinateObjectType = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.reserved3 = sfData[offset + 3];
            this.numberOfObjectsLow = UtilBinaryDecoding.parseLong(sfData, offset + 4, 4);
            this.numberOfObjectsHigh = this.length > 8 ? Long.valueOf(UtilBinaryDecoding.parseLong(sfData, offset + 8, 4)) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)(this.numberOfObjectsHigh != null ? 12 : 8);
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.subordinateObjectType);
            os.write(this.reserved3);
            os.write(UtilBinaryDecoding.longToByteArray(this.numberOfObjectsLow, 4));
            if (this.numberOfObjectsHigh != null) {
                os.write(UtilBinaryDecoding.longToByteArray(this.numberOfObjectsHigh, 4));
            }
        }
    }

    public static class FontHorizontalScaleFactor
    extends Triplet {
        short horizontalScaleFactor;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.horizontalScaleFactor = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)4;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(UtilBinaryDecoding.shortToByteArray(this.horizontalScaleFactor, 2));
        }
    }

    public static class ObjectOffset
    extends Triplet {
        ObjectType objectType;
        byte reserved3 = 0;
        long nrOfPrecedingObjectsLow;
        Long nrOfPrecedingObjectsHigh;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.objectType = ObjectType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 2, 1));
            this.reserved3 = sfData[offset + 3];
            this.nrOfPrecedingObjectsLow = UtilBinaryDecoding.parseLong(sfData, offset + 4, 4);
            this.nrOfPrecedingObjectsHigh = this.length > 7 ? Long.valueOf(UtilBinaryDecoding.parseLong(sfData, offset + 8, 4)) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)(this.nrOfPrecedingObjectsHigh != null ? 12 : 8);
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.objectType.toByte());
            os.write(this.reserved3);
            os.write(UtilBinaryDecoding.longToByteArray(this.nrOfPrecedingObjectsLow, 4));
            if (this.nrOfPrecedingObjectsHigh != null) {
                os.write(UtilBinaryDecoding.longToByteArray(this.nrOfPrecedingObjectsHigh, 4));
            }
        }

        public static enum ObjectType {
            Document,
            Page_PaginatedObject;


            public static ObjectType valueOf(short codeByte) throws AFPParserException {
                if (codeByte == 168) {
                    return Document;
                }
                if (codeByte == 175) {
                    return Page_PaginatedObject;
                }
                throw new AFPParserException(ObjectType.class.getSimpleName() + ": object type 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                if (this == Document) {
                    return 168;
                }
                if (this == Page_PaginatedObject) {
                    return 175;
                }
                return 0;
            }
        }
    }

    public static class ObjectStructuredFieldExtent
    extends Triplet {
        long numberOfSFLow;
        Long numberOfSFHigh;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.numberOfSFLow = UtilBinaryDecoding.parseLong(sfData, offset + 2, 4);
            this.numberOfSFHigh = this.length > 6 ? Long.valueOf(UtilBinaryDecoding.parseLong(sfData, offset + 6, 4)) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)(this.numberOfSFHigh != null ? 10 : 6);
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(UtilBinaryDecoding.longToByteArray(this.numberOfSFLow, 4));
            if (this.numberOfSFHigh != null) {
                os.write(UtilBinaryDecoding.longToByteArray(this.numberOfSFHigh, 4));
            }
        }
    }

    public static class ObjectStructuredFieldOffset
    extends Triplet {
        long offsetLow;
        Long offsetHigh;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.offsetLow = UtilBinaryDecoding.parseLong(sfData, offset + 2, 4);
            this.offsetHigh = this.length > 6 ? Long.valueOf(UtilBinaryDecoding.parseLong(sfData, offset + 6, 4)) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)(this.offsetHigh != null ? 10 : 6);
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(UtilBinaryDecoding.longToByteArray(this.offsetLow, 4));
            if (this.offsetHigh != null) {
                os.write(UtilBinaryDecoding.longToByteArray(this.offsetHigh, 4));
            }
        }
    }

    public static class ObjectByteExtent
    extends Triplet {
        long byteExtentLow;
        long byteExtentHigh;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.byteExtentLow = UtilBinaryDecoding.parseLong(sfData, offset + 2, 4);
            this.byteExtentHigh = UtilBinaryDecoding.parseLong(sfData, offset + 6, 4);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)10;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(UtilBinaryDecoding.longToByteArray(this.byteExtentLow, 4));
            os.write(UtilBinaryDecoding.longToByteArray(this.byteExtentHigh, 4));
        }
    }

    public static class MediumMapPageNumber
    extends Triplet {
        int pageNumber;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.pageNumber = UtilBinaryDecoding.parseInt(sfData, offset + 2, 4);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)4;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(UtilBinaryDecoding.intToByteArray(this.pageNumber, 4));
        }
    }

    public static class EncodingSchemeID
    extends Triplet {
        EnumSet<EncodingScheme> encodingSchemeForCodePage;
        EnumSet<EncodingScheme> encodingSchemeForUserData;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.encodingSchemeForCodePage = EncodingScheme.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 2, 2));
            this.encodingSchemeForUserData = length > 4 ? EncodingScheme.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 4, 2)) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)(this.encodingSchemeForUserData == null ? 4 : 6);
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(EncodingScheme.toBytes(this.encodingSchemeForCodePage));
            if (this.encodingSchemeForUserData != null) {
                os.write(EncodingScheme.toBytes(this.encodingSchemeForUserData));
            }
        }

        public EnumSet<EncodingScheme> getEncodingSchemeForCodePage() {
            return this.encodingSchemeForCodePage;
        }

        public void setEncodingSchemeForCodePage(EncodingScheme encodingScheme) {
            if (this.encodingSchemeForCodePage == null) {
                this.encodingSchemeForCodePage = EnumSet.noneOf(EncodingScheme.class);
            }
            EncodingScheme.handler.setFlag(this.encodingSchemeForCodePage, encodingScheme);
        }

        public void setEncodingSchemeForCodePage(EnumSet<EncodingScheme> encodingSchemeForCodePage) {
            this.encodingSchemeForCodePage = encodingSchemeForCodePage;
        }

        public EnumSet<EncodingScheme> getEncodingSchemeForUserData() {
            return this.encodingSchemeForUserData;
        }

        public void setEncodingSchemeForUserData(EnumSet<EncodingScheme> encodingSchemeForUserData) {
            this.encodingSchemeForUserData = encodingSchemeForUserData;
        }

        public static enum EncodingScheme implements IMutualExclusiveGroupedFlag
        {
            BasicEncoding_NotSpecified(0),
            BasicEncoding_IBMPC_Data(0),
            BasicEncoding_IBMPC_Display(0),
            BasicEncoding_EBCDIC_Presentation(0),
            BasicEncoding_UTF16(0),
            BasicEncoding_UnicodePresentation(0),
            NumberOfBytes_NotSpecified(1),
            NumberOfBytes_Fixed_SingleByte(1),
            NumberOfBytes_Fixed_DoubleByte(1),
            NumberOfBytes_UTFnVariable(1),
            CodeExtension_NotSpecified(2),
            CodeExtension_UTF8(2);

            public static final MutualExclusiveGroupedFlagHandler<EncodingScheme> handler;
            int group;

            private EncodingScheme(int code) {
                this.group = code;
            }

            public static EnumSet<EncodingScheme> valueOf(int code) throws AFPParserException {
                int basicEncoding = code >>> 12;
                int numberOfBytes = code >> 8 & 0xF;
                int extension = code & 0xFF;
                EnumSet<EncodingScheme> result = EnumSet.noneOf(EncodingScheme.class);
                if (basicEncoding == 0) {
                    result.add(BasicEncoding_NotSpecified);
                } else if (basicEncoding == 2) {
                    result.add(BasicEncoding_IBMPC_Data);
                } else if (basicEncoding == 3) {
                    result.add(BasicEncoding_IBMPC_Display);
                } else if (basicEncoding == 6) {
                    result.add(BasicEncoding_EBCDIC_Presentation);
                } else if (basicEncoding == 7) {
                    result.add(BasicEncoding_UTF16);
                } else if (basicEncoding == 8) {
                    result.add(BasicEncoding_UnicodePresentation);
                } else {
                    throw new AFPParserException(EncodingScheme.class.getSimpleName() + ": basic encoding value 0x" + Integer.toHexString(basicEncoding) + " is undefined.");
                }
                if (numberOfBytes == 0) {
                    result.add(NumberOfBytes_NotSpecified);
                } else if (numberOfBytes == 1) {
                    result.add(NumberOfBytes_Fixed_SingleByte);
                } else if (numberOfBytes == 2) {
                    result.add(NumberOfBytes_Fixed_SingleByte);
                } else if (numberOfBytes == 8) {
                    result.add(NumberOfBytes_UTFnVariable);
                } else {
                    throw new AFPParserException(EncodingScheme.class.getSimpleName() + ": number of bytes value 0x" + Integer.toHexString(numberOfBytes) + " is undefined.");
                }
                if (extension == 0) {
                    result.add(CodeExtension_NotSpecified);
                } else if (extension == 7) {
                    result.add(CodeExtension_UTF8);
                }
                return result;
            }

            public static byte[] toBytes(EnumSet<EncodingScheme> flags) {
                int result = 0;
                if (flags.contains(BasicEncoding_IBMPC_Data)) {
                    result |= 2;
                } else if (flags.contains(BasicEncoding_IBMPC_Display)) {
                    result |= 3;
                } else if (flags.contains(BasicEncoding_EBCDIC_Presentation)) {
                    result |= 6;
                } else if (flags.contains(BasicEncoding_UTF16)) {
                    result |= 7;
                } else if (flags.contains(BasicEncoding_UnicodePresentation)) {
                    result |= 8;
                }
                result <<= 4;
                if (flags.contains(NumberOfBytes_Fixed_SingleByte)) {
                    result |= 1;
                } else if (flags.contains(NumberOfBytes_Fixed_DoubleByte)) {
                    result |= 2;
                } else if (flags.contains(NumberOfBytes_UTFnVariable)) {
                    result |= 8;
                }
                result <<= 8;
                if (flags.contains(CodeExtension_UTF8)) {
                    result |= 7;
                }
                return UtilBinaryDecoding.intToByteArray(result, 2);
            }

            @Override
            public int getGroup() {
                return this.group;
            }

            static {
                handler = new MutualExclusiveGroupedFlagHandler();
            }
        }
    }

    public static class ColorSpecification
    extends Triplet {
        byte reserved2 = 0;
        AFPColorSpace colorSpace;
        byte[] reserved4_7 = new byte[4];
        byte nrOfBitsComponent1;
        byte nrOfBitsComponent2;
        byte nrOfBitsComponent3;
        byte nrOfBitsComponent4;
        byte[] colorValue;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2 = sfData[offset + 2];
            this.colorSpace = AFPColorSpace.valueOf(sfData[offset + 3]);
            this.reserved4_7 = new byte[4];
            System.arraycopy(sfData, offset + 4, this.reserved4_7, 0, this.reserved4_7.length);
            this.nrOfBitsComponent1 = sfData[offset + 8];
            this.nrOfBitsComponent2 = sfData[offset + 9];
            this.nrOfBitsComponent3 = sfData[offset + 10];
            this.nrOfBitsComponent4 = sfData[offset + 11];
            this.colorValue = new byte[length - 12];
            System.arraycopy(sfData, offset + 12, this.colorValue, 0, this.colorValue.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)(12 + this.colorValue.length);
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.reserved2);
            os.write(this.colorSpace.toByte());
            os.write(this.reserved4_7);
            os.write(this.nrOfBitsComponent1);
            os.write(this.nrOfBitsComponent2);
            os.write(this.nrOfBitsComponent3);
            os.write(this.nrOfBitsComponent4);
            os.write(this.colorValue);
        }
    }

    public static class AreaDefinition
    extends Triplet {
        byte reserved2 = 0;
        int xOrigin;
        int yOrigin;
        int xSize;
        int ySize;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 15);
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2 = sfData[offset + 2];
            this.xOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 3, 3);
            this.yOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 6, 3);
            this.xSize = UtilBinaryDecoding.parseInt(sfData, offset + 9, 3);
            this.ySize = UtilBinaryDecoding.parseInt(sfData, offset + 12, 3);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)15;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.reserved2);
            os.write(UtilBinaryDecoding.intToByteArray(this.xOrigin, 3));
            os.write(UtilBinaryDecoding.intToByteArray(this.yOrigin, 3));
            os.write(UtilBinaryDecoding.intToByteArray(this.xSize, 3));
            os.write(UtilBinaryDecoding.intToByteArray(this.ySize, 3));
        }
    }

    public static class ObjectAreaSize
    extends Triplet {
        byte sizeType_0x02;
        int xSize;
        int ySize;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 9);
            super.decodeAFP(sfData, offset, length, config);
            this.sizeType_0x02 = sfData[offset + 2];
            this.xSize = UtilBinaryDecoding.parseInt(sfData, offset + 3, 3);
            this.ySize = UtilBinaryDecoding.parseInt(sfData, offset + 6, 3);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)9;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.sizeType_0x02);
            os.write(UtilBinaryDecoding.intToByteArray(this.xSize, 3));
            os.write(UtilBinaryDecoding.intToByteArray(this.ySize, 3));
        }
    }

    public static class MeasurementUnits
    extends Triplet {
        AFPUnitBase xUnitBase;
        AFPUnitBase yUnitBase;
        short xUnitsPerUnitbase;
        short yUnitsPerUnitbase;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 8);
            super.decodeAFP(sfData, offset, length, config);
            this.xUnitBase = AFPUnitBase.valueOf(sfData[offset + 2]);
            this.yUnitBase = AFPUnitBase.valueOf(sfData[offset + 3]);
            this.xUnitsPerUnitbase = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            this.yUnitsPerUnitbase = UtilBinaryDecoding.parseShort(sfData, offset + 6, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)8;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.xUnitBase.toByte());
            os.write(this.yUnitBase.toByte());
            os.write(UtilBinaryDecoding.shortToByteArray(this.xUnitsPerUnitbase, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.yUnitsPerUnitbase, 2));
        }
    }

    public static class LineDataObjectPositionMigration
    extends Triplet {
        LocationAndOrientation locationAndOrientation;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 3);
            super.decodeAFP(sfData, offset, length, config);
            this.locationAndOrientation = LocationAndOrientation.valueOf(sfData[offset + 2]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)3;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.locationAndOrientation.toByte());
        }

        public static enum LocationAndOrientation {
            Standard_0,
            LowerLeft_270,
            LowerRight_180,
            UperRight_90;


            public static LocationAndOrientation valueOf(byte codeByte) throws AFPParserException {
                for (LocationAndOrientation lao : LocationAndOrientation.values()) {
                    if (lao.ordinal() != codeByte) continue;
                    return lao;
                }
                throw new AFPParserException(LocationAndOrientation.class.getSimpleName() + ": location/orientation code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal();
            }
        }
    }

    public static class TextOrientation
    extends Triplet {
        AFPOrientation xOrientation;
        AFPOrientation yOrientation;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 6);
            super.decodeAFP(sfData, offset, length, config);
            this.xOrientation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 2, 2));
            this.yOrientation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 4, 2));
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)6;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.xOrientation.toBytes());
            os.write(this.yOrientation.toBytes());
        }
    }

    public static class IMMInsertionTriplet
    extends Triplet {
        byte[] reserved2_3 = new byte[2];

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 4);
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2_3 = new byte[2];
            System.arraycopy(sfData, offset + 2, this.reserved2_3, 0, this.reserved2_3.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)4;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.reserved2_3);
        }
    }

    public static class ObjectOriginIdentifier
    extends Triplet {
        AFPSystem originationSystem;
        String systemIDSerialNumber;
        String storageMediaID;
        String dataSetID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 61);
            super.decodeAFP(sfData, offset, length, config);
            this.originationSystem = AFPSystem.valueOf(sfData[offset + 2]);
            this.systemIDSerialNumber = new String(sfData, offset + 3, 8, config.getAfpCharSet());
            this.storageMediaID = new String(sfData, offset + 11, 6, config.getAfpCharSet());
            this.dataSetID = new String(sfData, offset + 17, 44, config.getAfpCharSet());
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)61;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.originationSystem.toByte());
            os.write(UtilCharacterEncoding.stringToByteArray(this.systemIDSerialNumber, config.getAfpCharSet(), 8, (byte)64));
            os.write(UtilCharacterEncoding.stringToByteArray(this.storageMediaID, config.getAfpCharSet(), 6, (byte)64));
            os.write(UtilCharacterEncoding.stringToByteArray(this.dataSetID, config.getAfpCharSet(), 44, (byte)64));
        }

        public static enum AFPSystem {
            MVS,
            VM,
            PC_DOS,
            VSE;


            public static AFPSystem valueOf(byte codeByte) throws AFPParserException {
                if (codeByte == 1) {
                    return MVS;
                }
                if (codeByte == 2) {
                    return VM;
                }
                if (codeByte == 3) {
                    return PC_DOS;
                }
                if (codeByte == 4) {
                    return VSE;
                }
                throw new AFPParserException(AFPSystem.class.getSimpleName() + ": system code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                return this.ordinal() + 1;
            }
        }
    }

    public static class ObjectChecksum
    extends Triplet {
        CheckSumFormat checksumFormat;
        int crcCheckSum;
        EnumSet<ChecksumFlag> objectCheckSumFlags;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 6);
            super.decodeAFP(sfData, offset, length, config);
            this.checksumFormat = CheckSumFormat.valueOf(sfData[offset + 2]);
            this.crcCheckSum = UtilBinaryDecoding.parseInt(sfData, offset + 3, 2);
            this.objectCheckSumFlags = ChecksumFlag.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 5, 1));
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)6;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.checksumFormat.toByte());
            os.write(UtilBinaryDecoding.intToByteArray(this.crcCheckSum, 2));
            os.write(ChecksumFlag.toByte(this.objectCheckSumFlags));
        }

        public CheckSumFormat getChecksumFormat() {
            return this.checksumFormat;
        }

        public void setChecksumFormat(CheckSumFormat checksumFormat) {
            this.checksumFormat = checksumFormat;
        }

        public int getCrcCheckSum() {
            return this.crcCheckSum;
        }

        public void setCrcCheckSum(int crcCheckSum) {
            this.crcCheckSum = crcCheckSum;
        }

        public EnumSet<ChecksumFlag> getObjectCheckSumFlags() {
            return this.objectCheckSumFlags;
        }

        public void setObjectCheckSumFlags(EnumSet<ChecksumFlag> objectCheckSumFlags) {
            this.objectCheckSumFlags = objectCheckSumFlags;
        }

        public void setObjectCheckSumFlag(EnumSet<ChecksumFlag> objectCheckSumFlags, ChecksumFlag flag) {
            ChecksumFlag.handler.setFlag(objectCheckSumFlags, flag);
        }

        public static enum ChecksumFlag implements IMutualExclusiveGroupedFlag
        {
            UsageScope_PublicUnlimited(0),
            UsageScope_PrivateLimited(0),
            ResourceRetention_SaveResource(1),
            ResourceRetention_DoNotSaveResource(1);

            public static final MutualExclusiveGroupedFlagHandler<ChecksumFlag> handler;
            int group;

            private ChecksumFlag(int group) {
                this.group = group;
            }

            public static EnumSet<ChecksumFlag> valueOf(short codByte) {
                EnumSet<ChecksumFlag> result = EnumSet.noneOf(ChecksumFlag.class);
                if ((codByte & 0x80) == 0) {
                    result.add(UsageScope_PublicUnlimited);
                } else {
                    result.add(UsageScope_PrivateLimited);
                }
                if ((codByte & 0x40) == 0) {
                    result.add(ResourceRetention_SaveResource);
                } else {
                    result.add(ResourceRetention_DoNotSaveResource);
                }
                return result;
            }

            public static int toByte(EnumSet<ChecksumFlag> set) {
                int result = 0;
                if (set.contains(UsageScope_PrivateLimited)) {
                    result |= 0x80;
                }
                if (set.contains(ResourceRetention_DoNotSaveResource)) {
                    result |= 0x40;
                }
                return result;
            }

            @Override
            public int getGroup() {
                return this.group;
            }

            static {
                handler = new MutualExclusiveGroupedFlagHandler();
            }
        }

        public static enum CheckSumFormat {
            ObjectCycleRedundancyCheck,
            Retired_PrivateUse;


            public static CheckSumFormat valueOf(byte codeByte) throws AFPParserException {
                if (codeByte == 1) {
                    return ObjectCycleRedundancyCheck;
                }
                if (codeByte == 2) {
                    return Retired_PrivateUse;
                }
                throw new AFPParserException(CheckSumFormat.class.getSimpleName() + ": checksum format code 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                if (this == ObjectCycleRedundancyCheck) {
                    return 1;
                }
                return 2;
            }
        }
    }

    public static class ResourceUsageAttribute
    extends Triplet {
        FrequencyOfUse frequencyOfUse;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.frequencyOfUse = FrequencyOfUse.valueOf(sfData[offset + 2]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)3;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.frequencyOfUse.toByte());
        }

        public static enum FrequencyOfUse {
            Low,
            High;


            public static FrequencyOfUse valueOf(byte codeByte) {
                if (codeByte == 0) {
                    return Low;
                }
                return High;
            }

            public int toByte() {
                if (this == Low) {
                    return 0;
                }
                return 255;
            }
        }
    }

    public static class PageOverlayConditionalProcessing
    extends Triplet {
        PageOverlayType pageOverlayType;
        Short levelOfOverlay;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.pageOverlayType = PageOverlayType.valueOf(sfData[offset + 2]);
            this.levelOfOverlay = length > 3 ? Short.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 3, 1)) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)(this.levelOfOverlay == null ? 3 : 4);
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.pageOverlayType.toByte());
            if (this.levelOfOverlay != null) {
                os.write(this.levelOfOverlay.shortValue());
            }
        }

        public static enum PageOverlayType {
            Normal,
            Annotation,
            Redaction,
            Highlight;


            public static PageOverlayType valueOf(byte codeByte) throws AFPParserException {
                for (PageOverlayType loo : PageOverlayType.values()) {
                    if (loo.ordinal() != codeByte) continue;
                    return loo;
                }
                throw new AFPParserException(PageOverlayType.class.getSimpleName() + ": page overlay type 0x" + Integer.toHexString(codeByte) + " is unknown.");
            }

            public int toByte() {
                return this.ordinal();
            }
        }
    }

    public static class MediaEjectControl
    extends Triplet {
        byte reserved2 = 0;
        MediaEjectControlType mediaEjectControl;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2 = sfData[offset + 2];
            this.mediaEjectControl = MediaEjectControlType.valueOf(sfData[offset + 3]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)4;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.reserved2);
            os.write(this.mediaEjectControl.toByte());
        }

        public static enum MediaEjectControlType {
            EjectToNewSheet,
            ConditionalEjectToNextPartition,
            ConditionalEjectToNextFrontsidePartition,
            ConditionalEjectToNextBacksidePartition;


            public static MediaEjectControlType valueOf(byte codeByte) throws AFPParserException {
                if (codeByte == 1) {
                    return EjectToNewSheet;
                }
                if (codeByte == 2) {
                    return ConditionalEjectToNextPartition;
                }
                if (codeByte == 3) {
                    return ConditionalEjectToNextFrontsidePartition;
                }
                if (codeByte == 4) {
                    return ConditionalEjectToNextBacksidePartition;
                }
                throw new AFPParserException(MediaEjectControlType.class.getSimpleName() + ": code byte 0x" + Integer.toHexString(codeByte) + " is undefined.");
            }

            public int toByte() {
                if (this == EjectToNewSheet) {
                    return 1;
                }
                if (this == ConditionalEjectToNextPartition) {
                    return 2;
                }
                if (this == ConditionalEjectToNextFrontsidePartition) {
                    return 3;
                }
                if (this == ConditionalEjectToNextBacksidePartition) {
                    return 4;
                }
                return 0;
            }
        }
    }

    public static class DescriptorPosition
    extends Triplet {
        short objectAreaDescriptorID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 3);
            super.decodeAFP(sfData, offset, length, config);
            this.objectAreaDescriptorID = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)3;
            os.write(this.length);
            os.write(this.tripletID.toByte());
            os.write(this.objectAreaDescriptorID);
        }
    }

    public static class AttributeValue
    extends Triplet {
        byte[] reserved2_3 = new byte[2];
        String attributeValue;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2_3 = new byte[2];
            System.arraycopy(sfData, offset + 2, this.reserved2_3, 0, 2);
            this.attributeValue = length > 4 ? new String(sfData, offset + 4, length - 4, config.getAfpCharSet()) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.tripletID.toByte());
            baos.write(this.reserved2_3);
            if (this.attributeValue != null) {
                baos.write(this.attributeValue.getBytes(config.getAfpCharSet()));
            }
            this.length = (short)(baos.size() + 1);
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(baos.toByteArray());
        }

        public byte[] getReserved2_3() {
            return this.reserved2_3;
        }

        public void setReserved2_3(byte[] reserved2_3) {
            this.reserved2_3 = reserved2_3;
        }

        public String getAttributeValue() {
            return this.attributeValue;
        }

        public void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }
    }

    public static class ObjectByteOffset
    extends Triplet {
        long byteOffset;
        Long byteOffsetHighOrder;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.byteOffset = UtilBinaryDecoding.parseLong(sfData, offset + 2, 4);
            this.byteOffsetHighOrder = length > 6 ? Long.valueOf(UtilBinaryDecoding.parseLong(sfData, offset + 6, 4)) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)(this.byteOffsetHighOrder == null ? 6 : 10);
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(this.tripletID.toByte());
            os.write(UtilBinaryDecoding.longToByteArray(this.byteOffset, 4));
            if (this.byteOffsetHighOrder != null) {
                os.write(UtilBinaryDecoding.longToByteArray(this.byteOffsetHighOrder, 4));
            }
        }
    }

    public static class CharacterRotation
    extends Triplet {
        AFPOrientation characterRotation;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 4);
            super.decodeAFP(sfData, offset, length, config);
            this.characterRotation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 2, 2));
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)4;
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(this.tripletID.toByte());
            os.write(this.characterRotation.toBytes());
        }
    }

    public static class ResourceSectionNumber
    extends Triplet {
        short resourceSectionNumber;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 3);
            super.decodeAFP(sfData, offset, length, config);
            this.resourceSectionNumber = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)3;
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(this.tripletID.toByte());
            os.write(UtilBinaryDecoding.shortToByteArray(this.resourceSectionNumber, 1));
        }
    }

    public static class ResourceLocalIdentifier
    extends Triplet {
        RLI_ResourceType resourceType;
        short resourceLocalID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 4);
            super.decodeAFP(sfData, offset, length, config);
            this.resourceType = RLI_ResourceType.valueOf(sfData[offset + 2]);
            this.resourceLocalID = UtilBinaryDecoding.parseShort(sfData, offset + 3, 1);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.length = (short)4;
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(this.tripletID.toByte());
            os.write(this.resourceType.toByte());
            os.write(UtilBinaryDecoding.shortToByteArray(this.resourceLocalID, 1));
        }

        public static enum RLI_ResourceType {
            UsageDependent,
            PageOverlay,
            CodedFont,
            ColorAttributeTable;


            public static RLI_ResourceType valueOf(byte codeByte) throws AFPParserException {
                if (codeByte == 0) {
                    return UsageDependent;
                }
                if (codeByte == 2) {
                    return PageOverlay;
                }
                if (codeByte == 5) {
                    return CodedFont;
                }
                if (codeByte == 7) {
                    return ColorAttributeTable;
                }
                throw new AFPParserException(RLI_ResourceType.class.getSimpleName() + ": resource type code 0x" + Integer.toHexString(codeByte) + " is unknown.");
            }

            public int toByte() {
                if (this == UsageDependent) {
                    return 0;
                }
                if (this == PageOverlay) {
                    return 2;
                }
                if (this == CodedFont) {
                    return 5;
                }
                if (this == ColorAttributeTable) {
                    return 7;
                }
                return 0;
            }
        }
    }

    public static class ExtendedResourceLocalIdentifier
    extends Triplet {
        ERLI_ResourceType resourceType;
        long extendedResourceLocalID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 7);
            super.decodeAFP(sfData, offset, length, config);
            this.resourceType = ERLI_ResourceType.valueOf(sfData[offset + 2]);
            this.extendedResourceLocalID = UtilBinaryDecoding.parseLong(sfData, offset + 3, 4);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.tripletID.toByte());
            baos.write(this.resourceType.toByte());
            baos.write(UtilBinaryDecoding.longToByteArray(this.extendedResourceLocalID, 4));
            this.length = (short)(baos.size() + 1);
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(baos.toByteArray());
        }

        public static enum ERLI_ResourceType {
            IOBReference_Reserved,
            MediaTypeResource,
            MediaDestinationResource;


            public static ERLI_ResourceType valueOf(byte codeByte) throws AFPParserException {
                if (codeByte == 48) {
                    return IOBReference_Reserved;
                }
                if (codeByte == 64) {
                    return MediaTypeResource;
                }
                if (codeByte == 66) {
                    return MediaDestinationResource;
                }
                throw new AFPParserException(ERLI_ResourceType.class.getSimpleName() + ": resource type code 0x" + Integer.toHexString(codeByte) + " is unknown.");
            }

            public int toByte() {
                if (this == IOBReference_Reserved) {
                    return 48;
                }
                if (this == MediaTypeResource) {
                    return 64;
                }
                if (this == MediaDestinationResource) {
                    return 66;
                }
                return 0;
            }
        }
    }

    public static class ObjectFunctionSetSpecification_Retired
    extends Triplet {
        ResourceObjectType.ROT_ObjectType objectType;
        byte ocaArchitectureLevel;
        int modcaFunctionSetIdentifier;
        OCAFunctionSet ocaFunctionSet;
        byte[] reserved;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.objectType = ResourceObjectType.ROT_ObjectType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 2, 1));
            this.ocaArchitectureLevel = sfData[offset + 3];
            this.modcaFunctionSetIdentifier = UtilBinaryDecoding.parseInt(sfData, offset + 4, 2);
            this.ocaFunctionSet = OCAFunctionSet.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 6, 2));
            if (length > 8) {
                this.reserved = new byte[length - 8];
                System.arraycopy(sfData, offset + 8, this.reserved, 0, this.reserved.length);
            } else {
                this.reserved = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.tripletID.toByte());
            baos.write(this.objectType.toByte());
            baos.write(this.ocaArchitectureLevel);
            baos.write(UtilBinaryDecoding.intToByteArray(this.modcaFunctionSetIdentifier, 2));
            baos.write(this.ocaFunctionSet.toByte());
            if (this.reserved != null) {
                baos.write(this.reserved);
            }
            this.length = (short)(baos.size() + 1);
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(baos.toByteArray());
        }

        public static enum OCAFunctionSet {
            PTOCA_PT1_or_BCOCA_BCD1(0),
            PTOCA_PT2_or_GOCA_DR2V0(16384),
            IOCA_FS10(32768);

            int code;

            private OCAFunctionSet(int code) {
                this.code = code;
            }

            public static OCAFunctionSet valueOf(int code) throws AFPParserException {
                for (OCAFunctionSet fs : OCAFunctionSet.values()) {
                    if (fs.code != code) continue;
                    return fs;
                }
                throw new AFPParserException(OCAFunctionSet.class.getSimpleName() + ": code 0x" + Integer.toHexString(code) + " is unknown.");
            }

            public int toByte() {
                return this.code;
            }
        }
    }

    public static class ResourceObjectType
    extends Triplet {
        ROT_ObjectType objectType;
        byte[] constantData;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.objectType = ROT_ObjectType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 2, 1));
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            this.constantData = new byte[actualLength - 3];
            System.arraycopy(sfData, offset + 3, this.constantData, 0, this.constantData.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.tripletID.toByte());
            baos.write(this.objectType.toByte());
            baos.write(this.constantData);
            this.length = (short)(baos.size() + 1);
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(baos.toByteArray());
        }

        public static enum ROT_ObjectType {
            PresentationText(2),
            GraphicsObject_GOCA(3),
            BarCodeObject_BCOCA(5),
            ImageObject_IOCA(6),
            FontCharacterSetObject(64),
            CodePageObject(65),
            CodedFontObject(66),
            ObjectContainer(146),
            DocumentObject(168),
            PageSegmentObject(251),
            OverlayObject(252),
            Reserved(253),
            FormMapObject(254);

            int code;

            private ROT_ObjectType(int code) {
                this.code = code;
            }

            public static ROT_ObjectType valueOf(short codeByte) throws AFPParserException {
                for (ROT_ObjectType t : ROT_ObjectType.values()) {
                    if (t.code != codeByte) continue;
                    return t;
                }
                throw new AFPParserException(ROT_ObjectType.class.getSimpleName() + ": type 0x" + Integer.toHexString(codeByte) + " is unknown.");
            }

            public int toByte() {
                return this.code;
            }
        }
    }

    public static class FontCodedGraphicCharacterSetGlobalID
    extends Triplet {
        int codedGraphicCharacterSetGlobalID;
        int codePageGlobalID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.codedGraphicCharacterSetGlobalID = UtilBinaryDecoding.parseInt(sfData, offset + 2, 2);
            this.codePageGlobalID = UtilBinaryDecoding.parseInt(sfData, offset + 4, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.tripletID.toByte());
            baos.write(UtilBinaryDecoding.intToByteArray(this.codedGraphicCharacterSetGlobalID, 2));
            baos.write(UtilBinaryDecoding.intToByteArray(this.codePageGlobalID, 2));
            this.length = (short)(baos.size() + 1);
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(baos.toByteArray());
        }
    }

    public static class FontDescriptorSpecification
    extends Triplet {
        FDS_FontWeigthClass fontWeigthClass;
        FDS_FontWidthClass fontWidthClass;
        short fontHeight;
        short fontWidth;
        EnumSet<FDS_FontDsFlag> fontDsFlags;
        byte[] reserved9_18;
        EnumSet<FDS_FontUsFlag> fontUsFlags;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 9);
            super.decodeAFP(sfData, offset, length, config);
            this.fontWeigthClass = FDS_FontWeigthClass.valueOf(sfData[offset + 2]);
            this.fontWidthClass = FDS_FontWidthClass.valueOf(sfData[offset + 3]);
            this.fontHeight = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            this.fontWidth = UtilBinaryDecoding.parseShort(sfData, offset + 6, 2);
            this.fontDsFlags = FDS_FontDsFlag.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 8, 1));
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            if (actualLength > 9) {
                this.reserved9_18 = new byte[10];
                System.arraycopy(sfData, offset + 9, this.reserved9_18, 0, this.reserved9_18.length);
            } else {
                this.reserved9_18 = null;
            }
            this.fontUsFlags = actualLength > 19 ? FDS_FontUsFlag.valueOf(sfData[offset + 19]) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.tripletID.toByte());
            baos.write(this.fontWeigthClass.toByte());
            baos.write(this.fontWidthClass.toByte());
            baos.write(UtilBinaryDecoding.shortToByteArray(this.fontHeight, 2));
            baos.write(UtilBinaryDecoding.shortToByteArray(this.fontWidth, 2));
            baos.write(FDS_FontDsFlag.toByte(this.fontDsFlags));
            if (this.reserved9_18 != null) {
                baos.write(this.reserved9_18);
                if (this.fontUsFlags != null) {
                    baos.write(FDS_FontUsFlag.toByte(this.fontUsFlags));
                }
            }
            this.length = (short)(baos.size() + 1);
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(baos.toByteArray());
        }

        public static enum FDS_FontUsFlag implements IMutualExclusiveGroupedFlag
        {
            FontType_BitmapFont(1),
            FontType_OutlineOrVector(1),
            TransformFont_WillNotBeTransformed(2),
            TransformFont_MayBeTransformed(2);

            static MutualExclusiveGroupedFlagHandler<FDS_FontUsFlag> handler;
            int group;

            private FDS_FontUsFlag(int group) {
                this.group = group;
            }

            public static EnumSet<FDS_FontUsFlag> valueOf(byte flagByte) {
                EnumSet<FDS_FontUsFlag> result = EnumSet.noneOf(FDS_FontUsFlag.class);
                if ((flagByte & 0x40) == 0) {
                    result.add(FontType_BitmapFont);
                } else {
                    result.add(FontType_OutlineOrVector);
                }
                if ((flagByte & 0x20) == 0) {
                    result.add(TransformFont_WillNotBeTransformed);
                } else {
                    result.add(TransformFont_MayBeTransformed);
                }
                return result;
            }

            public static int toByte(EnumSet<FDS_FontUsFlag> flags) {
                int result = 0;
                if (flags.contains(FontType_OutlineOrVector)) {
                    result |= 0x40;
                }
                if (flags.contains(TransformFont_MayBeTransformed)) {
                    result |= 0x20;
                }
                return result;
            }

            public static void setFlag(EnumSet<FDS_FontUsFlag> flags, FDS_FontUsFlag flag) {
                handler.setFlag(flags, flag);
            }

            @Override
            public int getGroup() {
                return this.group;
            }

            static {
                handler = new MutualExclusiveGroupedFlagHandler();
            }
        }

        public static enum FDS_FontDsFlag implements IMutualExclusiveGroupedFlag
        {
            NoItalicCharacters(0),
            ItalicCharacters(0),
            NoUnderscoredCharacters(1),
            UnderscoredCharacters(1),
            NoHollowCharacters(3),
            HollowCharacters(3),
            NoOverstruckCharacters(4),
            OverstruckCharacters(4),
            UniformlySpacedCharacters(5),
            ProportionallyCharacters(5),
            NoPairwiseKernedCharacters(6),
            PairwiseKernedCharacters(6),
            ParameterIsNotSpecified(7),
            ParameterIsSpecified(7);

            static MutualExclusiveGroupedFlagHandler<FDS_FontDsFlag> handler;
            int group;

            private FDS_FontDsFlag(int group) {
                this.group = group;
            }

            public static EnumSet<FDS_FontDsFlag> valueOf(short flagByte) {
                EnumSet<FDS_FontDsFlag> result = EnumSet.noneOf(FDS_FontDsFlag.class);
                if ((flagByte & 0x80) == 0) {
                    result.add(NoItalicCharacters);
                } else {
                    result.add(ItalicCharacters);
                }
                if ((flagByte & 0x40) == 0) {
                    result.add(NoUnderscoredCharacters);
                } else {
                    result.add(UnderscoredCharacters);
                }
                if ((flagByte & 0x10) == 0) {
                    result.add(NoHollowCharacters);
                } else {
                    result.add(HollowCharacters);
                }
                if ((flagByte & 8) == 0) {
                    result.add(NoOverstruckCharacters);
                } else {
                    result.add(OverstruckCharacters);
                }
                if ((flagByte & 4) == 0) {
                    result.add(UniformlySpacedCharacters);
                } else {
                    result.add(ProportionallyCharacters);
                }
                if ((flagByte & 2) == 0) {
                    result.add(NoPairwiseKernedCharacters);
                } else {
                    result.add(PairwiseKernedCharacters);
                }
                if ((flagByte & 1) == 0) {
                    result.add(ParameterIsNotSpecified);
                } else {
                    result.add(ParameterIsSpecified);
                }
                return result;
            }

            public static int toByte(EnumSet<FDS_FontDsFlag> flags) {
                int result = 0;
                if (flags.contains(ItalicCharacters)) {
                    result |= 0x80;
                }
                if (flags.contains(UnderscoredCharacters)) {
                    result |= 0x40;
                }
                if (flags.contains(HollowCharacters)) {
                    result |= 0x10;
                }
                if (flags.contains(OverstruckCharacters)) {
                    result |= 8;
                }
                if (flags.contains(ProportionallyCharacters)) {
                    result |= 4;
                }
                if (flags.contains(PairwiseKernedCharacters)) {
                    result |= 2;
                }
                if (flags.contains(ParameterIsSpecified)) {
                    result |= 1;
                }
                return result;
            }

            public static void setFlag(EnumSet<FDS_FontDsFlag> flags, FDS_FontDsFlag flag) {
                handler.setFlag(flags, flag);
            }

            @Override
            public int getGroup() {
                return this.group;
            }

            static {
                handler = new MutualExclusiveGroupedFlagHandler();
            }
        }

        public static enum FDS_FontWidthClass {
            NotSpecified(0),
            UltraCondensed(1),
            ExtraCondensed(2),
            Condensed(3),
            SemiCondensed(4),
            Medium_Normal(5),
            Semi_Expanded(6),
            Expanded(7),
            Extra_Expanded(8),
            Ultra_Expanded(9);

            int code;

            private FDS_FontWidthClass(int code) {
                this.code = code;
            }

            public static FDS_FontWidthClass valueOf(byte codeByte) throws AFPParserException {
                for (FDS_FontWidthClass wc : FDS_FontWidthClass.values()) {
                    if (wc.ordinal() != codeByte) continue;
                    return wc;
                }
                throw new AFPParserException(FDS_FontWidthClass.class.getSimpleName() + ": class code 0x" + Integer.toHexString(codeByte) + " is unknown.");
            }

            public int toByte() {
                return this.ordinal();
            }
        }

        public static enum FDS_FontWeigthClass {
            NotSpecified(0),
            UltraLight(1),
            ExtraLight(2),
            Light(3),
            SemiLight(4),
            Medium_Normal(5),
            SemiBold(6),
            Bold(7),
            ExtraBold(8),
            UltraBold(9);

            int code;

            private FDS_FontWeigthClass(int code) {
                this.code = code;
            }

            public static FDS_FontWeigthClass valueOf(byte codeByte) throws AFPParserException {
                for (FDS_FontWeigthClass wc : FDS_FontWeigthClass.values()) {
                    if (wc.ordinal() != codeByte) continue;
                    return wc;
                }
                throw new AFPParserException(FDS_FontWeigthClass.class.getSimpleName() + ": class code 0x" + Integer.toHexString(codeByte) + " is unknown.");
            }

            public int toByte() {
                return this.ordinal();
            }
        }
    }

    public static class MODCAInterchangeSet
    extends Triplet {
        MODCAInterchangeSet_Type type;
        MODCAInterchangeSet_Identifier identifier;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 5);
            super.decodeAFP(sfData, offset, length, config);
            this.type = MODCAInterchangeSet_Type.valueOf(sfData[offset + 2]);
            this.identifier = MODCAInterchangeSet_Identifier.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 3, 2));
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.tripletID.toByte());
            baos.write(this.type.toByte());
            baos.write(this.identifier.toBytes());
            this.length = (short)(baos.size() + 1);
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(baos.toByteArray());
        }

        public static enum MODCAInterchangeSet_Identifier {
            MODCA_IS1(2304),
            MODCA_IS2_Retired(3072),
            MODCA_IS3(3328);

            int code;

            private MODCAInterchangeSet_Identifier(int code) {
                this.code = code;
            }

            public static MODCAInterchangeSet_Identifier valueOf(short code) throws AFPParserException {
                for (MODCAInterchangeSet_Identifier id : MODCAInterchangeSet_Identifier.values()) {
                    if (id.code != code) continue;
                    return id;
                }
                throw new AFPParserException(MODCAInterchangeSet_Identifier.class.getSimpleName() + ": type code 0x" + Integer.toHexString(code) + " is unknown.");
            }

            public byte[] toBytes() {
                return UtilBinaryDecoding.intToByteArray(this.code, 2);
            }
        }

        public static enum MODCAInterchangeSet_Type {
            Presentation;


            public static MODCAInterchangeSet_Type valueOf(byte typeCode) throws AFPParserException {
                if (typeCode == 1) {
                    return Presentation;
                }
                throw new AFPParserException(MODCAInterchangeSet_Type.class.getSimpleName() + ": type code 0x" + Integer.toHexString(typeCode) + " is unknown.");
            }

            public int toByte() {
                return 1;
            }
        }
    }

    public static class ObjectClassification
    extends Triplet {
        byte reserved2 = 0;
        ObjectClass objectClass;
        byte[] reserved4_5 = new byte[2];
        EnumSet<StructureFlag> structureFlags;
        byte[] registeredObjectID;
        String objectTypeName;
        String objectVersion;
        String companyName;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 24);
            super.decodeAFP(sfData, offset, length, config);
            this.reserved2 = sfData[offset + 2];
            this.objectClass = ObjectClass.valueOf(sfData[offset + 3]);
            this.reserved4_5 = new byte[2];
            System.arraycopy(sfData, offset + 4, this.reserved4_5, 0, this.reserved4_5.length);
            this.structureFlags = StructureFlag.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 6, 2));
            this.registeredObjectID = new byte[16];
            System.arraycopy(sfData, offset + 8, this.registeredObjectID, 0, this.registeredObjectID.length);
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            this.objectTypeName = actualLength > 24 ? new String(sfData, offset + 24, 32, config.getAfpCharSet()) : null;
            this.objectVersion = actualLength > 56 ? new String(sfData, offset + 56, 8, config.getAfpCharSet()) : null;
            this.companyName = actualLength > 64 ? new String(sfData, offset + 64, 32, config.getAfpCharSet()) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.tripletID.toByte());
            baos.write(this.reserved2);
            baos.write(this.objectClass.toByte());
            baos.write(this.reserved4_5);
            baos.write(StructureFlag.toBytes(this.structureFlags));
            if (this.objectTypeName != null) {
                baos.write(UtilCharacterEncoding.stringToByteArray(this.objectTypeName, config.getAfpCharSet(), 32, (byte)64));
                if (this.objectVersion != null) {
                    baos.write(UtilCharacterEncoding.stringToByteArray(this.objectVersion, config.getAfpCharSet(), 8, (byte)64));
                    if (this.companyName != null) {
                        baos.write(UtilCharacterEncoding.stringToByteArray(this.companyName, config.getAfpCharSet(), 32, (byte)64));
                    }
                }
            }
            this.length = (short)(baos.size() + 1);
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(baos.toByteArray());
        }

        public void setStructureFlag(StructureFlag flag) {
            StructureFlag.setFlag(this.structureFlags, flag);
        }

        public static enum StructureFlag implements IMutualExclusiveGroupedFlag
        {
            OC_Reserved(0),
            OC_DataNotCarriedInObjectContainer(0),
            OC_UnknownContainerStructure(0),
            OC_DataCarriedInObjectContainer(0),
            OEG_Reserved(1),
            OEG_NotIncluded(1),
            OEG_Unknown(1),
            OEG_Included(1),
            OCD_Reserved(2),
            OCD_DataNotCarriedInOCD(2),
            OCD_UnknownIfOCDCarriesData(2),
            OCD_DataCarriedInOCD(2);

            static MutualExclusiveGroupedFlagHandler<StructureFlag> handler;
            int group;

            private StructureFlag(int code) {
                this.group = code;
            }

            public static EnumSet<StructureFlag> valueOf(int codeByte) {
                EnumSet<StructureFlag> result = EnumSet.noneOf(StructureFlag.class);
                if ((codeByte & 0xC000) == 0) {
                    result.add(OC_Reserved);
                } else if ((codeByte & 0x8000) != 0 && (codeByte & 0x4000) != 0) {
                    result.add(OC_DataCarriedInObjectContainer);
                } else if ((codeByte & 0x8000) != 0) {
                    result.add(OC_UnknownContainerStructure);
                } else if ((codeByte & 0x4000) != 0) {
                    result.add(OC_DataNotCarriedInObjectContainer);
                }
                if ((codeByte & 0x3000) == 0) {
                    result.add(OEG_Reserved);
                } else if ((codeByte & 0x2000) != 0 && (codeByte & 0x1000) != 0) {
                    result.add(OEG_Included);
                } else if ((codeByte & 0x2000) != 0) {
                    result.add(OEG_Unknown);
                } else if ((codeByte & 0x1000) != 0) {
                    result.add(OEG_NotIncluded);
                }
                if ((codeByte & 0xC00) == 0) {
                    result.add(OCD_Reserved);
                } else if ((codeByte & 0x800) != 0 && (codeByte & 0x400) != 0) {
                    result.add(OCD_DataCarriedInOCD);
                } else if ((codeByte & 0x800) != 0) {
                    result.add(OCD_UnknownIfOCDCarriesData);
                } else if ((codeByte & 0x400) != 0) {
                    result.add(OCD_DataNotCarriedInOCD);
                }
                return result;
            }

            public static byte[] toBytes(EnumSet<StructureFlag> flags) {
                int result = 0;
                if (flags.contains(OC_DataCarriedInObjectContainer)) {
                    result |= 0xC000;
                } else if (flags.contains(OC_UnknownContainerStructure)) {
                    result |= 0x8000;
                } else if (flags.contains(OC_DataNotCarriedInObjectContainer)) {
                    result |= 0x4000;
                }
                if (flags.contains(OEG_Included)) {
                    result |= 0x3000;
                } else if (flags.contains(OEG_Unknown)) {
                    result |= 0x2000;
                } else if (flags.contains(OEG_NotIncluded)) {
                    result |= 0x1000;
                }
                if (flags.contains(OCD_DataCarriedInOCD)) {
                    result |= 0xC00;
                } else if (flags.contains(OCD_UnknownIfOCDCarriesData)) {
                    result |= 0x800;
                } else if (flags.contains(OCD_DataNotCarriedInOCD)) {
                    result |= 0x400;
                }
                return UtilBinaryDecoding.intToByteArray(result, 2);
            }

            public static void setFlag(EnumSet<StructureFlag> flags, StructureFlag flag) {
                handler.setFlag(flags, flag);
            }

            @Override
            public int getGroup() {
                return this.group;
            }

            static {
                handler = new MutualExclusiveGroupedFlagHandler();
            }
        }

        public static enum ObjectClass {
            TimeInvariantPaginatedPresentationObject(1),
            TimeVariantPresentationObject(16),
            ExecutableProgram(32),
            SetupFile(48),
            SecondaryResource(64),
            DataObjectFont(65);

            int code;

            private ObjectClass(int code) {
                this.code = code;
            }

            public static ObjectClass valueOf(byte codeByte) throws AFPParserException {
                for (ObjectClass oc : ObjectClass.values()) {
                    if (oc.code != codeByte) continue;
                    return oc;
                }
                throw new AFPParserException(ObjectClass.class.getSimpleName() + ": object class 0x" + Integer.toHexString(codeByte) + " is unknwon.");
            }

            public int toByte() {
                return this.code;
            }
        }
    }

    public static class MappingOption
    extends Triplet {
        DataObjecMapingOption dataObjecMapingOption;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.dataObjecMapingOption = DataObjecMapingOption.valueOf(sfData[offset + 2]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(this.tripletID.toByte());
            os.write(this.dataObjecMapingOption.toByte());
        }

        public static enum DataObjecMapingOption {
            Position(0),
            PositionAndTrim(16),
            ScaleToFit(32),
            CenterAndTrim(48),
            ImagePointToPel(65),
            ImagePointToPelWithDoubleDot(66),
            ReplicateAndTrim(80),
            ScaleToFill(96),
            UP3iPrintDataMapping(112);

            int code;

            private DataObjecMapingOption(int code) {
                this.code = code;
            }

            public static DataObjecMapingOption valueOf(byte codeByte) {
                for (DataObjecMapingOption o : DataObjecMapingOption.values()) {
                    if (o.code != codeByte) continue;
                    return o;
                }
                return null;
            }

            public int toByte() {
                return this.code;
            }
        }
    }

    public static class FullyQualifiedName
    extends Triplet {
        GlobalID_Use type;
        GlobalID_Format format;
        byte[] nameAsBytes;
        String nameAsString;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.type = GlobalID_Use.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 2, 1));
            this.format = GlobalID_Format.valueOf(sfData[offset + 3]);
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            this.nameAsBytes = new byte[actualLength - 4];
            System.arraycopy(sfData, offset + 4, this.nameAsBytes, 0, this.nameAsBytes.length);
            this.nameAsString = new String(this.nameAsBytes, config.getAfpCharSet());
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.tripletID.toByte());
            baos.write(this.type.toByte());
            baos.write(this.format.toByte());
            if (this.nameAsBytes != null) {
                baos.write(this.nameAsBytes);
            } else {
                baos.write(this.nameAsString.getBytes(config.getAfpCharSet()));
            }
            this.length = (short)(baos.size() + 1);
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(baos.toByteArray());
        }

        public GlobalID_Use getType() {
            return this.type;
        }

        public void setType(GlobalID_Use type) {
            this.type = type;
        }

        public GlobalID_Format getFormat() {
            return this.format;
        }

        public void setFormat(GlobalID_Format format) {
            this.format = format;
        }

        public byte[] getNameAsBytes() {
            return this.nameAsBytes;
        }

        public void setNameAsBytes(byte[] nameAsBytes) {
            this.nameAsBytes = nameAsBytes;
        }

        public String getNameAsString() {
            return this.nameAsString;
        }

        public void setNameAsString(String nameAsString) {
            this.nameAsString = nameAsString;
        }
    }

    public static class CodedGraphicCharacterSetGlobalID
    extends Triplet {
        int graphicCharacterSetGlobalID;
        int codePageGlobalID_codedCharacterSetID;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            super.decodeAFP(sfData, offset, length, config);
            this.graphicCharacterSetGlobalID = UtilBinaryDecoding.parseInt(sfData, offset + 2, 2);
            this.codePageGlobalID_codedCharacterSetID = UtilBinaryDecoding.parseInt(sfData, offset + 4, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.tripletID.toByte());
            baos.write(UtilBinaryDecoding.intToByteArray(this.graphicCharacterSetGlobalID, 2));
            baos.write(UtilBinaryDecoding.intToByteArray(this.codePageGlobalID_codedCharacterSetID, 2));
            this.length = (short)(baos.size() + 1);
            os.write(UtilBinaryDecoding.shortToByteArray(this.length, 1));
            os.write(baos.toByteArray());
        }

        public boolean isCCSIDForm() {
            return this.graphicCharacterSetGlobalID == 0;
        }
    }

    public static class Undefined
    extends Triplet {
        byte[] tripletData;
        AFPParserException parsingException;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            length = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            if (length > 2) {
                this.tripletData = new byte[length];
                System.arraycopy(sfData, offset, this.tripletData, 0, this.tripletData.length);
            } else {
                this.tripletData = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            if (this.tripletData != null) {
                this.length = (short)this.tripletData.length;
                os.write(this.tripletData);
            } else {
                os.write(0);
                os.write(0);
            }
        }

        public byte[] getTripletData() {
            return this.tripletData;
        }

        public void setTripletData(byte[] tripletData) {
            this.tripletData = tripletData;
        }

        public AFPParserException getParsingException() {
            return this.parsingException;
        }

        public void setParsingException(AFPParserException parsingException) {
            this.parsingException = parsingException;
        }
    }

    public static enum GlobalID_Format {
        CharacterString(0),
        OID(16),
        URL(32);

        int code;

        private GlobalID_Format(int code) {
            this.code = code;
        }

        public static GlobalID_Format valueOf(byte codeByte) {
            int n = 0;
            GlobalID_Format[] globalID_FormatArray = GlobalID_Format.values();
            int n2 = globalID_FormatArray.length;
            if (n < n2) {
                GlobalID_Format f = globalID_FormatArray[n];
                return f;
            }
            return null;
        }

        public int toByte() {
            return this.code;
        }
    }

    public static enum GlobalID_Use {
        ReplaceFirstGIDBame(1),
        FontFamilyName(7),
        FontTypefaceName(8),
        MODCAResourceHierarchyReference(9),
        BeginResourceGroupReference(10),
        AttributeGID(11),
        ProcessElementGID(12),
        BeginPageGroupReference(13),
        MediaTypeReference(17),
        MediaDestinationReference(18),
        ColorManagementResourceReference(65),
        DataObjectFontBaseFontIdentifier(110),
        DataObjectFontLinkedFontIdentifier(126),
        BeginDocumentReference(131),
        ResourceObjectReference(132),
        CodePageNameReference(133),
        FontCharacterSetNameReference(134),
        BeginPageReference(135),
        BeginMediumMapReference(141),
        CodedFontNameReference(142),
        BeginDocumentIndexReference(152),
        BeginOverlayReference(176),
        DataObjectInternalResourceReference(190),
        IndexElementGID(202),
        OtherObjectDataReference(206),
        DataObjectExternalResourceReference(222);

        int code;

        private GlobalID_Use(int code) {
            this.code = code;
        }

        public static GlobalID_Use valueOf(short codeByte) {
            for (GlobalID_Use gidu : GlobalID_Use.values()) {
                if (gidu.code != codeByte) continue;
                return gidu;
            }
            return null;
        }

        public int toByte() {
            return this.code;
        }
    }

    public static enum TripletID {
        Undefined(0),
        CodedGraphicCharacterSetGlobalID(1),
        FullyQualifiedName(2),
        MappingOption(4),
        ObjectClassification(16),
        MODCAInterchangeSet(24),
        TextOrientation(29),
        LineDataObjectPositionMigration(39),
        FontDescriptorSpecification(31),
        FontCodedGraphicCharacterSetGlobalID(32),
        ResourceObjectType(UNFORTUNATE_TRIPLETID),
        ObjectFunctionSetSpecification_Retired(UNFORTUNATE_TRIPLETID),
        ExtendedResourceLocalIdentifier(34),
        ResourceLocalIdentifier(36),
        ResourceSectionNumber(37),
        CharacterRotation(38),
        ObjectByteOffset(45),
        AttributeValue(54),
        DescriptorPosition(67),
        MediaEjectControl(69),
        PageOverlayConditionalProcessing(70),
        ResourceUsageAttribute(71),
        MeasurementUnits(75),
        ObjectAreaSize(76),
        AreaDefinition(77),
        ColorSpecification(78),
        EncodingSchemeID(80),
        MediumMapPageNumber(86),
        ObjectByteExtent(87),
        ObjectStructuredFieldOffset(88),
        ObjectStructuredFieldExtent(89),
        ObjectOffset(90),
        FontHorizontalScaleFactor(93),
        ObjectCount(94),
        LocalObjectDateAndTimeStamp(98),
        ObjectChecksum(99),
        ObjectOriginIdentifier(100),
        Comment(101),
        MediumOrientation(104),
        ResourceObjectInclude(108),
        PresentationSpaceResetMixing(112),
        PresentationSpaceMixingRule(113),
        UniversalDateAndTimeStamp(114),
        IMMInsertionTriplet(115),
        TonerSaver(116),
        ColorFidelity(117),
        FontFidelity(120),
        AttributeQualifier(128),
        PagePositionInformation(129),
        ParameterValue(130),
        PresentationControl(131),
        FontResolutionAndMetricTechnology(132),
        FinishingOperation(133),
        TextFidelity(134),
        MediaFidelity(135),
        FinishingFidelity(136),
        DataObjectFontDescriptor(139),
        LocaleSelector(140),
        UP3iFinishingOperation(142),
        ColorManagementResourceDescriptor(145),
        RenderingIntent(149),
        CMRTagFidelity(150),
        DeviceAppearance(151),
        ImageResolution(154),
        ObjectContainerPresentationSpaceSize(156);

        int code;

        private TripletID(int code) {
            this.code = code;
        }

        public static TripletID valueOf(short codeByte) throws AFPParserException {
            for (TripletID id : TripletID.values()) {
                if (id.code != codeByte) continue;
                return id;
            }
            throw new AFPParserException(TripletID.class.getSimpleName() + ": the ID 0x" + Integer.toHexString(codeByte) + " is undefined.");
        }

        public int toByte() {
            return this.code;
        }
    }
}

