/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.writer;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.writer.IAFPWriter;
import com.mgz.util.UtilCharacterEncoding;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class AFPWriterHumanReadable
implements IAFPWriter {
    @Override
    public String writeSF(StructuredField sf) {
        StringBuilder sb = new StringBuilder();
        sb.append(sf.getClass().getSimpleName()).append("{\n");
        Class<?> clazz = sf.getClass();
        block2: do {
            for (Field f : clazz.getDeclaredFields()) {
                AFPField annotationAFPField;
                if (!f.isAnnotationPresent(AFPField.class) || (annotationAFPField = f.getAnnotation(AFPField.class)).isHidden()) continue;
                String fieldName = null;
                String methodName = null;
                fieldName = f.getName();
                Method method = null;
                for (Method m : clazz.getDeclaredMethods()) {
                    if (!m.isAccessible() || !(methodName = m.getName()).startsWith("get") || !methodName.equalsIgnoreCase("get" + fieldName)) continue;
                    method = m;
                    break;
                }
                if (method == null) continue;
                try {
                    Object o = method.invoke((Object)sf, new Object[0]);
                    if (o == null && annotationAFPField.isOptional() || o == null) continue;
                    sb.append("\"").append(f.getName()).append("\":");
                    if (o instanceof Number) {
                        sb.append(o);
                    } else if (o instanceof Enum) {
                        sb.append('\"').append(((Enum)o).name()).append('\"');
                    } else if (o instanceof CharSequence) {
                        sb.append('\"').append(o).append('\"');
                    } else if (o instanceof Collection || o.getClass().isArray()) {
                        sb.append("[");
                        if (o.getClass().isArray() && Array.getLength(o) >= 0 && Array.get(o, 0) instanceof Byte) {
                            sb.append('\"').append(UtilCharacterEncoding.bytesToHexString((byte[])o)).append('\"');
                        } else {
                            List<Object> coll;
                            List<Object> list = coll = o instanceof Collection ? (List<Object>)o : Arrays.asList(o);
                            if (!coll.isEmpty()) {
                                Object firstObj = coll.iterator().next();
                                boolean isFirst = true;
                                if (firstObj instanceof Byte) {
                                    for (Object e : coll) {
                                        if (!isFirst) {
                                            sb.append(",");
                                            isFirst = false;
                                        }
                                        sb.append('\"').append(Integer.toHexString(((Byte)e).byteValue())).append('\"');
                                    }
                                } else {
                                    for (Object e : coll) {
                                        if (!isFirst) {
                                            sb.append(",");
                                        } else {
                                            isFirst = false;
                                        }
                                        if (e instanceof Enum) {
                                            sb.append('\"').append(((Enum)e).name()).append('\"');
                                            continue;
                                        }
                                        sb.append('\"').append(o).append('\"');
                                    }
                                }
                            }
                        }
                        sb.append("]");
                    }
                    sb.append("\n");
                    continue block2;
                }
                catch (Throwable ex) {
                    sb.append(ex.getMessage() + "\n");
                }
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        sb.append("}\n");
        return sb.toString();
    }
}

