/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.util;

import com.mgz.afp.exceptions.AFPParserException;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;

public class UtilBinaryDecoding {
    public static final byte[] shortToByteArray(short value, int nrOfBytes) {
        byte[] result = new byte[nrOfBytes];
        for (int i = 0; i < nrOfBytes && i < 2; ++i) {
            result[nrOfBytes - 1 - i] = (byte)(value >>> i * 8);
        }
        return result;
    }

    public static final short parseShort(InputStream is, int length) throws AFPParserException, IOException {
        if (length > 2) {
            throw new AFPParserException("Short has max length of two bytes.");
        }
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result <<= 8;
            result += is.read();
        }
        return (short)result;
    }

    public static short parseShort(byte[] sfData, int offset, int length) throws AFPParserException {
        if (length > 2) {
            throw new AFPParserException("Short has max length of two bytes.");
        }
        short result = 0;
        for (int i = 0; i < length; ++i) {
            result = (short)(result << 8);
            result = (short)(result + (sfData[offset + i] & 0xFF));
        }
        return result;
    }

    public static final int parseInt(InputStream is, int length) throws IOException {
        if (length > 4) {
            throw new IOException("Integer has max length of four bytes.");
        }
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result <<= 8;
            result += is.read();
        }
        return result;
    }

    public static int parseInt(byte[] sfData, int offset, int length) throws AFPParserException {
        if (length > 4) {
            throw new AFPParserException("Integer has max length of four bytes.");
        }
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result <<= 8;
            result += sfData[offset + i] & 0xFF;
        }
        return result;
    }

    public static final byte[] intToByteArray(int value, int nrOfBytes) {
        byte[] result = new byte[nrOfBytes];
        for (int i = 0; i < nrOfBytes && i < 4; ++i) {
            result[nrOfBytes - 1 - i] = (byte)(value >>> i * 8);
        }
        return result;
    }

    public static final long parseLong(InputStream is, int length) throws IOException {
        if (length > 8) {
            throw new IOException("Long integer has max length of eight bytes.");
        }
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            result <<= 8;
            result += (long)is.read();
        }
        return result;
    }

    public static long parseLong(byte[] sfData, int offset, int length) throws AFPParserException {
        if (length > 8) {
            throw new AFPParserException("Long integer has max length of eight bytes.");
        }
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            result <<= 8;
            result += (long)(sfData[offset + i] << 0 & 0xFF);
        }
        return result;
    }

    public static final byte[] longToByteArray(long value, int nrOfBytes) {
        byte[] result = new byte[nrOfBytes];
        for (int i = 0; i < nrOfBytes && i < 8; ++i) {
            result[nrOfBytes - 1 - i] = (byte)(value >>> i * 8);
        }
        return result;
    }

    public static BitSet parseBitSet(byte[] sfData, int offset, int length) {
        BitSet bitSet = new BitSet(length * 8);
        int pos = 0;
        for (int i = 0; i < length; ++i) {
            byte b = sfData[offset + i];
            for (int j = 0; j < 8; ++j) {
                boolean val = (b & 1 << 7 - j) != 0;
                bitSet.set(pos, val);
                ++pos;
            }
        }
        return bitSet;
    }

    public static byte[] bitSetToByteArray(BitSet bitSet, int byteLen) {
        byte[] result = new byte[byteLen];
        for (int i = 0; i < byteLen; ++i) {
            for (int j = 7; j >= 0; --j) {
                if (bitSet.length() < i * 8 + (7 - j)) {
                    return result;
                }
                if (!bitSet.get(i * 8 + (7 - j))) continue;
                int n = i;
                result[n] = (byte)(result[n] | 1 << j);
            }
        }
        return result;
    }
}

