/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Nono;
import hu.akarnokd.rxjava2.basetypes.NonoMergeArray;
import hu.akarnokd.rxjava2.util.CompositeSubscription;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class NonoMergeIterable
extends Nono {
    final Iterable<? extends Nono> sources;
    final boolean delayErrors;
    final int maxConcurrency;

    NonoMergeIterable(Iterable<? extends Nono> sources, boolean delayErrors, int maxConcurrency) {
        this.sources = sources;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Void> s) {
        Iterator it;
        try {
            it = (Iterator)ObjectHelper.requireNonNull(this.sources.iterator(), (String)"The source Iterable returned a null Iterator");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        MergeSubscriber parent = new MergeSubscriber(s, this.delayErrors, this.maxConcurrency, it);
        s.onSubscribe((Subscription)parent);
        parent.subscribe(this.maxConcurrency);
    }

    static final class MergeSubscriber
    extends BasicIntQueueSubscription<Void>
    implements NonoMergeArray.NonoInnerSupport {
        private static final long serialVersionUID = -58058606508277827L;
        final Subscriber<? super Void> actual;
        final AtomicThrowable errors;
        final boolean delayErrors;
        final Iterator<? extends Nono> iterator;
        final CompositeSubscription set;
        final AtomicInteger wip;
        volatile boolean cancelled;

        MergeSubscriber(Subscriber<? super Void> actual, boolean delayErrors, int maxConcurrency, Iterator<? extends Nono> iterator) {
            this.actual = actual;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.iterator = iterator;
            this.set = new CompositeSubscription();
            this.wip = new AtomicInteger();
            this.lazySet(1);
        }

        public int requestFusion(int mode) {
            return mode & 2;
        }

        public Void poll() throws Exception {
            return null;
        }

        public boolean isEmpty() {
            return true;
        }

        public void clear() {
        }

        public void request(long n) {
        }

        public void cancel() {
            this.cancelled = true;
            this.set.cancel();
        }

        void subscribe(int n) {
            int u;
            int c;
            do {
                if ((c = this.wip.get()) == Integer.MAX_VALUE) {
                    return;
                }
                u = c + n;
                if (u >= 0) continue;
                u = Integer.MAX_VALUE;
            } while (!this.wip.compareAndSet(c, u));
            if (c != 0) {
                return;
            }
            Iterator<? extends Nono> srcs = this.iterator;
            int e = 0;
            while (true) {
                if (e != n) {
                    boolean hasNext;
                    if (this.cancelled) {
                        return;
                    }
                    Nono np = null;
                    try {
                        hasNext = srcs.hasNext();
                        if (hasNext) {
                            np = (Nono)ObjectHelper.requireNonNull((Object)srcs.next(), (String)"The iterator returned a null Nono");
                        }
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        this.errors.addThrowable(ex);
                        this.complete();
                        return;
                    }
                    if (hasNext) {
                        NonoMergeArray.InnerSubscriber inner = new NonoMergeArray.InnerSubscriber(this);
                        this.set.add(inner);
                        this.getAndIncrement();
                        np.subscribe(inner);
                        ++e;
                        continue;
                    }
                    this.complete();
                    return;
                }
                n = this.get();
                if (e != n) continue;
                n = this.addAndGet(-e);
                if (n == 0) break;
                e = 0;
            }
        }

        @Override
        public void innerError(NonoMergeArray.InnerSubscriber inner, Throwable ex) {
            this.set.delete(inner);
            if (this.errors.addThrowable(ex)) {
                if (!this.delayErrors) {
                    this.set.cancel();
                    this.actual.onError(this.errors.terminate());
                } else {
                    this.subscribe(1);
                    this.complete();
                }
            } else {
                RxJavaPlugins.onError((Throwable)ex);
            }
        }

        @Override
        public void innerComplete(NonoMergeArray.InnerSubscriber inner) {
            this.set.delete(inner);
            this.subscribe(1);
            this.complete();
        }

        void complete() {
            if (this.decrementAndGet() == 0) {
                Throwable ex = this.errors.terminate();
                if (ex != null) {
                    this.actual.onError(ex);
                } else {
                    this.actual.onComplete();
                }
            }
        }
    }
}

