/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava2.basetypes;

import hu.akarnokd.rxjava2.basetypes.Perhaps;
import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class PerhapsFlatMapPublisher<T, R>
extends Flowable<R> {
    final Perhaps<T> source;
    final Function<? super T, ? extends Publisher<? extends R>> mapper;

    PerhapsFlatMapPublisher(Perhaps<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new FlatMapSubscriber<T, R>(s, this.mapper));
    }

    static final class FlatMapSubscriber<T, R>
    extends AtomicLong
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = 1417117475410404413L;
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final InnerSubscriber inner;
        Subscription s;
        boolean hasValue;

        FlatMapSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper) {
            this.actual = actual;
            this.mapper = mapper;
            this.inner = new InnerSubscriber(actual);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            Publisher ph;
            this.hasValue = true;
            try {
                ph = (Publisher)ObjectHelper.requireNonNull((Object)this.mapper.apply(t), (String)"The mapper returned a null Publisher");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                this.actual.onError(ex);
                return;
            }
            ph.subscribe((Subscriber)this.inner);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            if (!this.hasValue) {
                this.actual.onComplete();
            }
        }

        public void request(long n) {
            SubscriptionHelper.deferredRequest((AtomicReference)this.inner, (AtomicLong)this, (long)n);
        }

        public void cancel() {
            this.s.cancel();
            SubscriptionHelper.cancel((AtomicReference)this.inner);
        }

        final class InnerSubscriber
        extends AtomicReference<Subscription>
        implements Subscriber<R> {
            private static final long serialVersionUID = -7407027791505806997L;
            final Subscriber<? super R> actual;

            InnerSubscriber(Subscriber<? super R> actual) {
                this.actual = actual;
            }

            public void onSubscribe(Subscription s) {
                SubscriptionHelper.deferredSetOnce((AtomicReference)this, (AtomicLong)FlatMapSubscriber.this, (Subscription)s);
            }

            public void onNext(R t) {
                this.actual.onNext(t);
            }

            public void onError(Throwable t) {
                this.actual.onError(t);
            }

            public void onComplete() {
                this.actual.onComplete();
            }
        }
    }
}

